/*
 * PropertySet.java
 *
 * Created on 12 May 2006, 10:08
 *
 */

package mccombe.terrain;

import java.io.IOException;

/**
 *
 * @author Mike McCombe
 */
public class PropertySet {
    
    /** Creates a new instance of PropertySet */
    public PropertySet(String filename, java.util.Properties defaults)  {
        file = filename ;
        boolean propflag = true;
        properties = new java.util.Properties(defaults);
        java.util.Properties prop = System.getProperties();
        try {
            properties.loadFromXML(new java.io.FileInputStream(filename));
            java.util.Enumeration enums = properties.propertyNames();
            while(enums.hasMoreElements()){
                String s = (String) enums.nextElement();
                String val = properties.getProperty(s);
                prop.setProperty(s,val);
            }
            propflag = false ;
        } catch (IOException ex) {
            //Do nothing here. "propflag" causes new property file to be created.
        }
        if(propflag) {
            try {
                properties.storeToXML(new java.io.FileOutputStream(filename), "");
            } catch (java.io.IOException ex) {
                
            }
        }
        System.setProperties(prop);
    }
    public String get(TerrainProperties key){
        return properties.getProperty(key.toString());
    }
    public void set(TerrainProperties key, String value){
        properties.setProperty(key.toString(), value);
    }
    private String getProperty(String name){
        return properties.getProperty(name);
    }
    private void setProperty(String key, String value){
        properties.setProperty(key, value);
    }
    public void save() throws java.io.IOException {
        properties.storeToXML(new java.io.FileOutputStream(file),"");
     }
    private java.util.Properties properties ;
    private String file ;
    
}
