//
//	tardy - a tar post-processor
//	Copyright (C) 2004 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate remove_prefix_counts
//

#pragma implementation "tar_input_filter_remove_prefix_count"

#include <ac/assert.h>
#include <ac/string.h>

#include <cannonical.h>
#include <tar/input/filter/remove_prefix_count.h>


tar_input_filter_remove_prefix_count::~tar_input_filter_remove_prefix_count()
{
}


tar_input_filter_remove_prefix_count::tar_input_filter_remove_prefix_count(
	tar_input *arg_fp, int arg_count) :
    tar_input_filter(arg_fp),
    count(arg_count)
{
}


static rcstring
apply_remove_prefix_count(const rcstring &name, int count, bool isdir)
{
    const char *cp = name.to_c_string();
    while (count > 0)
    {
	const char *ep = strchr(cp, '/');
	if (!ep)
	{
	    if (isdir)
		return ".";
	    return (*cp ? cp : ".");
	}
	cp = ep + 1;
	--count;
    }
    return (*cp ? cp : ".");
}


int
tar_input_filter_remove_prefix_count::read_header(tar_header &h)
{
    for (;;)
    {
	int ok = tar_input_filter::read_header(h);
	if (!ok)
	    return 0;
	bool isdir = (h.type == tar_header::type_directory);
	h.name = apply_remove_prefix_count(h.name, count, isdir);
	if (isdir && h.name == ".")
	    continue;
	if (h.type == tar_header::type_link_hard)
	    h.linkname = apply_remove_prefix_count(h.linkname, count, false);
	return 1;
    }
}
