C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRAID1
C                       *****************
C
C     --------------------
     *(NDIM,NPOINR,NELRAY)
C     --------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C       1ere LECTURE DU MAILLAGE ELEMENTS FINIS POUR LE RAYONNEMENT    *
C             --> STRUCTURE DE DONNEE ISSUE DE IDEAS MS                *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : LCOODP,CMPTNO,CMPTEL,CMPTFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "nlofct.h"
#include "optct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINR,NELRAY
C
C.. Variables internes
      INTEGER NUM,ID,N1,N2,ICOU,NBNO,NN
      INTEGER ITYE
      CHARACTER*80 CH
C
C***********************************************************************
C
C
C     0- INITIALISATIONS
C     ==================
C
      REWIND (NFSGRA)
      NPOINR = 0
      NELRAY = 0
C
C
C     1- TABLE DES NOEUDS
C     ===================
C
      CALL SECIDE(NFSGRA,2411)
C
   12 READ(NFSGRA,1200,ERR=19,END=19) NUM
      READ(NFSGRA,1201,ERR=19,END=19) CH
      IF (NUM .EQ. -1) THEN
        GOTO 19
      ELSE
        NPOINR = NPOINR + 1
        GOTO 12
      ENDIF
C
   19 CONTINUE
C
C
C     2- TABLE DES ELEMENTS
C     =====================
C
C
      CALL SECIDE(NFSGRA,2412)
C
      IF (NDIM .EQ. 3) THEN
  221   READ(NFSGRA,2100,ERR=28,END=28) NUM,ID,N1,N2,ICOU,NN
        IF (NUM .EQ. -1) THEN
          GOTO 28
        ELSE
          NELRAY = NELRAY + 1
          NBNO=NN
          READ(NFSGRA,1201,ERR=28,END=28) CH
          ITYE   = ID
          GOTO 221
        ENDIF
      ELSE
  222   READ(NFSGRA,2100,ERR=28,END=28) NUM,ID,N1,N2,ICOU,NN
        IF (NUM .EQ. -1) THEN
          GOTO 28
        ELSE
          NELRAY = NELRAY + 1
          NBNO=NN
          READ(NFSGRA,1201,ERR=28,END=28) CH
          READ(NFSGRA,1201,ERR=28,END=28) CH
          ITYE   = ID
          GOTO 222
        ENDIF
      ENDIF
C
 28   CONTINUE
C      
C
C
C     Il ne faut pas de noeuds milieux
          IF (NDIM .NE. NBNO) THEN
             WRITE(NFECRA,5000)
             STOP
          ENDIF
C
C--------
C FORMATS
C--------
C 
 1200 FORMAT(4I10)
 1201 FORMAT(A80)
 2100 FORMAT(6I10)
 5000 FORMAT('  %% ERREUR LRAID1 : LE MAILLAGE POSSEDE DES'
     &                             ,' NOEUDS MILIEUX')      
C 
C
      END

