C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE ECRG2E
C                       *****************
C
C     --------------------------------------
     * (NBSCAL,NFIC,NDIM,NDIELE,NELEM,NPOIN)
C     --------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       GENERATION DE L'ENTETE DU FICHIER RESULTAT  (partie 1)         *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NFIC   !   E  ! D  ! NUMERO LOGIQUE DU FICHIER                   !
C   ! TYPDOM !   A  ! D  ! INDIQUE SI ON TRAITE LE MAILLAGE SOLIDE OU  !
C   !        !      !    ! LA PEAU DU FLUIDE                           !
C   !        !      !    ! TYPDOM = 'S' pour le solide                 !
C   !        !      !    !          'F' pour le fluide                 !
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME                       !
C   ! NDIELE !   E  ! D  ! DIMENSION DES ELEMENTS                      !
C   ! NELEM  !   E  ! D  ! NOMBRE D'ELTS DU MAILLAGE TRAITE            !
C   ! NPOIN  !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE TRAITE         !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! D  !                                             !
C   !/DIVCT/ !      ! D  !                                             !
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C      
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "optct.h"
#include "divct.h"
C
C**********************************************************************
C
C..Variables externes
      INTEGER NFIC,NDIM,NDIELE,NELEM,NPOIN,NBSCAL
C
C..Variables internes
C
C**********************************************************************
C     FONCTIONS IMPLICITES
C**********************************************************************
C
C**********************************************************************
C
C
C     1- ECRITURE DE L'ENTETE DU PAS DE TEMPS 
C     =======================================
C
C     1.1- MISE A JOUR DES VARIABLES PRESENTES DANS L'ENTETE
C     ------------------------------------------------------
C
C     TITSOL : Titre du calcul
C     NELEM  : Nombre d'elements
C     NDIM   : Dimension du probleme
C     NDIELE : Dimension des elements 
C     NPOIN  : Nombre total de noeuds P2
C     NBSCAL : Nombre de variable scalaires a ecrire
C
C
C     1.3- ENTETE DU PAS DE TEMPS : ECRITURE
C     --------------------------------------
C
      WRITE(NFIC,1200) TITSOL,NDIM,NDIELE,NELEM,NPOIN,NBSCAL
C
C 
C--------
C FORMATS
C--------
C
 1200 FORMAT(72('*'),/,A72,/,72('*'),/,
     &       'C1C*      NDIM    NDIELE     NELEM     NPOIN     ',
     &                                     'NBSCAL',/,
     &       'C2C*',5I10)
C
C
C
      END
