/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SHAPEHANDLER_H
#define SHAPEHANDLER_H

#define SHPFILE 0
#define DBFFILE 1

#include "apentry.h"

#include <shapefil.h>
#include <string.h>
#include <iostream>
#include <qmutex.h>

using namespace std;

class ShapeHandler{

private:
	QMutex mut;
	SHPHandle shpH;		// file handler for the shapefiles (.shp, .shx)
	DBFHandle dbfH;		// file handler for the attributes files (.dbx)
	int nextID;		// id of the next point(or object, or record) to be added
	char * shapeName;	// name (before the '.') of the files
	//char * path;		// directory where the "three files" are

public:
	//ShapeHandler();
	ShapeHandler(SHPHandle sH=NULL, DBFHandle dH=NULL, int id=0, char * name=NULL):shpH(sH), dbfH(dH), nextID(id)
		{ setShapeName(name); };
	~ShapeHandler();
	int newData(APEntry * ap);		// data to be added/updated if exists/not exists
	int createShapefile(char * name);	// creates .shp, .shx and .dfx, and assigns the handlers (shpH and dfxH)
	void setShapeName(char * n);
	
protected:
	void * openShapeFile(int type, char * name);
	void updateRecord(APEntry* ap, int id);		// update the record pointed by id with the data from ap
	void newRecord(APEntry* ap);		// add a new record in the nextID position, with the data from ap
	int isInShapes(char * mac);		// search for a mac in all records. If found returns the id, otherwise, ret -1
	//int getSignal(int id);		// get the signal+ of the record pointed by 'id'
	void writePoint(int rec, double x, double y );
	void updatePoint(int rec, double x, double y );	
	void ErrorMem();
};

#endif
