/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ErrorSupport.h"
#include "ErrorHandler.h"
#include "events/DialogEvent.h"
#include "events/EventSupport.h"
#include "util/Condition.h"
#include "util/Error.h"
#include "util/ErrorCodes.h"

// qt
#include <QtGui/QApplication>


void handleError( const sc::Error* error )
{
  if( error )
  {
    sc::Condition cond;
    ErrorHandler  handler(
      createError(sc::ErrSvn,sc::strError(sc::ErrSvn),error), &cond );

    postEvent( qApp->mainWidget(), new DialogEvent(&handler) );

    cond.wait();
  }
}

void handleError( const sc::Error* error, QWidget* parent )
{
  if( error )
  {
    ErrorHandler handler(
      createError(sc::ErrSvn,sc::strError(sc::ErrSvn),error), NULL );
    handler.run(parent);
  }
}
