/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */


// sc
#include "RpSelection.h"
#include "svn/DirEntry.h"

RpSelection::RpSelection()
{
}

RpSelection::RpSelection( const RpSelection& sel )
: _entries(sel._entries)
{
}

RpSelection::RpSelection( const svn::DirEntries& entries )
: _entries(entries)
{
}

bool RpSelection::isDir() const
{
  bool dir = true;
  for( svn::DirEntries::const_iterator it = _entries.begin(); it != _entries.end(); it++ )
  {
    dir &= (*it)->isDir();
  }
  return dir;
}

bool RpSelection::isFile() const
{
  bool file = true;
  for( svn::DirEntries::const_iterator it = _entries.begin(); it != _entries.end(); it++ )
  {
    file &= (*it)->isFile();
  }
  return file;
}

const svn::DirEntries& RpSelection::get() const
{
  return _entries;
}

svn::DirEntryPtr RpSelection::getSingle() const
{
  assert(_entries.size()>0);
  return *(_entries.begin());
}

long RpSelection::size() const
{
  return (long)_entries.size();
}

void RpSelection::getNames( svn::Paths& paths )
{
  for( svn::DirEntries::iterator it = _entries.begin(); it != _entries.end(); it++ )
  {
    paths.push_back( (*it)->getName() );
  }
}

bool RpSelection::isEmpty() const
{
  return _entries.size() == 0;
}

bool RpSelection::isSingle() const
{
  return _entries.size() == 1;
}

bool RpSelection::isMulti() const
{
  return _entries.size() > 1;
}
