/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "WcViewItemProxyModelTest.h"
#include "subcommander-test/WcViewItemTest.h" 

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// gmock
#include <gmock/gmock.h>
using testing::_;
using testing::NiceMock;
using testing::Property;
using testing::InSequence;

// sc
#include "subcommander/WcViewTreeItemModel.h"
#include "subcommander/WcViewItemProxyModel.h"
#include "subcommander-test/SignalTarget.h" 
#include "subcommander-test/MockSignalTarget.h"
#include "subcommander-test/IndexEq.h"


void WcViewItemProxyModelTest::setUp()
{
  _model = new WcViewTreeItemModel(
    sc::String("invisible/root"), new WcViewItemDataTest() );
  _proxy = new WcViewItemProxyModel();
  _proxy->setSourceModel(_model);
}

void WcViewItemProxyModelTest::tearDown()
{
  delete _proxy;
  delete _model;
}

void WcViewItemProxyModelTest::emitsModelResetSignals()
{
  MockSignalTarget mtarget(_proxy);
  EXPECT_CALL(mtarget, modelAboutToBeReset()).Times(1);
  EXPECT_CALL(mtarget, modelReset()).Times(1);

  _model->reset();
}

void WcViewItemProxyModelTest::emitsLayoutChangedSignals()
{
#if 0
  NiceMock<MockSignal> mtarget(_proxy);
  EXPECT_CALL(mtarget, layoutAboutToBeChanged()).Times(1);
  EXPECT_CALL(mtarget, layoutChanged()).Times(1);

  WcViewItems items[1];
  items[0].push_back( WcViewItemPtr(
    new WcViewItemTest(sc::String("invisible/root"),
    WcViewItemTypeDir,WcViewItemStateNormal)));
  
  _model->remove( items[0].front()->path() );
  _model->insert( items[0].front()->path(), items[0] );
#endif
}

void WcViewItemProxyModelTest::emitsRowsInsertedSignals()
{
  NiceMock<MockSignalTarget> mtarget(_proxy);
  {
    InSequence dummy;
    EXPECT_CALL(mtarget, rowsAboutToBeInserted(
      IndexEq(-1,-1),0,0)).Times(1);
    EXPECT_CALL(mtarget, rowsInserted(
      IndexEq(-1,-1),0,0)).Times(1);
    EXPECT_CALL(mtarget, rowsAboutToBeInserted(
      IndexEq(0,0),0,0)).Times(1);
    EXPECT_CALL(mtarget, rowsInserted(
      IndexEq(0,0),0,0)).Times(1);
  }

  WcViewItems items[1];
  items[0].push_back( WcViewItemPtr(
    new WcViewItemTest(sc::String("invisible/root"),
    WcViewItemTypeDir,WcViewItemStateNormal)));
  items[0].push_back( WcViewItemPtr(
    new WcViewItemTest(sc::String("invisible/root/child"),
    WcViewItemTypeFile,WcViewItemStateNormal)));

  _model->remove( items[0].front()->path() );
  _model->insert( items[0].front()->path(), items[0] );
}
