/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004,2005 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sys/stat.h>
#include <unistd.h>
#ifdef _WIN32
#include <io.h>
#define Mkdir(x) mkdir(x)
#else
#define Mkdir(x) mkdir(x, S_IRWXU)
#endif
#include <string.h>
#include <stdlib.h>
#include <FL/Fl_GIF_Image.H>
#include <FL/Fl_JPEG_Image.H>
#include <FL/Fl_PNG_Image.H>
#include <FL/Fl_Preferences.H>
#include <FL/Fl_Scroll.H>
#include <png.h>
#include "load.h"
#include "html.h"
#include "http.h"
#include "interface.h"

extern Fl_Preferences *CurComicCacheGroup;

Fl_Image *LoadImage(const char *File) 
{
	FILE *fptr;
	char head[10];
	if (!(fptr = fopen(File, "rb"))) {
		EOut("Error opening %s!\n", File);
		return NULL;
	}
	if(fread(head, 1, 10, fptr) == 10) {
		fclose(fptr);
		if(!strncmp(head, "\xFF\xD8\xFF\xE0", 4) && !strncmp((head + 6), "JFIF", 4)) { // JFIF/JPEG file
			DbgOut("Opening %s as JPEG\n", File);
			return new Fl_JPEG_Image(File);
		} else if (!strncmp(head, "GIF", 3)) { // GIF file
			DbgOut("Opening %s as GIF\n", File);
			return new Fl_GIF_Image(File);
		} else if (!png_sig_cmp((png_byte *) head, 0, 10)) { // PNG file
			DbgOut("Opening %s as PNG\n", File);
			return new Fl_PNG_Image(File);
		} else {	// Unknown
			EOut("Unknown image format: %s\n", File);
			return NULL;
		}
	} else {
		EOut("%s is too short to be an image!\n", File);
		fclose(fptr);
		return NULL;
	}
	
}

char *GetCacheFileName(const char *File, bool create, const char *Dir) 
{
	static char buf[2047];
	buf[0] = '\0';
#ifndef _WIN32					// If we're not running *nix, tack the home stuff in front, else just use the current working directory
	strcpy(buf, getenv("HOME"));
	strcat(buf, "/.stripclub/");
	if (create) { Mkdir(buf); }
#endif
	strcat(buf, Dir);
	if (create) { Mkdir(buf); }		// Make sure it exists
	strcat(buf, "/");
	strcat(buf, File);
	return buf;
}

char *URLFileToFile(const char *File)
{
	static char buf[2047];
	void *tmp;
	buf[0] = '\0';
	if (strlen(File)) {
		tmp = memchr(File, '=', strlen(File));
		if (tmp) {
			strcpy(buf, ((char *)tmp + 1));
		} else {
			strcpy(buf, File);
		}
	} else {
		strcpy(buf, "index.html");
	}
	return buf;
}

// FIXME: There's really no reason this should use a limited array, rewrite to use dynamic memory
Fl_Box **MakeImages(Fl_Image **Images, Fl_Scroll *Scroll, int x, int y)
{
	static Fl_Box **Boxes = NULL;
	static char ToolTips[30][160] = { "" };		// Holds the tooltips for the boxes
	struct stat filestat;
	int i;
	int cury = y, maxx = 0, newx = 0, newy = 0;
	if (!Images) {
		DbgOut("NULL pointer passed to MakeImages(), incorrect URL?\n");
		Scroll->redraw();
		return NULL;
	}
	Boxes = new Fl_Box *[30];
	if (!Boxes) {
		Out("Error creating Box Array!\n");
		return NULL;
	}
	Scroll->position(0, 0);
	Scroll->begin();
	DbgOut("Arranging Images\n");
	for(i = 0; Images[i]; i++) {
		char *tmp;
		if (i == 29) { MOut("Warning: More than 30 images to display, only showing the first 30.\n"); break; }
		Boxes[i] = new Fl_Box(x - (Images[i]->w() / 2), cury, Images[i]->w(), Images[i]->h());
		Boxes[i]->image(Images[i]);
		CurComicCacheGroup->get(Fl_Preferences::Name("Image%d", i), tmp, "");
		stat(GetCacheFileName(tmp), &filestat);
		snprintf(ToolTips[i], 160, "%s/%s %dx%d (%d bytes)", CurComic, tmp, Images[i]->w(), Images[i]->h(), (int)filestat.st_size);
		free(tmp);
		Boxes[i]->tooltip(ToolTips[i]);
		cury += Images[i]->h();
		if (Boxes[i]->w() > maxx) {
			maxx = Boxes[i]->w();
		}
	}
	Boxes[i] = NULL;
	DbgOut("Done Arranging\n");
	Scroll->end();
	if (maxx > Scroll->w()) {
		newx = -((maxx - Scroll->w()) / 2) - 2;
	}
	if ((cury - y) < (Scroll->h() - 4)) {
		newy = -(Scroll->h() / 2) + ((cury - y) / 2) + 2;
	}
	Scroll->position(newx, newy);
	Scroll->redraw();
	return Boxes;
}

Fl_Image **LoadImages() 
{
	static Fl_Image **Images = NULL;
	int numimage;

	if (Images) {
		for (int i = 0; Images[i]; i++) {
			delete Images[i];
		}
		delete []Images;
		Images = NULL;
	}

	CurComicCacheGroup->get("numimage", numimage, 0);
	
	Images = new Fl_Image *[numimage + 1];
	Images[numimage] = NULL;	// Null terminate the array

	Interface.StatusRange(0.0f, (float)numimage);
	Interface.StatusValue(0.0f);
	
	for (int i = 0; i < numimage; i++) {
		char *buf;
		CurComicCacheGroup->get(Fl_Preferences::Name("Image%d", i), buf, "");
		Interface.StatusValue((float)i);
		Interface.StatusLabel("Loading Image... (%s)", buf);
		Images[i] = LoadImage(GetCacheFileName(buf));
		free(buf);
	}
	Interface.StatusValue(0.0f);
	return Images;
}

void LoadLinks()
{
	Interface.PrevButton->deactivate();
	Interface.PrevButton->tooltip(NULL);
	Interface.NextButton->deactivate();
	Interface.NextButton->tooltip(NULL);

	free(CurLinks.PrevLink);
	CurLinks.PrevLink = NULL;

	free(CurLinks.NextLink);
	CurLinks.NextLink = NULL;

	if (CurComicCacheGroup->entryExists("prevlink")) {
		CurComicCacheGroup->get("prevlink", CurLinks.PrevLink, "");
	}

	if (CurComicCacheGroup->entryExists("nextlink")) {
		CurComicCacheGroup->get("nextlink", CurLinks.NextLink, "");
	}

	if (CurLinks.PrevLink) {
		Interface.PrevButton->activate();
		Interface.PrevButton->tooltip(CurLinks.PrevLink);
	}

	if (CurLinks.NextLink) {
		Interface.NextButton->activate();
		Interface.NextButton->tooltip(CurLinks.NextLink);
	}

}

void LoadURL(const char *NewURL) 
{
	char *File;
	sURL *Break;
	time_t modtime = 2, localtime = 1;
	int tmp;
	if (Offline == OFFTYPE_OFFLINE) {
		MOut("Unable to retrieve URL in offline mode\n");
		return;
	}
	Break = URLCreate(NewURL);
	CurComicCacheGroup->get("modtime", tmp, 1);
	localtime = tmp;
	Interface.CancelButton->activate();
	Cancel = false;
	if ((tmp == 1) || GetRemoteInfo(Break, 0, &modtime, 0, 0)) {
		DbgOut("Local: %d Remote: %d\n", localtime, modtime);
		if ((localtime < modtime) || !modtime) {
			File = GrabHTTPLink(NewURL);
			if (File) {
				char *Pattern;
				CurComicCacheGroup->set("modtime", (int)(time(0) + timezone));
				CurComicG->get("imgpattern", Pattern, "");
				FindImages(File, Pattern, Break);
				FindLinks(File, Break);
				free(Pattern);
			}
		}
	}
	URLDelete(Break);
}
