/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#ifndef _h_os_native_
#define _h_os_native_

/* get this guy included so that off_t is 64 bit */
#ifndef _STDINT_H
#include "stdint.h"
#endif

/* specify at least NT 4.0 */
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif

/* we should never include this directly */
#include <WINDOWS.H>
#include <limits.h>

#ifndef _h_klib_defs_
#include <klib/defs.h>
#endif

#ifndef _h_klib_text_
#include <klib/text.h>
#endif

#include <direct.h>

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------
 * LPFX
 * SHLX
 *  should probably be passed in from make
 */
#ifndef LIBPREFIX
 #define LPFX ""
#else
 #define LPFXSTR2( str ) # str
 #define LPFXSTR( str ) LPFXSTR2 ( str )
 #define LPFX LPFXSTR ( LIBPREFIX )
#endif
#define SHLX "dll"

/* to make code work that depends on POSIX-bits (octal!) under Windows */
#define S_IWGRP 0020
#define S_IWOTH 0002

#define mode_t uint32_t

/*--------------------------------------------------------------------------
 * timeout_t
 *  a structure for communicating a timeout
 *  which under Windows is a relative time
 */
typedef struct timeout_t timeout_t;
struct timeout_t
{
    uint32_t mS;
};

/* Init
 *  initialize a timeout in milliseconds
 */
rc_t TimeoutInit ( timeout_t *tm, uint32_t msec );


/* Prepare
 *  ensures that a timeout is prepared with an absolute value
*/
#define TimeoutPrepare( tm ) \
    ( ( void ) ( tm ), 0 )


/* not consistent across all windows? */
/* #define snprintf _snprintf */


#define mkdir( d, m ) _mkdir( d )
#define strcasecmp _stricmp

#undef strdup
#define strdup( str ) \
    string_dup_measure ( ( str ), NULL )

#undef strndup
#define strndup( str, n ) \
    string_dup ( ( str ), ( n ) )


static __inline int isblank(int x)
{
    return (((x) == ' ') || ((x) == '\t'));
}

int snprintf (char * buffer, size_t bufsize, const char * format, ...);


static __inline__
void *memrchr ( const void *s, int c, size_t n )
{
    size_t i;
    const char *cp = s;
    for ( i = n; i > 0; )
    {
        if ( ( int ) cp [ -- i ] == c )
            return (void *)(cp + i);
    }
    return NULL;
}

static __inline
char *strchrnul ( const char *s, int c_in )
{
    uint32_t i;
    for ( i=0; s[i] != 0; ++i )
    {
        if ( s[i] == c_in ) 
            break;
    }
  return ( char * )&s[ i ];
}

static __inline
char *strsep ( char **stringp, const char *delim )
{
	char *s, *tok, c, delim_char;
	const char *p_delim;

	if ( ( s = *stringp ) == NULL )
		return NULL;

	for ( tok = s; ; )
	{
		c = *s++;
		p_delim = delim;
		do {
			if ( ( delim_char = *p_delim++ ) == c )
			{
				if ( c == 0 )
					s = NULL;
				else
					s[-1] = 0;
				*stringp = s;
				return ( tok );
			}
		} while ( delim_char != 0 );
	}
	return NULL;
}


#ifdef __cplusplus
}
#endif

#endif /* _h_os_native_ */
