<?php
/**
 * functions for bug_report plugin
 *
 * @copyright &copy; 2004-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: functions.php,v 1.7 2006/01/23 18:42:22 tokul Exp $
 * @package plugins
 * @subpackage bug_report
 */

/** @ignore */
if (! defined('SM_PATH')) define('SM_PATH','../../');

/** Declare plugin configuration vars */
global $bug_report_admin_email, $bug_report_allow_users;

/** Load default config */
if (file_exists(SM_PATH . 'plugins/bug_report/config_default.php')) {
    include_once (SM_PATH . 'plugins/bug_report/config_default.php');
} else {
    // default config was removed.
    $bug_report_admin_email = '';
    $bug_report_allow_users = false;
}

/** Load site config */
if (file_exists(SM_PATH . 'config/bug_report_config.php')) {
    include_once (SM_PATH . 'config/bug_report_config.php');
} elseif (file_exists(SM_PATH . 'plugins/bug_report/config.php')) {
    include_once (SM_PATH . 'plugins/bug_report/config.php');
}

/**
 * Checks if user can use bug_report plugin
 * @return boolean
 * @since 1.5.1
 */
function bug_report_check_user() {
    global $username, $bug_report_allow_users, $bug_report_admin_email;

    if (file_exists(SM_PATH . 'plugins/bug_report/admins')) {
        $auths = file(SM_PATH . 'plugins/bug_report/admins');
        array_walk($auths, 'bug_report_array_trim');
        $auth = in_array($username, $auths);
    } else if (file_exists(SM_PATH . 'config/admins')) {
        $auths = file(SM_PATH . 'config/admins');
        array_walk($auths, 'bug_report_array_trim');
        $auth = in_array($username, $auths);
    } else if (($adm_id = fileowner(SM_PATH . 'config/config.php')) &&
               function_exists('posix_getpwuid')) {
        $adm = posix_getpwuid( $adm_id );
        $auth = ($username == $adm['name']);
    } else {
        $auth = false;
    }

    if (! empty($bug_report_admin_email) && $bug_report_allow_users) {
        $auth = true;
    }

    return ($auth);
}

/**
 * Removes whitespace from array values
 * @param string $value array value that has to be trimmed
 * @param string $key array key
 * @since 1.5.1
 * @todo code reuse. create generic sm function.
 * @access private
 */
function bug_report_array_trim(&$value,$key) {
    $value=trim($value);
}

?>