

#ifndef OPTIONSSIMPLE_H
#define OPTIONSSIMPLE_H

#include "outputdirectory.h"
#include "conversionoptions.h"

#include <qwidget.h>

class Config;
class ConversionOptions;
class OptionsDetailed;

class KComboBox;
class KToolBarButton;
class KPushButton;

/**
 * @short The options widget for setting up the output options very easy
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsSimple : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    OptionsSimple( Config*, OptionsDetailed*, const QString &text, QWidget* parent=0, const char* name=0 );

    /**
     * Detructor
     */
    virtual ~OptionsSimple();

    /**
     * Set the current options
     */
//     void setCurrentOptions( const ConversionOptions& );

    /**
     * Refills the whole form (e.g. after a config change)
     */
    void refill(); // TODO syncronize with optionsDetailed

    void setCurrentProfile( const QString& profile );
    void setCurrentFormat( const QString& format );
    void setCurrentOutputDirectory( const QString& directory );

private:
    KComboBox* cProfile;
    KPushButton* pProfileRemove;
    KPushButton* pProfileInfo;
    KComboBox* cFormat;
    KPushButton* pFormatInfo;

    OutputDirectory* outputDirectory;

    Config* config;
    OptionsDetailed* optionsDetailed;

    QStringList sProfile;
    QStringList sFormat;

    int profileIndex( const QString& string );
    int formatIndex( const QString& string );

//public slots:
//    void setProfile( const QString &profile );
//    void setFormat( const QString &format );

private slots:
    void profileInfo();
    void profileRemove();
    void formatInfo();
    void profileChanged();
    void formatChanged();
    void outputDirectoryModeChanged( OutputDirectory::Mode );
    void outputDirectoryPathChanged( const QString& );

    void somethingChanged();

signals:
//     void setFormat( const QString& format );
//     void setQualityMode( const QString& qualityMode );
//     void setQuality( int quality );
//     void setBitrateMode( const QString& bitrateMode );
//     void setBitrateRangeEnabled( bool enabled );
//     void setMinBitrate( int bitrate );
//     void setMaxBitrate( int bitrate );
//     void setSamplingrateEnabled( bool enabled );
//     void setSamplingrate( int sampleRate );
//     void setSamplingrate( const QString& sampleRate );
//     void setChannelsEnabled( bool enabled );
//     void setChannels( const QString& channels );
//     void setReplayGainEnabled( bool enabled );
//     void setOutputDirectoryMode( OutputDirectory::Mode );
//     void setOutputDirectoryPath( const QString& directory );
//     void setOptions( const ConversionOptions& options );
//     void setUserOptions( const QString& options );

    void optionsChanged();
};

#endif
