/*
 * ------------------------------------------------------------------------
 *
 * I2C-Serializer/Deserializer
 *      Adapting between Logical levels and the byte level
 *      I2C-Chip interface
 *
 *
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */

#include <i2c.h>

typedef struct I2C_SerDes I2C_SerDes;

void I2C_SerDesAddSlave(I2C_SerDes * serdes,I2C_Slave *slave,int addr);
int I2C_SerDesDetachSlave(I2C_SerDes * serdes,I2C_Slave *slave);
I2C_SerDes * I2C_SerDesNew(const char *name);
void SerDes_UnstretchScl(I2C_SerDes *serdes);
void SerDes_Decouple(I2C_SerDes *serdes);
