/***************************************************************************
    smb4kmounter_p  -  This is a private helper class for Smb4KMounter.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KMOUNTER_P_H
#define SMB4KMOUNTER_P_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qthread.h>
#include <qstring.h>

// KDE includes
#include <kdebug.h>

// system includes
#include <sys/statvfs.h>

class Smb4KMounterPrivate
{
  public:
    Smb4KMounterPrivate();
    ~Smb4KMounterPrivate();
    int timerTicks;

    class Thread : public QThread
    {
      public:
        Thread() : QThread(), m_mountpoint( QString::null ), m_broken( true ) {}
        ~Thread() {}

        void setMountpoint( const QString &mp ) { m_mountpoint = mp; }

        virtual void run()
        {
          if ( m_mountpoint.isEmpty() )
          {
            kdFatal() << "Smb4KMounterPrivate::Thread: No mountpoint specified" << endl;
          }

          struct statvfs fs;

          if ( statvfs( m_mountpoint.local8Bit(), &fs ) == -1 )
          {
            m_broken = true;
            m_total = -1;
            m_free = -1;
          }
          else
          {
            m_broken = false;

            double kB_block = (double)(fs.f_bsize / 1024);
            double total = (double)(fs.f_blocks*kB_block);
            double free = (double)(fs.f_bfree*kB_block);

            m_total = total;
            m_free = free;
          }

          m_mountpoint = QString::null;
        }

        bool isBroken() { return m_broken; }
        double totalDiskSpace() { return m_total; }
        double freeDiskSpace() { return m_free; }

      private:
        QString m_mountpoint;
        bool m_broken;
        double m_total;
        double m_free;
    };

    Thread thread;
    void clearData();
    const QString &workgroup();
    const QString &host();
    const QString &share();
    const QString &ip();
    const QString &path();
    const QString &filesystem();
    const QString &cifsLogin();
    void setWorkgroup ( const QString &wg );
    void setHost( const QString &h );
    void setShare( const QString &s );
    void setIP( const QString &i );
    void setPath( const QString &p );
    void setFileSystem( const QString &f );
    void setCIFSLogin( const QString &l );

  private:
    QString m_workgroup;
    QString m_host;
    QString m_share;
    QString m_ip;
    QString m_path;
    QString m_filesystem;
    QString m_cifsLogin;
};

#endif
