/***************************************************************************
    smb4kuserinterfaceoptions  -  This configuration page takes care
    of all settings concerning the user interface of Smb4K
                             -------------------
    begin                : Mi Aug 30 2006
    copyright            : (C) 2006-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4kuserinterfaceoptions.h"
#include "../core/smb4ksettings.h"

Smb4KUserInterfaceOptions::Smb4KUserInterfaceOptions( QWidget *parent, const char *name )
: QTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // Configuration for the main window:
  //
  QWidget *main_wd_widget     = new QWidget( this );
  QGridLayout *main_wd_layout = new QGridLayout( main_wd_widget );
  main_wd_layout->setSpacing( 10 );

  QButtonGroup *shares_view   = new QButtonGroup( 1, Qt::Horizontal, i18n( "Shares View" ),
                                main_wd_widget, "kcfg_SharesView" );

  shares_view->insert( new QRadioButton( i18n( "Show mounted shares in an icon view" ), shares_view ), Smb4KSettings::EnumSharesView::IconView );

  shares_view->insert( new QRadioButton( i18n( "Show mounted shares in a list view" ), shares_view ), Smb4KSettings::EnumSharesView::ListView );

  QButtonGroup *bookmarks_grp = new QButtonGroup( 1, Qt::Horizontal, i18n( "Bookmarks" ),
                                main_wd_widget, "BookmarksBox" );

  (void) new QCheckBox( i18n( "Show custom bookmark label if available" ), bookmarks_grp, "kcfg_ShowCustomBookmarkLabel" );

  QButtonGroup *tray_group    = new QButtonGroup( 1, Qt::Horizontal, i18n( "System Tray" ),
                                main_wd_widget, "SystemTrayBox" );

  (void) new QCheckBox( i18n( "Embed application into the system tray" ), tray_group, "kcfg_EmbedIntoSystemTray" );

  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  main_wd_layout->addWidget( shares_view, 0, 0, 0 );
  main_wd_layout->addWidget( bookmarks_grp, 1, 0, 0 );
  main_wd_layout->addWidget( tray_group, 2, 0, 0 );
  main_wd_layout->addItem( spacer1, 3, 0 );

  //
  // Configuration for the network browser:
  //
  QWidget *browser_widget =     new QWidget( this );
  QGridLayout *browser_layout = new QGridLayout( browser_widget );
  browser_layout->setSpacing( 10 );

  QButtonGroup *remoteGroup = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Remote Shares" ),
                              browser_widget, "BrowserRemoteSharesBox" );
  (void) new QCheckBox( i18n( "Show printer shares" ), remoteGroup, "kcfg_ShowPrinterShares" );
  QCheckBox *hidden = new QCheckBox( i18n( "Show hidden shares" ), remoteGroup, "kcfg_ShowHiddenShares" );
  (void) new QCheckBox( i18n( "Show IPC$ shares" ), remoteGroup, "kcfg_ShowHiddenIPCShares" );
  (void) new QCheckBox( i18n( "Show ADMIN$ shares" ), remoteGroup, "kcfg_ShowHiddenADMINShares" );

  QButtonGroup *columnsGroup = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Columns" ),
                               browser_widget, "BrowserColumnsBox" );
  (void) new QCheckBox( i18n( "Show type" ), columnsGroup, "kcfg_ShowType" );
  (void) new QCheckBox( i18n( "Show IP address" ), columnsGroup, "kcfg_ShowIPAddress" );
  (void) new QCheckBox( i18n( "Show comment" ), columnsGroup, "kcfg_ShowComment" );

  QButtonGroup *netTooltipsGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Tooltips" ),
                                   browser_widget, "BrowserTooltipsBox" );
  (void) new QCheckBox( i18n( "Show tooltip with information about a network item" ), netTooltipsGroup, "kcfg_ShowNetworkItemToolTip" );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  browser_layout->addWidget( remoteGroup, 0, 0, 0 );
  browser_layout->addWidget( columnsGroup, 1, 0, 0 );
  browser_layout->addWidget( netTooltipsGroup, 2, 0, 0 );
  browser_layout->addItem( spacer2, 3, 0 );

  //
  // Configuration for the shares view
  //
  QWidget *shares_widget =     new QWidget( this );
  QGridLayout *shares_layout = new QGridLayout( shares_widget );
  shares_layout->setSpacing( 10 );

  QButtonGroup *shares_group = new QButtonGroup( 1, Qt::Horizontal, i18n( "Mounted Shares" ),
                              shares_widget, "SharesIconGroupBox" );
  (void) new QCheckBox( i18n( "Show mount point instead of share name" ), shares_group, "kcfg_ShowMountPoint" );
  (void) new QCheckBox( i18n( "Show all shares that are mounted on the system" ), shares_group, "kcfg_ShowAllShares" );

  QButtonGroup *dnd_group = new QButtonGroup( 1, Qt::Horizontal, i18n( "Drag and Drop" ),
                            shares_widget, "DragnDropBox" );
  (void) new QCheckBox( i18n( "Allow dropping of files and directories onto shares" ), dnd_group, "kcfg_EnableDropSupport" );
  (void) new QCheckBox( i18n( "Allow dragging of shares" ), dnd_group, "kcfg_EnableDragSupport" );

  QButtonGroup *sharesTooltipGroup = new QButtonGroup( 1, Qt::Horizontal, i18n( "Tooltips" ),
                                     shares_widget, "SharesTooltipsBox" );
  (void) new QCheckBox( i18n( "Show tooltip with information about a share" ), sharesTooltipGroup, "kcfg_ShowShareToolTip" );

  QButtonGroup *list_view_group = new QButtonGroup( 2, Qt::Horizontal, i18n( "List View" ),
                                  shares_widget, "SharesListViewBox" );

#ifndef __FreeBSD__
  (void) new QCheckBox( i18n( "Show owner and group (SMBFS only)" ), list_view_group, "kcfg_ShowOwner" );    
  (void) new QCheckBox( i18n( "Show login (CIFS only)" ), list_view_group, "kcfg_ShowLogin" );
#else
  (void) new QCheckBox( i18n( "Show owner and group" ), list_view_group, "kcfg_ShowOwner" );    
#endif
  (void) new QCheckBox( i18n( "Show file system" ), list_view_group, "kcfg_ShowFileSystem" );
  (void) new QCheckBox( i18n( "Show free disk space" ), list_view_group, "kcfg_ShowFreeDiskSpace" );
  (void) new QCheckBox( i18n( "Show used disk space" ), list_view_group, "kcfg_ShowUsedDiskSpace" );
  (void) new QCheckBox( i18n( "Show total disk space" ), list_view_group, "kcfg_ShowTotalDiskSpace" );
  (void) new QCheckBox( i18n( "Show disk usage" ), list_view_group, "kcfg_ShowDiskUsage" );

  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  shares_layout->addWidget( shares_group, 0, 0, 0 );
  shares_layout->addWidget( dnd_group, 1, 0, 0 );
  shares_layout->addWidget( sharesTooltipGroup, 2, 0, 0 );
  shares_layout->addWidget( list_view_group, 3, 0, 0 );
  shares_layout->addItem( spacer3, 4, 0 );

  //
  // Configuration for the preview dialog
  //
  QWidget *preview_widget =     new QWidget( this );
  QGridLayout *preview_layout = new QGridLayout( preview_widget );
  preview_layout->setSpacing( 10 );

  QButtonGroup *previewFilesGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Hidden Files and Directories" ), preview_widget, "HiddenFilesBox" );
  (void) new QCheckBox( i18n( "Preview hidden files and directories" ), previewFilesGroup, "kcfg_PreviewHiddenItems" );

  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  preview_layout->addWidget( previewFilesGroup, 0, 0, 0 );
  preview_layout->addItem( spacer4, 1, 0 );

  //
  // Add tabs:
  //
  addTab( main_wd_widget, i18n( "Main Window && System Tray" ) );
  addTab( browser_widget, i18n( "Network Browser" ) );
  addTab( shares_widget, i18n( "Shares View" ) );
  addTab( preview_widget, i18n( "Preview Dialog" ) );

  // Add connections:
  connect( hidden, SIGNAL( stateChanged( int ) ),
           this,   SLOT( slotShowHiddenShares( int ) ) );

  // Do last adjustments:
  slotShowHiddenShares( hidden->state() );
}


Smb4KUserInterfaceOptions::~Smb4KUserInterfaceOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KUserInterfaceOptions::slotShowHiddenShares( int state )
{
  if ( state == QCheckBox::On )
  {
    static_cast<QCheckBox *>( child( "kcfg_ShowHiddenIPCShares", "QCheckBox" ) )->setEnabled( true );
    static_cast<QCheckBox *>( child( "kcfg_ShowHiddenADMINShares", "QCheckBox" ) )->setEnabled( true );
  }
  else if ( state == QCheckBox::Off )
  {
    static_cast<QCheckBox *>( child( "kcfg_ShowHiddenIPCShares", "QCheckBox" ) )->setEnabled( false );
    static_cast<QCheckBox *>( child( "kcfg_ShowHiddenADMINShares", "QCheckBox" ) )->setEnabled( false );
  }
}

#include "smb4kuserinterfaceoptions.moc"
