static variable window = NULL;
static variable icon_toggle = 0;

define set_toolbar_horizontal (widget, toolb)
{
   gtk_toolbar_set_orientation (toolb, GTK_ORIENTATION_HORIZONTAL);
}

define set_toolbar_vertical (widget, toolb)
{
   gtk_toolbar_set_orientation (toolb, GTK_ORIENTATION_VERTICAL);
}

define set_toolbar_icon_size(widget, toolb)
{
   icon_toggle = not icon_toggle;
   if (icon_toggle)
	gtk_toolbar_set_icon_size (toolb, GTK_ICON_SIZE_SMALL_TOOLBAR);
   else
	gtk_toolbar_set_icon_size (toolb, GTK_ICON_SIZE_LARGE_TOOLBAR);
}

define create_toolbar (test)
{
  if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (window, "GtkToolbar");
	gtk_window_set_resizable(window, FALSE);
	gtk_container_set_border_width (window, 0);

	() = g_signal_connect (window, "destroy",
			&gtk_widget_destroyed, &window);

	variable toolbar = gtk_toolbar_new();
	variable horiz = gtk_image_new_from_stock(GTK_STOCK_GO_BACK,
	    					GTK_ICON_SIZE_LARGE_TOOLBAR);

	() = gtk_toolbar_append_item (toolbar, "Horizontal",
		"Horizontal toolbar layout","Toolbar/Horizontal",
		horiz, &set_toolbar_horizontal, toolbar);

	gtk_toolbar_append_space (toolbar);

	variable vert  = gtk_image_new_from_stock(GTK_STOCK_GO_UP,
	    					GTK_ICON_SIZE_LARGE_TOOLBAR);
	() = gtk_toolbar_append_item (toolbar,"Vertical",
		"Vertical toolbar layout", "Toolbar/Vertical",
		vert, &set_toolbar_vertical, toolbar);

	variable frame = gtk_frame_new(NULL);
	variable label = gtk_label_new("Toggle Icon Size");
	gtk_widget_show(label);
	gtk_container_add(frame,label);
	() = gtk_toolbar_append_item (toolbar,"",
		"Click to toggle icon size", "",
		frame, &set_toolbar_icon_size, toolbar);

	gtk_container_add (window, toolbar);
	test.lower = test.raise;
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
