
static variable window = NULL;
static variable spinner1;

define toggle_snap (widget, spinb)
{
  gtk_spin_button_set_snap_to_ticks (spinb,
			gtk_toggle_button_get_active(widget));
}

define toggle_numeric (widget, spin)
{
  gtk_spin_button_set_numeric (spin, 
			gtk_toggle_button_get_active(widget));
}

define change_digits (widget, spinb)
{
  gtk_spin_button_set_digits (spinner1,
  			gtk_spin_button_get_value_as_int (spinb));
}

define get_value (widget, data)
{
  variable spin = spinner1;
  variable label = g_object_get_data (widget,"user_data");

  variable buf;
  if (data == 1)
    buf = sprintf ("%d", gtk_spin_button_get_value_as_int (spin));
  else
    buf = sprintf ("%0.*f", gtk_spin_button_get_digits(spin),
	     gtk_spin_button_get_value(spin));
  gtk_label_set_text (label, buf);
}

define create_spinb (test)
{
   if (window == NULL) {

  	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      
  	() = g_signal_connect (window, "destroy",
			   &gtk_widget_destroyed, &window);
      
	gtk_window_set_title (window, "GtkSpinButton");
      
	variable main_vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_set_border_width (main_vbox, 5);
	gtk_container_add ( window, main_vbox);
      
	variable frame = gtk_frame_new ("Not accelerated");
	gtk_box_pack_start (main_vbox, frame, TRUE, TRUE, 0);
      
	variable vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width ( vbox, 5);
	gtk_container_add ( frame, vbox);
      
	% Day, month, year spinners 
	variable hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (vbox, hbox, TRUE, TRUE, 5);
      
	variable vbox2 = gtk_vbox_new (FALSE, 0);
  	gtk_box_pack_start (hbox, vbox2, TRUE, TRUE, 5);
      
  	variable label = gtk_label_new ("Day :");
  	gtk_misc_set_alignment (label, 0, 0.5);
  	gtk_box_pack_start ((vbox2), label, FALSE, TRUE, 0);
      
  	variable adj = gtk_adjustment_new (1.0, 1.0, 31.0, 1.0, 5.0, 0.0);
  	variable spinner = gtk_spin_button_new (adj, 0, 0);
  	gtk_spin_button_set_wrap (spinner, TRUE);
  	gtk_box_pack_start (vbox2, spinner, FALSE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (hbox, vbox2, TRUE, TRUE, 5);
      
	label = gtk_label_new ("Month :");
	gtk_misc_set_alignment (label, 0, 0.5);
	gtk_box_pack_start (vbox2, label, FALSE, TRUE, 0);
      
	adj = gtk_adjustment_new (1.0, 1.0, 12.0, 1.0, 5.0, 0.0);
	spinner = gtk_spin_button_new (adj, 0, 0);
	gtk_spin_button_set_wrap (spinner, TRUE);
	gtk_box_pack_start (vbox2, spinner, FALSE, TRUE, 0);
      
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (hbox, vbox2, TRUE, TRUE, 5);

	label = gtk_label_new ("Year :");
	gtk_misc_set_alignment (label, 0, 0.5);
	gtk_box_pack_start (vbox2, label, FALSE, TRUE, 0);

	adj = gtk_adjustment_new (1998.0, 0.0, 2100.0, 1.0, 100.0, 0.0);
	spinner = gtk_spin_button_new (adj, 0, 0);
	gtk_spin_button_set_wrap (spinner, TRUE);
	gtk_widget_set_usize (spinner, 55, 0);
	gtk_box_pack_start (vbox2, spinner, FALSE, TRUE, 0);

	frame = gtk_frame_new ("Accelerated");
	gtk_box_pack_start (main_vbox, frame, TRUE, TRUE, 0);
  
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width ( vbox, 5);
	gtk_container_add ( frame, vbox);
      
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (vbox, hbox, FALSE, TRUE, 5);
      
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (hbox, vbox2, TRUE, TRUE, 5);
      
	label = gtk_label_new ("Value :");
	gtk_misc_set_alignment (label, 0, 0.5);
	gtk_box_pack_start (vbox2, label, FALSE, TRUE, 0);

	adj = gtk_adjustment_new (0.0, -10000.0, 10000.0, 0.5, 100.0, 0.0);
	spinner1 = gtk_spin_button_new (adj, 1.0, 2);
	gtk_spin_button_set_wrap (spinner1, TRUE);
	gtk_widget_set_usize (spinner1, 100, 0);
	gtk_box_pack_start (vbox2, spinner1, FALSE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (hbox, vbox2, TRUE, TRUE, 5);

	label = gtk_label_new ("Digits :");
	gtk_misc_set_alignment (label, 0, 0.5);
	gtk_box_pack_start (vbox2, label, FALSE, TRUE, 0);

	adj = gtk_adjustment_new (2, 1, 5, 1, 1, 0);
	spinner = gtk_spin_button_new (adj, 0.0, 0);
	gtk_spin_button_set_wrap (spinner, TRUE);
	() = g_signal_connect (adj, "value_changed", &change_digits,
								spinner);
	gtk_box_pack_start (vbox2, spinner, FALSE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (vbox, hbox, FALSE, TRUE, 5);

	variable button = gtk_check_button_new_with_label ("Snap to 0.5-ticks");
	() = g_signal_connect (button, "clicked", &toggle_snap, spinner1);

	gtk_box_pack_start (vbox, button, TRUE, TRUE, 0);
	gtk_toggle_button_set_active (button, TRUE);

	button = gtk_check_button_new_with_label ("Numeric only input mode");
	() = g_signal_connect (button, "clicked", &toggle_numeric, spinner1);
	gtk_box_pack_start (vbox, button, TRUE, TRUE, 0);
	gtk_toggle_button_set_active (button, TRUE);

	variable val_label = gtk_label_new ("");
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (vbox, hbox, FALSE, TRUE, 5);

	button = gtk_button_new_with_label ("Value as Int");
	g_object_set_data (button, "user_data", val_label);
	() = g_signal_connect (button, "clicked", &get_value, 1);
	gtk_box_pack_start (hbox, button, TRUE, TRUE, 5);

	button = gtk_button_new_with_label ("Value as Float");
	g_object_set_data (button, "user_data", val_label);
	() = g_signal_connect (button, "clicked", &get_value, 2);
	gtk_box_pack_start (hbox, button, TRUE, TRUE, 5);

	gtk_box_pack_start (vbox, val_label, TRUE, TRUE, 0);
	gtk_label_set_text (val_label, "0");

	test.lower = generic_close_button(main_vbox, window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
