/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A web viewer with more features (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgwebviewdesignerplugin.h"
#include "skgwebview.h"

#include "kicon.h"

#include <QtPlugin>

SKGWebViewDesignerPlugin::SKGWebViewDesignerPlugin(QObject* parent)
    : QObject(parent)
{
    m_initialized = false;
}

void SKGWebViewDesignerPlugin::initialize(QDesignerFormEditorInterface* /* core */)
{
    if (m_initialized) return;

    m_initialized = true;
}

bool SKGWebViewDesignerPlugin::isInitialized() const
{
    return m_initialized;
}

QWidget* SKGWebViewDesignerPlugin::createWidget(QWidget* parent)
{
    return new SKGWebView(parent);
}

QString SKGWebViewDesignerPlugin::name() const
{
    return "SKGWebView";
}

QString SKGWebViewDesignerPlugin::group() const
{
    return "SKG Widgets";
}

QIcon SKGWebViewDesignerPlugin::icon() const
{
    return KIcon("skg_open");
}

QString SKGWebViewDesignerPlugin::toolTip() const
{
    return "A web viewer with more features";
}

QString SKGWebViewDesignerPlugin::whatsThis() const
{
    return "A web viewer with more features";
}

bool SKGWebViewDesignerPlugin::isContainer() const
{
    return false;
}

QString SKGWebViewDesignerPlugin::domXml() const
{
    return "<widget class=\"SKGWebView\" name=\"SKGWebView\">\n"
           " <property name=\"geometry\">\n"
           "  <rect>\n"
           "   <x>0</x>\n"
           "   <y>0</y>\n"
           "   <width>100</width>\n"
           "   <height>10</height>\n"
           "  </rect>\n"
           " </property>\n"
           "</widget>\n";
}

QString SKGWebViewDesignerPlugin::includeFile() const
{
    return "skgwebview.h";
}

