/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGPROPERTYEDITOR_H
#define SKGPROPERTYEDITOR_H
/** @file
 * A property editor for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "ui_skgpropertyeditor.h"
#include "skgbankgui_export.h"

#include <QWidget>
#include <skgservices.h>

class SKGDocument;


/**
 * This file is a property editor for skrooge
 */
class SKGBANKGUI_EXPORT SKGPropertyEditor : public QWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGPropertyEditor(QWidget *parent = 0);


    /**
     * Default Destructor
     */
    virtual ~SKGPropertyEditor();


    /**
     * Set parameters
     * @param iDocument the document
     * @param iTable the table
     * @param iEditableAttribute the list of attributes (empty means all attributes supported of the table)
     * @param iOtherAttributes the list of other attributes (empty means all attributes supported of the table)
     */
    virtual void setParameters(SKGDocument* iDocument, const QString& iTable, const QStringList& iEditableAttribute, const QStringList& iOtherAttributes);


    /**
     * Set values in widgets
     * @param iXML the XML String describing the operation line
     */
    virtual void setXMLCondition(QString iXML);

public Q_SLOTS:

    /**
     * Shows or hide relevant widgets depending on the attribute type and selected operation
     */
    virtual void setupWidgets();

private:
    Q_DISABLE_COPY(SKGPropertyEditor);

    Ui::skgpropertyeditor_base ui;

    QString m_table;
    SKGDocument* m_document;
    SKGServices::SKGAttributesList m_listAtts;
    SKGServices::SKGAttributesList m_listOtherAtts;

    QStringList m_listOperations;
};

#endif // SKGPROPERTYEDITOR_H
