/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef TIPSOFTHEDAYAPPLET_H
#define TIPSOFTHEDAYAPPLET_H
/** @file
* This file is Plasma Applet for Tip of the Day Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/PopupApplet>
#include <Plasma/Label>
#include <Plasma/ToolButton>

#include <KTipDatabase>

class QGraphicsLinearLayout;
/**
 * Class FileSkroogoid
 */
class TipsOfTheDayApplet : public Plasma::Applet
{
    Q_OBJECT

public:
    /**
      * Default Constructor
      */
    TipsOfTheDayApplet(QObject *parent, const QVariantList &args);

    /**
      * Default Destructor
      */
    ~TipsOfTheDayApplet();

private:
    /**
      * QGraphicsLinearLayout layout for adding items
      */
    QGraphicsLinearLayout *m_layout;

    Plasma::Label* displayLabel;
    Plasma::ToolButton* previous_tip_button;
    Plasma::ToolButton* next_tip_button;

    /**
     * The Tips of the Day database
     */
    KTipDatabase* tipDB;

private Q_SLOTS:
    /**
    * function to display the next tip of the day on button click
    */
    void nextClicked();

    /**
    * function to display the previous tip of the day on button click
    */
    void previousClicked();
};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(tipsofthedayapplet, TipsOfTheDayApplet)

#endif
