/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Bank Skroogoid
*
* @author Siddharth SHARMA
*/

#include "bankskroogoid.h"
#include "skgdocumentbank.h"
#include "skgservices.h"
#include "skgmainpanel.h"

#include <QGraphicsGridLayout>
#include <KMessageBox>
#include <qgraphicsscene.h>
#include <Plasma/ToolButton>

BankSkroogoid::BankSkroogoid(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
{}

BankSkroogoid::~BankSkroogoid()
{}

void BankSkroogoid::init()
{
    // This is the layout for the whole widget
    widgetLayout = new QGraphicsGridLayout();
    setLayout(widgetLayout);

    // Get the current document
    Plasma::DataEngine* engine = dataEngine("skgdataengine");
    if(engine->isValid())  engine->connectSource("Banks", this);
}

void BankSkroogoid::dataUpdated(const QString sourceName, const Plasma::DataEngine::Data& engineData)
{
    if(sourceName != "Banks") return;

    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    doc = qobject_cast<SKGDocumentBank*> (panel->getDocument());
    // Get the primary unit
    SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();

    QHash<QString, QVariant> listData;
    for(int i = 0 ; i < engineData.keys().count() ; ++i) {
        const QString bankName = engineData.keys().at(i);
        QVariant bankValue = engineData.value(bankName);

        listData[bankName] = bankValue;

    }

    //Initialisation
    int nb = widgetLayout->count();
    for(int i = 0; widgetLayout && i < nb; ++i) {
        QGraphicsLayoutItem* item = widgetLayout->itemAt(0);
        if(item) {
            widgetLayout->removeAt(0);
            delete item;
        }
    }

    nb = listData.count();

    if(nb == 0) {
        Plasma::Label* noAccountLabel = new Plasma::Label();
        noAccountLabel->setText("No account defined yet !");
        widgetLayout->addItem(noAccountLabel, 0, 0);
        // TODO: Add a button to the banks & account Tab
        return;
    }

    double sum = 0;
    for(int i = 0; i < nb; ++i) {
        // Get values in the dataengine
        QString bankName = listData.keys().at(i);
        QVariant bankValueVariant = listData[bankName];
        double bankValue = bankValueVariant.toDouble();

        // Create a button for the bank
        Plasma::ToolButton* bankButton = new Plasma::ToolButton();
        bankButton->setText(bankName);
        widgetLayout->addItem(bankButton, i, 0);
        connect(bankButton, SIGNAL(clicked()), this, SLOT(openBankTab()));


        // Create label for the value
        Plasma::Label* valueLabel = new Plasma::Label();
        valueLabel->setText(doc->formatMoney(bankValue, primary));
        valueLabel->setAlignment(Qt::AlignRight);
        widgetLayout->addItem(valueLabel, i, 1);

        sum = sum + bankValue;
    }

    // Add A total line
    Plasma::Label* totalLabel = new Plasma::Label();
    totalLabel->setText(i18nc("Noun, the sum of of several numerical values", "Total"));
    QFont totalFont = totalLabel->font();
    totalFont.setBold(true);
    totalLabel->setFont(totalFont);
    widgetLayout->addItem(totalLabel, nb, 0);


    Plasma::Label* totalValue = new Plasma::Label();
    totalValue->setText(doc->formatMoney(sum, primary));
    totalValue->setAlignment(Qt::AlignRight);
    widgetLayout->addItem(totalValue, nb, 1);
}

void BankSkroogoid::openBankTab()
{
    // Create a dom document, containing relevant parameters
    QDomDocument params("SKGML");

    // Get default parameters from the current Skrooge document
    params.setContent(doc->getParameter("SKGOPERATION_DEFAULT_PARAMETERS"));
    QDomElement root = params.documentElement();
    if(root.isNull()) {
        root = params.createElement("parameters");
        params.appendChild(root);
    }

    // And finally, open a new tab for units
    SKGMainPanel::getMainPanel()->openPage(SKGMainPanel::getMainPanel()->getPluginByName("Skrooge bank plugin"), -1, params.toString());
}

#include "bankskroogoid.moc"
