#
# Threshold a value around zero
#
# Input pins
#	in (float)
#
# Output pins
# 	out (float)
#
# Arguments
#	-lsld <label>	Slider label
#	-lchk <label>	Checkbox label
#	-max <num>		Max range
#	-v <num>		Initial value

type around_zero_threshold
name "Threshold"
args -lsld -lchk -max -v

# Input pin
create forward forward
export_ipin forward in in float

#
# Threshold
#
create fthreshold thresneg -a 0 -b orig_minus_thres
create fthreshold threspos -a orig_minus_thres -b 0
create fadd add_thres

connect forward out threspos value
connect forward out thresneg value
connect threspos result add_thres b
connect thresneg result add_thres a

# Slider
create widget_slider sldthres --min 0 --max $-max$ -v $-v$ -l \"$-lsld$\" --log 1
connect sldthres value threspos thres
create fmul neg -v -1.0
connect sldthres value neg a
connect neg result thresneg thres

# Checkbox to show if motion detected
create widget_checkbox chkmotion -l \"$-lchk$\"
create fneq hasmotion -v 0 
connect add_thres result hasmotion a
connect hasmotion result chkmotion value

# Export motion value
export_opin add_thres result out

begin_gui_layout
	layout_begin vbox
		component sldthres
		component chkmotion
	layout_end
end_gui_layout
