# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: sitemap created from parameters extracted from input file(s)

=end
module SiSU_Embedded
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  class Source
    def initialize(opt)
      @opt=opt
      @md=SiSU_Param::Parameters.new(@opt).get
      @env=SiSU_Env::InfoEnv.new(@md.fns)
      @rhost=SiSU_Env::InfoRemote.new(@opt).remote_host_base
      @base_src_dir=@opt.f_pth[:pth].sub(/\/#{@opt.f_pth[:lng]}$/,'')
      @f=SiSU_Env::FileOp.new(@md)
    end
    def read
      songsheet
    end
    def songsheet
      images
      audio
      multimedia
      begin
      rescue; SiSU_Errors::InfoError.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def images
      src="#{@base_src_dir}/_sisu/image"
      src_img='_sisu/image'
      ldest=@env.path.output
      img_dir="#{@env.path.output}/_sisu/image"
      @rhost.each do |remote_conn|
        rdest="#{remote_conn[:name]}/#{@env.path.stub_pwd}/_sisu/image"
        remote_rel=remote_conn[:name] + '/' + @f.output_path.stub.rcp
        if @md.opt.cmd.inspect =~/[vVMR]/ \
        and FileTest.directory?(src)
          FileUtils::mkdir_p(img_dir) unless FileTest.directory?(img_dir)
          src_ec=@f.place_file.images.rel + '/' + @md.ec[:image].join(" #{@f.output_path.images.rel}/")
          unless @opt.fns =~/\.-sst$/
            SiSU_Env::SystemCall.new(src_ec,ldest,'q').rsync('--relative',@opt.base_path)
            #if @md.opt.cmd.inspect =~/R/ #rsync to remote image directory
            #  SiSU_Env::SystemCall.new(src_ec,remote_rel,'q').rsync('--relative')
            #end
          end
        end
      end
    end
    def audio
      #p @md.ec[:audio]
      src="#{@base_src_dir}/_sisu/mm/audio"
      ldest="#{@env.path.webserv}/#{@env.path.stub_pwd}/_sisu/mm/audio"
      @rhost.each do |remote_conn|
        rdest="#{remote_conn[:name]}/#{@env.path.stub_pwd}/_sisu/mm/audio"
        if @md.opt.cmd.inspect =~/[vVMR]/ \
        and FileTest.directory?(src)
          FileUtils::mkdir_p(ldest) unless FileTest.directory?(ldest)
          src_ec="#{src}/" + @md.ec[:audio].join(" #{src}/")
          SiSU_Env::SystemCall.new(src_ec,"#{ldest}/.",'q').rsync
          if @md.opt.cmd.inspect =~/R/ #rsync to remote audio directory
            SiSU_Env::SystemCall.new(src_ec,"#{rdest}/.",'q').rsync
          end
        end
      end
    end
    def multimedia
      #p @md.ec[:multimedia]
      src="#{@base_src_dir}/_sisu/mm/video"
      ldest="#{@env.path.webserv}/#{@env.path.stub_pwd}/_sisu/mm/video"
      @rhost.each do |remote_conn|
        rdest="#{remote_conn[:name]}/#{@env.path.stub_pwd}/_sisu/mm/video"
        if @md.opt.cmd.inspect =~/[vVMR]/ \
        and FileTest.directory?(src)
          FileUtils::mkdir_p(ldest) unless FileTest.directory?(ldest)
          src_ec="#{src}/" + @md.ec[:multimedia].join(" #{src}/")
          SiSU_Env::SystemCall.new(src_ec,"#{ldest}/.",'q').rsync
          if @md.opt.cmd.inspect =~/R/ #rsync to remote video directory
            SiSU_Env::SystemCall.new(src_ec,"#{rdest}/.",'q').rsync
          end
        end
      end
    end
  end
end
__END__
