# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: texinfo formatting template

=end
module SiSU_Texinfo_format
  @@table_pg_break_counter=1
  require_relative 'param'                              # param.rb
    include SiSU_Param
  include SiSU_Viz
  class Texinfo
    @@tex_1='\\\\~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    def initialize(md,dob=nil)
      @md,@dob=md,dob
      if dob.class==Hash
        p dob.class
        p caller
      elsif dob.class==String
        p dob.class
        p caller
      end
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def head
      t=Time.now
      year=t.year
      filename=%{#{@md.fns}}[/(.+?)\.\w\w\d\d$/,1]
      title=spec_char(@md.title.full)
      title=title.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{Tex[:backslash]*2} ")
      title.gsub!(/\$/,"\\$")
      title.gsub!(/[,]\s*/,' - ')
      if @md.title.sub
        subtitle=spec_char(@md.title.sub)
        subtitle=subtitle.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{Tex[:backslash]*2} ")
        subtitle.gsub!(/\$/,"\\$")
        subtitle.gsub!(/[,]\s*/,' - ')
        subtitle="@subtitle @value{VERSION}, @value{UPDATED}\n" #bugwatch
      end
      subtitle ||=''
      author=@md.author if @md.author
      author ||=''
      author.gsub!(/[\*]/,'') #if author
      v=SiSU_Env::Info_version.instance.get_version
      head =<<WOK
\\input texinfo   @c -*-texinfo-*-
@comment $Id$
@comment %**start of header
@setfilename #{@md.fnb}.info
@settitle #{title} @value{VERSION}
@syncodeindex pg cp
@comment %**end of header
@c %% 2
@copying
SiSU texinfo of #{title}

Copyright @copyright{} #{year} #{author}.

@quotation
Copyright #{author}, generated by ``SiSU''
@end quotation
@end copying

@dircategory SiSU Texinfo
@direntry
* sisu: SiSU texinfo file.
@end direntry
WOK
      if @md.title.sub
        titlepage=<<WOK
@c %% 3
@titlepage
@title #{title} #{subtitle}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage
@contents
WOK
      else
        titlepage=<<WOK
@c %% 3
@titlepage
@title #{title}
@value{VERSION}, @value{UPDATED}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage

@contents
WOK
      end
      "#{head}#{titlepage}"
    end
    def topnode(txt)
      txt=spec_char(txt)
      txt=txt.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{Tex[:backslash]*2} ")
      txt.gsub!(/\$/,"\\$")
      txt.gsub!(/[,]\s*/,' - ')
      "@c %% 4\n" +
        "@ifnottex\n" +
        "@node Top\n" +
        "@top #{txt}\n\n" +
        "@insertcopying\n" +
        "@end ifnottex\n\n" +
        "@menu\n"
    end
    def dublincore
      title=spec_char(@md.title.main) if @md.title.main
      subtitle=spec_char(@md.title.sub) if @md.title.sub
      if defined? @md.title.full \
      and @md.title.full=~/\S+/
        full_title=spec_char(@md.title.full)
      end
      if defined? @md.creator.author \
      and @md.creator.author=~/\S+/
        author=spec_char(@md.creator.author)
      end
      if defined? @md.classify.subject \
      and @md.classify.subject=~/\S+/
        subject=spec_char(@md.classify.subject)
      end
      if defined? @md.notes.description \
      and @md.notes.description=~/\S+/
        description=spec_char(@md.description)
      end
      if defined? @md.publisher \
      and @md.publisher=~/\S+/
        publisher=spec_char(@md.publisher)
      end
      if defined? @md.creator.contributor \
      and @md.creator.contributor=~/\S+/
        contributor=spec_char(@md.contributor)
      end
      if defined? @md.date.published \
      and @md.date.published=~/\S+/
        date=spec_char(@md.date.published)
      end
      if defined? @md.date.created \
      and @md.date.created=~/\S+/
        date_created=spec_char(@md.date.created)
      end
      if defined? @md.date.issued \
      and @md.date.issued=~/\S+/
        date_issued=spec_char(@md.date.issued)
      end
      if defined? @md.date.available \
      and @md.date.available=~/\S+/
        date_available=spec_char(@md.date.available)
      end
      if defined? @md.date.valid \
      and @md.date.valid=~/\S+/
        date_valid=spec_char(@md.date.valid)
      end
      if defined? @md.date.modified \
      and @md.date.modified=~/\S+/
        date_modified=spec_char(@md.date.modified)
      end
      type=spec_char(@md.type) if @md.type                                   #dc
      if defined? @md.classify.format \
      and @md.classify.format=~/\S+/
        format=spec_char(@md.classify.format)
      end
      if defined? @md.classify.identifier \
      and @md.classify.identifier=~/\S+/
        identifier=spec_char(@md.classify.identifier)
      end
      if defined? @md.original.source \
      and @md.original.source=~/\S+/
        source=spec_char(@md.original.source)
      end
      if defined? @md.title.language \
      and @md.title.language=~/\S+/
        language=spec_char(@md.title.language)
      end
      if defined? @md.classify.relation \
      and @md.classify.relation=~/\S+/
        relation=spec_char(@md.classify.relation)
      end
      if defined? @md.classify.coverage \
      and @md.classify.coverage=~/\S+/
        coverage=spec_char(@md.classify.coverage)
      end
      if defined? @md.rights.all \
      and @md.rights.all=~/\S+/
        rights=spec_char(@md.rights.all)
      end
      rights=spec_char(@md.rights.all)
      full_title="Title: #{full_title}\n\n" if full_title                           #dc
      author="Author: #{author}\n\n" if author                                      #dc
      subject="Subject: #{subject}\n\n" if subject                                  #dc
      description="Description: #{description}\n\n" if description                  #dc
      publisher="Publisher: #{publisher}\n\n" if publisher                          #dc
      contributor="Contributor: #{contributor}\n\n" if contributor                  #dc
      date="Date: #{date}\n\n" if date                                              #dc
      date_created="Date Created: #{date_created}\n\n" if date_created              #dc
      date_issued="Date Issued: #{date_issued}\n\n" if date_issued                  #dc
      date_available="Date Available: #{date_available}\n\n" if date_available      #dc
      date_valid="Date Valid: #{date_valid}\n\n" if date_valid                      #dc
      date_modified="Date Modified: #{date_modified}\n\n" if date_modified          #dc
      format="Format: #{format}\n\n" if format                                      #dc
      identifier="Identifier: #{identifier}\n\n" if identifier #watch               #dc
      source="Source: #{source}\n\n" if source                                      #dc
      language="Language: #{language}\n\n" if language                              #dc
      relation="Relation: #{relation}\n\n" if relation                              #dc
      coverage="Coverage: #{coverage}\n\n" if coverage                              #dc
      rights="Rights: #{rights}\n\n" if rights                                      #dc
      "@node Dublin Core\n" +
        "@unnumbered Dublin Core\n" +
        "@cindex chapter, Dublin Core\n\n" +
        "#{full_title}" +
        "#{author}" +
        "#{subject}" +
        "#{description}" +
        "#{publisher}" +
        "#{contributor}" +
        "#{date}" +
        "#{date_created}" +
        "#{date_issued}" +
        "#{date_available}" +
        "#{date_valid}" +
        "#{date_modified}" +
        "#{format}" +
        "#{identifier}" +
        "#{source}" +
        "#{language}" +
        "#{relation}" +
        "#{coverage}" +
        "#{rights}" +
        "\n\n"
    end
    def tail
     "@c %% 6\n" +
      "@node Index\n" +
      "@unnumbered Index\n" +
      "@printindex cp\n\n" +
      "@bye"
    end
    def clean(dob)
      if dob.is=='heading' \
      and dob.obj !~/##{dob.ocn}/
        dob.obj="#{dob.obj} ##{dob.ocn}"
      end
      dob.obj.gsub!(/<:#>/,'')
      dob.obj.strip!
      dob
    end
    def menu
      dob=clean(@dob)
      m=dob.obj
      m.gsub!(/[:,]\s*/,' - ')
      m.gsub!(/@footnote\{.+?\}\s+/,'')
      m="* #{m}::"
    end
    def level1
      dob=clean(@dob)
      nd=dob.obj.gsub(/@footnote\{.+?\}\s+/,'')
      dob.obj="@node #{nd}\n@unnumbered #{dob.obj}\n@cindex chapter, #{nd}\n"
      dob
    end
    def level2
      dob=clean(@dob)
      nd=dob.obj.gsub(/@footnote\{.+?\}\s+/,'')
      dob.obj="@node #{nd}\n@unnumbered #{dob.obj}\n@cindex chapter, #{nd}\n"
      dob
    end
    def level3
      dob=clean(@dob)
      nd=dob.obj.gsub(/@footnote\{.+?\}\s+/,'')
      dob.obj="@node #{nd}\n@unnumbered #{dob.obj}\n@cindex chapter, #{nd}\n"
      dob
    end
    def level4
      dob=clean(@dob)
      nd=dob.obj.gsub(/@footnote\{.+?\}\s+/,'')
      dob.obj="@node #{nd}\n@unnumbered #{dob.obj}\n@cindex chapter, #{nd}\n"
      dob
    end
    def level5
      dob=clean(@dob)
      nd=dob.obj.gsub(/@footnote\{.+?\}\s+/,'')
      dob.obj="@node #{nd}\n@unnumbered #{dob.obj}\n@cindex chapter, #{nd}\n"
      dob
    end
    def level6
      dob=clean(@dob)
      nd=dob.obj.gsub(/@footnote\{.+?\}\s+/,'')
      dob.obj="@node #{nd}\n@unnumbered #{dob.obj}\n@cindex chapter, #{nd}\n"
      dob
    end
    def submenu
      @dob.obj=@dob.obj.join("\n")
      @dob.obj.gsub!(/[5]\\+~\S+/,'')
      dob=clean(@dob)
      dob.obj="@menu\n#{dob.obj}\n@end menu\n\n"
      dob.obj.gsub!(/.+/m,"#{dob.obj}")
    end
    def subsubmenu
      @dob.obj=@dob.obj.join("\n")
      @dob.obj.gsub!(/[6]\\+~\S+/,'')
      dob=clean(@dob)
      dob.obj="@menu\n#{dob.obj}\n@end menu\n\n"
      dob.obj.gsub!(/.+/m,"#{dob.obj}")
    end
    def indent1
      @dob.obj.gsub!(/<:i1>(.*)/,'\1')
    end
    def indent2
      @dob.obj.gsub!(/<:i2>(.*)/,'\1')
    end
    def spec_char(txt) # special characters
      txt.gsub!(/#{Mx[:br_eof]}/i,'')
      txt.gsub!(/#{Mx[:gl_o]}#169#{Mx[:gl_c]}/,'(c)')
      txt.gsub!(/#{Mx[:gl_o]}#(?:lt|060)#{Mx[:gl_c]}/,'<'); txt.gsub!(/#{Mx[:gl_o]}(gt|#062)#{Mx[:gl_c]}/,'>')
      txt.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{'); txt.gsub!(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'}')
      txt.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/i,'~')
      txt.gsub!(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!')
      txt.gsub!(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'#')
      txt.gsub!(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*')
      txt.gsub!(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'/')
      txt.gsub!(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'_')
      txt.gsub!(/#{Mx[:gl_o]}#092#{Mx[:gl_c]}/,'\\')
      txt.gsub!(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})\s*/,"\n\n")                                   # watch
      txt.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ')
      #txt.gsub!(/\\/,'\\backslash ')
      txt.gsub!(/<:pb>/,'\\newpage')
      txt.gsub!(/\\backslash copyright/,'\\copyright ')
      txt.gsub!(/\^/,'\\wedge ')
      txt.gsub!(/(\$)/,"\\$")
      txt.gsub!(/\~/,'\\~')
      txt.gsub!(/#{Mx[:url_o]}(https?:\S+?)#{Mx[:url_c]}/,'<\1>')
      txt.gsub!(/#{Mx[:url_o]}_(https?:\S+?)#{Mx[:url_c]}/,'\1')
      txt.gsub!(/§/i,'\S')
      txt.gsub!(/£/i,'\pounds')
      txt.gsub!(/å/,'\aa'); txt.gsub!(/Å/,'\AA')
      txt.gsub!(/æ/,'\ae'); txt.gsub!(/Æ/,'\AE')
      txt.gsub!(/ø/,'\o'); txt.gsub!(/Ø/,'\O')
      txt.gsub!(/<a href=".+?">/i,' ')
      txt.gsub!(/<\/a>/i,' ')
      txt.gsub!(/<!>/i,' ')
      txt.gsub!(/#{Mx[:br_paragrph]}/i,'') #watch
      txt.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'*\1*')
      txt.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'/\1/')
      txt.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'_\1_')
      txt.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'[\1]')
      txt.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'^\1^')
      txt.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'+\1+')
      txt.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'"\1"')
      txt.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'-\1-')
      txt.gsub!(/@/i,'@@')
      txt.gsub!(/\{/,'@{'); txt.gsub!(/\}/,'@}')
      txt.gsub!(/(?:&nbsp;|#{Mx[:nbsp]})+/,' ')        # ~ character for hardspace
      txt.gsub!(/&(\S+?);/,' ')
      txt.gsub!(/&/,'<=and>')
      txt.gsub!(/(\s+&\s+)/,' and ')
      txt.gsub!(/(\&)/,"\\&")
      txt.gsub!(/"(.+?)"/,"`\\1'")                                        # open & close "
      txt.gsub!(/\s+"/," `")                                              # open "
      txt.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*"/,'\1`')       # open "
      txt.gsub!(/"(\s|\.|,|:|;)/,"'\\1")                                  # close "
      txt.gsub!(/"([1-6-]\\+(?:~\S+)?|<.+?>)?\s*$/,"'\\1")       # close "
      txt.gsub!(/"(\.|,)/,"'")                                            # close "
      txt.gsub!(/\s+'/," `")                                              # open '
      txt.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*'/,'\1`')       # open '
      txt.gsub!(/(<font.*?>|<\/font>)/,'')
      txt
    end
    def longtable
      @end_table="\\end{longtable}"
      @row_break='\\\\\\'
      if @dob[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/ui] #CHECK !> closure #fix
        no_of_cols,cols_width=$1,$2
        @@tableheader=1 if @dob =~ /#{Mx[:gr_o]}Th/i #fix
        @w=cols_width.split(/;\s+/)
        @@number_of_cols=no_of_cols
        @colW=[]
        @colW << '{'
        @w.each  do |x|
          col_w=x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "#{col_w}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @@start_table="\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{longtable}[hb]#{@colW}\n"
        @dob.obj.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#{@@start_table}") #fix
      end
      if @dob =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/ #fix
        @dob.obj.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/," #{@end_table}") #fix
      end
      @dob.obj.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
      if @@tableheader==1
        if @dob =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
          tablefoot=para[/\<!f(.+?)!\>/,1]
          @dob.obj.gsub!(/\<!f(.+?)!\>/,'')
          @dob.obj.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,
          "{\\begin{tiny} {\\bfseries \\1}\\end{tiny}}&")
          @dob.obj.gsub!(/&>\s*$/,
          " #{@row_break} \\hline\\endhead #{@row_break}")
          @dob="#{@dob} \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader=0
          @@number_of_cols=0
        end
      else
        if @dob =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
          @dob.obj.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,"\\begin{tiny}\\1\\end{tiny}&")
          @dob.obj.gsub!(/&>\s*$/," #{@row_break}")
        end
      end
      @dob
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable
      # that are not included yet here, so until synced is broken on some
      # input files, work needs to be done if is to work as before
      @end_table="\\end{tabular}"
      @row_break='\\\\\\\\'
      @break_page="#{@row_break}\n#{@row_break} \n"
      if @dob[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/ui] #fix
        no_of_cols,cols_width=$1,$2
        @w=cols_width.split(/;\s+/)
        @colW=[]
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @@start_table="\\begin{tabular}{#{@colW}}\n"
        @dob.obj.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#{@@start_table}") #fix
      end
      if @dob =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/ #fix
        @dob.obj.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/,"#{@end_table}") #fix
        @@table_pg_break_counter=1
      end
      if @dob =~/#{Mx[:tc_o]}#{Mx[:tc_p]}/u
        if @@table_pg_break_counter==28 # taken from 34 ideal for portrait to 28 which suits landscape
          @dob =
            "\n\n#{@end_table} \n" +
            "#{@break_page}" +
            "#{@@start_table}\n"
          @@table_pg_break_counter=1
        else
          @dob.obj.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
          @@table_pg_break_counter+=1
          tablefoot=@dob[/\<!f(.+?)!\>/]
          @dob.obj.gsub!(/\<!f(.+?)!\>/,'')
        end
      end
      if @dob =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
      @dob.obj.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,"\\begin{tiny}\\1\\end{tiny}&")
      @dob.obj.gsub!(/&>\s*$/,"#{@row_break}")
      end
      @dob
    end
    def graphics
      dir=SiSU_Env::Info_env.new(@md.fns)
      @dob.obj.gsub!(/<::\s+(\S+?)\s+>/i, #watch
        "\\includegraphics*[width=11pt]{#{dir.path.image_source_include}/c_\\1.png}")
    end
    def image
      dir=SiSU_Env::Info_env.new(@md.fns)
      width="100"
      width=@dob[/<:image.+?width=``(\d+)''.+?>/im,1]
      width=width.to_i*0.4
      @dob.obj.gsub!(/<:image\s+((?:https?|file|ftp)\S+)\s+(\S+)\s+.+\s+?>/i,
        "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_include}/\\2}}")
      @dob.obj.gsub!(/<:image\s+(\S+)\s+.+\s+?>/i,
        "\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_include}/\\1}")
    end
    def png
      # very messy clean up ! - work area, testing
      z=@dob[/\\\{(.+?)\}(?:image|png)/,1] # match operator for z \\ fragile !
      image,w,x,y=z.scan(/\S+/)
      image.gsub!(/\\/,'')
      @dob.obj.gsub!(/\\\{\S+\.(png|jpg|gif).+?\}(image|png)/,"<image #{image} not available>")  # fragile match operator\\ fragile !
    end
    def http
      # very messy clean up ! - work area, testing
      z=@dob[/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/,1] # match operator for z \\ fragile !
      url=@dob[/((?:https?|file|ftp):\S+)/im,1]
      if @dob =~/\.(png|jpg|gif)/
        image,w,x,y=z.scan(/\S+/)
        image.gsub!(/\\/,'')
        width=200
        width=z[/w=(\d+)/im,1] if z =~/w=(\d+)/
        width=width.to_i*0.8
        width=400 if width > 400
        c=z[/``(.+?)''/im,1]
        caption="{\\\\\\\ \n\\begin{scriptsize}#{c}\\end{scriptsize}&}" if c
      end
      if image
        dir=SiSU_Env::Info_env.new(@md.fns)
        @dob.obj.gsub!(/#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/, # fragile match operator\\ fragile !
          "\n\\href{#{url}}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_include}/#{image}}}#{caption}")
      else
        link=z[/(.+?)\\/im,1]
        @dob.obj.gsub!(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+#{Mx[:url_c]}/,"\n\\noindent\\href{#{url}}{#{link}}")  # fragile match operator\\ fragile !
      end
    end
  end
  class Texinfo_txt
    def initialize(md,dob,txt)
      @md,@dob,@txt=md,dob,txt
    end
    def clean(dob,txt)
      if dob.is=='heading' \
      and txt !~/##{dob.ocn}/
        txt="#{dob.obj} ##{dob.ocn}"
      end
      txt.gsub!(/<:#>/,'')
      txt.strip!
      txt
    end
    def submenu
      txt=@txt.join("\n")
      txt.gsub!(/[5]\\+~\S+/,'')
      txt=clean(@dob,txt)
      txt="@menu\n#{txt}\n@end menu\n\n"
      txt.gsub!(/.+/m,"#{txt}")
    end
    def subsubmenu
      txt=@txt.join("\n")
      txt.gsub!(/[6]\\+~\S+/,'')
      txt=clean(@dob,txt)
      txt="@menu\n#{dob.obj}\n@end menu\n\n"
      txt.gsub!(/.+/m,"#{txt}")
    end
  end
end
__END__
watch title, might need full_title
