# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: generates naive cgi search form for search of sisu database (pgsql sqlite)

=end
module  SiSU_CGI_sqlite                                                            #% database building documents
  require_relative 'sysenv'                             # sysenv.rb
  require_relative 'cgi_sql_common'                     # cgi_sql_common.rb
    include SiSU_CGI_sql
  class SiSU_search_sqlite < SiSU_CGI_common
    def initialize(opt,webserv)
      @opt,@webserv=opt,webserv
      @env=SiSU_Env::Info_env.new('',opt)
      @image_src="#{@env.url.webserv_cgi}/_sisu/image_sys"
      @common=SiSU_CGI_sql::SiSU_CGI_common.new(@webserv,@opt,@image_src,@env)
      @cgi_file_name="#{Db[:name_prefix_db]}by_#{opt.dir_structure_by}_sqlite.cgi"
    end
    def sqlite
      serve=[]
      Dir.foreach(@env.path.webserv) do |x|
        if x !~/^\./ \
        and FileTest.directory?("#{@env.path.webserv}/#{x}")
          if FileTest.file?("#{@env.path.webserv}/#{x}/sisu_sqlite.db")
            serve << x unless x =~/^_\S+/
          end
        end
      end
      serve.sort!
      f1,f2,f3='','',''
      serve.each do |x|
        f1 << %{              <option value="#{Db[:name_prefix]}#{x}">#{x}</option>\n}
      end
      f2 <<  %{          selected_db=case cgi['db']\n}
      serve.each do |x|
        f2 << %{           when /#{Db[:name_prefix]}#{x}/; '<option value="#{Db[:name_prefix]}#{x}">#{x}</option>'\n}
      end
      f2 << "          end\n"
      f3 << %{          db_name='sisu_sqlite.db'\n}
      f3 << %{          db_sqlite=case cgi['db']\n}
      serve.each do |x|
        f3 << %{          when /#{Db[:name_prefix]}#{x}/;                      "#{@env.path.webserv}/#{x}/sisu_sqlite.db"\n}
      end
      f3 << %{           else  '#{@env.path.webserv}/#{serve[0]}/sisu_sqlite.db'\n          end\n}
      if FileTest.writable?('.')
        output=File.open(@cgi_file_name,'w')
        output << header0 << header1 << header_desc << header2 << f1 << buttons1 << buttons2 << search_request << search_statement << search_statement_common << search_query1 << @common.pages << search_query2 << @common.tail << @common.main1 << f2 << f3 << dbi_connect << @common.main2 << @common.dir_structure << @common.main3
        a=%{        generated sisu_sqlite.cgi,
            BASED ON ALREADY CREATED sisu_sqlite.db OUTPUT, (-d)
        }
        SiSU_Screen::Ansi.new(@opt.cmd,a).print_grey
        c=case @webserv
        when /pwd/; ''
        else "if necessary make the directory /usr/lib/cgi-bin :
                  sudo cp -vi #{Dir.pwd}/#{@cgi_file_name} /usr/lib/cgi-bin/.
                  sudo chmod -v 755 /usr/lib/cgi-bin/#{@cgi_file_name}
                  sudo ln -s /usr/lib/cgi-bin/#{@cgi_file_name} /usr/lib/cgi-bin/sisu_sqlite.cgi
                  (copy #{@cgi_file_name} to your cgi directory) set file permissions to 755, and make symbolic link to sisu_sqlite.cgi"
        end
        a=%{#{c}
                  #{@env.webserv_base_cgi}/cgi-bin/sisu_sqlite.cgi
        }
        b='(to create and populate sisu sqlite database see "man sisu" and in particular the -d flag)'
        SiSU_Screen::Ansi.new(@opt.cmd,a,b).warn
      else puts "failed in attempt to write #{@cgi_file_name} to present directory, is directory writable?"
      end
    end
    def header0
      <<-WOK_SQL
#!/usr/bin/env ruby
=begin
#{about}
 * Description: generates naive cgi search form for search of sisu database (sqlite)
#{gpl}
=end
      require 'cgi'
      require 'fcgi'
      require 'dbi'
      @version='sisu_sqlite'
      @image_src="#{@env.url.webserv_cgi}/_sisu/image_sys"
      @hosturl_db="#{@env.url.webserv_base_cgi}"
      @hosturl_files="#{@env.url.webserv_files_from_db}"
      @db_name_prefix="#{Db[:name_prefix]}"
      WOK_SQL
    end
    def search_statement
      <<-'WOK_SQL'
      class Dbi_search_string
        def initialize(l,t,q,cse=false)
          @l,@t,@q=l,t,q
        end
        def string
          search={ :search => [], :flag => false }
          if @t =~/\S+/ or @q =~/\S+/
            if @t =~/\S+/;     unescaped_search=CGI.unescape(@t)
            elsif @q =~/\S+/;  unescaped_search=CGI.unescape(@q)
            end
            search_construct=[]
            unescaped_search.gsub!(/\s*(AND|OR)\s*/,"%' \) \\1 #{@l} LIKE \( '%")
            unescaped_search.gsub!(/(.+)/,"#{@l} LIKE \( '%\\1%' \)")
            search_construct << unescaped_search
            search_construct=search_construct.join(' ')
            search[:search]                    << search_construct
            search[:flag]=true
            search
          end
          search
        end
      end
      WOK_SQL
    end
    def search_query1
      <<-'WOK_SQL'
          @search_text,@search_endnotes='',''
          search[:text].flatten.each {|x| @search_text << "#{x} AND " }
          @search_text=@search_text.gsub!(/AND\s+$/m,'')
          @search_text.gsub!(/(doc_objects\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\)\s+(?:(?:AND|OR)\s+doc_objects\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\))+)/,'(\1)')
          search[:endnotes].flatten.each {|x| @search_endnotes << "#{x} AND " }
          @search_endnotes=@search_endnotes.gsub!(/AND\s+$/m,'')
          @search_endnotes.gsub!(/(endnotes\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\)\s+(?:(?:AND|OR)\s+endnotes\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\))+)/,'(\1)')
        end
      WOK_SQL
    end
    def search_query2
      <<-'WOK_SQL'
        def sql_select_body
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:body]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, metadata_and_text.notes_suffix, doc_objects.body, doc_objects.seg, doc_objects.ocn, metadata_and_text.tid FROM doc_objects, metadata_and_text WHERE #{@search_text} AND doc_objects.metadata_tid = metadata_and_text.tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, doc_objects.ocn}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:body] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_endnotes
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:endnotes]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, endnotes.body, endnotes.nr, endnotes.ocn, endnotes.metadata_tid FROM metadata_and_text, endnotes WHERE #{@search_endnotes} AND metadata_and_text.tid = endnotes.metadata_tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, endnotes.nr}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:endnotes] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_body_format
          %{<font color="#666666" size="2">#{sql_select_body}</font>}
        end
        def sql_select_endnotes_format
          %{<font color="#666666" size="2">#{sql_select_endnotes}</font>}
        end
        def contents
          @conn.select_all(sql_select_body)
        end
        def endnotes
          @conn.select_all(sql_select_endnotes)
        end
      end
      WOK_SQL
    end
    def dbi_connect
      <<-'WOK_SQL'
          @dbi="DBI:SQLite3:#{db_sqlite}" #sqlite3 ?
          @conn=DBI.connect(@dbi)
      WOK_SQL
    end
  end
end
__END__
