# coding:utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   particulars, composite information about document being processed

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007,
   2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Particulars
  require 'singleton'
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/param"
  require "#{SiSU_lib}/dal"
  include SiSU_Env
  include SiSU_Param
  class Combined_singleton
    include Singleton
    def get_all(opt)
      @opt=opt
      set_env
      set_md
      set_dal                #needs @md
    end
    def get_env(opt)
      @opt=opt
      set_env
    end
    def get_md(opt)
      @opt=opt
      set_md
    end
    def get_dal_array(opt)
      @opt=opt
      set_dal                #needs @md
    end
    def get_env_md(opt)
      @opt=opt
      set_env
      set_md
    end
    attr_accessor :opt,:md
    def set_md
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        self
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      end
    end
    attr_accessor :opt,:env
    def set_env
      begin
        @env=SiSU_Env::Info_env.new(@opt.fns)
        self
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      end
    end
    attr_accessor :opt,:dal_array
    def set_dal
      begin
        @dal_array=@dal_array=SiSU_DAL::Source.new(@md).get
        self
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      end
    end
  end
end
__END__
consider running as separate objects
