# Explicit examples on how to use regressions
#
# run as R --no-save --slave --file=<filename>

library("sg")
#uncomment if make install does not work and comment the library("sg") line above
#dyn.load('sg.so')
#sg <- function(...) .External("sg",...,PACKAGE="sg")

size_cache <- 10
C <- 10
tube_epsilon <- 1e-2
width <- 2.1

fm_train <- as.matrix(read.table('../data/fm_train_real.dat'))
fm_test <- as.matrix(read.table('../data/fm_test_real.dat'))
label_train <- as.real(as.matrix(read.table('../data/label_train_twoclass.dat')))

#
# SVM-based
#

# SVR Light
dosvrlight <- function()
{
	print('SVRLight')

	dump <- sg('set_features', 'TRAIN', fm_train)
	dump <- sg('set_kernel', 'GAUSSIAN', 'REAL', size_cache, width)
	dump <- sg('init_kernel', 'TRAIN')

	dump <- sg('set_labels', 'TRAIN', label_train)

	dump <- sg('new_regression', 'SVRLIGHT')
	dump <- sg('svr_tube_epsilon', tube_epsilon)
	dump <- sg('c', C)
	dump <- sg('train_regression')

	dump <- sg('set_features', 'TEST', fm_test)
	dump <- sg('init_kernel', 'TEST')
	result <- sg('classify')
}
try(dosvrlight())

# LibSVR
print('LibSVR')

dump <- sg('set_features', 'TRAIN', fm_train)
dump <- sg('set_kernel', 'GAUSSIAN', 'REAL', size_cache, width)
dump <- sg('init_kernel', 'TRAIN')

dump <- sg('set_labels', 'TRAIN', label_train)
dump <- sg('new_regression', 'LIBSVR')
dump <- sg('svr_tube_epsilon', tube_epsilon)
dump <- sg('c', C)
dump <- sg('train_regression')

dump <- sg('set_features', 'TEST', fm_test)
dump <- sg('init_kernel', 'TEST')
result <- sg('classify')


#
# misc
#

# KRR
print('KRR')

tau <- 1e-6

dump <- sg('set_features', 'TRAIN', fm_train)
dump <- sg('set_kernel', 'GAUSSIAN', 'REAL', size_cache, width)
dump <- sg('init_kernel', 'TRAIN')

dump <- sg('set_labels', 'TRAIN', label_train)

dump <- sg('new_regression', 'KRR')
dump <- sg('krr_tau', tau)
dump <- sg('c', C)
dump <- sg('train_regression')

dump <- sg('set_features', 'TEST', fm_test)
dump <- sg('init_kernel', 'TEST')
result <- sg('classify')


