
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef MOLECULE_H
#define MOLECULE_H 1
#include <math.h>
#include <QString>
#include <QStringList>
#include <QList>
#include <QtOpenGL>
#include <QtCore>
#ifndef M_PI
#define	M_PI		3.14159265358979323846
#endif
#define ATOM_STYLE_WALLS 1
#define ATOM_STYLE_RINGS 2
#define ATOM_STYLE_SPHERE 4
#define ATOM_STYLE_SOLID 8
#define ATOM_STYLE_WHITERING 16
#define ATOM_STYLE_NOLABEL 32
#define ATOM_STYLE_NOADP 64
#define ATOM_STYLE_PLAID 128
#define ATOM_STYLE_METAL 256
#include <QSettings>
//GLOBAL SETTINGS
//static int global_zero_counter=0;

struct V3 {
  double x, y, z;
  int rc;
  inline V3( void ){}
  inline V3( const double& _x, const double& _y, const double& _z ) : 
  x(_x), y(_y), z(_z), rc(0) {
    ;
  }
  inline V3& operator *= ( const double& d ){
    x *= d;
    y *= d;
    z *= d;
    return *this;
  }
  inline V3& operator += ( const V3& v ){
    x += v.x;
    y += v.y;
    z += v.z;
    return *this;
  } 
  inline V3& operator += ( const double& v ){
    x += v;
    y += v;
    z += v;
    return *this;
  }
};
inline V3 operator + ( const V3& v1, const V3& v2 ) {
  V3 t;
  t.x = v1.x + v2.x;
  t.y = v1.y + v2.y;
  t.z = v1.z + v2.z;
  return t;
}
inline V3 operator - ( const V3& v1, const V3& v2 ) {
  V3 t;
  t.x = v1.x - v2.x;
  t.y = v1.y - v2.y;
  t.z = v1.z - v2.z;
  return t;
}
inline V3 operator * ( const V3& v, const double& d ) {
  V3 t;
  t.x = v.x*d;
  t.y = v.y*d;
  t.z = v.z*d;
  return t;
}
inline V3 operator * ( const double& d, const V3& v ) {
  V3 t;
  t.x = v.x*d;
  t.y = v.y*d;
  t.z = v.z*d;
  return t;
}
inline V3 operator % ( const V3& v1, const V3& v2 ) {
  V3 t;
  t.x = v1.y*v2.z - v2.y*v1.z;
  t.y = v1.z*v2.x - v2.z*v1.x;
  t.z = v1.x*v2.y - v2.x*v1.y;
  return t;
}
inline double operator * ( const V3& v1, const V3& v2 ) {
  return v1.x*v2.x + v1.y*v2.y + v1.z*v2.z;
}
inline double Norm( const V3& v ) {
  return v.x*v.x + v.y*v.y + v.z*v.z;
}
inline double Distance( const V3& v1, const V3& v2 ) {
  return Norm(v1 - v2);
}
inline bool operator == (const V3& v1, const V3& v2 ) {
  //  return ((v1.x==v2.x)&&(v1.y==v2.y)&&(v1.z==v2.z));
  return (Distance(v1,v2)<0.001);
}
inline V3& Normalize( V3 v ) {
static V3 erg=V3(1,0,0);
  if (Norm(v))  erg= (v * (1.0/sqrt(Norm(v)))); 
  return erg; 
}
struct Matrix{
double m11, m21, m31, m12, m22, m32, m13, m23, m33;
 inline Matrix(void){}
 inline Matrix( const V3 &a, const V3 &b, const V3 &c):
	 m11(a.x), m21(b.x), m31(c.x),
	 m12(a.y), m22(b.y), m32(c.y),
	 m13(a.z), m23(b.z), m33(c.z){;}
 inline Matrix( const double& x11, const double& x21, const double& x31,
                const double& x12, const double& x22, const double& x32,
                const double& x13, const double& x23, const double& x33):
	 m11(x11), m21(x21), m31(x31),
	 m12(x12), m22(x22), m32(x32),
	 m13(x13), m23(x23), m33(x33){;}

};
 inline Matrix transponse (Matrix a){//transponse
    return Matrix(
		  a.m11, a.m12, a.m13,
		  a.m21, a.m22, a.m23,
		  a.m31, a.m32, a.m33);
 }
 inline bool operator == (const Matrix &a,const Matrix &b){
     return ((a.m11 == b.m11)&&(a.m21 == b.m21)&&(a.m31 == b.m31)&&
     (a.m12 == b.m12)&&(a.m22 == b.m22)&&(a.m23 == b.m23)&&
     (a.m13 == b.m13)&&(a.m32 == b.m32)&&(a.m33 == b.m33));
 }
inline Matrix operator * (const Matrix &a,const Matrix &b){
  Matrix erg;
  erg.m11 = a.m11 * b.m11 + a.m21 * b.m12 + a.m31 * b.m13;
  erg.m21 = a.m11 * b.m21 + a.m21 * b.m22 + a.m31 * b.m23;
  erg.m31 = a.m11 * b.m31 + a.m21 * b.m32 + a.m31 * b.m33;

  erg.m12 = a.m12 * b.m11 + a.m22 * b.m12 + a.m32 * b.m13;
  erg.m22 = a.m12 * b.m21 + a.m22 * b.m22 + a.m32 * b.m23;
  erg.m32 = a.m12 * b.m31 + a.m22 * b.m32 + a.m32 * b.m33;

  erg.m13 = a.m13 * b.m11 + a.m23 * b.m12 + a.m33 * b.m13;
  erg.m23 = a.m13 * b.m21 + a.m23 * b.m22 + a.m33 * b.m23;
  erg.m33 = a.m13 * b.m31 + a.m23 * b.m32 + a.m33 * b.m33;
  return erg;
}
inline V3 operator * (const Matrix &a, const V3 &b){
  V3 erg;
  erg.x = a.m11*b.x + a.m21*b.y + a.m31*b.z;
  erg.y = a.m12*b.x + a.m22*b.y + a.m32*b.z;
  erg.z = a.m13*b.x + a.m23*b.y + a.m33*b.z;
  return erg;
}
inline V3 operator * (const V3 &a, const Matrix &b){
  V3 erg;
  erg.x = b.m11*a.x + b.m12*a.y + b.m13*a.z;
  erg.y = b.m21*a.x + b.m22*a.y + b.m23*a.z;
  erg.z = b.m31*a.x + b.m32*a.y + b.m33*a.z;
  return erg;
}

typedef struct MyAtom{
  QString Label;
  QString ResiClass;
  QString orginalLine;
  int molindex, symmGroup;
  int hidden;
  double sof_org,sof;
  Matrix uf,uc;
  V3 pos,frac;
  double peakHeight;
  int resiNr;
  int an;
  int part;
  int style;
  int afixParent;
  int afix;
  GLdouble screenX,screenY;
}MyAtom;
inline bool  operator == (const MyAtom &a1,const MyAtom &a2){
  return ((a1.Label == a2.Label)&&(a1.resiNr == a2.resiNr)&&(a1.part == a2.part)&&(a1.symmGroup == a2.symmGroup));
} 
inline bool operator < (const MyAtom &a1, const MyAtom &a2){
  return (a1.Label < a2.Label);
} 

typedef struct MyBond{
MyAtom const *ato1,*ato2;
  double length;
  int a1,a2;
  inline MyBond& operator = (const MyBond& b){
    length=b.length;
    ato1=b.ato1;
    ato2=b.ato2;
    a1=b.a1;
    a2=b.a2;
    return *this;
  } 
}MyBond;

typedef struct MyBind{
  QString Lab1,Lab2;
}MyBind;


typedef QList<MyBond> Connection;
typedef QList<MyAtom> CEnvironment;
struct Cell {
  double a,b,c,al,be,ga;
  double phi,V,as,bs,cs,tau,cosga,cosal,cosbe,singa,tanga;
  QList<Matrix> symmops;
  QList<V3> trans;
  bool centered,centeric;
  QString Z;
  double wave;
};
struct SdmItem{
  double d;
  int a1,a2,sn;
  V3 floorD;
  bool covalent;
};

inline bool operator < (const SdmItem &a1, const SdmItem &a2){
  double d1=a1.d;//a1.a2*99999+a1.d;
  double d2=a2.d;//a2.a2*99999+a2.d;
  return (d1<d2);
}
struct Knopf{
QList<int> neighbors;
};
class Molecule{
public:
	bool nopm1;
	bool qbeforehkl;
        bool growQPeak;
  int LOD;
  Molecule();
  void Farbverlauf (GLfloat wrt,GLfloat min,GLfloat max);
  Cell cell;
  QString Fragments;
  QList<SdmItem> sdm;
  QList<SdmItem> envi_sdm;
  QList<SdmItem> contact;
  QList<Matrix> symmopsEQIV;
  QStringList labelEQIV;
  QList<V3> transEQIV;
  QList<MyBind> freeatoms,bindatoms;
  QList<Knopf> knoepfe;
  int adp,intern,bondColorStyle;
  double bondStrength;
  GLuint hbtex, hbtex2;
  GLuint adpwall,adpwall_plaid;
  int nonPositiveDefinite;
  int proba,tubes,dratom;
  V3 VZ;
  QColor AtomColor[109];
  int AtomStyle[109];
  int pseSize;
  double  pmin,pmax;
  QColor bondColor;
  CEnvironment asymm,showatoms,selectedatoms,duplicateAtoms;
  Connection showbonds;
  double arad[109];
  unsigned short Kovalenz_Radien[109];
  //unsigned short ElNeg[83];
  void atoms(CEnvironment atom,int proba=50);
  void bonds(Connection bond);
  void dbond(Connection bond);
  void lbond();
  QString h_bonds(Connection bond,CEnvironment atoms);
  void h_bonds2(Connection bond,CEnvironment atoms);
  void unitCell();
  Connection connecting(const CEnvironment &atom, bool eac=false);
  Connection lbonds;
  bool decodeSymmCard(const QString symmCard);
  bool decodeSymmCardEQIV(const QString symmCard);
  //void countMols(QList<INP> & xdinp);
  //bool applyLatticeCentro(const QChar latt,const bool centro);
  QString symmcode2human(QStringList brauchSymm);
  QString symmcode2human(QString brauchSymm);
  QString symmcode2human(QString brauchSymm, int j);
  QString symmcode2human(int s);
  QString symmCard2Code(QString symmCard);
  void frac2kart (V3 x, V3 & y);
  void kart2frac (V3 x, V3 & y);
  int getOZ(QString S1);
  double shortestDistance(QString sc);
  static double winkel(V3 a,V3 b);//vector3...
  double dieder(V3 a,V3 b, V3 c);
  static V3 kreuzX(double x1,double y1,double z1,double x2,double y2,double z2) ;
  double fl(double x,double y, double z);
  double wl(V3 f2, V3 f1, V3 f3);
  void cellSetup();
  void fuse();
  void grow();
  void fillCell();
  void uniqueInCell();
  void packer(QStringList brauchSymm);
  void applyLatticeCentro(int gitter);
  void Uf2Uo(const Matrix x, Matrix & y) ;
  void Usym (Matrix x,Matrix sym, Matrix & y);
  double dimension();
  void expandAt(int index);
  void expandAll();
  void complete();
  void enviSDM(double range);
  QStringList sdmcompleter();
  QStringList usedSymmetry;
  QString HumanSymmetry;
  QSettings *einstellung;
  QString pse(int oz);
  void loadSettings();
  void ikosa(double R);
  int maxmols(){return maxmol;}
private:
  double HAMax,HAWink;
  void ellipse(int style);
  void hirsh(Connection bond);
  void sphere(int adp);
  void dCube(GLfloat rad);
//  void ikosa(double R);
//  V3 eigenvalues(const Matrix m);
//  Matrix eigenvectors(const Matrix m,const V3 l);
  double * jacobi(const Matrix &uij, V3 &ev);
int maxmol;

};
#endif
