
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef FOURXLE_H
#define FOURXLE_H 1
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <fftw3.h>
#include "molecule.h"
#include "chgl.h"
#include <QObject>
#include <QCheckBox>
typedef struct {
int  ih,
     ik,
     il;
float fo,so,fc,phi;
} rec;
#define LM 2000000

struct FNode {
  V3 vertex;
  V3 normal;
  char flag;
  inline operator char (){
    return flag;
  }
  inline operator V3(){
    return vertex;
  }
  friend inline double Distance( const FNode& n1, const FNode& n2 ){
    return Norm(n1.vertex-n2.vertex);
  }
};
//

class FourXle:public QObject{
Q_OBJECT
  public:
          int HKLMX;
          float *datfo,*datfo_fc;
          FourXle(Molecule *mole_, chGL *chgl_,QToolBar *toolView, double resol=2.5, double wght=1.1);
          ~FourXle();
          bool loadFouAndPerform(const char filename[],bool neu=true);
          double lintrans,linwidth;
          float sigma[3];
          float iso[3];
	//  double mInimum[2],mAximum[2];
	  QProgressBar *balken;
	  int balkenstep;
          V3 urs;
	  QCheckBox *doMaps;
          double rr,rw;
	  int maptrunc;
          Molecule *mole;
	  double map_radius;
          chGL *chgl;
	  void deleteLists();
	  void killmaps();
	  int n1,n2,n3,n4;
	  int n5;
	  V3 dx,dy,dz;
  public slots:
          void bewegt(V3 v);
          void inimap();
          void change_iso(int numsteps,int diff);
  signals:
  void bigmessage(const QString &);

  private:
	  double C[15],D[9],sy[12][192],wave;
	  inline int Intersect( double& vm, double& vp ){ return vm*vp <= 0.0 && (vm<0.0 || vp<0.0); }
          int dex(int x,int y,int z);
          int dex3(int x,int y,int z);
	  int oldatomsize;
	  int acnt;
	  V3 oc,dxc,dyc,dzc;
	  V3  delDA[27];
	  fftwf_plan  fwd_plan;
          fftwf_complex *B;
          FNode *nodex,*nodey,*nodez;
	  int *noGoMap;
	  rec lr[LM];
	  char cen,git;
          int nr,nc,ns;
	  int mtyp,tri;
	  QTime foti,suti;
//          double minnor,maxnor;
          void gen_surface(bool neu,int imin=0, int imax=3);
          void CalcVertex( int ix, int iy, int iz);
	  V3 CalcNormalX( int ix, int iy, int iz );
	  V3 CalcNormalY( int ix, int iy, int iz );
	  V3 CalcNormalZ( int ix, int iy, int iz );
          int IndexSelected( FNode& node0, FNode& node1, FNode& node2, FNode& node3 );
          V3& VectorSelected( FNode& node0, FNode& node1, FNode& node2, FNode& node3 );
          void MakeElement( int ix, int iy, int iz ,int s1, int s2);
          void makeFaces(int n, FNode poly[] );

char titl[80];/*fcmax=0,f000=0,resmax=99999.0,*/
void trimm(char s[]);
void deletes(char *s, int count);
int readHeader(const char *filename);
void sorthkl(int nr, rec r[]);
};

#endif
