
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef CHGL_H
#define CHGL_H

#include <QGLWidget>

#include "molecule.h"
#ifndef MAXSELECT
#define MAXSELECT 300001
#endif

#define HIDE_REASON_SELECT          1
#define HIDE_REASON_THIS_FRAGMENT   2
#define HIDE_REASON_OTHER_FRAGMENT  4
#define HIDE_REASON_HYDROGEN        8
#define HIDE_REASON_QPEAK          16 



class chGL : public QGLWidget{
Q_OBJECT
public:
    explicit chGL(QWidget *parent = 0);
    int www,ww,wh,minus;
    int stereo_mode;
    int objCnt;
    int ImeanThisAtom;
    double viewAngle,envirange;
    QColor labelColor,backGroundColor;
    bool pause,inRenameMode,noWaitLabel;
    bool hiddenThings;
    QFont myFont,nonAtomFont;
    QTimer *moving;
    GLdouble MM[16];
    QAction *addBond,*killBond,*clearSelection,*centerSelection,*hideNotSelection,*unhide,*grow,*fuse,*shpm1,
	    *hideh, *qPeakBonds,*toggleDockWidgets,*delSelAt,*highlightParts, *centroid, *enviNoQ,*wireButt,
	    *invSelection;
    QToolButton *enviButt;
    QList<V3>enviPositions;
    QList<int>enviKat;
    V3 enviP0;
    QMenu *sfacMenu;
    QStringList labs;
    void initLists();
    void zoom(double speed);
    bool isFO(){return drawFO;}
    bool isDF(){return drawDF;}
    void warFaul(){warfaul=true;}
    void gZoom(double speed);
    void rotZ(double speed);
    void rotY(double speed);
    void rotX(double speed);
    void moveX(double speed);
    void moveY(double speed);
    void setupTexture();    
    void updateBondActions();
    Molecule *mol;
    int bas,murx,foubas[36],wirbas;
    double L;
    QAction *foact, *fofcact;
    int rotze;
    QCheckBox *invertMouseZoom,*lighting,*niceTrans,*fillMap;
    QToolButton *rCenter;
    V3 altemitte;
signals:
    void message(const QString &);
    void bigmessage(const QString &);
    void jumpit(int index);
    void diffscroll(int numsteps,int diff);
    void neuemitte(V3 mitte);
    void inimibas();
    void qpfoci(double height);
public slots:
    void clearEnvi();
    void hideQPeaksBelow(double cutoff);
    void highliteQPeak(double co);
    void invertSelection();
    void setReNaMo(bool b);
    void Listen();
    void rotCenter();
    void setRotationCenter();
    void setViewAngle(double ang);
    void setRotationCenter(int rz);
    void selectResiByNr(int nr);
    void selectThisFragment();
    void setMolecule(Molecule *m);
    void homeXY();
    void zalman();
    void parallel();
    void crosseye();
    void anaglyphRedCyan();
    void nostereo();
    void hideNonSelected();
    void showHidden();
    void connectSelection();
    void disConnectSelection(int index);
    void disSelection();
    void selectPair(const QString &s);
    void incFontSize();
    void decFontSize();
    void changeBColor();
    void changeTColor();
    void hidePartMinusOne(bool off);
    void hideThisFragment();
    void hideSelected();
    void hideOtherFragments();
    void hideHydrogens();
    void rehide();
    void changeEnviRange();
    void setAtom(bool b);
    void setBond(bool b);
    void setLabel(bool b);
    void setHBond(bool b);
    void setDepthCueing(bool b);
    void setXRayView(bool b);
    void setBGGradient(bool b);
    void setTube(bool b){tubes=b;updateGL();}
    void unsetTube(bool b){tubes=!b;updateGL();}
    void setADP(bool b);
    void setUnit(bool b);
    void expand();
    void envi();

protected:
   void initializeGL();
   void resizeGL(int width, int height);
   void paintGL();
#if (QT_VERSION >= 0x040600) && defined (Q_WS_MAC)
   bool event(QEvent *event);
#endif
   void mousePressEvent(QMouseEvent *event);
   void mouseMoveEvent(QMouseEvent *event);
   void contextMenuEvent(QContextMenuEvent *event);
   void wheelEvent(QWheelEvent *event);
private:
   
  GLuint ppp,pp,p;     
#if (QT_VERSION >= 0x040600) && defined (Q_WS_MAC)
        bool gestureEvent(QGestureEvent *event);
        void pinchTriggered(QPinchGesture*);
        void swipeTriggered(QSwipeGesture*);
#endif
        bool mouseOverInteraction,atomsClickable,tubes,bggradient;
	bool drawAx,drawUc,drawAt,drawADP,drawBo,drawLa,drawHb,drawFO,drawDF,xray_vision,depthcueing,warfaul,warLabel;
        int imFokus,afok;
	void draw();
        //void highFocus();
	int xray_eye,fogrange;
	GLuint selectBuf[MAXSELECT];
	GLfloat feedBuf[3000];
        GLint vp[4];
	int hideReason; 
        double qcutoff,pickradius;
	int frid;
        QPoint lastPos;
};

#endif // CHGL_H
