
/*
#    Sfront, a SAOL to C translator    
#    This file: Main loop for runtime: active driver, shorts
#
# Copyright (c) 1999-2006, Regents of the University of California
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#  Redistributions of source code must retain the above copyright
#  notice, this list of conditions and the following disclaimer.
#
#  Redistributions in binary form must reproduce the above copyright
#  notice, this list of conditions and the following disclaimer in the
#  documentation and/or other materials provided with the distribution.
#
#  Neither the name of the University of California, Berkeley nor the
#  names of its contributors may be used to endorse or promote products
#  derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu
*/



#if defined(ASYS_ACTIVE_O)

int asys_orun(ASYS_OTYPE obuf[], long * osize)

{
  int obusidx = 0;
  int busidx;

  if (asys_exit_status == ASYS_EXIT)
    return ASYS_EXIT;

  while (obusidx < *osize)
    if (acycleidx < ACYCLE)
      {
	for (busidx=0; busidx<ENDBUS;busidx++)
	  bus[busidx]=0.0F;
	main_apass();
	for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)
	  {
	    bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];

#if (ASYS_OTYPENAME == ASYS_SHORT)
	    bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
	    obuf[obusidx++] = (short) (32767.0F * bus[busidx]);
#endif

#if (ASYS_OTYPENAME == ASYS_FLOAT)
	    obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
#endif

	  }
	acycleidx++;
      }
    else
      {
	acycleidx = 0;
	if (pass == APASS)
	  {      
	    cpuload = ksync();
	    kcycleidx++;
	  }
	if (kcycleidx > endkcycle)
	  {
	    *osize = obusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = IPASS;
	scorebeats = scoremult*(kcycleidx - kbase) + scorebase;
	absolutetime = (kcycleidx - 1)*KTIME;
	main_ipass();
	pass = KPASS;
	main_control();
	if (main_kpass())
	  {
	    *osize = obusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = APASS;
      }

  return ASYS_DONE;
}

#endif  /* ASYS_ACTIVE_O */


#if defined(ASYS_ACTIVE_IO)

int asys_iorun(ASYS_ITYPE ibuf[], long * isize,ASYS_OTYPE obuf[], long * osize)

{  
  int ibusidx = 0;
  int obusidx = 0;
  int busidx;

  if (asys_exit_status == ASYS_EXIT)
    return ASYS_EXIT;

  while ((obusidx < *osize) && (ibusidx < *isize))
    if (acycleidx < ACYCLE)
      {
	for (busidx=0; busidx<ENDBUS;busidx++)
	  bus[busidx] = 0.0F;

#if (ASYS_ITYPENAME == ASYS_SHORT)
	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)
	  bus[busidx] = 3.051851e-5F*ibuf[ibusidx++];
#endif

#if (ASYS_ITYPENAME == ASYS_FLOAT)
	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)
	  bus[busidx] = ibuf[ibusidx++];
#endif

	main_apass();
	for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)
	  {
	    bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];

#if (ASYS_OTYPENAME == ASYS_SHORT)
	    bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
	    obuf[obusidx++] = (short) (32767.0F * bus[busidx]);
#endif

#if (ASYS_OTYPENAME == ASYS_FLOAT)
	    obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
#endif
	  }
	acycleidx++;
      }
    else
      {
	acycleidx = 0;
	if (pass == APASS)
	  {      
	    cpuload = ksync();
	    kcycleidx++;
	  }
	if (kcycleidx > endkcycle)
	  {
	    *osize = obusidx;
	    *isize = ibusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = IPASS;
	scorebeats = scoremult*(kcycleidx - kbase) + scorebase;
	absolutetime = (kcycleidx - 1)*KTIME;
	main_ipass();
	pass = KPASS;
	main_control();
	if (main_kpass())
	  {
	    *osize = obusidx;
	    *isize = ibusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = APASS;
      }

  if (obusidx < *osize)
    *osize = obusidx;
  if (ibusidx < *isize)
    *isize = ibusidx;
  return ASYS_DONE;
}

#endif /* ASYS_ACTIVE_IO */


int main(int argc, char *argv[])

{
  system_init(argc, argv);
  effects_init();
  main_initpass();

  kcycleidx = kbase;
  acycleidx = ACYCLE;
  pass = IPASS;

  asys_main();
  shut_down();
  return 0;
}





