/*
 *  Copyright (C) 2004, 2005, 2006, 2008, 2009, 2010, 2011 Savoir-Faire Linux Inc.
 *  Author: Yan Morin <yan.morin@savoirfairelinux.com>
 *
 *  Inspired by tonegenerator of
 *   Laurielle Lea <laurielle.lea@savoirfairelinux.com> (2004)
 *  Inspired by ringbuffer of Audacity Project
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Additional permission under GNU GPL version 3 section 7:
 *
 *  If you modify this program, or any covered work, by linking or
 *  combining it with the OpenSSL project's OpenSSL library (or a
 *  modified version of that library), containing parts covered by the
 *  terms of the OpenSSL or SSLeay licenses, Savoir-Faire Linux Inc.
 *  grants you additional permission to convey the resulting work.
 *  Corresponding Source for a non-source form of such a combination
 *  shall include the source code for the parts of OpenSSL used as well
 *  as that of the covered work.
 */

#include "audioloop.h"
#include <math.h>
#include <cstring>
#include <cassert>

AudioLoop::AudioLoop() : buffer_(0),  size_(0), pos_(0), sampleRate_(0)
{
}

AudioLoop::~AudioLoop()
{
    delete [] buffer_;
}

void
AudioLoop::getNext(SFLDataFormat* output, size_t total_samples, short volume)
{
    size_t pos = pos_;

    if (size_ == 0) {
        ERROR("AudioLoop: Error: Audio loop size is 0");
        return;
    }

    while (total_samples) {
        size_t samples = total_samples;

        if (samples > (size_ - pos))
            samples = size_ - pos;

        // short->char conversion
        memcpy(output, buffer_ + pos, samples * sizeof(SFLDataFormat));

        if (volume != 100) {
            double gain = volume * 0.01;

            for (size_t i = 0; i < samples; i++) {
                *output *= gain;
                output++;
            }
        } else
            output += samples; // this is the destination...

        pos = (pos + samples) % size_;

        total_samples -= samples;
    }

    pos_ = pos;
}

