// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_PIPE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_PIPE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AbstractSource

template <typename TValue, typename TSize > struct AbstractSource;       	// "projects/library/seqan/pipe/pipe_base.h"(231)

//____________________________________________________________________________
// AdapterSpec

struct AdapterSpec;       	// "projects/library/seqan/pipe/pipe_base.h"(594)

//____________________________________________________________________________
// AdaptorCompare2Less

template <typename TCompare > struct AdaptorCompare2Less;       	// "projects/library/seqan/pipe/pool_sorter.h"(61)

//____________________________________________________________________________
// BufReadHandler

template <typename TInput > struct BufReadHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(585)

//____________________________________________________________________________
// BufWriteHandler

template <typename TOutput > struct BufWriteHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(588)

//____________________________________________________________________________
// BufferHandler

template <typename TObject, typename TSpec > struct BufferHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(578)

//____________________________________________________________________________
// Bundle2

template <typename TInput1, typename TInput2 > struct Bundle2;       	// "projects/library/seqan/pipe/pipe_base.h"(94)

//____________________________________________________________________________
// Bundle3

template <typename TInput1, typename TInput2, typename TInput3 > struct Bundle3;       	// "projects/library/seqan/pipe/pipe_base.h"(141)

//____________________________________________________________________________
// Bundle5

template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > struct Bundle5;       	// "projects/library/seqan/pipe/pipe_base.h"(199)

//____________________________________________________________________________
// Caster

template <typename TValue, typename TSpec > struct Caster;       	// "projects/library/seqan/pipe/pipe_caster.h"(48)

//____________________________________________________________________________
// CasterConvert

struct CasterConvert;       	// "projects/library/seqan/pipe/pipe_caster.h"(45)

//____________________________________________________________________________
// CasterReinterpret

struct CasterReinterpret;       	// "projects/library/seqan/pipe/pipe_caster.h"(44)

//____________________________________________________________________________
// ContainerBuffer

template <typename TContainer > struct ContainerBuffer;       	// "projects/library/seqan/pipe/pipe_source.h"(107)

//____________________________________________________________________________
// ControlBeginRead_

struct ControlBeginRead_;       	// "projects/library/seqan/pipe/pipe_base.h"(431)

//____________________________________________________________________________
// ControlClear_

struct ControlClear_;       	// "projects/library/seqan/pipe/pipe_base.h"(430)

//____________________________________________________________________________
// ControlEndRead_

struct ControlEndRead_;       	// "projects/library/seqan/pipe/pipe_base.h"(432)

//____________________________________________________________________________
// ControlEof_

struct ControlEof_;       	// "projects/library/seqan/pipe/pipe_base.h"(428)

//____________________________________________________________________________
// ControlEos_

struct ControlEos_;       	// "projects/library/seqan/pipe/pipe_base.h"(429)

//____________________________________________________________________________
// Counter

struct Counter;       	// "projects/library/seqan/pipe/pipe_counter.h"(44)

//____________________________________________________________________________
// Echoer

template <unsigned echoRepeats, bool omitFirst > struct Echoer;       	// "projects/library/seqan/pipe/pipe_echoer.h"(69)

//____________________________________________________________________________
// EchoerClearWorker_

struct EchoerClearWorker_;       	// "projects/library/seqan/pipe/pipe_echoer.h"(53)

//____________________________________________________________________________
// EchoerFillWorker_

struct EchoerFillWorker_;       	// "projects/library/seqan/pipe/pipe_echoer.h"(46)

//____________________________________________________________________________
// EchoerShiftWorker_

struct EchoerShiftWorker_;       	// "projects/library/seqan/pipe/pipe_echoer.h"(60)

//____________________________________________________________________________
// EditEnvironment

template <typename TDistanceSpec, unsigned STEP_SIZE > struct EditEnvironment;       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(45)

//____________________________________________________________________________
// ExtStringSourceCachingSpec_

struct ExtStringSourceCachingSpec_;       	// "projects/library/seqan/pipe/pipe_source.h"(282)

//____________________________________________________________________________
// Filter

template <typename TFunctor > struct Filter;       	// "projects/library/seqan/pipe/pipe_filter.h"(61)

//____________________________________________________________________________
// Handler

template <typename TObject, typename TSpec > struct Handler;       	// "projects/library/seqan/pipe/pipe_base.h"(581)

//____________________________________________________________________________
// HandlerArgs

template <typename TPool > struct HandlerArgs;       	// "projects/library/seqan/pipe/pool_base.h"(621)

//____________________________________________________________________________
// IPipeIterator

template <typename TInput> struct IPipeIterator;       	// "projects/library/seqan/pipe/pipe_iterator.h"(50)

//____________________________________________________________________________
// IteratorBuffer

template <typename TIterator > struct IteratorBuffer;       	// "projects/library/seqan/pipe/pipe_source.h"(147)

//____________________________________________________________________________
// Joiner

struct Joiner;       	// "projects/library/seqan/pipe/pipe_joiner.h"(44)

//____________________________________________________________________________
// MapperAsyncWriter

struct MapperAsyncWriter;       	// "projects/library/seqan/pipe/pool_mapper.h"(404)

//____________________________________________________________________________
// MapperConfig

template <typename TMap, typename TFile > struct MapperConfig;       	// "projects/library/seqan/pipe/pool_mapper.h"(86)

//____________________________________________________________________________
// MapperConfigSize

template <typename TMap, typename TSize, typename TFile > struct MapperConfigSize;       	// "projects/library/seqan/pipe/pool_mapper.h"(62)

//____________________________________________________________________________
// MapperMemAdapter

struct MapperMemAdapter;       	// "projects/library/seqan/pipe/pool_mapper.h"(273)

//____________________________________________________________________________
// MapperSpec

template <typename TConfig > struct MapperSpec;       	// "projects/library/seqan/pipe/pool_mapper.h"(107)

//____________________________________________________________________________
// MapperSyncWriter

struct MapperSyncWriter;       	// "projects/library/seqan/pipe/pool_mapper.h"(314)

//____________________________________________________________________________
// MemorySpec_

struct MemorySpec_;       	// "projects/library/seqan/pipe/pool_base.h"(188)

//____________________________________________________________________________
// MergeStreamComparer

template <typename TValue, typename Compare > struct MergeStreamComparer;       	// "projects/library/seqan/pipe/pool_sorter.h"(45)

//____________________________________________________________________________
// Multi

template <typename TSpec, typename TPair, typename TLimitsString> struct Multi;       	// "projects/library/seqan/pipe/pipe_base.h"(74)

//____________________________________________________________________________
// MultiplexSpec_

struct MultiplexSpec_;       	// "projects/library/seqan/pipe/pool_base.h"(461)

//____________________________________________________________________________
// Namer

template <typename TCompare > struct Namer;       	// "projects/library/seqan/pipe/pipe_namer.h"(45)

//____________________________________________________________________________
// OPipeIterator

template <typename TOutput> struct OPipeIterator;       	// "projects/library/seqan/pipe/pipe_iterator.h"(136)

//____________________________________________________________________________
// PairDecrementer_

template <typename TPair, typename TLimits, unsigned m > struct PairDecrementer_;       	// "projects/library/seqan/pipe/pipe_base.h"(742)

//____________________________________________________________________________
// PairIncrementer_

template <typename TPair, typename TLimits> struct PairIncrementer_;       	// "projects/library/seqan/pipe/pipe_base.h"(678)

//____________________________________________________________________________
// Pipe

template <typename TInput, typename TSpec > struct Pipe;       	// "projects/library/seqan/pipe/pipe_base.h"(65)

//____________________________________________________________________________
// Pool

template <typename TValue, typename TSpec > struct Pool;       	// "projects/library/seqan/pipe/pool_base.h"(114)
template <typename TValue, typename TSpec > struct Pool;       	// "projects/library/seqan/pipe/pool_base.h"(632)

//____________________________________________________________________________
// PoolConfig

template <typename TFile > struct PoolConfig;       	// "projects/library/seqan/pipe/pool_base.h"(75)

//____________________________________________________________________________
// PoolConfigSize

template <typename TSize, typename TFile > struct PoolConfigSize;       	// "projects/library/seqan/pipe/pool_base.h"(56)

//____________________________________________________________________________
// PoolParameters

struct PoolParameters;       	// "projects/library/seqan/pipe/pool_base.h"(118)

//____________________________________________________________________________
// PoolSpec

template <typename TConfig > struct PoolSpec;       	// "projects/library/seqan/pipe/pool_base.h"(95)

//____________________________________________________________________________
// ReadFileSpec_

struct ReadFileSpec_;       	// "projects/library/seqan/pipe/pool_base.h"(228)

//____________________________________________________________________________
// ReadHandler

template <typename TInput > struct ReadHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(660)

//____________________________________________________________________________
// ReadMapperSpec_

struct ReadMapperSpec_;       	// "projects/library/seqan/pipe/pool_mapper.h"(118)

//____________________________________________________________________________
// ReadSorterSpec_

struct ReadSorterSpec_;       	// "projects/library/seqan/pipe/pool_sorter.h"(150)

//____________________________________________________________________________
// Sampler

template <unsigned m, typename TCompression > struct Sampler;       	// "projects/library/seqan/pipe/pipe_sampler.h"(50)

//____________________________________________________________________________
// ShiftLeftWorker_

struct ShiftLeftWorker_;       	// "projects/library/seqan/pipe/pipe_tupler.h"(84)

//____________________________________________________________________________
// Shifter

template <int delta, bool omitBlank , bool _echoing > struct Shifter;       	// "projects/library/seqan/pipe/pipe_shifter.h"(47)

//____________________________________________________________________________
// SkewDC_

template <int I, typename T > struct SkewDC_;       	// "projects/library/seqan/pipe/pipe_sampler.h"(45)

//____________________________________________________________________________
// SorterConfig

template <typename TCompare, typename TFile > struct SorterConfig;       	// "projects/library/seqan/pipe/pool_sorter.h"(114)

//____________________________________________________________________________
// SorterConfigSize

template <typename TCompare, typename TSize, typename TFile > struct SorterConfigSize;       	// "projects/library/seqan/pipe/pool_sorter.h"(90)

//____________________________________________________________________________
// SorterSpec

template <typename TConfig > struct SorterSpec;       	// "projects/library/seqan/pipe/pool_sorter.h"(136)

//____________________________________________________________________________
// Source

template <typename T> struct Source;       	// "projects/library/seqan/pipe/pipe_base.h"(290)

//____________________________________________________________________________
// SourceCachingSpec_

struct SourceCachingSpec_;       	// "projects/library/seqan/pipe/pipe_source.h"(223)

//____________________________________________________________________________
// SourceNonCachingSpec_

struct SourceNonCachingSpec_;       	// "projects/library/seqan/pipe/pipe_source.h"(184)

//____________________________________________________________________________
// Tupler

template <unsigned tupleLen, bool omitLast , typename TCompression > struct Tupler;       	// "projects/library/seqan/pipe/pipe_tupler.h"(47)

//____________________________________________________________________________
// TuplerLastTuples_

template <typename TTupler > struct TuplerLastTuples_;       	// "projects/library/seqan/pipe/pipe_tupler.h"(74)

//____________________________________________________________________________
// WriteFileSpec_

struct WriteFileSpec_;       	// "projects/library/seqan/pipe/pool_base.h"(346)

//____________________________________________________________________________
// WriteHandler

template <typename TOutput > struct WriteHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(666)

//____________________________________________________________________________
// filterI1

template <typename InType, typename Result > struct filterI1;       	// "projects/library/seqan/pipe/pipe_filter.h"(45)

//____________________________________________________________________________
// filterI2

template <typename InType, typename Result > struct filterI2;       	// "projects/library/seqan/pipe/pipe_filter.h"(50)

//____________________________________________________________________________
// filterI3

template <typename InType, typename Result > struct filterI3;       	// "projects/library/seqan/pipe/pipe_filter.h"(55)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ControlBeginRead

typedef Tag<ControlBeginRead_> ControlBeginRead;       	// "projects/library/seqan/pipe/pipe_base.h"(437)

//____________________________________________________________________________
// ControlClear

typedef Tag<ControlClear_> ControlClear;       	// "projects/library/seqan/pipe/pipe_base.h"(436)

//____________________________________________________________________________
// ControlEndRead

typedef Tag<ControlEndRead_> ControlEndRead;       	// "projects/library/seqan/pipe/pipe_base.h"(438)

//____________________________________________________________________________
// ControlEof

typedef Tag<ControlEof_> ControlEof;       	// "projects/library/seqan/pipe/pipe_base.h"(434)

//____________________________________________________________________________
// ControlEos

typedef Tag<ControlEos_> ControlEos;       	// "projects/library/seqan/pipe/pipe_base.h"(435)

//____________________________________________________________________________
// ExtStringSourceCachingSpec

typedef Tag<ExtStringSourceCachingSpec_> ExtStringSourceCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(283)

//____________________________________________________________________________
// MemorySpec

typedef Tag<MemorySpec_> MemorySpec;       	// "projects/library/seqan/pipe/pool_base.h"(189)

//____________________________________________________________________________
// MultiplexSpec

typedef Tag<MultiplexSpec_> MultiplexSpec;       	// "projects/library/seqan/pipe/pool_base.h"(462)

//____________________________________________________________________________
// ReadFileSpec

typedef Tag<ReadFileSpec_> ReadFileSpec;       	// "projects/library/seqan/pipe/pool_base.h"(229)

//____________________________________________________________________________
// ReadMapperSpec

typedef Tag<ReadMapperSpec_> ReadMapperSpec;       	// "projects/library/seqan/pipe/pool_mapper.h"(119)

//____________________________________________________________________________
// ReadSorterSpec

typedef Tag<ReadSorterSpec_> ReadSorterSpec;       	// "projects/library/seqan/pipe/pool_sorter.h"(151)

//____________________________________________________________________________
// SourceCachingSpec

typedef Tag<SourceCachingSpec_> SourceCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(224)

//____________________________________________________________________________
// SourceNonCachingSpec

typedef Tag<SourceNonCachingSpec_> SourceNonCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(185)

//____________________________________________________________________________
// WriteFileSpec

typedef Tag<WriteFileSpec_> WriteFileSpec;       	// "projects/library/seqan/pipe/pool_base.h"(347)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// append

template <typename TValue, typename TSpec, typename TSource > inline bool append(Pool<TValue, TSpec> &dest, TSource &src);       	// "projects/library/seqan/pipe/pool_base.h"(1182)
template <typename TValue, typename TSpec, typename TStringSpec > inline bool append(Pool<TValue, TSpec> &dest, String<TValue, TStringSpec> &src);       	// "projects/library/seqan/pipe/pool_base.h"(1198)

//____________________________________________________________________________
// assign

template <typename TValue, typename TStringSpec, typename TInput, typename TSpec > inline bool assign(String<TValue, TStringSpec> &dest, Pipe<TInput, TSpec> &src);       	// "projects/library/seqan/pipe/pipe_base.h"(540)
template <typename TValue, typename TSpec, typename TSource > inline bool assign(Pool<TValue, TSpec> &dest, TSource &src);       	// "projects/library/seqan/pipe/pool_base.h"(1214)
template <typename TValue1, typename TStringSpec, typename TValue2, typename TSpec > inline bool assign(String<TValue1, TStringSpec> &dest, Pool<TValue2, TSpec> &src);       	// "projects/library/seqan/pipe/pool_base.h"(1236)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSpec > OPipeIterator< Pool< TValue, TSpec > > begin(Pool< TValue, TSpec > &pool);       	// "projects/library/seqan/pipe/pool_base.h"(934)
template <typename TInput, typename TSpec, typename TTag > inline typename Iterator< Pipe< TInput, Source<TSpec> >, Tag<TTag> const >::Type begin(Pipe< TInput, Source<TSpec> > &pipe, Tag<TTag> const);       	// "projects/library/seqan/pipe/pipe_source.h"(91)
template <typename TInput, typename TSpec > IPipeIterator< Pipe< TInput, TSpec > > begin(Pipe< TInput, TSpec > &pipe);       	// "projects/library/seqan/pipe/pipe_iterator.h"(237)

//____________________________________________________________________________
// beginRead

template <typename TInput, typename TSpec > inline bool beginRead(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(480)
template <typename TValue, typename TSpec > inline bool beginRead(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1165)

//____________________________________________________________________________
// beginWrite

template <typename TValue, typename TSpec > inline bool beginWrite(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1133)

//____________________________________________________________________________
// bundle2

template <typename TInput1, typename TInput2 > inline Bundle2< TInput1, TInput2 > bundle2(TInput1 &_in1, TInput2 &_in2);       	// "projects/library/seqan/pipe/pipe_base.h"(115)

//____________________________________________________________________________
// bundle3

template <typename TInput1, typename TInput2, typename TInput3 > inline Bundle3< TInput1, TInput2, TInput3 > bundle3(TInput1 &_in1, TInput2 &_in2, TInput3 &_in3);       	// "projects/library/seqan/pipe/pipe_base.h"(165)

//____________________________________________________________________________
// bundle5

template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > inline Bundle5< TIn1, TIn2, TIn3, TIn4, TIn5 > bundle5(TIn1 &_in1, TIn2 &_in2, TIn3 &_in3, TIn4 &_in4, TIn5 &_in5);       	// "projects/library/seqan/pipe/pipe_base.h"(226)

//____________________________________________________________________________
// clear

template <typename TInput, typename TSpec > inline bool clear(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(459)
template <typename TValue, typename TSpec > inline void clear(Pool<TValue, TSpec> &me);       	// "projects/library/seqan/pipe/pool_base.h"(999)

//____________________________________________________________________________
// control

template <typename TInput, unsigned m, typename TCompression > inline bool control(Pipe< TInput, Sampler<m, TCompression> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(276)
template <typename TInput, unsigned m, typename TCompression > inline bool control(Pipe< TInput, Sampler<m, TCompression> > &me, ControlEof const & );       	// "projects/library/seqan/pipe/pipe_sampler.h"(283)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline bool control(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(492)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline bool control(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > &me, ControlEof const & );       	// "projects/library/seqan/pipe/pipe_sampler.h"(499)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline bool control(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > &me, ControlEos const & );       	// "projects/library/seqan/pipe/pipe_sampler.h"(504)
template <typename TInput, typename TCompare > inline bool control(Pipe< TInput, Namer<TCompare> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_namer.h"(124)
template <typename TInput, typename TSpec, typename TCommand > inline bool control(Pipe<TInput, TSpec> &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(441)
template <typename TInput1, typename TInput2, typename TCommand > inline bool control(Bundle2<TInput1, TInput2> &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(507)
template <typename TInput1, typename TInput2, typename TInput3, typename TCommand > inline bool control(Bundle3<TInput1, TInput2, TInput3> &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(515)
template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5, typename TCommand > inline bool control(Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5 > &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(524)
template <typename TInput, unsigned echoRepeats, bool omitFirst > inline bool control(Pipe< TInput, Echoer< echoRepeats, omitFirst > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_echoer.h"(127)
template <typename TInput, unsigned echoRepeats > inline bool control(Pipe< TInput, Echoer< echoRepeats, true > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_echoer.h"(136)
template <typename TInput > inline bool control(Pipe< TInput, Counter > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_counter.h"(96)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<HammingDistance_>, STEP_SIZE > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(256)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<LevenshteinDistance_>, STEP_SIZE > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(271)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<LevenshteinDistance_>, STEP_SIZE > > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(300)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<LevenshteinDistance_>, STEP_SIZE > > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(309)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pool_base.h"(1093)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pool_base.h"(1098)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlClear const &);       	// "projects/library/seqan/pipe/pool_base.h"(1103)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlBeginRead const &);       	// "projects/library/seqan/pipe/pool_base.h"(1109)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlEndRead const &);       	// "projects/library/seqan/pipe/pool_base.h"(1114)
template <typename TInput, int delta, bool omitBlank > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, false > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_shifter.h"(127)
template <typename TInput, int delta, bool omitBlank > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, true > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_shifter.h"(137)
template <typename TInput, int delta, bool omitBlank, bool _echoing > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, _echoing > > &me, ControlEof const & );       	// "projects/library/seqan/pipe/pipe_shifter.h"(154)
template <typename TInput, int delta, bool omitBlank, bool _echoing > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, _echoing > > &me, ControlEos const & );       	// "projects/library/seqan/pipe/pipe_shifter.h"(159)
template <typename TInput, typename TSpec, typename TCommand > inline bool control(Pipe< TInput, Source<TSpec> > & , TCommand const &);       	// "projects/library/seqan/pipe/pipe_source.h"(374)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlBeginRead const &);       	// "projects/library/seqan/pipe/pipe_source.h"(379)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlEndRead const &);       	// "projects/library/seqan/pipe/pipe_source.h"(385)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_source.h"(391)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_source.h"(396)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline bool control( Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_tupler.h"(382)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline bool control( Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_tupler.h"(399)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline bool control( Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(412)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline bool control( Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(427)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline bool control( Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(436)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline bool control( Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(451)

//____________________________________________________________________________
// countSequences

template <typename TInput, typename TSpec > inline typename Size< Pipe<TInput, TSpec> >::Type countSequences(Pipe<TInput, TSpec> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(348)
template <typename TInput1, typename TInput2 > inline typename Size< Bundle2<TInput1, TInput2> >::Type countSequences(Bundle2<TInput1, TInput2> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(355)
template <typename TInput1, typename TInput2, typename TInput3 > inline typename Size< Bundle3<TInput1, TInput2, TInput3> >::Type countSequences(Bundle3<TInput1, TInput2, TInput3> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(362)
template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > inline typename Size< Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> >::Type countSequences(Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(369)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline unsigned countSequences(Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(487)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline unsigned countSequences(Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > const &me);       	// "projects/library/seqan/pipe/pipe_tupler.h"(499)

//____________________________________________________________________________
// difference

template <typename TInput > inline typename Difference<TInput>::Type difference(IPipeIterator<TInput> first, IPipeIterator<TInput> last);       	// "projects/library/seqan/pipe/pipe_iterator.h"(250)
template <typename TOutput > inline typename Difference<TOutput>::Type difference(OPipeIterator<TOutput> first, OPipeIterator<TOutput> last);       	// "projects/library/seqan/pipe/pipe_iterator.h"(256)

//____________________________________________________________________________
// end

template <typename TValue, typename TSpec > OPipeIterator< Pool< TValue, TSpec > > end(Pool< TValue, TSpec > & );       	// "projects/library/seqan/pipe/pool_base.h"(940)
template <typename TInput, typename TSpec, typename TTag > inline typename Iterator< Pipe< TInput, Source<TSpec> >, Tag<TTag> const >::Type end(Pipe< TInput, Source<TSpec> > &pipe, Tag<TTag> const);       	// "projects/library/seqan/pipe/pipe_source.h"(97)
template <typename TInput, typename TSpec > IPipeIterator< Pipe< TInput, TSpec > > end(Pipe< TInput, TSpec > & );       	// "projects/library/seqan/pipe/pipe_iterator.h"(243)

//____________________________________________________________________________
// endRead

template <typename TInput, typename TSpec > inline bool endRead(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(499)
template <typename TValue, typename TSpec > inline bool endRead(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1171)

//____________________________________________________________________________
// endWrite

template <typename TValue, typename TSpec > inline bool endWrite(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1152)

//____________________________________________________________________________
// eof

template <typename TInput, typename TSpec > inline bool eof(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(447)
template <typename TValue, typename TSpec > inline bool eof(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1159)

//____________________________________________________________________________
// eos

template <typename TInput, typename TSpec > inline bool eos(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(453)

//____________________________________________________________________________
// front

template <typename TInput, typename TSpec, typename TValue > inline Value< Pipe<TInput, TSpec> > const & front(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(389)
template <typename TValue, typename TSpec > inline typename Value< Pool<TValue, TSpec> >::Type const & front(Pool<TValue, TSpec> &me);       	// "projects/library/seqan/pipe/pool_base.h"(1032)

//____________________________________________________________________________
// length

template <typename TInput, unsigned m, typename TCompression > inline typename Size< Pipe< TInput, Sampler<m, TCompression> > >::Type length(Pipe< TInput, Sampler<m, TCompression> > const &me);       	// "projects/library/seqan/pipe/pipe_sampler.h"(289)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline typename Size< Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > >::Type length(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > const &me);       	// "projects/library/seqan/pipe/pipe_sampler.h"(511)
template <typename TInput, typename TSpec > inline typename Size< Pipe<TInput, TSpec> >::Type length(Pipe<TInput, TSpec> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(317)
template <typename TInput1, typename TInput2 > inline typename Size< Bundle2<TInput1, TInput2> >::Type length(Bundle2<TInput1, TInput2> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(324)
template <typename TInput1, typename TInput2, typename TInput3 > inline typename Size< Bundle3<TInput1, TInput2, TInput3> >::Type length(Bundle3<TInput1, TInput2, TInput3> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(331)
template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > inline typename Size< Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> >::Type length(Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(338)
template <typename TInput, unsigned echoRepeats > inline Size< Pipe< TInput, Echoer< echoRepeats, true > > > length(Pipe< TInput, Echoer< echoRepeats, true > > const &me);       	// "projects/library/seqan/pipe/pipe_echoer.h"(146)
template <typename TInput, unsigned STEP_SIZE > inline typename Size< Pipe< TInput, Pipe< TInput, EditEnvironment< Tag<HammingDistance_>, STEP_SIZE > > > >::Type length(Pipe< TInput, EditEnvironment< Tag<HammingDistance_>, STEP_SIZE > > const &me);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(315)
template <typename TInput, unsigned STEP_SIZE > inline typename Size< Pipe< TInput, Pipe< TInput, EditEnvironment< Tag<LevenshteinDistance_>, STEP_SIZE > > > >::Type length(Pipe< TInput, EditEnvironment< Tag<LevenshteinDistance_>, STEP_SIZE > > const &me);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(330)
template <typename TValue, typename TSpec > inline typename Size< Pool<TValue, TSpec> >::Type length(Pool<TValue, TSpec> const &me);       	// "projects/library/seqan/pipe/pool_base.h"(1016)
template <typename TInput, int delta, bool _echoing > inline Size< Pipe< TInput, Shifter< delta, true, _echoing > > > length(Pipe< TInput, Shifter< delta, true, _echoing > > const &me);       	// "projects/library/seqan/pipe/pipe_shifter.h"(149)
template <typename TContainer > inline typename Size< ContainerBuffer<TContainer> >::Type length(ContainerBuffer<TContainer> const &me);       	// "projects/library/seqan/pipe/pipe_source.h"(135)
template <typename TIterator > inline typename Size< IteratorBuffer<TIterator> >::Type length(IteratorBuffer<TIterator> const &me);       	// "projects/library/seqan/pipe/pipe_source.h"(177)
template <typename TInput, typename TSpec > inline typename Size< Pipe< TInput, Source<TSpec> > >::Type length(Pipe< TInput, Source<TSpec> > const &me);       	// "projects/library/seqan/pipe/pipe_source.h"(402)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline typename Size< Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > >::Type length(Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > const &me);       	// "projects/library/seqan/pipe/pipe_tupler.h"(458)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline typename Size< Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > >::Type length(Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > const &me);       	// "projects/library/seqan/pipe/pipe_tupler.h"(475)

//____________________________________________________________________________
// operator!=

template <typename TInput> bool operator!=(const IPipeIterator<TInput>& _Left, const IPipeIterator<TInput>& Right_);       	// "projects/library/seqan/pipe/pipe_iterator.h"(124)
template <typename TOutput> bool operator!=(const OPipeIterator<TOutput>& _Left, const OPipeIterator<TOutput>& Right_);       	// "projects/library/seqan/pipe/pipe_iterator.h"(204)

//____________________________________________________________________________
// operator<<

template <typename TValue, typename TStringSpec, typename TInput, typename TSpec > inline bool operator<<(String<TValue, TStringSpec> &dest, Pipe<TInput, TSpec> &src);       	// "projects/library/seqan/pipe/pipe_base.h"(559)
template <typename TInput, typename TSpec > std::ostream& operator<<(std::ostream &out, Pipe<TInput, TSpec> &p);       	// "projects/library/seqan/pipe/pipe_base.h"(566)
template <typename TValue, typename TSpec > ::std::ostream& operator<<(::std::ostream &out, Pool<TValue, TSpec> &p);       	// "projects/library/seqan/pipe/pool_base.h"(1066)
template <typename TValue, typename TSpec, typename TSource > inline bool operator<<(Pool<TValue, TSpec> &dest, TSource &src);       	// "projects/library/seqan/pipe/pool_base.h"(1223)
template <typename TValue1, typename TStringSpec, typename TValue2, typename TSpec > inline bool operator<<(String<TValue1, TStringSpec> &dest, Pool<TValue2, TSpec> &src);       	// "projects/library/seqan/pipe/pool_base.h"(1256)

//____________________________________________________________________________
// operator==

template <typename TInput> bool operator==(const IPipeIterator<TInput>& _Left, const IPipeIterator<TInput>& Right_);       	// "projects/library/seqan/pipe/pipe_iterator.h"(118)
template <typename TOutput> bool operator==(const OPipeIterator<TOutput>& _Left, const OPipeIterator<TOutput>& Right_);       	// "projects/library/seqan/pipe/pipe_iterator.h"(198)

//____________________________________________________________________________
// pop

template <typename TInput, typename TSpec, typename TValue > inline void pop(Pipe<TInput, TSpec> &me, TValue &Ref_);       	// "projects/library/seqan/pipe/pipe_base.h"(410)
template <typename TInput, typename TSpec > inline void pop(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(417)
template <typename TValue, typename TSpec > inline void pop(Pool<TValue, TSpec> &me);       	// "projects/library/seqan/pipe/pool_base.h"(1039)
template <typename TValue, typename TSpec > inline void pop(Pool<TValue, TSpec> &me, TValue &Ref_);       	// "projects/library/seqan/pipe/pool_base.h"(1044)

//____________________________________________________________________________
// processBuffer

template <typename TValue, typename TConfig > inline PageFrame< TValue, typename TConfig::File, Dynamic<> > & processBuffer( PageFrame< TValue, typename TConfig::File, Dynamic<> > &buf, BufferHandler< Pool< TValue, SorterSpec<TConfig> >, WriteFileSpec > &me);       	// "projects/library/seqan/pipe/pool_sorter.h"(397)
template <typename TValue, typename TConfig > inline SimpleBuffer<TValue> & processBuffer( SimpleBuffer< TValue > &buf, BufferHandler< Pool< TValue, SorterSpec<TConfig> >, MemorySpec > &me);       	// "projects/library/seqan/pipe/pool_sorter.h"(410)
template <typename TValue, typename TConfig > inline SimpleBuffer< TValue > & processBuffer( PageFrame< TValue, typename TConfig::File, Dynamic<> > &buf, BufferHandler< Pool< TValue, MapperSpec<TConfig> >, ReadFileSpec > &me);       	// "projects/library/seqan/pipe/pool_mapper.h"(158)
template <typename TBuffer, typename THandler > inline TBuffer& processBuffer(TBuffer &h, THandler &);       	// "projects/library/seqan/pipe/pool_base.h"(181)

//____________________________________________________________________________
// push

template <typename TValue, typename TSpec > inline void push(Pool<TValue, TSpec> &me, TValue const &Val_);       	// "projects/library/seqan/pipe/pool_base.h"(1061)

//____________________________________________________________________________
// resize

template <typename TValue, typename TSpec, typename TSize > inline TSize resize(Pool<TValue, TSpec> &me, TSize new_length);       	// "projects/library/seqan/pipe/pool_base.h"(1024)

//____________________________________________________________________________
// setHost

template <typename TPair, typename TLimits> void setHost(PairIncrementer_<TPair, TLimits> &me, TLimits const &limits);       	// "projects/library/seqan/pipe/pipe_base.h"(709)
template <typename TPair, typename TLimits, unsigned m, typename TLimits2> void setHost(PairDecrementer_<TPair, TLimits, m> &me, TLimits2 const &limits);       	// "projects/library/seqan/pipe/pipe_base.h"(781)
template <typename TPair, typename TLimits, typename TLimits2> void setHost(PairDecrementer_<TPair, TLimits, 0> &me, TLimits2 const &limits);       	// "projects/library/seqan/pipe/pipe_base.h"(831)

//____________________________________________________________________________
// size

template <typename TValue, typename TSpec > inline typename Size< Pool<TValue, TSpec> >::Type size(Pool<TValue, TSpec> const &me);       	// "projects/library/seqan/pipe/pool_base.h"(1007)

//____________________________________________________________________________
// source

template <typename TInput, typename TSpec > inline TInput const & source(Pipe<TInput, TSpec> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(300)
template <typename TInput, typename TSpec > inline TInput & source(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(307)

//____________________________________________________________________________
// value

template <typename TPair, typename TLimits> TPair const & value(PairIncrementer_<TPair, TLimits> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(725)
template <typename TPair, typename TLimits> TPair & value(PairIncrementer_<TPair, TLimits> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(730)
template <typename TPair, typename TLimits, unsigned m> TPair const & value(PairDecrementer_<TPair, TLimits, m> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(846)
template <typename TPair, typename TLimits, unsigned m> TPair & value(PairDecrementer_<TPair, TLimits, m> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(851)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

