#!/bin/bash

##########################################################################
# SecPanel.remoteconf - Client for Remote Account Manager
# Shellscript for fetching and setting remote ssh access configuration
#
# Version SecPanel 0.5.3
# Author: Steffen Leich <steffen.leich _at_ gmail.com>
##########################################################################

function do_exit {
    echo
    echo -e "Remote account management: transfer finished ($MODE)\n\nPress <Return> to continue"
    read
    exit
}

if [ -z $5 ]
then
cat <<EOF

	SecPanel
	Shellscript for fetching and setting remote ssh access configuration
	Usage: secpanel_remoteconf.sh <host> <user> <scpbin> <mode> <Runfile Timestamp>

EOF
    exit 2
fi

HOST=$1
USER=$2
SCPBIN=$3
MODE=$4
RFTS=$5

cat <<EOF

    SecPanel - Client for Remote Account Manager
    ------------------------------------------------------

    Connecting to $HOST as $USER


EOF


RF="$HOME/.secpanel/.runfiles/ram.$RFTS"
mkdir $RF 2> /dev/null

if [ $MODE = "read" ]
    then

    $SCPBIN $USER@$HOST:.shosts $USER@$HOST:.ssh/authorized_keys $RF
    chmod 600 $RF/authorized_keys $RF/.shosts

elif [ $MODE = "write" ]
    then    

    $SCPBIN $RF/.shosts $USER@$HOST:
    $SCPBIN $RF/authorized_keys $USER@$HOST:.ssh

else
    echo "nothing to do..."
fi

do_exit
