package SDL::Tutorial::LunarLander;

sub import {
    my ($class, $filename) = (@_);
    return unless defined $filename;

# TODO: make these images shorter or maybe move them
# to a __DATA__ block at the bottom
    my $ship_image= join '', map { chr( hex($_) ) } qw(
FF D8 FF E0 00 10 4A 46 49 46 00 01 01 01 00 48 00 48 00 00 FF FE 00 13 
43 72 65 61 74 65 64 20 77 69 74 68 20 47 49 4D 50 FF DB 00 43 00 05 03 
04 04 04 03 05 04 04 04 05 05 05 06 07 0C 08 07 07 07 07 0F 0B 0B 09 0C 
11 0F 12 12 11 0F 11 11 13 16 1C 17 13 14 1A 15 11 11 18 21 18 1A 1D 1D 
1F 1F 1F 13 17 22 24 22 1E 24 1C 1E 1F 1E FF DB 00 43 01 05 05 05 07 06 
07 0E 08 08 0E 1E 14 11 14 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 
1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 
1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E FF C0 00 11 08 00 48 00 5C 03 01 22 00 
02 11 01 03 11 01 FF C4 00 1C 00 00 02 02 03 01 01 00 00 00 00 00 00 00 
00 00 00 00 06 05 07 01 03 04 08 02 FF C4 00 35 10 00 02 01 04 00 05 02 
03 05 07 05 00 00 00 00 00 01 02 03 00 04 05 11 06 12 13 21 31 07 41 22 
51 71 14 32 61 81 91 08 16 17 23 42 52 E1 15 33 63 A1 F0 FF C4 00 19 01 
01 01 01 01 01 01 00 00 00 00 00 00 00 00 00 00 00 04 05 03 01 06 FF C4 
00 26 11 00 01 04 01 03 03 05 01 01 00 00 00 00 00 00 00 01 00 02 03 04 
11 12 21 31 05 41 F0 13 51 61 81 C1 14 71 FF DA 00 0C 03 01 00 02 11 03 
11 00 3F 00 F1 A5 14 51 44 45 15 94 56 77 08 8A 59 98 E8 00 36 49 F9 54 
FE 5F 82 78 BF 11 8A 6C AE 57 86 F2 96 56 48 E2 37 96 7B 66 40 8C 42 90 
1B 7D C6 C3 2E B7 E7 62 88 97 EA F0 FD 95 B8 57 D2 EE 25 93 3F FC 43 8E 
E2 E2 68 12 11 67 08 B9 78 22 55 62 DD 49 0B A6 B6 E0 00 55 49 D1 D1 D8 
23 65 68 FA B1 FD 33 E1 4B E9 EC 23 CE 40 59 4B B9 50 A4 8D 15 04 6F CF 
CC 6C 6F F1 ED DE 88 92 F8 B2 D7 1D 63 C5 59 6B 2C 44 B7 12 E3 A0 BD 9A 
2B 49 2E 13 96 56 89 5D 82 17 1A 1A 62 A0 6C 68 77 F6 15 19 52 BC 5B 8A 
93 09 C4 37 58 D9 4B 33 46 54 F3 31 D9 3C CA 1B 7B FC EB 92 2B 29 4C 72 
CB 29 10 A4 4B CC 79 FB 13 F2 00 79 EF FA 7E 94 45 CB 45 14 51 11 45 14 
51 11 45 14 51 16 63 77 8A 45 92 37 64 74 21 95 94 E8 82 3C 11 4F B9 DE 
28 97 31 82 83 11 95 CD 64 6F AE 67 8A 19 15 A2 91 3A 41 FB 82 B2 80 81 
89 03 94 79 3A F3 A2 69 06 9A 7D 37 6C 78 CC 91 71 1C C6 76 86 55 0D D5 
09 18 05 40 1C C4 91 A1 F7 B6 49 D6 8F 8A 22 6C 83 87 EC F0 B8 83 77 69 
67 23 B7 28 E7 B8 65 0C E0 7B 91 BE C3 EA 06 BE 7B AB 13 80 61 4F DD 3B 
26 48 BA 6A DC E4 28 24 FF 00 59 A9 68 38 56 7E 88 55 BC 88 C6 57 EE 98 
F6 35 FA D4 B5 D5 8E 4B 15 20 C6 E1 31 1C 37 2D 9D AC 71 C5 CD 75 F6 BE 
A1 94 22 F5 76 23 90 28 1D 4E 7D 00 3B 0D 51 15 51 EA 05 94 5F BD D0 A2 
5B 16 9E E6 04 3C CA 37 CD A2 47 71 F4 1E 7C FE 5D AA BC E3 BC 2B E1 A3 
82 35 85 E0 47 72 59 79 89 52 75 D8 8F 9F BF FE ED 5E 94 B9 C2 4D 93 B2 
8E F6 E2 D7 15 65 95 B7 95 E2 94 D9 AC CC 9D 16 55 31 FF 00 BA C5 81 E6 
59 B7 A3 A2 35 F2 AA 97 D7 AC 4D DD 8E 33 1C 9D 7F B4 19 E6 6D A2 C5 DC 
01 A1 BD FB 77 60 3F 31 44 54 D5 15 97 56 46 28 EA 55 87 90 46 88 AC 51 
11 45 14 51 11 45 14 51 11 53 1C 1B 60 72 19 F8 23 28 19 23 DC AF BF 1A 
1E 3F EF 55 1D 05 A5 C4 C0 32 44 79 4E F4 C7 B2 9D 7E 27 B5 31 F0 44 C9 
89 BC 96 E6 EA 46 5E 65 E5 31 72 6C 30 F3 BE 60 7B 1D FB 68 8F 3D C5 13 
0B D4 FE 9D 65 71 19 5C 45 8D 84 37 B0 1B F8 61 11 3D B3 B8 12 92 83 44 
85 F2 C3 B6 F6 37 D8 F7 A9 BC 14 28 D8 E5 93 A7 73 29 95 8C AE CB 03 90 
59 BB B7 7D 7F 71 35 E6 FC 06 5E E6 5C ED 94 10 AF 4D 66 BC 8C C5 38 87 
9C C2 EC 40 0E AE B2 76 61 F4 DE C6 AA CC 6C 27 10 E2 30 6D 71 98 E2 1E 
27 8E 5B 78 D5 5E 2C 56 79 C8 91 80 50 CC B1 F4 00 50 49 53 AD 9F BC 06 
CE C6 E3 9E FC 15 E4 11 C8 EC 13 C0 F7 EC AA 8A 94 D3 46 64 60 D8 27 F5 
86 3F F5 FB 80 AD 24 6A D6 DF CF 59 55 90 0E 91 05 49 DF 6F 13 37 D2 90 
78 F2 F0 5F F3 49 6A AC 23 B5 05 A2 ED DD D8 1D F8 F9 1D 01 AA E3 E2 5C 
76 6F 87 F0 97 9C 49 0F 14 B6 42 D9 23 45 31 4D 92 93 22 D7 2F 2B 43 CA 
47 F2 E2 55 2A A1 49 F8 98 9F 87 43 B6 E9 2E 6E 3D 32 5A 18 72 16 69 0B 
B7 6E 65 F8 0F 6F F8 F6 CC 37 ED B2 05 74 AD 6E 1B 4D 2E 88 E4 03 8F BF 
0A E7 35 79 20 20 48 31 9D D2 F7 A8 18 2B 23 04 99 08 17 95 1A 23 34 45 
47 B7 92 BF 4A AD EA D0 CC 66 6C 72 5C 19 7F 67 05 C8 86 74 25 A0 59 A3 
F8 99 49 EE 83 C8 D9 07 F1 F1 ED E6 AB 06 05 4E 88 22 A8 5C 70 B1 45 14 
51 11 5D 98 4C 7C 99 5C AD BD 84 72 24 5D 56 F8 E5 7D F2 C4 80 12 EE DA 
FE 95 50 58 FE 00 D7 1D 34 61 2C 2F A2 E1 A9 DF 1B 67 73 77 91 CA F3 40 
8B 6C A6 47 8A D9 08 32 12 AA 09 1C ED CA A0 FF 00 6A 48 08 D3 0A F0 90 
06 4A F4 02 78 5B 84 D8 FE 20 7B 9C 75 A0 16 5F 67 E6 38 C6 66 E5 DC 4B 
FD 12 1F 1B 20 73 16 3E 09 63 B0 3B 56 FE 17 C3 A6 62 ED A1 92 ED 2D A3 
8D 41 79 0E 8E BF 2D 8A 8D C5 E0 2F 6C EE A3 BB BE BC B5 C6 98 5C 37 2C 
97 28 92 A9 04 1F BB BE 60 7F 2D 8F 95 36 5D 71 FE 36 09 82 47 04 92 82 
80 33 42 7E 10 43 1F 1B 03 F0 FF 00 35 9F 25 89 23 71 F4 1B AC 1F 9E 16 
B4 35 A2 78 69 B2 ED 18 F8 E4 79 B7 F8 B4 FA 77 67 37 F1 17 09 14 62 52 
83 25 0A 19 17 B7 C3 D4 1B 3B F1 5E 90 CB FD 92 4C 1E 72 F6 49 24 6D 5D 
A2 C0 1B 9B 68 82 64 04 96 03 5B 23 F1 1B D8 FA 55 13 C3 9E A3 D9 CB 93 
B6 48 B1 57 E5 63 65 25 A3 20 B0 EF B1 EF FE 77 56 5D A7 1D E3 F3 36 17 
38 78 2D AE 2C 9E E4 73 A0 91 A0 E6 01 00 7D 32 A9 07 60 26 B7 DB E9 A1 
5F 3B 79 96 EC 5A 64 CE 8F 48 6E 3B E7 6C E4 AD 48 5B 5E 2A E6 28 A4 D5 
A8 9F 8D F1 8C 2D 7E AA 47 6F 8A E0 7E 2A E1 C4 6B C1 73 15 D4 57 30 29 
2C 01 85 9D 00 1A D9 D9 1A 60 76 7B 06 4F 9D 53 DC 15 C2 8B C4 10 DE 89 
67 9A DA 58 1A 30 A0 20 20 86 E6 DE C1 FA 0A B0 B8 F7 D4 7B 0B D5 5B 91 
8A BC 90 41 27 31 92 DC C6 EB D2 60 03 AB 15 6D 0D 95 8C F7 0B DD 7E 74 
81 37 A9 16 52 F6 7C 75 D6 BC 72 F3 8F 1F 53 56 74 CF EC AB 19 69 8B 24 
9C 9D C7 38 03 F3 3F 6A 7B 71 D5 B0 43 9D 2E 92 36 E0 9D B2 4F EE 3E 92 
84 36 A6 F6 78 FA 92 B4 36 D1 03 25 C4 8A 37 CA 83 5B FC FD 87 CC 90 3D 
EB 6D C3 45 9C C2 5D 49 14 42 2B 9C 61 0F 14 7D 4F 36 84 85 2A 37 E4 A3 
90 DD BB 9E A3 93 E2 A7 B3 39 9C 6F 15 62 A4 B4 86 48 F1 F7 4A E8 C9 D7 
75 41 20 F8 B6 0B 12 00 1B D1 D6 FB F6 F9 6A A0 B1 B8 EC DE 06 FE 1C C2 
E3 9A F2 CE 22 44 AF 08 EA C3 2C 4C A4 3A 33 2E C0 0C 85 81 DE 8E 8D 6E 
43 3E BD E5 1A 4F B7 9C AC 99 EB E8 18 88 EA 6F B8 F3 64 B9 45 48 71 16 
3D 31 B9 59 6D ED E5 69 AD 5B 52 5B 4A C3 46 48 98 6D 18 81 E0 E8 E8 8F 
62 08 F6 A8 FA AD 44 BB F0 B8 D1 91 B8 31 FD B6 CE D0 0D 6D AE 26 11 8D 
7B EB 7E 6B 7F 14 5C F3 66 A6 5B 59 A3 FB 34 6A 21 80 42 C3 94 44 A3 4A 
09 1A 04 EB EF 1F 72 49 F7 A2 8A 98 38 99 C8 3D 82 A9 CD 0D AE 08 E4 95 
13 45 14 55 2A 55 D9 6D 93 BD B7 80 41 1C CD D1 D6 BA 7B D2 9E E4 F7 D7 
9F 27 CD 58 5E 9A 5F DF BC D0 4E F9 8C 6C 11 24 72 2A C3 24 AA AC 36 85 
46 F9 A4 53 E4 EC 7D 28 A2 B3 BA 9B BD 3A CE 2D 5A 7D 29 A2 4B 2D 0E 4A 
FC 4F 71 7F 8F BD 40 D9 5B 7B C7 1B E4 78 A6 E7 64 EF EE 43 1D 7E B4 B9 
3C B2 4C E5 E5 6E 66 3E 4F CE 8A 2A AA CE 2F 89 AF 77 24 29 2D 30 47 2B 
98 DE 02 F8 AC AB BA 12 51 99 49 04 1D 1D 6C 1F 22 8A 2B BA 9D 30 5A 5A 
0C AF 0D 42 86 EF 1F 1D CD A4 AC 23 EB 5D 2C 6E 61 6D 92 A4 31 1D 95 BB 
8D 77 FE 63 6F C0 A5 F7 42 8E C8 48 24 1D 12 0E C7 EA 28 A2 A5 81 E4 C8 
F6 F6 05 57 3B 00 8D 8F EE 57 FF D9                                     
    );
    my $background_image = join '', map { chr( hex($_) ) } qw(
FF D8 FF E0 00 10 4A 46 49 46 00 01 01 01 00 48 00 48 00 00 FF FE 00 13 
43 72 65 61 74 65 64 20 77 69 74 68 20 47 49 4D 50 FF DB 00 43 00 05 03 
04 04 04 03 05 04 04 04 05 05 05 06 07 0C 08 07 07 07 07 0F 0B 0B 09 0C 
11 0F 12 12 11 0F 11 11 13 16 1C 17 13 14 1A 15 11 11 18 21 18 1A 1D 1D 
1F 1F 1F 13 17 22 24 22 1E 24 1C 1E 1F 1E FF DB 00 43 01 05 05 05 07 06 
07 0E 08 08 0E 1E 14 11 14 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 
1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 
1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E FF C0 00 11 08 02 58 03 20 03 01 22 00 
02 11 01 03 11 01 FF C4 00 1D 00 01 00 01 05 01 01 01 00 00 00 00 00 00 
00 00 00 00 03 01 02 04 05 07 06 08 09 FF C4 00 4D 10 00 02 01 02 05 01 
06 02 07 03 07 09 08 02 03 00 00 01 02 03 11 04 05 12 21 31 41 06 07 13 
22 51 61 14 71 23 32 81 91 A1 B1 D2 42 52 C1 08 15 62 A2 D1 D3 F0 17 24 
33 34 63 72 B2 B3 E1 25 43 53 83 92 93 C2 C3 35 73 44 82 A3 FF C4 00 19 
01 01 01 00 03 01 00 00 00 00 00 00 00 00 00 00 00 00 01 02 03 04 05 FF 
C4 00 25 11 01 01 00 02 02 02 03 00 01 05 01 00 00 00 00 00 00 01 02 11 
03 12 21 31 04 13 41 05 14 33 51 61 71 81 FF DA 00 0C 03 01 00 02 11 03 
11 00 3F 00 F8 C8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 12 E1 B0 D5 F1 35 63 4A 85 29 D5 9C 
9A 49 45 5D B6 74 3E CA 77 2D DB DC FE 70 F0 F2 99 60 E9 C9 5F 5E 2E 5E 
12 B7 C9 EF F8 19 4C 2D F4 5F 0E 6E 0F A5 72 9F E4 BE A1 4E 35 73 EE D9 
60 70 AA CF C4 85 18 39 B8 FD AE DD 3D 8D DE 13 F9 37 77 7B 5E 6A 9D 3E 
DA E3 6A D4 72 D3 18 FD 1C 5C DF B2 B6 E8 D9 38 72 B1 8D CF 19 FA F9 3C 
1F 58 66 BF C9 63 B3 F4 D3 8E 1B B5 B8 CA 13 97 D4 75 E8 46 50 F9 5D 34 
FF 00 03 9B 76 B3 F9 3B F6 C3 28 C4 F8 78 2C 66 59 98 A9 2D 50 50 AA E1 
29 2F 94 95 BF 12 7D 39 7E 1D F1 FF 00 2E 30 0D EF 69 7B 21 DA 5E CD D4 
50 CE F2 6C 5E 09 37 68 CE 70 F2 49 FB 49 6C FE C6 68 8D 77 1B 3D AC BB 
00 04 50 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 02 A9 5D DA D7 02 87 
52 EE 7F B9 BC EF B7 35 63 8C C5 C9 E5 59 3A DF E2 6A C3 7A BE D4 E3 B6 
A7 EF B2 F9 F0 7A 8E E8 7B A3 A1 43 23 A5 DB 5E DB 61 A4 B0 B3 B3 C0 60 
64 93 F1 39 B5 49 AB EF 1D B6 8F 5E 5E DB 3E 9B 8F ED 55 77 89 C2 E0 A9 
BA 30 C3 C1 C7 54 23 1B 24 D7 A3 5D 3A 25 BD 8F 4B E2 FC 1B C9 3B 57 27 
3F CA 9C 77 AC F6 F5 5D DA 76 53 B1 BD 95 AB 1C 3F 67 32 DC 25 39 D2 4A 
35 33 1C 4B 53 AB 51 B5 7B A9 5B 6F 92 B1 D3 E5 8A CB F2 FC 6E 13 09 98 
2C 35 3A 58 A4 DC 65 3D D4 9A 49 B7 77 C1 C9 7B 35 2A 59 5E 06 35 AA E4 
DF CE D8 BA F2 9E 8A 6E AB D3 4D C6 CE F6 F7 4D 24 D2 BA 3D 77 65 32 AC 
E3 1F 86 C3 57 C6 E5 58 05 1A 77 D3 4A AD 49 4A 5A 79 5A 6A EE E3 65 65 
6D D3 EA 6C E6 E1 C7 1B E3 D3 0E 3E 5C B2 F7 ED EE 33 7C BE 9D 5C 05 5A 
14 30 90 AF 07 BD 38 D3 6D 29 4B D6 6F D1 7A 7B 1C EF B6 2B 29 CB E8 62 
E9 60 72 49 E2 31 94 E1 BD 7C 2A FA 38 CA FB BD DD E4 95 FA 5E C7 A3 ED 
74 F3 BC 97 B2 55 3E 16 BD 2A 10 AD 27 18 C3 56 A9 CE 53 69 28 A7 C2 5F 
71 E6 FB 37 98 E6 39 8E 33 2A A2 F1 39 6E 51 0C B1 38 CF 14 A8 47 4C DF 
EE 28 B6 B5 2E 53 7B 2D AE 8C 78 31 B8 CE DB DC 39 6C CB 2E BE AB C8 E1 
BB 47 8E AA E3 52 A5 4C 2D 25 4E 94 AA 69 C4 D4 94 95 4B 2D B4 DF 7B DD 
7C BD 4F 51 D8 FE D7 53 AF 98 53 CA 73 9C AE 58 D9 E2 D3 A9 45 C5 2D 54 
D5 DD EE BA 6F EE 6E 7B 43 95 F6 77 35 71 C7 E6 58 7A 18 B5 4D BF 0E 38 
35 38 B9 36 DD D3 51 57 92 6E DD 7E D2 B9 47 77 B4 B0 B4 29 E6 D9 25 7C 
4E 02 75 26 E6 B0 D5 97 88 95 39 2D A0 EF 69 46 CF D5 BE 17 CC DF 9F 2F 
0E 58 F9 9A 6B C3 8F 93 1C BC 7E 37 D9 D6 03 B2 95 30 D5 32 CC C6 85 2A 
90 A8 BC D4 67 15 3B 2F 46 8E 11 DE 7F F2 7C EC 8E 7B 52 55 7B 25 88 8E 
4B 99 34 DC 28 CD 37 87 AC D7 4F 5A 6F EC B7 B1 D2 E8 E1 32 BC DF 3A A3 
4F B5 14 5E 53 9D 52 94 A9 D3 AB 0A FA 56 23 4D D3 DD 3D FD 53 F4 F5 44 
99 A7 67 F1 F9 56 2E 95 6A 18 84 E9 51 57 F1 D7 99 FB A6 93 FE 1D 7A 9C 
DF 5E 3E AD 6E FB 2F B9 1F 03 F6 BB B3 19 E7 65 33 8A D9 56 7B 97 D6 C1 
62 69 49 A7 1A 91 B2 92 F5 8B E1 AF 74 69 8F D0 0E FB 7B 29 5B B7 59 35 
2C 2E 27 2D C3 63 B2 F9 52 D7 43 19 41 25 5F 0B 52 D6 7A 5F 55 7E 9C 35 
CE F6 3E 1F ED DF 64 F3 4E C8 E7 73 CB 73 2A 7B 6E E8 D5 4B CB 56 37 B5 
D7 A7 BA E8 73 72 70 59 8F 68 DF 87 2C B9 75 BE DE 7C 00 73 36 80 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 07 63 FE 4F 5D DE D0 CE F1 33 ED 4E 79 A2 19 
76 06 77 C3 53 A9 4D CA 35 EA C7 7F 32 E3 44 7A A7 CB DB D4 E6 DD 87 EC 
F6 37 B5 5D A8 C0 E4 78 0A 6E 75 71 55 54 5B E9 08 F3 29 3F 64 93 7F 61 
F6 6E 7F 95 61 FB 35 D9 3C 1E 49 92 E1 9D 2C 1E 1A 10 A5 36 9F 4B 70 FD 
DB DD FB B3 B3 E2 70 CC B2 ED 5A 79 B3 B8 CD 4F D7 9D CF D6 6B 9D C9 3A 
F8 C9 42 0B 7A 70 6A D0 4B EC EB 6D 8C 2C A3 B3 15 71 38 89 D6 8F D2 E1 
F0 B2 53 C4 CA 53 D2 B4 59 B7 67 EB B6 C8 D8 62 F3 99 D4 CA A8 60 2A D1 
6A AE 1A 6D 46 A2 DA F1 7C 27 F8 92 D0 ED 1C F2 3E CE 62 A9 46 31 93 C4 
49 28 27 1D E5 A9 DB 7D B8 B2 3D 49 F2 39 37 D6 7A 72 67 F1 F0 98 F7 BE 
D9 BD 94 C3 56 CF FB C1 C3 2C 2C EB 65 98 27 7A B1 8B 72 9C 69 C1 3D A3 
16 DE F7 BF E2 76 7C BA 78 EA 19 8E 27 01 47 07 1A 6A 9C 95 48 62 12 6A 
0E 29 AB AB F0 A5 67 F9 FA 1C 6B B2 39 B6 23 07 9C 60 71 D8 FA 90 C1 D2 
A9 86 74 BC 46 D5 A2 B5 3D DC 79 57 DA C7 60 A7 DA 4C 1E 17 38 A9 91 D4 
8D 4A 95 71 17 9C EA B5 68 C6 9A B4 2E BE 6E EB EF 39 7E 57 6B 96 99 7C 
7D 4C 5B 5A D9 15 0C D6 A2 C5 E3 EA 78 8A 31 97 85 4A 15 1B A6 93 B7 3E 
BC 23 8A 67 59 2C F0 79 86 2A 92 BB 8C AA CA 4E 56 B6 A7 7E 0E D7 8C C0 
E1 F2 7C 9D E2 32 E9 2A 35 21 1B 27 1B B8 C9 FA B4 B9 3C 5C 26 E5 8A 95 
5A EA 4D 6B 70 C4 2B 5A CA A2 6B 54 3F 7A 3E E6 BF 8F C9 66 EF E2 F3 E1 
2E BF CB 9D BC D3 35 C3 56 A7 57 09 8F C5 D2 9D 28 B5 17 09 36 E0 AD 64 
95 CC 4A FD BC ED 6E 0A 35 A9 7F 3A 62 31 34 EB 6F 38 56 7A D5 BF 81 26 
6D F1 19 6E 3B 19 83 9C 9E B4 DD 39 EA DB 65 2D 9F E0 79 AC CD D6 55 9C 
A3 27 77 1B C7 55 D5 D7 43 D4 C3 0C 2F B8 E2 B9 65 3D 55 72 AC DB 1F 9C 
76 8A 9C 33 68 CB 1C EB CB CF 4E BD 57 14 E4 F8 6B DD 1D C7 B2 19 B6 16 
9E 61 8E C0 51 58 95 84 CB 94 23 56 32 93 A8 A7 17 78 DB CC AF 74 D7 3D 
51 F3 EE 63 8E C6 D3 C5 47 15 39 7C 2F 83 A2 DA 16 EB 4E E9 A7 EB 7B 33 
AB F7 25 98 C7 38 ED 26 7D 5A BD 3D 35 F1 78 5A 35 2A DF 67 29 26 D3 92 
BB EA DD F6 F6 35 FC CE 39 D7 B7 E3 6F C6 CA EF 5F AF 75 D9 BC D3 05 E2 
3C 4E 0A 87 83 80 C4 56 94 55 28 41 E9 6A F6 4D A7 C3 6F 7D B6 E8 79 0E 
FE 3B BB C8 7B 4B 95 57 A1 89 87 82 E7 25 52 95 68 C7 53 A3 27 FB 4B F8 
AB AB AF BD 7B FA 59 35 4A 38 E5 2C 3F 86 E8 B7 79 C1 F2 FE 45 7B 4B 81 
FE 78 C9 31 58 15 6A 55 15 29 A8 EF E6 5E 9F 79 E7 63 96 33 39 67 A7 55 
96 E1 FE DF 9A FD AF EC FE 61 D9 7E D1 62 F2 3C D2 9A 86 27 0B 3D 2D AF 
AB 35 CC 65 1F 54 D3 4D 7C CD 41 F5 17 F2 86 EC 4E 23 B4 1D DF 53 ED 3D 
2A 09 E6 DD 9E 93 C2 E3 6C BC D3 C3 F2 9B FF 00 75 BB FC 9B F4 47 CB CF 
93 97 9F 8B EB CB 5F 8E 8E 2C FB E3 B5 00 06 86 C0 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 02 AB 90 3E 91 FE 48 5D 99 86 17 0D 8F ED A6 2E 2B 54 9C B0 B8 54 D7 
09 2B D4 97 DF A5 2F 93 3B 7E 0B 0D 5B 3A C6 6B C4 C5 4A 85 59 E9 4A 6B 
6F 7B 7B 9E 7F BB FC AA 9E 45 DD 16 45 97 36 A9 B7 84 84 EA AE AE A4 FC 
F2 5F 7B B7 D8 7B 0E CE D4 78 68 3A D8 76 E5 87 C2 61 9C A5 2F DF AB 2D 
94 52 3D 6C 27 4E 3F 0E 2E 4B DF 91 E0 B1 F8 1A 33 C2 E2 B1 31 9E 9F 1B 
13 2D 34 D4 7F 62 2D A4 45 87 EC E4 B3 2C DA B6 13 1F 8B 8E 5D 87 A5 4A 
55 2B 55 A8 AF B2 FD 95 EF 6B 9E 8F 24 CB EB D1 C6 E6 11 AA D3 C3 50 9A 
DE 51 52 6E 56 52 7F 9F E0 78 3E F3 33 37 8E CD 6F 43 15 1A 74 EA 42 A4 
A6 DF 16 69 6C ED D5 D9 F0 FA 99 71 61 73 CF 5B 39 79 75 87 86 C7 24 C2 
47 0D DB 9C 2E 0E A5 4A 58 FA 55 9C 67 87 95 26 A7 1D 3A AF 15 F3 F5 5B 
9D B3 B3 7D 9E 82 C8 A9 E1 A5 88 55 33 58 A7 52 AE 22 AA 6E A4 EA 75 93 
F6 BF 43 82 F7 5F 89 C5 3C CF 0B 2B 3A 90 C2 BB 53 A8 9B DD BE 12 F4 DD 
7D C8 EA 95 BB 55 9A 64 B8 CA B5 67 82 8D 49 D1 A1 7A 94 A1 3B 4A 35 66 
F9 92 7C AB 34 F6 DE E5 F9 38 65 BE B3 DB 5F 0D C6 4D D6 1F 78 3D B4 C5 
E1 33 7A D9 66 26 B5 55 97 CE 0A 35 65 42 11 77 69 DA 5B BE 38 7B 7B FC 
CC 3C E7 B7 B9 75 77 86 A5 96 2A F0 D3 45 50 94 A5 1D 3A A0 F9 DB D7 FB 
4E 51 9A E6 59 AE 6F 9E 63 69 54 9B AB 27 88 D7 34 A9 F9 9C 94 B8 B2 E1 
6F F2 37 F9 0E 50 F3 5A 35 B1 BE 1D 58 E1 A1 5F C3 A9 88 8C F5 78 31 51 
BB 6A 3B CA 4F 67 BE E9 1B BE 8C 31 93 6D 5F 66 59 6F 4E 87 98 65 39 16 
73 98 56 AF 2C 56 36 A5 47 08 CE BD 58 C1 27 4A EA DB C7 DA D7 7F 2F 73 
51 DE D6 56 AB 64 B8 6A F8 0A 98 4C 4D 0C 02 B2 9D 08 DA A2 8E DA 94 E2 
B6 B6 D7 56 B1 E5 65 53 0D 81 AD 4F 32 C1 BA F3 82 A8 E3 35 89 56 71 92 
5B 45 DA C9 A6 AC EF B5 FA 91 E5 39 A5 4C B3 17 5A 9B A1 7A 55 2D AA 49 
5B 55 37 7B C6 DD 7A 59 FF 00 D0 CB 1E 3C A5 99 4B E9 32 CA 79 8D 0F 66 
7E 0F 1D 9B CF 2D C6 56 9D 38 E2 62 FC 1A 8D B7 08 54 BF 97 52 E8 9F 17 
E9 74 77 5C 97 19 1C A7 30 F8 8C FB 06 E1 89 A7 4B C3 C2 D4 8E 1F 4D 48 
C1 45 29 53 BC 76 6B 6E BD 57 B9 F3 C6 77 3A D9 66 71 8F C1 61 31 33 A3 
4A B3 D0 D4 27 FE 92 0E 4A 51 DF EC 5B F2 7D 03 DD A7 68 F0 79 97 66 F0 
F9 7F 68 14 EB 62 5C 5D 28 62 26 D4 BC 78 FF 00 6E DF 6A 1F 36 5D 4B AF 
0B F1 AF E7 EB A0 4E BC 16 59 2C 4D 39 D5 82 8D A6 93 E5 6F C5 CC 0A D8 
CF 16 75 1C 65 69 CE 9B 51 71 77 DF DF D8 D7 62 B1 18 8C 3E 36 58 3A 9E 
1A A3 38 B5 09 B7 F5 D7 4F B4 D2 67 55 B1 98 79 D2 C6 E1 E8 55 AA B0 D4 
DC 2A D1 A7 6D 52 8B 5C A5 D5 A6 B8 F9 9C 18 71 BA 73 CD 83 D9 C9 CF 17 
9C E7 39 16 71 86 A5 2A 58 FA 6D 57 A1 6D AC E3 A6 4B DD 34 F9 F6 3E 20 
EF 33 B3 55 7B 21 DB AC DB B3 D5 2E D6 13 11 28 D2 93 FD AA 6F 78 3F B6 
2D 1F 75 62 EB D3 C6 CB 03 DA 2C BE 34 BC 4A 14 75 38 CB 67 34 FD 3D 2C 
7C E9 FC B4 32 88 2E D0 64 BD A5 A3 04 96 3F 0D 2A 35 9C 57 13 A6 D3 57 
7E EA 56 FF 00 FA 8F 93 8F 6C 76 BC 19 6A E9 F3 E0 00 F3 5D 80 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 01 9F D9 EC 37 C6 E7 D9 7E 11 AB AA D8 9A 74 DA F6 72 48 C0 
37 3D 87 94 61 DB 0C A6 73 B6 98 E2 E9 B7 7F F7 91 9F 1C DE 72 25 F4 FB 
1F B5 19 9C 30 B9 2E 06 11 D9 46 70 D3 6E 96 DC CE ED 1E 77 4B 03 93 F8 
5D 9C C5 E1 F1 18 8A B8 DA 73 94 1B B3 84 38 50 BF B3 B7 D8 78 CA B9 AE 
17 11 8C C0 47 13 E6 A1 4A EA A4 12 BD EE AC BF 16 6A 3B 23 93 55 CC F3 
8C 3D 39 62 DD 3A 35 A7 27 29 2E 7C 38 49 2F B1 DD 73 EC 7B B7 8E 75 DD 
FC 79 9B BD BC 7E BA 07 68 BB 69 1C 25 2C C3 22 CA 28 F8 38 CA 70 94 AB 
D7 7A 6D 19 EC 9C A7 26 ED D7 6E BB 1C C3 09 9A 62 6B D4 70 C4 42 9D 5C 
3D 4A 73 D1 53 47 FA 29 B7 26 E5 EB 26 FC DC DF 9B 7A 1D 13 B6 58 9C 8F 
29 A3 5F 09 3C 0E 1B 1E EB CE 0E AC 2A CB CB 16 9D F5 5F 66 DB 6D 7C CD 
77 6B 6A 60 71 F9 52 F8 AC 34 28 69 A7 1F 06 A5 05 68 49 3B 5A D6 E1 DF 
9F 91 38 EC C6 7A F6 C7 39 BF 3B 7A 1E EC 7B 3D 1C 34 70 B9 AE 1F 0B 52 
9D 1B C6 3A 67 27 24 9F ED 49 5E DC B5 B2 7C 5D 99 5D BA 8E 2B 1D D9 FC 
56 69 98 E5 B5 EA CA 9E 36 BD 0A 6F 5C A8 E8 A1 AE D4 E6 DC 5A 6D 25 1B 
EF FB C7 9B EE C3 B5 39 D4 73 0A 1D 91 C5 54 82 F0 E4 E2 A7 2D E6 E2 BC 
D6 DF ED DD 1D 97 31 C1 43 1D 91 E2 F0 58 A9 37 4E BC 14 5E 9E 6C F9 BF 
CC D1 CB 95 C7 3F 2D D8 C9 96 1E 1F 2D 76 57 07 57 1F DB 2C 4E 13 0B 8A 
69 CA 32 A8 AB 78 2E 2A 36 DF 87 7E 9B DF D8 DB BE D1 E6 9D 9D AD 88 C1 
65 39 9C E5 41 D3 6A A4 3C 04 92 9A 7A 64 D7 A5 DA DF D7 A9 E9 F2 7C 2E 
49 3C E3 38 C1 50 AD E0 CA AE 26 A6 1E AD 7A 4B 4C 92 A7 14 E3 A7 66 92 
76 95 F7 E8 DF CB 96 76 96 94 A9 62 DC 75 C2 7A 67 E7 AF 4E 7A 94 D3 6D 
A7 EC ED F9 9D D8 E5 39 32 F2 E5 CA 74 9E 1D 37 BB 7C C7 37 CF 33 CC 3D 
0C 7D 35 98 61 A9 D7 8B 8C 6A B4 E1 27 6B 2B AE B6 4F F0 3D 47 7A 39 2E 
13 2F 9F 84 BC 2A 35 2B C7 C6 A3 6B 45 45 A6 AF 14 97 1F 6F 17 BE DB 9E 
1F B0 58 55 1C 66 4D 89 C8 F3 4D 59 86 22 A2 8E 2E 84 9D 9C 6D 2D E5 4F 
7B 4A CB 95 CF A7 3B 6F 7F 94 5D 48 47 39 C0 D2 78 AF 0E 5E 1C A5 A7 57 
D6 4D E9 8C FE 4E CD 35 D0 D1 BD F3 4D 36 E5 35 C7 E5 E5 30 59 76 45 9D 
D7 59 6E 63 88 AB 47 1B 06 E3 4A BD 29 A7 75 7D B6 7B 3F 63 45 19 4F 26 
CD 2B E1 F1 D5 71 15 61 86 92 51 8C 69 A6 E4 93 F9 DE 2B FD D2 F5 8C C2 
52 A2 B0 95 AA 3C 35 75 A5 3C 44 7C D1 57 EA BE CB 75 E8 CC 2C CA 71 CC 
6B 4E F8 B7 2A D4 EA 68 4E D6 D4 BA 3B 74 EB F7 9D 93 77 C5 BE 1C F7 C7 
AF 6E B7 D8 FE DF D5 AD 42 95 6C DF 03 8A 59 74 6A 43 0D 2A B5 F5 4E 9A 
A9 64 EC A7 FB 3D 3E B7 B6 E7 47 C8 F1 D9 6E 3B 03 5F 13 81 AB 4F 19 4A 
7C C6 E9 CA 0D FE CB F4 3E 67 EC FE 3E AE 07 3A C0 52 AA D4 E3 4A AB 75 
28 FD 58 B6 D5 AF 6E 2F D5 3F 53 A4 65 79 CE 5D 86 A9 1C 66 55 29 61 B1 
38 46 E3 88 A6 A9 D9 D6 A7 7B CB 5F 47 2E 5A 67 1F 37 04 97 C3 A3 8F 93 
73 CB DD E3 70 71 A1 8E A7 E0 D3 84 28 CE 8C EE A3 B3 52 BA 7B 7C FF 00 
81 C7 7F 95 45 15 8B EE C6 84 E7 4B 45 6C 1E 32 9C E3 D7 C9 24 E3 75 F7 
AF B8 EB D9 C6 3A 33 C2 42 6E 2E 0D AD 4B 6B 33 8C F7 FF 00 99 54 C4 76 
13 37 C3 D6 85 38 DF C2 74 D2 E9 15 38 BB 7C EE 69 EB 6E 17 FE 36 4B AC 
A3 E5 A0 54 A1 E3 3D 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 97 09 5A 78 6C 4D 2A F4 
DB 52 A7 35 24 D7 B3 22 05 96 CB B8 3B 8F 66 73 AA 38 CC 35 2A F4 EA C9 
D5 AD 38 4B CA D2 71 69 71 F7 D8 E9 DD 8D CD 29 E0 E8 CB 15 55 AA 7E 05 
08 50 8A 4F 65 A5 B9 3F C5 9F 28 E4 D9 AE 23 2E AD 17 4A 6D 47 52 6D 1D 
33 03 DA E8 63 32 AF 83 F1 A3 15 38 E9 6A FE BE C7 BD 87 24 E7 C3 78 FF 
00 EB 87 3E 2E 96 D7 B4 CD B3 4C 3E 2F 3D AC AB D5 FA 67 29 CF 7E 1C AD 
CE FD 17 4F 90 C8 7B 45 8A 96 0E AD 19 2A 75 97 8B 28 D3 F1 37 5A 6F 7D 
9F 43 C1 47 13 53 1D 52 1F 13 8C 4D 41 D9 35 F5 D2 F6 F6 37 B9 45 48 D3 
85 2A 34 64 E6 A9 CE D2 97 1A B7 7C 23 7E 52 48 E6 D6 5B 7A FE C9 E3 55 
0E D8 64 D9 CE 22 BB A6 FE 92 8D 4B BD DC 94 D2 B7 DD 24 8E F3 8C CC EA 
54 C2 A5 4E 4A CE D1 96 99 6F 67 D5 1F 36 62 B1 34 70 B4 F0 F5 27 2D 15 
68 66 32 AF 17 2E 8A D1 8B E6 DD 6C 74 7C 27 6A 29 54 C2 4A A2 D1 2A 2A 
9C 5B 82 D9 B4 DB 4E DF 8B 39 39 71 DD 95 BB 0F 13 4F 09 57 34 C5 76 7F 
B4 99 E6 17 C5 D1 57 10 9D 39 5D 38 A9 29 3D 49 FB 7B 3F 76 6A F0 55 70 
D4 32 AA F3 C6 53 AD 56 AC B5 6D 0A D6 8C 1A 4E D2 71 7C B5 B7 55 B3 B0 
EF 0F 32 A5 99 E7 F0 AD 3C 42 55 12 8D 3A 8E 31 69 38 C5 25 07 7B EE EC 
BF 0F 73 51 4B 32 A3 FC DB 08 62 13 AB 0A 75 64 9C 63 6B AB AB 37 7F B1 
6C FF 00 03 B7 1C 77 25 73 5F 15 9F D9 1E D1 E2 72 0C D3 0F 8E C3 6D 52 
9C 92 FA DC 3E AF ED 5B 58 E8 DD EE E6 34 7B 57 91 E5 79 B5 38 45 E3 A1 
1D 30 D1 2B 45 A6 EF A6 CF FC 6C CE 27 52 BD 38 4D 4A 1E 66 D5 DF A3 3D 
4E 4B 3A D9 8E 02 52 51 84 70 B4 56 A9 C1 46 4D CA 51 6B 66 D2 BE E9 F4 
7D 1F A0 E6 C2 4C A6 66 16 DC 6E 2F 41 93 62 68 C3 01 87 A5 8B C3 46 35 
30 52 94 A0 E5 6B 4A 32 6E F1 97 A7 FD 0C FE CD 62 32 B8 54 C5 64 38 AC 
16 8A B8 BA 6E 51 AF 2A 9A 25 AA DA A2 96 DB 74 FB CF 25 DA 7C C3 13 57 
1D 46 AC 70 B1 8E 0E A2 5A 29 C2 ED 45 5F 78 3B EF CA EB B9 93 8B C6 51 
9D 59 56 A3 5E 73 95 D2 97 8B 25 74 9F EE BE 91 DF A9 85 96 CF FA CB D3 
1F 1D 89 AB FC E9 07 42 9B 55 A0 E5 37 29 3F 3E DE BE BB 1E 9F B2 B9 D5 
3C CF 13 08 63 30 D1 8D 67 56 4D 55 8C 74 C6 51 D0 96 97 F6 D9 F3 D0 F3 
99 85 2A 55 F0 B1 9D 2A B0 94 9D 47 37 4D 2D 53 71 E3 97 FB 3B 7E 24 75 
71 38 55 46 1E 36 EA 83 49 AE 1A 7F BD 75 EE 65 6C CA 69 26 36 57 4F CD 
FB 53 49 FF 00 9B BA D1 6E 0F 74 E4 93 47 15 EF B3 B4 B1 C5 61 AA E0 21 
36 DD 47 18 BD FA 26 9F F0 30 BB 4D DA 68 D2 AB 5F 11 E2 C2 B5 7A BB D3 
B7 EC 23 9B E6 D9 86 23 32 C5 CF 11 88 96 A9 37 B7 B1 CB F2 72 C7 87 8F 
FD D7 4F 06 19 67 96 EF E3 0C 00 78 4F 40 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
24 A5 5A A5 27 78 49 A7 EC C8 C1 96 19 E5 85 DE 34 B3 6D A6 07 35 AB 41 
A6 A4 DB F5 6C F5 9D 98 ED 2C 16 22 14 E7 3F 0D BA 8A 49 B7 B2 DB 93 9F 
95 8C A5 1E 19 E8 61 FC 8D BE 39 23 4D E1 C6 BA BF 6B F3 DA 12 AD 46 9D 
0A 91 F1 12 BC A5 7D 9B 72 8B FB F6 5F 71 B2 EC B7 6A A1 4F 2D C5 50 AA 
E1 29 47 F6 B5 3F 37 1F 86 FF 00 79 C7 7E 2A B3 69 CA 6D B5 EE 4D 87 CC 
6A 51 A7 28 2E 1A B5 CE AC 7E 4F 06 78 C9 BD 35 5E 1B 1D 1F B4 18 F8 56 
AE EB C6 2D DD C9 A9 F4 56 DB 93 53 83 C7 C6 18 5C 5D 3A 92 D5 AE DA 17 
A3 BB B9 E6 FF 00 9F B1 52 C2 CF 0D 29 45 D2 9D AE AD BD D1 85 F1 D3 F1 
9D 5D 57 95 EF B9 D5 8F C8 E2 98 EA E4 D5 FD 3D DB D4 4E B6 B9 4E 94 5A 
92 B3 92 F9 1E DB BA BC C1 45 62 F0 F5 31 0E 9C 25 15 24 D4 AD A6 4B 87 
EF F2 39 0A C7 4F 5C 26 E5 77 15 6D CC 8C BF 39 C4 60 6A 4D D1 9B B4 D5 
A4 BD 51 8F 37 CA E2 CB 0D 76 65 87 C7 B8 D7 48 ED 0E 37 E1 B1 F5 6A 4E 
73 94 27 37 19 53 A9 2B ED D2 49 DF AE EC D6 BC F6 33 A5 68 C6 9D E2 9E 
BB 3D ED 6D 99 E2 71 F9 D5 6C 4D 57 25 75 17 CC 5B B9 85 F1 53 50 94 62 
DA 52 E5 1A A7 CA E1 C6 79 AC BF A7 B5 EE AB 76 8E 34 9B 7A BC CA 2A CF 
55 ED EA 6A B3 DE D4 3C 55 39 53 84 54 94 9D E5 EE 79 49 D5 9C DF 9A 4D 
96 1C BC BF C8 63 3F B7 1B 31 F8 F2 7B 49 5A B4 EA C9 CA 4D EE 46 01 E6 
E7 C9 96 77 79 56 F9 24 F4 00 0C 14 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
07 D1 BF E4 47 B0 51 85 E7 9B F6 81 CB A5 AA D2 5F FD 46 35 7E E7 3B 03 
4E 2E D9 97 68 AF D3 E9 A9 7F 74 4D B3 E9 5F 3D 83 BC 4F BA 2E C5 AB AF 
E7 1C F5 6D B7 D2 D2 7F FD 65 B0 EE AB B0 74 62 FE 2B 1D DA 19 4E DB 46 
9D 7A 2B F3 A6 36 74 AE 12 0E E3 2E EB 7B 17 26 95 0A 9D A1 95 F8 D5 8A 
A3 BF FF 00 E4 61 D4 EE C7 B2 EE 56 A5 5F 39 56 E7 56 22 9B FC A9 8D 9F 
5D 71 A0 76 0A 9D D8 F6 7A 2B FD 67 35 4F DE AC 3F BB 2E 87 75 DD 9B 71 
5A B1 F9 9A 7C BF A5 A7 FA 06 CF AE B8 E8 3B 1C BB AE EC D7 EC E3 B3 5B 
7B D5 A7 BF F5 09 21 DD 5F 66 A4 AE F1 D9 AA 5C FF 00 A5 A7 FA 06 CE 95 
C6 01 DA FF 00 C9 3F 66 9C B6 C7 66 A9 6F CD 5A 7F A0 3E E9 FB 37 19 C5 
7C 66 6F 25 D5 2A D4 EE FD 97 90 6C FA EB 8A 03 B2 D4 EE C7 B2 EE 56 A5 
5F 39 56 E7 56 22 9B FC A9 91 54 EE C7 B3 D1 5F EB 39 AA 7E F5 61 FD D8 
D9 F5 D7 1F 07 62 87 75 DD 9B 71 5A B1 F9 9A 7C BF A5 A7 FA 0A CB BA EE 
CD 7E CE 3B 35 B7 BD 5A 7B FF 00 50 6C E9 5C 70 1D 9E 1D D5 F6 6A 4A EF 
1D 9A A5 CF FA 5A 7F A0 93 FC 93 F6 69 CB 6C 76 6A 96 FC D5 A7 FA 06 CF 
AE B8 A0 3B 54 FB A7 EC DC 64 92 C6 E6 BE FF 00 4B 4F F4 14 97 75 1D 9C 
53 B2 C6 66 B6 F4 F1 69 FE 81 B3 A5 71 60 76 A7 DD 3F 66 93 D2 F1 F9 AA 
77 E3 C4 87 E8 11 EE 9F B3 4F 77 8F CD 6D 7F FC 5A 7F A0 6D 3A 57 15 07 
6C 5D D2 F6 69 FF 00 FC EC D5 FA AF 16 9F E8 29 FE 49 BB 37 E2 24 F1 F9 
A2 4F D6 B5 3B FF 00 C0 36 BD 2B 8A 03 B6 3E E9 FB 30 A9 EA 79 86 6B 7F 
45 52 9F E8 2E 7D D2 F6 5D 2B BC 76 71 F6 54 A7 F7 7D 41 B4 E9 5C 44 1D 
BA 3D D4 76 51 D3 6F E3 73 AB AF F6 D4 92 FF 00 80 B1 F7 53 D9 96 F6 C5 
67 29 75 6E B5 3F EE CA BD 2B 8A 03 B6 AE E9 BB 31 7F 36 3B 37 B5 AE AD 
56 9E FF 00 D4 12 EE 9B B3 2B 8C 5E 70 EF C7 D3 53 FE EC 9B 3A 57 12 07 
6D 8F 74 7D 9D 92 FF 00 5B CD D7 FE 6D 3F EE CB A1 DD 0F 67 A4 DA 58 AC 
DD DB FD B5 3F D0 36 9D 2B 88 03 B9 52 EE 7B B3 D5 15 FE 37 36 8C 7D 5D 
5A 7F A0 91 77 35 D9 CB 7F F9 1C D6 4F D1 54 A7 FA 06 D7 A5 70 90 77 48 
77 3B D9 A6 E5 AB 31 CD 52 4F 6F A5 A7 FA 0B D7 73 5D 99 71 BF F3 9E 69 
FF 00 BB 4F F4 0D 9D 2B 84 03 BB 4B B9 BE CC 46 37 79 9E 6B ED F4 94 F7 
FE A1 1B EE 7B B3 6A 1A 9E 3F 34 8A F7 AD 4F 7F EA 0D 9D 2B 86 83 B8 D2 
EE 7F 20 A9 26 A1 89 CE 6A 5B 7B C2 A5 37 65 FF 00 B6 5B 2E E8 BB 39 17 
BE 37 36 5E DE 2D 3B FF 00 C0 37 0F AE B8 80 3B B5 1E E6 FB 35 59 2D 18 
CC E2 FC DF C6 A6 D5 BE 5E 19 9F 4B B9 0E C9 59 3A B9 9E 71 6F E8 D7 A5 
FD D8 ED 0F AE BE 7A 07 D1 D2 EE 37 B1 0D C7 4E 6B 9E C7 6B CB 55 7A 5F 
DD 05 DC 7F 61 22 DF 89 9C 67 CD 2F DD AB 49 7F F5 8E D0 E9 5F 38 83 E8 
7A BD CC F6 02 9D DB CC FB 44 D2 F4 AD 4B FB A3 0A 7D D1 76 25 3B C7 31 
CF B4 DE D7 F1 69 5F FE 58 D9 D2 B8 28 3B B4 3B A6 EC 44 25 AB 11 98 E7 
CE 95 F6 70 AB 49 37 F7 D3 23 AB DD 7F 61 5D FC 0A DD A3 6B FA 58 AA 3F 
DD 0D 9D 2B 86 83 B4 62 7B AF EC AC 24 E9 C2 AE 77 09 ED 6D 78 9A 4D 7F 
CB 21 97 75 FD 9E 4A FF 00 11 9B 2F 77 56 16 FF 00 96 36 7D 75 C7 41 D8 
29 77 61 D9 C9 45 B9 63 73 35 7E 3E 96 9F E8 24 97 75 DD 9A 4B 6C 7E 68 
DF 57 E2 D3 B7 FC 03 67 4A E3 60 EC B4 FB AC EC DC B9 C7 66 BF FB B4 FF 
00 41 2F F9 28 EC D3 8A D3 8E CD 6F 6B BB D5 A7 FA 06 CF AE B8 A8 3B 5D 
4E E9 BB 37 18 ED 8E CD 5B FF 00 F6 D3 FD 05 B2 EE A3 B3 8A 29 AC 66 6B 
EF F4 B4 FF 00 40 D9 D2 B8 B0 3B 53 EE A3 B3 49 27 2C 76 6B 1B AD BE 92 
9F E8 0B BA 7E CD B6 FF 00 CF F3 4D 97 3E 2D 3F D0 36 9D 2B 8A 83 B6 2E 
E9 BB 34 DD 96 3F 35 FF 00 DD A7 FA 0A 4F BA 6E CE 25 75 8E CD 57 AD EA 
D3 FD 03 67 4A E2 80 ED AB BA 5E CC DD DF 30 CD 52 B6 DF 4B 4F F4 08 77 
4D D9 87 1D 4F 1D 9B DA FF 00 F8 94 F6 F7 FA 83 67 4A E2 40 ED D0 EE A3 
B2 9A 9A 96 37 3A 7E 96 AB 4D 7F F0 2D 97 75 3D 98 BD A1 8A CE 5F A3 F1 
A9 FF 00 76 55 E9 5C 4C 1D B1 77 4D D9 96 93 F8 EC DA DD 7E 96 9E DF D4 
2E 97 74 DD 98 5B AC 66 71 25 FF 00 EE A7 FD D8 D9 D2 B8 88 3B 6C 7B A5 
EC E4 9B B6 2B 38 5F 3A B4 FF 00 BB 2B FE 48 BB 3B AA DF 17 9B BF FC DA 
7F A0 9B 4E 95 C4 41 DC 63 DC FF 00 67 A5 37 15 8B CD 93 5F ED A9 BF FE 
04 8B B9 AE CE 5D DF 32 CD 2D E8 AA 53 7F FC 06 D7 A5 70 A0 77 47 DC E7 
66 D5 55 17 98 66 A9 75 BD 5A 7F A0 BE 3D CD F6 66 57 B6 67 9A 2B 7A D6 
A7 FD D8 D9 D2 B8 40 3B BA EE 6B B3 36 BB CC F3 5B 75 FA 4A 7B 7F 50 8D 
77 3B D9 B7 7B 66 19 AE 95 FB 4E B5 3F D0 36 74 AE 18 0E DE BB A1 EC EB 
A8 A3 0C 66 6F 51 BE 14 2A D3 6E FF 00 FA 0A D5 EE 7F B3 D4 DD A7 8B CD 
E0 D7 49 54 A6 9F FC B1 B8 7D 75 C3 C1 DC 69 77 47 D9 66 BC D8 DC E1 B5 
E9 5E 9A FF 00 EB 22 C4 77 3F 90 4E 0F E1 73 5C CA 94 93 FF 00 BD D1 3D 
BE C4 87 68 7D 75 C4 C1 DB 68 77 39 91 DF 4D 6C E3 31 93 7D 61 08 2F CE 
E4 35 FB 96 C0 BA 8F C1 ED 06 22 10 F4 A9 86 4D FE 0C 6E 1F 5D 71 80 76 
0A DD CB 53 82 7A 3B 4B 19 FA 35 85 76 FB 7C C6 04 BB 9B CC 94 9C 96 75 
83 74 FD 74 4A EF EC 1B 87 4C 9C B8 1D 87 0D DD 1E 58 A0 96 27 34 C6 B9 
2F AC E1 18 A5 F6 5D 17 4B BA 6C 97 5B 51 CC 73 27 1F 5B 42 FF 00 90 DC 
3A 57 1C 07 62 5D D3 E4 CF 8C CB 30 7B FF 00 43 F4 92 2E E8 F2 46 AF FC 
E7 98 7C D6 8D BF AA 36 74 AE 32 0E D0 FB A3 C8 AC AD 99 E6 37 EA BC 9B 
7F 54 8D 77 4D 92 B6 D2 CC 73 17 B7 3E 4F D2 36 74 AE 36 0E CA FB A4 C9 
6D 78 E6 78 F7 FF 00 A3 FB 0A C7 BA 4C 8D BB 3C D3 30 4F D3 C9 FD 83 67 
4A E3 20 EC FF 00 E4 87 26 7F 57 34 C7 BB AF 48 7F 61 45 DD 1E 4B E2 68 
79 9E 61 F3 F2 7F 60 D9 D3 27 19 07 68 5D D0 65 1B FF 00 DA 59 82 5D 3E 
A7 F6 17 2E E7 F2 57 6F FB 4F 30 BF BE 8F D2 37 0E 95 C5 41 DB A3 DC F7 
67 E2 93 AB 9A 66 8D 6F F5 74 7E 92 C9 F7 43 90 C2 A2 BE 65 99 38 3F E9 
41 3F F8 46 CE 95 C5 01 DC A8 77 3B D9 BA 91 D5 2C D7 34 8A F6 70 7F FC 
48 31 9D D1 76 7A 37 8E 1B 34 CD 2F D1 C9 41 AF C9 0D C3 EB AE 28 0E B5 
5F BA 2C 2C 7F D1 67 B5 DF AA 78 54 FF 00 1D 45 F5 3B A6 CB 55 2D 30 CD 
71 7E 35 B6 72 A7 15 1B FC BD 06 CE 95 D8 A7 89 87 86 E3 6F 33 EB D5 18 
18 9A 97 D5 E7 5F 71 81 F1 0E 6E 53 72 9B F7 2C 9D 58 5A CE AC DF 56 91 
26 9B B4 BE B5 65 A2 F1 5B DB 6B EE 45 27 27 E6 9C 14 AF C3 F7 29 78 3F 
AB 37 1B F4 B0 9C 5A 83 72 9B 9A B6 CD 2E 09 69 A5 AE 70 52 51 A6 9C 64 
93 4E CE D7 2E 73 5A 6F 67 2B F4 23 8C 69 EB D5 AA CD 3F DA 7C 92 A9 6B 
5A 6F 4F 6F 4F CC BB DC 2A C9 27 29 36 DC 52 F4 E5 08 53 49 26 93 95 B7 
7B 97 C2 51 50 FA D7 F6 6C BE E9 C5 AF 2A B6 D6 4F 91 2F 81 49 52 93 FA 
8B 69 2E 6D C1 45 4E F3 94 A7 2B 74 F9 94 F1 EB 6D 08 EC BD 51 46 A3 6D 
A5 BB FD E0 89 52 D3 27 79 37 B6 D7 64 4E A4 A3 E5 8E A9 5B 6D 41 45 B6 
A2 E7 A9 7A 2D 89 E4 96 99 59 F1 7B B6 15 03 9A D3 7B 39 5F A1 6C 93 94 
9B 6E 29 7A 72 8B D4 B5 AD 37 A7 B7 A7 E6 21 28 A8 7D 6B FB 36 3F 51 64 
29 A4 93 49 CA DB BD C9 65 4A 4F EA 2D A4 B9 B7 05 6E 9C 5A F2 AB 6D 64 
F9 2C F1 EB 6D 08 EC BD 51 6F 91 55 4E F3 94 A7 2B 74 F9 97 A5 A6 4E F2 
6F 6D AE C8 9A 8D B6 96 EF F7 82 8B 6D 45 CF 52 F4 5B 12 2E CF 12 51 76 
8D E4 D6 CA 56 2E 53 9B 69 CE 4E CF D3 A1 33 8D EE A2 FA BB B6 8A 24 94 
9C 64 D5 D7 E5 EA 25 D2 2D 8D 59 CF 84 B6 8E EE DC 92 42 32 76 F2 C5 3F 
42 8D C5 B6 A1 52 5E AF 60 94 97 9A CD DD ED B9 36 A9 52 94 5A 8B B2 2C 
A9 39 A4 AC 94 7E 45 23 16 F7 BB 4F AF 52 BE 13 B7 89 AA 4E FF 00 56 C5 
86 D6 A9 37 A6 2E 56 B1 74 1B DA F2 6D FA 14 50 7A 93 8A D4 DF 2D F4 24 
4E 7A 5A D3 06 FA B6 C9 B1 46 A9 D9 3B E9 5F 22 C8 CE 29 DB 54 BD DD CB 
DE A5 05 2B 45 F4 57 68 8B 43 E9 1D F9 E9 62 89 95 68 3A 7A 74 B7 3F 59 
3F E0 65 60 F1 74 A3 68 D5 A4 AD EB 05 BA F7 DC D6 D3 A9 67 B2 DF D5 A2 
69 49 A8 E8 D1 1E 37 F5 20 DE D3 74 2B D5 8A A1 27 3A 7D 5D AC D2 F7 2E 
8C 68 41 CE 73 A8 A2 93 E3 A9 A0 8D 5A 91 71 71 8C B5 37 6D 9D 9B 32 68 
E3 68 46 3B D3 52 BB DE EF FC 7A 0D 58 8D 8C F1 54 1C B4 D3 BB 4B 8F 97 
B9 14 29 4E B5 BC F6 6F 7B 70 47 07 87 AE D7 87 17 09 BE A9 75 2B 18 55 
D4 A3 E3 4B 6B 59 3E 05 F4 18 8C 13 A1 1D 53 AB 79 3D D2 4C 8E 2A B2 A4 
E4 B7 4B AB D8 C8 74 9C 24 9C EA 78 8E FD 5F 3F 69 63 95 7A 95 25 18 C6 
5A 1C 93 71 4E E8 41 83 57 C4 7E 5B 2F 9D C8 F4 D4 8F D7 8C D4 BD F8 32 
EB D0 A9 7D 56 94 52 7E 9B 18 B3 95 47 1B 37 74 92 E4 B4 4F 47 13 8A A3 
42 6E 9D 77 04 F9 4A 56 6C 42 B4 A6 93 93 DB F1 66 2D DB B6 AD D9 74 25 
67 6B 25 62 45 6C E9 49 47 87 B9 37 8F 24 B6 97 BF 26 B6 33 D8 A4 EB 35 
D7 FA C1 1B 45 89 A9 AA FA 9B BF B8 58 A8 C5 DE A2 BB DB 66 69 A5 8A 71 
BB E6 DC AD 4C 86 58 B7 56 4B CF 29 25 D3 A5 82 E9 B3 C4 54 4D FD 6D BD 
FD 2E 6B AA 55 49 C9 72 EF 7B F4 22 95 68 EE DD 59 A6 F6 B5 88 DC A9 BD 
D4 A5 17 C5 DF 25 0D 73 9A D4 E2 9C 57 4E 12 45 B3 9D 38 C5 A7 0D 33 6E 
E9 FA 17 A8 C9 EE AA 6A 57 BB 8D 88 5C 61 2B 5D C9 73 67 22 6C D2 65 53 
96 DB 6D 7B DE E5 B2 72 92 5A 6D 15 E9 7B 97 46 6B EA 27 4D DF 6F 56 23 
A5 4D A7 2B 3F 45 C3 2D 45 8A 92 77 B6 EE FD 2D 62 58 D3 6E 29 C6 36 6B 
66 84 24 9E C9 41 27 BD EE 5B E3 54 A7 78 C1 75 DB A9 6F 90 74 A7 78 C6 
52 E3 7F FA 12 69 4A CD 4D B8 DD DC 8F 69 2D 55 26 F5 AE 6F FE 37 2D D2 
D2 DA A2 57 BD D2 56 24 5D AF A9 37 19 3B 37 2B EF 6F 42 9E 25 59 6E DB 
B2 E8 89 A1 14 A2 92 E6 D7 57 E8 1A D3 6D 72 4D 0D E9 16 46 AC BE A4 7C 
DE 6E 5A 24 8A 94 B5 6A 8A F9 BE A1 B8 26 92 9B 52 E3 65 C0 51 93 DE EE 
56 5B EE 4D AC 49 A6 71 5A 9A 4A FD 50 A9 29 28 BB 45 7B BE 0B 12 72 7C 
B4 FA 6E 57 C2 73 57 D6 ED 15 BD 8B 0D AC D7 26 A5 77 CF 2C BA 10 A9 29 
AB 55 DA FD 78 26 C2 D1 55 6B 5A 52 B5 B8 D5 C1 91 89 C3 69 BB 4E 2D BE 
B1 61 18 B2 A4 D4 B4 BB 6E F9 89 26 1B 0D AD DD 56 6A D6 6D 69 E0 8A A5 
29 29 38 B6 EE B9 DF 84 5F 86 AA E9 4F 52 6A 37 76 DF 83 1A AD 85 3C 15 
24 FE B5 5A A9 F1 BD 91 9D 86 CB E0 9A 5E 12 57 EA FA 9A A8 66 2E 2A D7 
8D F9 DB 62 79 66 98 97 69 52 95 BD 1A 7C 97 F1 19 F8 CC 3C 68 A5 18 5E 
52 7D 34 96 4A 95 25 56 2A 52 51 56 BD D9 A9 AF 8F AD 56 4E 75 71 13 53 
4A C9 2F C8 B2 96 32 94 5B 72 5A 9A 5D 65 7F F1 C1 3C 8D A5 5C 4E 1A 3E 
4A 72 72 6F 96 BD 48 65 AA B4 9D A5 A5 71 C1 0C 6B E1 6B 27 7A 5A 65 EC 
B8 2F 95 29 C1 E9 55 A6 A2 DF B7 A1 7F 05 F5 70 12 51 75 6A 56 4A 3D 2C 
F7 66 3D 28 55 72 6A 17 7E CC C8 74 67 A5 4A A5 66 D5 B8 E9 62 95 27 55 
4A 31 A5 17 1F 2D B6 97 3E E2 0C 3A B2 AB BD D2 6D DF 86 C8 1C 2A 27 79 
46 7A 7A 35 C1 9D 5A 85 49 46 DA 25 1D 95 DA 46 24 9D 58 BD 09 DF 7E 1F 
05 B4 5F 84 AB 5E 9C F5 52 AB E1 B8 F0 D3 B3 FB 03 C5 56 9E B9 4E 7A E5 
77 79 37 76 63 A9 49 C6 CD A6 BD 2D B1 57 A5 AB 38 C6 CF A9 22 A6 55 20 
DD 9E A7 E8 48 94 1B 77 B3 6F 6D F8 46 1C 67 E5 77 D9 D8 91 49 B5 B4 96 
C9 EF D5 FB 05 8C B5 35 4A 56 BB F7 DC 55 C4 42 A3 5A 25 2D 3D 55 CC 49 
C9 7D 5E 96 BB B1 66 AB 43 8B 7B 58 51 92 E7 15 78 DD AF 41 34 E7 1B 26 
92 BF 3D 4C 68 D4 A8 DB BA 4D 27 C3 5D 09 21 CB E7 D3 D8 A8 B1 D3 9A 95 
EC DB FC C4 75 5B 6D 5B 73 63 22 8C 9C 14 BC 58 F2 BD 6D 62 B0 51 4E 4E 
29 73 7F 62 78 18 AB 5E B6 D4 64 D7 C8 BA 11 9F 0E 94 D5 FD 17 26 67 99 
4F CD A6 DC F2 23 38 DA EA 32 E3 D0 6C DB 1A 50 A9 6D 2A 0F 9F 4E 84 7A 
67 AD AD 0E F6 BA 49 3D 8C B8 CF 5B D6 ED 6B 5D 7B 91 3A B6 9C A5 6D AF 
6B DC 08 E3 85 C4 4A 4B E8 E7 66 BD 0B D5 1A CA 56 9C 1F BD EE 65 51 C4 
47 4C 9B AF 28 AD 36 56 85 CB 1E 2E AA 5A 54 9B 56 E7 81 B1 65 2A 55 14 
95 58 A6 EC EF 6D 3C 17 79 A7 3D 52 8B 4F AE C4 7E 33 D5 74 F7 BF 09 97 
46 A4 E3 06 E7 3B FC 90 D2 D5 F3 8B 49 4A 4E 49 A7 C5 BA 17 45 CE 57 D3 
14 D2 4B 72 35 28 EC AE DD FD 4A BA 89 A6 D3 D2 96 CB E7 EA 2C 42 3A E7 
51 DD 3B 5F A2 E4 8B 16 E6 A4 E2 E2 9D BA A7 B7 E0 5F E2 69 DB 4B BB F4 
EA 13 F1 25 A6 73 D2 BD 5A B9 28 86 84 A4 EA 45 DB DD A4 2B D3 9B 93 DE 
4F D1 7A 19 49 53 8C 34 A7 7B BE 6D B1 74 29 24 FC 49 CD 28 FB 7C C0 C1 
8C 66 9F 96 2F 6F 44 62 E6 F8 CA 39 66 5D 57 1F 8E A9 2A 38 7A 36 73 9C 
97 09 B4 97 DE DA 46 F5 AA 6A 3A 62 EE BD 5E C7 8F EF 7E 71 7D DB E6 E9 
41 AF F4 2A F7 FF 00 6D 02 C2 F8 8D 87 C6 C7 5D DC 68 36 BE 5B 92 47 1F 
46 51 D2 E3 05 7E AB FB 4C 49 51 8C 1B 6E 84 1E F7 BB 89 44 A9 A7 75 4A 
0E DB F1 D4 B4 DB 32 18 8A 33 92 8C A4 AD 7E 2F D0 96 A6 26 84 2A 69 58 
87 CD D2 B5 CD 6C DD 2B AB D1 A6 ED B2 4E 25 55 3A 33 77 54 69 34 F6 7E 
72 E9 19 F2 C7 50 77 8D 45 19 AB AF AC BF 22 C7 8B C2 29 E9 8D 24 D5 9D 
97 AA BD CC 37 84 A6 D5 E3 87 5B 73 79 5D 17 7C 2D 07 6B 61 EA 47 6E 6E 
48 32 E5 52 12 83 93 A0 E1 B6 D7 5B 11 C2 BE 19 C9 5D 59 71 F5 4C 7F 86 
9E 87 18 C6 B4 93 F5 65 3E 15 AD 9D 0A 8E CF 84 D9 46 7F 8F 83 4F CD 1F 
25 B7 49 17 78 D8 79 ED 19 45 27 BA 56 BB 35 EB 0C 92 BF 83 5E 17 7B 6E 
5E F0 AE 56 6D D4 4D 70 94 96 C2 C1 99 5A BD 24 F9 8A 95 F8 B7 04 6B 15 
45 4A F3 8C 1F AA 6B A1 14 F0 D3 9C 14 7C 4A D2 8A 7B 45 B4 D1 14 B0 B1 
57 BC 64 41 96 F1 58 55 2B 46 8D D6 FB 7A EF 71 2A 90 94 1C 9D 07 0D B6 
BA D8 C4 54 12 FA B1 9A FB 4A 2C 3C DC 64 A3 1A B2 4F 7E 6C 8A 32 21 5F 
0C E4 AE AC B8 FA A4 DE 3E 0D 3F 34 7C 96 DD 24 60 7C 2B 5B 3A 15 1D 9F 
09 B2 B1 C3 C7 FF 00 06 B4 1B E9 71 26 C6 C3 C6 C3 CF 68 CA 29 3D D2 B5 
D9 4A B5 A9 27 CC 54 B5 71 6E 0C 27 86 72 6A FE 2A 6B 8B 34 49 2A 12 A9 
49 25 5A BE 95 7B 45 D9 A2 0C 8A 75 A1 AA EE 34 DD FA 4A C5 67 65 59 B8 
CA 8C BA F9 4C 3F 83 6F 8A 92 B2 DF 65 C1 6F C1 2D 7E 6A 92 6B 94 AC 5B 
A1 94 E5 29 C9 D3 A7 18 3B 2E AC 8E 53 7A 9C 9E CD 3B 5B D4 B6 18 4A 6D 
3B D5 9A DB A4 6E 5D F0 31 92 BA C5 CD 5F D6 3C 0D 40 58 94 F7 AB 09 B5 
D2 DB 32 AB 12 92 B2 73 5B EF BE E5 EF 2F 93 76 A5 8F BD B7 B3 A7 62 DF 
E6 CA EB 75 8C 82 96 D6 4D 74 31 12 D3 CC 6A 41 EA 85 57 69 2E 1A 2F A9 
8C BC 15 4F F3 77 25 CA 4A C6 14 F0 18 97 3B 2A B4 E5 EA D2 2B 0C BE A6 
FE 2E 22 9C 77 E5 C1 B5 6F B1 14 66 53 C5 A4 D2 B4 1A 7F 81 75 4A B4 E1 
2B 4E 4B D9 2D DF DE 61 3C 2C A0 9C 7C 4A 53 6B 87 A5 94 58 29 CA 4F 54 
A9 C5 2E 96 68 9A 19 D5 AB E1 54 14 29 54 D3 27 B7 9A DF 81 4C 35 2A 6D 
37 2C C2 84 1A 57 51 95 F7 F4 E0 C5 58 29 2D DB A5 C6 C9 B2 E5 86 8A 56 
72 A6 95 BF 65 31 60 9A 55 A7 4E 6D 28 C2 6F 87 67 B1 63 4A 7E 65 4D A4 
DD 95 92 D8 8D E1 A1 B5 A6 B5 DA FC 17 42 8C DD 97 8D A7 D1 14 49 0F 16 
0E E9 3F 5F 99 33 C4 62 14 13 5D 57 A1 0A C2 D5 B3 5E 2C 5A 6F 9B 6E 27 
46 71 95 9D 5B DB 6D A3 76 48 25 59 8E 22 11 D2 D6 CF 7E 38 2B 1C CB 11 
06 AA 42 A6 9B 2E 52 22 58 7A D2 DA 13 AB 37 D1 46 9B 2D 6F 13 0B AA BA 
D2 8E D6 D3 67 F7 14 64 CF 1F 88 71 B5 DF BB F5 2C 96 29 D4 49 78 5B A5 
B3 5D 0C 49 54 B3 BC 6A C9 27 D5 F2 4D 41 CA 71 92 75 29 AB EC 93 95 AE 
05 F3 93 71 BD A5 7E A8 8A 4E CF DB E4 EE 5D 51 AB F9 6A 42 2B E5 D7 EF 
20 F8 8C 54 BC BE 3A 94 7F DC 16 0C 88 56 DB 72 B2 AD 1B 74 FB 48 15 19 
B4 F5 68 6D EF C1 49 45 EF E5 8F 04 12 2C 64 21 2B B8 42 6B D1 F0 45 53 
19 06 FE AE 1F 4D FD 56 C5 25 6D 96 95 67 F9 11 54 A2 B5 6A 95 08 3D AD 
65 1D 8B 22 ED 93 0C C2 9A 7E 68 53 BA F4 E9 EE 53 E2 A8 FE F2 51 B7 46 
61 DA 0F FE EA 1A BD 12 2B 27 4D AB 3A 50 B7 CB EE 11 1B 19 D7 C3 D3 A7 
1F A6 70 BA B3 B6 FB F5 2D F8 EA 71 69 39 29 26 BA C7 63 5E A3 46 69 35 
46 92 6B A6 AB 15 78 5A 52 BE 9C 3C 6E F7 DA 77 42 C8 6D 99 2C 5E 0E 29 
38 D3 8A 7B 5E DD 1E FF 00 DA 5C AB 53 9B F2 E1 A4 A2 9F 29 18 4B 0B 47 
4D 9E 1A 4E 5E B1 7B 15 8E 1B 4C BE 8E 35 AD E8 99 44 D2 AF 41 37 19 2B 
3E BE 52 65 5F 0A A2 AC 97 4D ED B9 83 F0 B2 5C D2 A9 BD F8 77 29 E0 41 
3D E9 D5 83 4B D4 41 B2 55 F0 AD 7D 1D A2 AF 6F 37 37 13 AB 4A 30 B3 6A 
C9 59 5D 73 C9 AD F0 9A 56 BB 92 2E 8F 8A A2 E0 AA 4D 27 CA 4C 59 A1 98 
AB 41 B5 75 16 97 56 5F 59 C2 71 8C D3 A0 AE AD A5 72 60 53 C3 6A 56 55 
1A 7E 96 2B 3C 13 B2 BD 59 FA 3B A0 32 EA 4D A6 A2 94 1C 9B DE E4 75 75 
A9 68 9A D3 B5 EE 9D D7 E0 47 1C 25 34 EC EA 49 59 F4 8D D9 7A C1 53 77 
B6 26 6A DD 1C 50 92 50 F8 89 7D 57 16 E2 9E F6 2A B1 50 4D B8 29 C5 5B 
64 D9 74 72 FB 45 28 63 DC 64 F6 F3 53 FE 21 E5 95 EF 77 8C 84 52 EA D7 
2C C4 56 18 D7 18 AD 35 26 B4 F4 7B DC 92 18 A6 DC A6 EA D3 D4 96 D7 6D 
18 B5 30 18 94 AD E3 D2 9B F9 14 8E 5F 5F 52 D7 5A 29 5B F7 5B B3 2F A1 
97 1C 67 ED 5A 9B DF 74 4B 3A D1 D2 A7 29 46 31 92 F5 B9 85 F0 6E 9B 5F 
4F 46 A4 5F F4 24 5B F0 95 26 D6 F4 92 7E 89 AB 93 42 5A DF 0F 2F 3F 89 
18 5D 3B 92 61 A1 07 25 7C 75 2A 2B A3 7C 7E 04 0B 03 25 FB 54 EC 9E F7 
65 D1 C2 A5 CB A4 B7 E6 DB 8D 0C 8A D2 9D 1B C6 35 E8 E2 22 DD E2 D7 0F 
EF 23 DA 71 B7 82 A3 65 76 A2 8B 1E 1A 9E 9B B9 C5 EF 64 23 46 49 B5 E2 
E9 5D 58 82 45 19 A7 78 A7 6F C8 9E 15 EB A8 B6 AF B3 F4 B9 0C 70 D5 79 
55 A3 2D BA AF FA 89 61 EA 42 29 3A A9 DF 7B 58 09 23 8F C4 D2 BB B6 FC 
5A DC 95 59 85 76 9D 9A 4F E4 45 1A 15 1F D5 AB 3B 7A 46 9E E2 50 C6 52 
7A 64 A7 18 BD FC D1 B5 CA 32 5E 67 89 A8 9C A5 37 26 FA FA 16 7C 64 A5 
1D 13 A5 AF 53 F3 74 B9 89 52 A5 E5 75 39 A6 9E EA 45 D4 2A 49 CD 7D 2C 
6C BA B6 D0 13 EB 72 5E 65 2B F4 D8 89 BD BD 1F 5B A2 FA 96 8A B6 BA 7A 
BA DB 7D BE F2 19 62 71 18 69 A7 43 17 17 C5 D6 9D BF 11 60 AC 14 63 2B 
DE 5B BB 7D 5D 89 1E 99 3F 22 D2 D7 D6 7A 79 31 A1 8A C5 54 A8 FC 4A B6 
DE E9 AA 77 F5 13 A9 8A D7 A1 54 94 6D BF 9A 3B BF 7E 04 83 2A 31 A6 E7 
66 E7 27 F9 99 14 E8 D2 D6 AE A7 15 EF F9 9A CF 12 BE BF 34 B4 6D B3 BB 
23 95 4A B1 8A 93 72 BB 56 8D B9 7F 21 AD 8D EB 85 08 6A 74 EA EC FA 34 
56 12 C2 A5 A7 43 BF B7 0C F3 F1 C4 62 A0 D4 67 76 9E F6 6C 9A 18 B8 C2 
9D E3 4E A3 7F 35 C8 D0 DE 3A D8 2B 46 5A 64 E4 B6 B7 05 D1 54 27 2F A3 
84 D7 BA 6A DF 99 E7 21 8E 71 4A 2D 2B 73 6B 17 CF 15 53 52 97 86 92 FE 
8F FD 07 55 DB 6F 59 BA 6F EB 4B 7D 93 71 FE 23 C5 84 1A 75 6A 6A F6 35 
3F CE B5 E3 4E D6 D3 15 C2 72 6E C4 70 CC 53 BB 94 13 F5 DF 91 22 37 B8 
7C 6C 29 4E 55 70 F3 8C 65 A7 46 F0 4E E9 90 45 53 73 DE 69 5F 7B DB 83 
57 1C 55 2B 5E 29 C1 BF 56 B9 2F F8 CA 51 49 55 6E 4D F1 7D BF 20 BB 6D 
5D 3A 0E 2E 32 C4 25 F2 E0 BF 4E 0F 4A 51 A9 2F B1 1A 98 E6 38 3B 2F A3 
93 B2 E8 52 A6 32 9C 52 54 A2 FD 75 5A CD 7E 24 83 65 38 D0 72 7A 6A 35 
2E 6F 7E 0A 28 49 2B EA 53 57 DD C5 70 6B E9 62 3C 47 14 E9 39 3E 8D 4A 
D6 36 B8 7A 53 F0 5C 9E 21 45 7B 6F 6F B4 A7 B4 17 D9 35 25 25 D2 DC 89 
F8 B2 92 A7 A1 B5 EA 65 E1 70 B4 AB 29 78 98 A8 AD F6 5A 4C 99 E5 D4 63 
04 96 36 32 95 B7 B3 B5 89 EC DB 56 A9 57 F6 69 7A BD CB A3 4F 53 6D 4A 
37 BE EA ED FD 86 C6 59 44 94 75 CB 1B 46 31 BE D7 8E A7 6F 5D 99 1B CB 
94 A9 25 47 1D 4A 75 2F F5 3E 1E 4B F1 B8 A8 A4 65 4E 9A 8B 92 C3 CD DB 
8B BD 88 2A 2A D5 5D E1 06 D3 FD DE 82 58 5C 5D 29 6A 92 A5 FE EC 9D 85 
7A 55 E3 07 27 89 A6 EF D1 4D 31 D4 4D 43 0D 37 16 E5 38 43 6D F5 A3 CA 
77 C7 AA 3D DC 66 91 75 35 FF 00 A1 5F 56 DF F7 D0 37 F0 8C EE 94 EB B8 
DB 97 A5 5B EF 3C E7 7B B8 65 1E ED B3 4A CF 12 AA 35 E0 F9 54 93 FF 00 
BE 80 D7 94 CB D3 7A A9 37 2B 28 DD F3 64 5F 1A 5A 2F AA 1A 6E B9 92 6C 
C0 9E 22 A4 BE A6 B4 FE CB 15 F1 AA CA 3E 69 54 E9 6B 6C 93 2A B2 6A 53 
96 AD A0 9B E7 7E AB 72 F5 42 8B 84 7C 91 D4 DE FB 23 02 6E A4 62 BC D2 
5B 5F EB 5C BA 35 2A C5 5A ED DB 76 EF CF B0 19 D0 C2 D0 8B 97 D1 B6 DA 
BD 8A CA 85 1B BF 2A 51 E2 D1 66 2C 6B E2 52 72 71 8D 92 DB 82 AE A5 79 
2B BD 2E CF 7D F6 64 F2 32 1D 2A 31 57 8C E7 65 CA D5 72 B0 71 8B 52 8D 
59 35 F3 D8 C5 75 6A A8 DB 98 DB 87 D0 BA 93 8B 69 4E 3E 5E 7D CB E7 F4 
65 CE 70 5B B9 5F 6D DD CC 6A B5 E8 C9 34 E4 D5 B9 56 76 25 F0 30 32 7E 
47 35 7E 6F 22 E8 E1 30 EF CB AA 76 BF A9 20 86 8D 7A 11 8C E1 19 3D 2D 
59 B7 B9 34 6A 42 D1 6A 49 70 1E 03 0E 93 B4 A5 FF 00 A8 C6 AF 83 8C 65 
AA 13 6E CA F6 D5 D4 B4 65 54 F0 E4 ED 26 9F AB BE FF 00 81 63 A7 4D 2B 
EB 9B B7 36 66 14 21 38 F9 92 4F D6 F2 24 75 6B 28 DB 98 DB 86 4F 3F 82 
79 CA 9C 20 E6 AA D5 6A DF B2 D9 1C 71 0B 56 CE A3 BB E5 CA E5 29 E9 93 
5A 95 97 24 B3 A3 85 84 94 AF 0B 5E EE D2 65 11 4E B5 65 25 BC BE 48 8E 
52 C4 69 BD E7 25 F9 1B 4A 71 A2 EC B4 29 2F 99 35 3A 14 5C DC 53 8A 8B 
FE 9F 08 90 69 56 22 AD 38 BD 2F C9 EA 96 E4 D8 7A B5 2A DF CD F5 57 CA 
F7 36 92 C1 2A 4E F1 B3 8B 5B 69 9A 64 3F 0E DB 6A 2D AB F3 7B 14 62 C6 
A3 8A D1 E2 73 BD DE FF 00 91 2C 31 50 8C 1E A9 42 5D 3D CB E5 87 9D 9A 
D7 08 AF 48 CA DF C0 8E A6 0B F6 A5 04 DD F9 6D 93 42 B5 B1 70 4D BF 0A 
31 DB 8E 3F C7 04 4F 1F 18 D9 F8 5C F5 BF 04 8B 04 ED 6B B4 9D FF 00 32 
F8 65 73 4D 35 14 D3 E5 5F EF 10 40 B3 26 B7 D0 B7 76 BA 2F F8 8D 4A EE 
2D 5B 7E 4A CF 2D 4B 68 D3 8B DE D6 52 DD 90 62 32 F7 46 2B 55 2A 91 72 
EB 19 27 F9 17 C0 C9 55 21 14 92 84 67 6F E9 16 D5 C4 6F 1F 2C 52 4B 74 
9D FE CB 9A C9 D0 82 9E DE 2A 6B FC 58 3C 3D 59 B7 18 45 BF 6B 96 0C D9 
E2 68 CA EF 4B 4B 87 BF 25 D4 71 91 85 92 F2 3B 5B DA C4 98 1E CE D6 AB 
15 2C 4E 22 95 18 4B A6 AB C9 FD 87 A0 CB 72 3C 83 0C D7 C5 45 E2 9A 56 
F3 49 DB EE 46 3B 1A 0F 88 C2 B9 A4 A4 A5 75 BB B9 95 4D 60 65 45 D4 D7 
15 27 B6 87 1D FE 77 33 B3 6C 9B 25 AC DC B0 31 96 1E 4F A2 DE 2B EF 30 
32 EC 8A 9C AB B8 D7 C4 5E 0B F7 5D BF 83 1B 83 19 BC 2B A8 93 F1 37 56 
B5 FA 97 C9 50 8C AF AA 51 4B F7 67 BF DC 7A 4C 56 49 94 46 8C 7C 2A 50 
93 4B EB 3A 92 BB E0 C0 A5 90 E1 27 29 56 A3 5E 54 ED 64 A1 29 5F F1 62 
51 83 46 B4 A1 14 E9 63 B1 34 E2 D7 EC CB 92 F5 85 A5 5D 3A B5 B1 B2 94 
B9 F3 3B B3 2A AE 54 D4 EF 57 7F 5F 32 DF EE 30 EA 61 6A C2 6D 43 0B AB 
FD D9 EE FE F1 B1 0C B2 D8 B9 2B 62 95 D7 F4 0B 23 94 CA ED BC 55 29 24 
EF E6 8B B1 74 D5 58 49 C7 E1 31 09 AD DE FC 15 A6 AB A9 B6 A9 D6 B7 5B 
49 2E 83 CC 0C 4E 57 29 D9 AA 98 5A 5E D1 83 5F 6F 24 70 C9 6B 27 65 8A 
A3 CE EF 73 27 C2 AE E4 E2 95 47 EB A9 A2 94 E9 57 B2 5A 25 75 B3 DC 9B 
11 7F 35 D6 8A 57 AF 4F 7D B6 22 9E 0E 71 FD B8 BE 86 6B C3 62 1F 30 97 
DE 43 57 0D 59 2D E0 F9 F5 E0 0C 29 52 94 5D F6 29 A5 BE 52 BF B1 5C 55 
3A B0 4F CB 6B 4B 7D CC 27 56 AC 65 67 7E 7A 33 29 B1 B0 8D 19 46 4A 4E 
9B D9 F5 57 45 B5 69 F9 6F 18 A6 B8 4E DB 70 61 C6 BD 56 AC E5 52 DB DE 
DD 4A 37 53 4B 95 E5 BB FD E0 33 69 D1 83 8C 9D 5A 71 53 4B 6E 0A AC 2D 
15 38 C9 D3 F4 D9 5C C0 A7 3A C9 5D 4A 4D BE 37 E0 96 9D 5C 43 B2 8C 56 
9F 56 D0 A3 31 E1 E8 EC A3 05 17 F3 DC A2 A1 41 2F 2C A6 9B E9 A8 C7 F1 
B1 13 4E FA 78 DA CF 8B 05 52 B4 77 5B 7A A4 F9 27 91 91 15 4D CB CB 56 
69 A7 C5 C9 55 07 28 ED 52 53 5C 79 BA 98 30 9B 6E EE 29 3B 9B 1A 78 8C 
3C 68 A5 BA 95 D6 E5 F2 21 9E 0F 7D 95 B7 2D F8 4B F2 8C BA 55 E3 38 A9 
46 49 A6 49 A9 3E 88 6C 61 2C 24 A3 BA 7F 71 7C E8 54 50 76 AD 7F 77 D0 
CC D1 29 2F 2F E6 43 3A 75 6F 66 DA 62 0C 3F 12 50 93 93 9B DF A7 36 24 
A7 88 50 95 A5 3A 72 B7 47 B7 E6 4A F0 D3 5C 4A 9C 6F D6 F6 64 73 C1 B9 
46 F2 5A D5 9E EE 44 15 78 BA 6E 11 6A 9C 6D 7D A5 6E 7F C5 88 7E 3A 29 
5D 51 4E DB 6C CB E3 83 EB 15 6E 36 57 2E 8E 59 29 79 A3 66 FE 7C FA 12 
08 96 63 BD E3 05 64 8B E3 8B F1 55 DC 5E FC EF B2 2F AB 96 A4 DB 70 8A 
95 AE EF 26 43 53 2D 94 20 EA 4A 84 92 4F F6 66 BF 23 2A 25 55 61 BC B4 
A6 DF 29 BB 15 9D 7B 42 CA 9C 20 EF EB 76 6B 2A E1 E0 AC 9A AC 9D EF B9 
6F 83 36 92 8E AE 36 6C B0 67 4F 13 4D BD 2E 2D C9 72 D3 2D A7 8A A7 06 
DA 8B 4A F7 D5 D4 65 F9 26 2F 12 D4 9C E9 D1 85 F7 72 9F 1F 62 37 D9 77 
67 72 8A 3A 65 8A AE F1 17 DF 4A 76 46 37 D8 D4 CB 15 87 94 54 A7 35 29 
DF AB 32 30 CF 05 56 4D CE 71 A7 A7 7B CA 37 4F DB 83 75 99 E5 5D 9C AD 
0B 61 F0 DE 04 D2 B2 70 93 DF EF 34 51 C8 A3 1C 4A 8F C4 5E 0F 7E 2C EC 
36 6D 66 21 E1 54 AD E7 49 3E 8E DB 15 70 C3 E9 56 BA 4F 7B EB 49 9E 92 
86 45 94 43 07 E6 8A AB 3E 5B 95 47 B7 DC 60 CB 22 C0 D6 AE A3 09 CB 0F 
28 EE DA 9E A4 C6 E0 D6 D0 A9 18 DE 54 71 55 E9 B5 6D D4 AD 62 6F 0D 62 
DD AB E6 15 64 97 FE 24 AE 66 55 CA 25 18 A5 A9 4A 0B 68 C9 49 18 98 8C 
14 A9 C9 78 74 23 34 B8 7A DA 6B EF 1B 10 56 CB E9 49 BD 38 A5 6F F7 48 
A5 94 CA 53 FF 00 5B 85 AD C6 92 4A B0 AD 4D F9 B0 75 D3 7C 59 96 5A B4 
9A 71 A5 59 35 7D AE 8B E8 49 2C B1 BA 0A 2A 78 45 6E 66 A0 EE FF 00 13 
19 E4 B5 13 BA C5 51 6D FB 6C 66 38 57 6E 2D 46 B5 E4 F8 72 4C 46 8D 75 
36 B4 3D F7 5B A3 1D 88 D6 41 8C 51 D7 46 B5 0D 29 6F 27 2B 5C 86 BE 57 
99 49 5D 4A 9C D2 DE EA 7C 1B 1F 87 C4 D3 85 EA A9 A4 DD 94 6F C8 A9 17 
E2 78 6A 35 20 D7 37 DF 61 BA 35 6F 2B CC 63 E6 9D 19 B4 BA C2 CD 90 4F 
05 88 57 95 4A 73 85 97 A3 EB C9 BD A7 5A 74 AA 34 A6 E4 ED 6B 58 96 9E 
26 A2 95 D4 E4 FE 65 D8 D1 42 9C 65 1D 35 29 5F D3 5B 4C 8E A6 12 83 56 
93 8C 6E AC AC 91 E8 9E 2A 12 8B 94 A9 41 B4 F7 F2 A6 D9 03 C5 E1 F5 A5 
28 51 6A 3C C5 A1 BA AF 3C F0 50 71 F2 38 B5 6B 2B D8 4F 2F 92 8A FA 48 
AE 9A 53 B1 E8 A7 8A C2 CA 4D C7 0D 41 2E 90 89 3E 1F 11 84 84 AF E0 D1 
57 7B DE 37 DC 76 47 91 9E 5D 36 AE B4 4B AF 24 51 C0 D4 D5 BC 15 FF 00 
03 DC BC 46 12 A2 94 61 4A 0D FB 6C 5B 0A 51 A8 B6 71 5F 60 99 68 78 99 
60 EA 39 3D 54 A2 9A B7 2A D6 11 C2 D4 6D 26 9B 57 E2 CB 63 D9 62 70 55 
5F 9D 28 CE EB A2 30 5D 1A 7B C6 54 AD F6 F0 5D 8F 38 F0 C9 4A FE 15 E4 
DF 4E 85 F4 E9 C5 27 7A 4D FD 9C 1B E5 4E 84 5D 94 3E CB 95 92 A2 A4 92 
84 FE FD 91 37 B1 A4 84 E3 16 93 52 D9 58 AC 71 D1 82 F2 C5 A6 DF 2F 93 
6B 2A 78 6D 57 71 BA 5C DD 97 2A 78 29 C6 F2 C1 D3 76 E1 F8 AD 3B FC 8A 
35 8B 34 AF 38 28 CD DA 29 71 65 B8 96 3F 55 FE 91 EF C2 57 B2 32 E7 84 
A2 E5 B6 1D A4 97 2A 44 15 30 74 BF 65 4D 59 75 B0 17 61 F1 F3 A5 25 A6 
BD 3D BD 5D 8C DC 5E 77 5B 19 24 AA 53 A2 F4 AB 29 53 51 85 9F D8 8D 57 
C2 28 BB C6 F7 E9 74 57 E1 31 30 8E A7 4B CB FB C9 5F 6E A0 64 78 95 9C 
E5 78 A8 FA B6 F7 65 B3 8C DC 2D 78 26 B9 FA 44 AF F8 98 DA DA 86 F4 A2 
DF 17 64 6E 7A B7 94 52 FB 40 CA 55 E5 4D A7 3E 3A A8 B5 F9 9E 5F BD 8C 
54 6A F6 13 33 8A BD A5 E1 5A FD 3E 96 06 FF 00 4C 65 F5 69 EF E9 AB 63 
CC 77 A1 08 AE C2 66 36 8B 4D 78 5D 7F DA C0 25 F4 DC D3 C6 3D 9A A5 15 
D7 8D 99 9B 1C 73 95 35 AE 95 24 AF 6B 58 C4 A5 97 E2 E2 D6 B8 D9 27 CF 
F0 FC 89 A3 86 AB 67 B3 7F 65 FA 0B 75 55 64 B1 09 BB C6 D6 FE 8A D8 AF 
8E AF BB 7F DA 15 0C 46 CF C1 DD 27 D0 B1 53 C4 3D 52 76 51 EA 9B EA 5D 
09 A1 56 0B 54 26 DB EB 7F 42 FF 00 16 2A 37 D5 3B ED 75 73 1B E1 DB DE 
53 8B 97 B3 7B FF 00 8B 95 85 1A 8A F6 71 DB A3 77 1A 13 CE 71 4E DA E6 
FD 1E DB 0A 75 62 AE DA 6D A4 55 53 AD 14 B4 42 FB 5F 82 B6 C4 24 B5 41 
28 FB 34 28 96 38 AA 69 D9 C2 D6 2E 8E 28 C3 94 65 0B 6A 56 5C 3B 85 51 
7B 2D FA 91 36 CD 78 A6 45 3C 4A 6D A9 5F 74 62 CA A5 9D AE AF 72 37 52 
32 93 8A 6A EF 6D 8B A5 65 78 B1 51 6F 54 EF D5 5C A4 E7 14 ED AE 6F D1 
ED B1 04 28 D4 4D D9 C7 6E 8D DC C8 54 EB 45 2D 10 BE D7 E0 B0 52 9D 58 
AB B6 9B 69 12 AC 4D 18 C9 6A A4 AC B7 7D 0B 2D 88 49 6A 82 51 F6 68 8A 
51 94 1A 72 56 B6 DB 98 8C B5 8B A5 29 5E 31 94 7D AF C1 33 C5 50 94 74 
2F 24 9B DE 52 6C D6 EB 8E FA 62 A3 BA D9 BE 4B A5 5D A9 DA 5E 1C B7 EA 
AF 72 A6 DB 2A 78 FF 00 01 38 49 D3 9D FA F4 FC 48 3E 3A A4 A4 E5 1D 9D 
B8 B9 82 F1 51 FA AA 34 D7 C9 17 D0 C6 43 FA 11 F9 C3 76 34 56 5B C4 4D 
BD 2D CB E6 99 2C 2B 59 7F AE DA 49 DE CE 3D 6D C1 AC 95 66 E4 E5 74 97 
0F 4A B2 28 AA 39 26 AE EF D3 6D D8 90 DB 77 87 CD AB D3 5A 6D 19 B9 2D 
AE BF C5 8A CB 35 92 9A D5 0B 37 1D ED C1 A5 D4 D3 D9 B6 F6 BF F1 2A EA 
4D DA F6 6B 6B DE E2 C3 6D 8C F1 B5 5C 93 84 D4 53 DF 7E 51 7A C5 E2 75 
7D 78 37 7D DD DF A7 53 55 52 A6 FE 58 D3 F9 36 D9 1A AA D3 4D 38 7D BE 
A3 4A DF AA 95 AA FD 75 4E 57 E1 6C FD 8C EC 26 0A BD 54 FC 3C 32 7D 1E 
CB F8 9E 55 E2 67 24 9C 1E 9F 78 32 5A 58 EA D7 6A 55 F1 0E 36 D9 46 4C 
96 23 D6 BC 0D 5C 23 F1 6A 4D 52 6B 74 9C 13 F4 F7 30 AA E6 14 A1 2D AA 
4A 6F AB D3 64 79 CF 8A C4 4F 67 56 72 5D 1C EF C1 15 5A D3 93 6B 5F 1D 
44 83 D1 3C D2 10 69 A9 BB 7A 47 94 52 39 B4 67 16 E3 5E 4D BE 52 47 9E 
55 24 DD 9B 92 BA F4 E4 92 8D 58 2B B9 6A 87 4B C5 17 43 D1 AC C5 AA 4A 
72 AD 51 C5 7A A7 62 DA B9 D5 ED 15 5E 76 4A D6 B6 CC D1 3C 75 4A 71 D3 
1A D5 2C DF 2E D6 23 A9 89 4E 2E 36 4D F5 D8 75 57 A0 86 69 4B 4F D2 CE 
E9 6F 64 EC 56 9E 3E 8C A7 78 BD AF 7B 6A 67 9B 53 5A E5 64 97 F0 25 8D 
3A 92 82 94 12 7F 36 86 92 D7 A2 8E 3A 4E 4F 4B FB DB 77 25 86 63 0D 4D 
54 A7 19 DD 5A ED D8 F2 92 9D 68 5F CE D6 F6 B2 F4 2C 55 26 D6 AF 16 4D 
13 5B F0 AF 5D 53 37 A1 14 FC 25 04 93 DE EA E4 11 CC 69 CA 7A 9B 57 E1 
9E 55 4A 52 FD BB B4 B7 F5 2E F1 5E 86 AF 79 70 DA E8 35 07 AC 96 65 46 
31 8B D5 4D EF 6E 0C 3C 4E 6F 45 5D 79 1D A7 F7 F2 68 21 7A A9 45 CF 42 
5B DD B2 1A B4 9B 93 5B 3E BE BB 89 06 CF 17 9A C2 69 DA 2B EB DF F3 35 
F2 C6 27 26 D4 13 BB B9 1A C2 4B 66 E2 DA E5 EC 5F 1C BB 12 FC D0 A7 E5 
7B AD F8 32 F0 32 28 63 E5 14 ED 4A 9F 1D 51 59 E2 54 9B 7A 63 1D BA 16 
47 03 88 8F EC DB 62 EF 85 AC 92 F2 BF B8 C7 62 8E BD ED BB 2F 85 68 A9 
29 36 DC 5E D6 2D 74 2B AB DA 9F E0 5A E8 56 7C A4 97 42 E8 4F 1A B4 EF 
B4 A4 AC F6 B0 75 20 D2 7A E6 D3 E6 3F F5 31 FC 09 FA AF BC AA A3 3F 54 
27 81 34 6A 45 4B 76 DA BF A9 2A C4 53 FD CB BE 0C 75 4E AD B6 48 BF C3 
AD BF 95 01 92 F1 74 6C 92 A6 E3 6F 47 C9 2C 31 D4 94 6C D4 AF F3 30 5C 
2A 5F EA 14 F3 AB 79 51 06 C6 38 E5 4D DE 33 52 5E 85 95 B1 F2 A9 34 D2 
B5 9F 29 98 3A ED CC 63 F7 05 52 3D 4A 9E D9 6F 15 55 EF 26 DB 7D 13 E0 
BE 9D 6E 75 62 BC 3B A6 AD 25 7B 18 6E 51 92 BA 76 7E A5 8D C9 4B 9B A0 
7A 6D 69 66 55 70 F3 BA A9 1A A9 35 66 D1 2D 4C DA A3 4A 53 A4 96 F7 56 
34 6A 4D 2B 5D DE FB 17 78 95 1C 6D 74 5B 0D B6 75 F3 09 D4 BC A0 D2 7C 
6F C3 28 B1 98 87 14 FC 48 CB 67 6D F7 35 8E A5 A0 BC B0 4F E6 F7 23 75 
1F F4 13 DB 6E 96 26 86 FA 18 8C 45 45 69 3A 6E 37 B3 EB FF 00 53 2B 07 
87 AB 55 AD 14 23 29 3D F8 D8 F3 4B 13 27 17 15 A6 EB AC 5D 99 75 3C 6D 
78 34 95 7A A9 5F 74 A4 EE 4B 15 EC 1E 57 88 87 D2 54 8F 84 96 EF CA BD 
7E 66 36 27 19 0A 4E D2 AC E7 28 ED E5 A7 64 8F 35 3C 65 69 4D A8 D6 AE 
E2 FA 4E EF 72 2A B5 AA 59 27 3B BF 6E 82 41 E8 67 99 C2 CE 4A 69 3F 4D 
F7 2D 59 BC 25 2D AB 4E 2D 2D 93 5B 9E 71 55 92 5B B7 B3 E4 92 15 22 AA 
2D 4A 5B 6F 7B 6E 5D 23 D2 51 CC 25 24 ED 5A A7 BA D2 C4 B3 95 1A 7A 63 
5A 6A FB EC 8D 0A C5 CA 9D E5 4E B5 5F C3 F1 2D F8 B7 25 AA 72 53 93 EA 
D0 EA B1 BD 86 6B 19 37 AE A6 CF 9E 85 5E 63 42 52 F2 3B 24 AD BC 99 E7 
3C 44 DC 5E 95 7F 4F 52 4A 71 95 4B E9 B3 7F 34 34 96 BD 1C B1 DE 64 A0 
ED D2 EE 4D 92 47 31 D2 E3 AE 31 9D 9D ED BA 3C BC DD 78 35 79 69 DA EE 
C4 5E 2D 49 5E F5 A5 AB AA 44 D2 BD 7C F3 4C 3C 16 98 42 31 A9 66 F9 BD 
8C 79 E6 70 AB 2D DC 6E B8 B2 DB EE 3C AC A7 29 4A DA FA EC 9F F0 2E 8D 
47 16 E3 27 AB 9B 24 3A E8 7B 28 E6 74 5C 52 5E 0C A5 6E 1A B5 88 2A 63 
D3 9B 73 95 EC B9 67 95 A7 56 71 6E CE 57 7C B2 45 5A 4D 27 66 93 BA 6E 
C3 43 D2 AC 55 2E 1A 5B EF 7B 09 E2 E8 E9 50 9C 23 6E 9E 5D FE C3 CF D3 
C5 D4 4B 9B 6C 96 EC BA 55 E6 D5 ED 04 FA 6E 4B 88 DE 6A C3 B8 A9 4A AB 
4B DD 5C A5 4A 78 79 AB 29 27 CB EB 76 6A 69 D4 AF 28 B8 DA 1B 2B B5 A8 
C8 A7 1C 4C 53 71 95 07 ED E2 21 AD 2B 25 61 F0 FA 95 EA 55 BA E9 B2 26 
A7 4E 8A 95 A1 AE 56 EA DF 06 1C 69 E2 1B D5 39 52 F5 DA A1 74 DC A1 A5 
36 D2 7E E9 8D 7E A3 65 4D C1 24 9C 63 F3 BB 6C 96 15 D5 38 B6 E9 5E DD 
75 58 D3 2C 4C E0 AF 7D FD 34 94 A9 8E 9B B5 E6 F6 E7 CA 2F 91 B3 A9 88 
A9 35 68 D4 92 5E 97 29 4F 0D 5E BB 4A 9A 55 1B 5B 46 E6 A3 E2 5B 8B FA 
55 7E 9E 5D AF 62 29 62 AA EB F2 CA 1B 75 BB 26 87 A0 A9 4A 58 79 28 E2 
70 95 60 DA E5 3B 98 B5 DA 8C 9B 4A 4E 09 EF 7E 4D 67 C4 D7 D0 9B C6 45 
AF 4B B6 52 38 BA B1 E6 BD 26 97 0B A9 64 1B 19 CA 52 57 8C 2F B7 45 62 
92 9B 71 51 92 5B 7A 7B FA FD E6 BF F9 C7 11 BA 55 D5 9A F4 1E 3D 57 CD 
68 F4 B9 7C 8D 84 F5 4A CE 2E C9 37 CF 52 97 94 AF E2 4B EE 46 24 6B E2 
9E CA A5 37 1F 4B 96 78 D8 8B 2B AB FB 45 93 F4 67 3A 4D AD A3 25 CE F7 
2D D2 D2 4A F3 5B 5B 73 09 62 AB 46 7A A4 83 C7 CB 4D AC F7 7B 5D 14 67 
C5 41 6D 3B 37 D7 66 C9 29 D2 C3 3A 7A 34 A6 DE FF 00 54 D6 7F 39 CA 37 
E6 EF 91 3C CA 6D BD 32 95 FE 60 DB 65 E0 42 0F 6A 4E CB AF 54 79 3E F7 
7C 25 DD E6 6C 92 F3 7D 0D 9F FE 74 0D DC 33 39 B7 65 52 6A EA CE EC F3 
3D EB E2 9D 6E C1 66 49 D7 52 6F C2 DB 6D ED 56 04 91 32 F4 DD 78 35 B4 
38 4A 4D 49 7D C5 BF 0F 89 92 4E 30 A9 C6 CD 6D C8 05 BE D5 58 61 F1 3C 
37 59 ED CD D9 6D 6A 6A 31 F3 AA BE EF 50 05 BE 86 3C A4 F8 86 A5 A9 6E 
9D FE F2 CF 16 BA B2 57 4D 3F BC 00 2E F1 6A 36 D4 A5 25 75 6B AD 8B BC 
49 69 BA 9C DF A2 BD D8 05 16 CA B3 D4 95 DE DE A8 78 CA FB AB DB AB 00 
68 5C AB 42 4D DE 92 7F 66 E5 F2 AD 49 A7 15 45 45 B5 B3 F7 00 68 41 E2 
D7 56 4A E9 A7 F7 97 78 B5 1B 6A 52 92 BA B5 D6 C0 12 0B BC 49 69 BA 9C 
DF A2 BD D9 6C AB 3D 49 5D ED EA 80 28 78 CA FB AB DB AB 2E 55 A1 26 EF 
49 3F B3 70 06 84 9E 3D 14 D7 F9 BC 57 F1 2D 95 5A 55 1D FE 1D 47 A2 D1 
FC 40 02 91 F0 DC 92 54 E5 EA EE F6 45 EE A2 BA D5 0D 2D F1 E8 00 16 B9 
C9 DE 36 E7 8F C0 42 FE 64 E7 65 65 C0 05 15 D4 BA D5 B2 6F 96 AE 47 6B 
26 AE E5 BF 40 0C 71 F6 8A 5A 2D 46 DC 37 F7 97 38 3B 3F 3D FE 40 19 55 
51 46 4B 87 26 FD 99 6C E3 52 33 F2 B6 97 17 71 00 0A 39 54 6B CD 56 FE 
9E 5F FA 95 7A 94 5D 9D BD 90 02 8B A1 0A 9B 38 2A 8F E4 8A 54 85 48 BF 
32 9C 5D BA AE 40 01 AE 57 F3 A8 DA CF 6B 58 AA 6A 51 B2 8E 9E A0 08 2D 
DD BB A7 A9 3E 2C 55 5D 45 F9 7E F6 01 45 B2 93 57 B2 DE EF 7B 8E 5E F7 
B3 5B 7F 8F B4 02 7E 89 E8 A8 F9 94 FC C9 C7 6D F8 77 2F A1 4D 2A AA 76 
94 DA 7B AE 96 00 C6 8C AC 42 A9 5B 4C 69 61 28 D2 69 5A F4 DB B7 CD DF 
A9 0F 81 5E 12 D3 37 28 EA E2 C0 12 0A 3A 35 BA 39 4A CE DB 14 78 7C 4E 
FB 54 00 41 5F 02 BA 5E 65 57 EF 64 33 B4 6F BD 4F B5 B0 00 8E 52 92 BD 
B5 7A AE 4B 5D 4A 9D 2E 01 43 C5 AB FB D2 2B E2 CF AC A4 01 43 C5 97 AB 
1E 37 CD 80 34 2F 8D 65 D5 17 29 42 40 0D 06 95 FB 32 17 92 E7 74 80 02 
AA 7B AF C4 B2 1A 94 A2 F5 69 4D F4 E5 00 58 2E 6E D7 B5 5E 17 55 72 C9 
25 AE EA 7A AE BA 20 0C 27 B4 5A B4 E9 76 BA 76 DC B9 43 65 69 5B 6E 00 
33 AA A2 83 E6 F2 7E D7 29 52 35 34 A7 1D 57 F7 5C 00 05 35 54 E1 D5 DB 
9F AA 23 7B 5E EB DF A5 C0 14 21 1A 92 E1 4D BF 65 D4 BE 70 A8 A2 A5 28 
D4 4B D5 A6 00 16 29 4E 29 26 95 AF D6 25 CA 71 D4 D2 82 5E E8 01 05 AE 
EB 64 F8 D9 AE A5 63 AA FF 00 55 F1 D7 60 00 A3 95 B7 71 E9 D1 F0 52 ED 
AB BB AB 3D FE 60 0A 2E 5E 55 78 C9 2D F8 6C 9D D6 84 A2 B5 EA F1 7A EE 
00 AB A4 71 F0 76 BB 94 9F CB 82 F9 4A 09 AB 4A 16 00 41 48 2A D3 BC A2 
DE 95 CE 9E A8 3A D5 54 23 F5 65 16 B6 7B 6F EE 01 24 F0 8A 7C 4C BC D1 
B2 BB E3 77 FD A5 1D 69 69 B3 94 95 BD 40 12 41 74 31 55 6C DB A8 DD B6 
DF F2 2F 8E 32 AD B5 6E AF D5 F0 00 B2 68 56 38 DA 6D DE 54 5C 92 7F 79 
34 B1 58 1D 49 BC 3D 44 DA E1 4E E0 12 08 AA 54 C3 5F 55 38 54 8A 7C DE 
64 53 9A 6F CB AF 8E A0 19 58 2B 1A 93 DD A4 DF DC 52 52 AC B9 EA EF C8 
06 20 EB D4 49 AE 9E AD 0F 11 C9 3B 29 7D 9D 40 32 D7 81 63 A9 3D 36 D6 
F4 A7 D5 DC BD 54 AB 7B A9 C7 8B F3 D3 A0 04 09 BA CE D7 9C 5B 7D 23 BA 
2C 8C EA 37 CB 57 DA C9 80 4A 8B F4 E2 23 2B F8 2D DF 6B 9E 6F BC B7 37 
D8 BC C3 52 B7 FA 3F F9 91 00 CA 7A 4B E9 FF D9
);

    my $game =<<'EOGAME';
#!/usr/bin/perl
use SDL; #needed to get all constants
use SDL::App;
use SDL::Surface;
use SDL::Rect;

use strict;
use warnings;

my $app = SDL::App->new(
    -title  => "Lunar Lander",
    -width  => 800,
    -height => 600,
    -depth  => 32,
);

my $background = SDL::Surface->new( -name => 'images/background.jpg', );
my $ship       = SDL::Surface->new( -name => 'images/ship.jpg', );

my $background_rect = SDL::Rect->new(
    -height => $background->height(),
    -width  => $background->width(),
);

my $ship_rect = SDL::Rect->new(
    -height => $ship->height(),
    -width  => $ship->width(),
);

sub draw {
    my ( $x, $y ) = @_; # spaceship position

    # fix $y for screen resolution
    $y = 450 * ( 1000 - $y ) / 1000;

    # background
    $background->blit( $background_rect, $app, $background_rect );

    # ship
    my $ship_dest_rect = SDL::Rect->new(
        -height => $ship->height(),
        -width  => $ship->width(),
        -x      => $x,
        -y      => $y,
    );

    $ship->blit( $ship_rect, $app, $ship_dest_rect );

    $app->update($background_rect);
}

my $height   = 1000; # m
my $velocity = 0;    # m/s
my $gravity  = 1;    # m/s^2

my $t = 0;

my $script_re = qr/(\d+) \D+ (\d+)/x;
my %up = map { $_ =~ $script_re } <DATA>;

while ( $height > 0 ) {
    print "at $t s height = $height m, velocity = $velocity m/s\n";

    if ( $up{$t} ) {
        my $a = $up{$t};
        print "(accellerating $a m/s^2)\n";
        $velocity = $velocity - $a;
    }

    $height   = $height - $velocity;
    $velocity = $velocity + $gravity;
    $t        = $t + 1;

    draw( 100, $height );
    $app->delay(10);
}

if ( $velocity > 10 ) {
    print "CRASH!!!\n";
} else {
    print "You landed on the surface safely! :-D\n";
}

# small delay to let us view the window
# in the end, before closing
sleep 2;

__DATA__
at 41s, accelerate 10 m/s^2 up
at 43s, 10 m/s^2
at 45s, 10
at 47s, 10
at 49s, 10
EOGAME

    write_file ($filename, $game);
    mkdir 'images'
        or die "error creating dir 'images': $!\n";
    print "[-] created 'images'\n";

    write_file ('images/ship.jpg', $ship_image, 1);
    write_file ('images/background.jpg', $background_image, 1);

}

sub write_file {
    my ($filename, $buffer, $binary) = (@_);

    open my $fh, '>', $filename
       or die "error creating file '$filename': $!\n";

    binmode $fh if $binary;
    print $fh $buffer;
    close $fh;
    print "[-] created '$filename'\n";
}

"all your base are belong to us";
__END__
=head1 NAME

Lunar Lander - a small tutorial on Perl SDL

=head1 INTRODUCTION

This is a quick introduction to Games, Perl, and  SDL (Simple 
DirectMedia Layer, a cross-platform multimedia programming 
library). We'll write a small game -- Lunar Lander -- in 100 
lines of code, or less.

=head3 CREATING A DEMO

You can see the final version of the demo code by doing:

   perl -MSDL::Tutorial::LunarLander=lander.pl -e1

this will create all three files used in the tutorial:



=head2 FIRST VERSION

We'll start with a text version of the game.

"What?", you may ask. "I thought it was a SDL tutorial".

Yes, it is -- thank you for reminding me. But we'll leave the SDL part for
later. We must build the game logic first!

One of the traps of game programming is focusing too much on the interface.
If we start with a simpler simulation, we can worry with the presentation
later.

So, here's the initial code:

    #!/usr/bin/perl

    use strict;
    use warnings;

    my $height   = 1000; # m
    my $velocity = 0;    # m/s
    my $gravity  = 1;    # m/s^2

    my $t = 0;

    while ( $height > 0 ) {
        print "at $t s height = $height m, velocity = $velocity m/s\n";

        $height   = $height - $velocity;
        $velocity = $velocity + $gravity;
        $t        = $t + 1;
    }

    if ( $velocity > 10 ) {
        print "CRASH!!!\n";
    } else {
        print "You landed on the surface safely! :-D\n";
    }

Run the code and you'll see something like this:

    at 0 s height = 1000 m, velocity = 0 m/s
    at 1 s height = 1000 m, velocity = 1 m/s
    at 2 s height = 999 m, velocity = 2 m/s
    at 3 s height = 997 m, velocity = 3 m/s
    at 4 s height = 994 m, velocity = 4 m/s
    at 5 s height = 990 m, velocity = 5 m/s
    ...
    at 43 s height = 97 m, velocity = 43 m/s
    at 44 s height = 54 m, velocity = 44 m/s
    at 45 s height = 10 m, velocity = 45 m/s

    CRASH!!!

"What happened? How do I control the ship???"

=head2 CONTROLLING THE SHIP

The problem with our first spaceship is that it had no controls!

So, let's fix this problem, making the spaceship scriptable. (We 
could write some code to handle keyboard and joysticks now, but 
an scriptable spaceship will be easier to start. Remember, focus
on the game logic!)

So, create add this simple script to the end of your file:

    __DATA__
    at 41s, accelerate 10 m/s^2 up
    at 43s, 10 m/s^2
    at 45s, 10
    at 47s, 10
    at 49s, 10

The script is straightforward: it simply states a time when we
will push the spaceship up with a given acceleration. It accepts
free text: any two numbers you type will work.

We can parse the script using this regular expression:

    my $script_re = qr/(\d+) \D+ (\d+)/x;

And we can build a hash of ( time => acceleration ) with:

    my %up = map { $_ =~ $script_re } <DATA>;

So the middle section of the program will become:

    my $script_re = qr/(\d+) \D+ (\d+)/x;
    my %up = map { $_ =~ $script_re } <DATA>;

    while ( $height > 0 ) {
        print "at $t s height = $height m, velocity = $velocity m/s\n";

        if ( $up{$t} ) {
            my $a = $up{$t};
            print "(accellerating $a m/s^2)\n";
            $velocity = $velocity - $a;
        }

        $height   = $height - $velocity;
        $velocity = $velocity + $gravity;
        $t        = $t + 1;
    }

That's it!

Try to run the program, and the ship should land safely:

    ./lunar.pl autopilot.txt 
    at 0 s height = 1000 m, velocity = 0 m/s
    at 1 s height = 1000 m, velocity = 1 m/s
    at 2 s height = 999 m, velocity = 2 m/s
    at 3 s height = 997 m, velocity = 3 m/s
    at 4 s height = 994 m, velocity = 4 m/s
    at 5 s height = 990 m, velocity = 5 m/s
    ...
    at 54 s height = 19 m, velocity = 4 m/s
    at 55 s height = 15 m, velocity = 5 m/s
    at 56 s height = 10 m, velocity = 6 m/s
    at 57 s height = 4 m, velocity = 7 m/s

    You landed on the surface safely! :-D

Cool, but...

=head2 HOW ABOUT THE GRAPHICS?

Okay, okay... now that we have a working prototype, we can work on
the graphics. But, first of all, we'll need...

=head3 THE GRAPHICS

Yes, the graphics.

We won't use anything fancy here, just two images: a large one, for
the background, and a smaller one for the spaceship.

Create the images using the Gimp, or use the images provided by
this tutorial; Save these images in a subdirectory called "images":
("C<images/background.jpg>" and "C<images/ship.png>").

=head2 USING SDL

First step: use the required libraries:

    use SDL; #needed to get all constants
    use SDL::App;
    use SDL::Surface;
    use SDL::Rect;

Second step: initialize C<SDL::App>:

    my $app = SDL::App->new(
        -title  => "Lunar Lander",
        -width  => 800,
        -height => 600,
        -depth  => 32,
    );

Third step: load the images and create the necessary "rectangles":

    my $background = SDL::Surface->new( -name => 'images/background.jpg', );
    my $ship       = SDL::Surface->new( -name => 'images/ship.png', );

    my $background_rect = SDL::Rect->new(
        -height => $background->height(),
        -width  => $background->width(),
    );

    my $ship_rect = SDL::Rect->new(
        -height => $ship->height(),
        -width  => $ship->width(),
    );

Fourth step: create a sub to draw the spaceship and background:

    sub draw {
        my ( $x, $y ) = @_; # spaceship position

        # fix $y for screen resolution
        $y = 450 * ( 1000 - $y ) / 1000;

        # background
        $background->blit( $background_rect, $app, $background_rect );

        # ship
        my $ship_dest_rect = SDL::Rect->new(
            -height => $ship->height(),
            -width  => $ship->width(),
            -x      => $x,
            -y      => $y,
        );

        $ship->blit( $ship_rect, $app, $ship_dest_rect );

        $app->update($background_rect);
    }

Note that this sub first combines all the bitmaps, using a blit
("Block Image Transfer") operation -- which is quite fast, but does
not update the display.

The combined image is displayed in the last line. This process of
combining first, and displaying later, avoids that annoying fading
between cycles ("flickering").

Finally, add the following lines to the end of the main loop, so that
we call the C<draw()> function with the correct spaceship
coordinates:

    while ( $height > 0 ) {

        # ...

        draw( 100, $height );
        $app->delay(10);
    }

That's it!

Run the program and watch the spaceship landing safely on the surface
of the moon.

=head1 COPYRIGHT & LICENSE

Copyright 2009 Nelson Ferraz, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

