#ifndef SCREEM_ICON_CACHE_H
#define SCREEM_ICON_CACHE_H

#include <glib-object.h>

#define SCREEM_TYPE_ICON_CACHE            (screem_icon_cache_get_type ())
#define SCREEM_ICON_CACHE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_ICON_CACHE, ScreemIconCache))
#define SCREEM_ICON_CACHE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_ICON_CACHE, ScreemIconCacheClass))
#define SCREEM_IS_ICON_CACHE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_ICON_CACHE))

#define SCREEM_ICON_CACHE_DEFAULT_SIZE 20

typedef struct ScreemIconCachePrivate ScreemIconCachePrivate;

typedef struct ScreemIconCache ScreemIconCache;

struct ScreemIconCache {
	GObject parent;

	ScreemIconCachePrivate *priv;
};

typedef struct {
	GObjectClass parent_class;

	void (*changed)( ScreemIconCache *cache );
	
} ScreemIconCacheClass;

GType screem_icon_cache_get_type( void );
ScreemIconCache* screem_icon_cache_new( void );

GdkPixbuf *screem_icon_cache_get_pixbuf( ScreemIconCache *cache,
		const gchar *uri, const gchar *mime_type, gint size );

GdkPixbuf *screem_icon_cache_get_thumbnail( ScreemIconCache *cache,
		const gchar *uri, const gchar *mime_type, gint size );

GdkPixbuf *screem_icon_cache_get_large_thumbnail( ScreemIconCache *cache,
		const gchar *uri, const gchar *mime_type, gint size );

#endif
