#ifndef SCREEM_FILE_BROWSER_H
#define SCREEM_FILE_BROWSER_H

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreesortable.h>

#include <libgnomevfs/gnome-vfs-monitor.h>

#include "screem-icon-cache.h"

#define SCREEM_TYPE_FILE_BROWSER  (screem_file_browser_get_type())
#define SCREEM_FILE_BROWSER(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), \
                              SCREEM_TYPE_FILE_BROWSER, \
                              ScreemFileBrowser ) )
#define SCREEM_IS_FILE_BROWSER(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                 SCREEM_TYPE_FILE_BROWSER ) )

enum {
	FILE_BROWSER_NAME_COL,
	FILE_BROWSER_ICON_COL,
	FILE_BROWSER_NODE_COL,
	FILE_BROWSER_USER_COL,
	FILE_BROWSER_DATA_COL,
	FILE_BROWSER_URI_COL,
	FILE_BROWSER_MIME_COL,  /* pointer to const string, as
				   there is no G_TYPE_CONST_STRING */
	FILE_BROWSER_SHOW_COL,
	FILE_BROWSER_MAX_COL
};

typedef enum {
	FILE_BROWSE_NORMAL = 0,
	FILE_BROWSE_RECURSE = 1 << 2,
	FILE_BROWSE_ROOT = 1 << 3
} ScreemFileBrowserMode;

typedef struct ScreemFileBrowserDetails ScreemFileBrowserDetails;

typedef struct  {
	GObject parent_object;

	ScreemFileBrowserDetails *details;
} ScreemFileBrowser;

typedef struct {
	GObjectClass parent_spot;

	/* emited when we remove a node from the model */
	void (*removed)( ScreemFileBrowser *browser,
			 const gchar *uri,
			 GtkTreeIter *it  );

	/* emited when we add a node to the model */
	void (*added)( ScreemFileBrowser *browser,
		       const gchar *uri,
		       const gchar *mime_type,
		       GtkTreeIter *it );

	void (*icon_change)( ScreemFileBrowser *browser,
				const gchar *uri,
				const gchar *mime_type,
				GtkTreeIter *it );
} ScreemFileBrowserClass;

GType  screem_file_browser_get_type( void );
ScreemFileBrowser *screem_file_browser_new( ScreemIconCache *cache );

/* set the default mode, passing -1 as the mode to other funcs
   causes this to be used */
void screem_file_browser_set_mode( ScreemFileBrowser *browser,
				   ScreemFileBrowserMode mode );

/* made available so a different view can be used if wanted */
GtkTreeModel *screem_file_browser_get_model( ScreemFileBrowser *browser );

void screem_file_browser_scan_directory( ScreemFileBrowser *browser,
					 const gchar *uri,
					 int mode );
void screem_file_browser_scan_iter( ScreemFileBrowser *browser,
		GtkTreeIter *iter, int mode );

/* returns a list of filenames from the given list of iterators */
GList *screem_file_browser_get_pathnames( ScreemFileBrowser *browser,
					  GList *iters, gboolean recurse );

/* give a custom sort function for the browser */
void screem_file_browser_set_sort_func( ScreemFileBrowser *browser,
					GtkTreeIterCompareFunc func,
					gpointer data );

void screem_file_browser_file_mod( ScreemFileBrowser *browser,
				const gchar *directory,
				const gchar *file,
				GnomeVFSMonitorEventType type );


void screem_file_browser_set_show_hidden( ScreemFileBrowser *browser,
		gboolean show );
void screem_file_browser_set_show_backups( ScreemFileBrowser *browser,
		gboolean show );
/* override default backup file suffix of ~ */
void screem_file_browser_set_backup_suffix( ScreemFileBrowser *browser,
		const gchar *suffix );

/* only call on app exit */
void screem_file_browser_cleanup( void );
				
#endif
