#ifndef SCREEM_DBUS_H
#define SCREEM_DBUS_H

#include <glib-object.h>

#include "screem-application.h"

#define SCREEM_TYPE_DBUS            (screem_dbus_get_type ())
#define SCREEM_DBUS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_DBUS, ScreemDbus))
#define SCREEM_DBUS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_DBUS, ScreemDbusClass))
#define SCREEM_IS_DBUS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_DBUS))

typedef struct ScreemDbus ScreemDbus;
typedef struct ScreemDbusPrivate ScreemDbusPrivate;

struct ScreemDbus {
	GObject parent;
	
	ScreemDbusPrivate *priv;
};

typedef struct {
	GObjectClass parent_class;

} ScreemDbusClass;

GType screem_dbus_get_type( void );
ScreemDbus *screem_dbus_new( ScreemApplication *app );

gboolean screem_dbus_instance_exists( ScreemDbus *dbus );
void screem_dbus_open_files( ScreemDbus *dbus, 
		const gchar **start_files );

#endif
