; Helper defines
!define PRODUCT_NAME "Scorched3D"
!define PRODUCT_VERSION "41.3"
!define PRODUCT_PUBLISHER "Scorched"
!define PRODUCT_WEB_SITE "http://www.scorched3d.co.uk"
!define PRODUCT_DONATE_WEB_SITE "https://www.paypal.com/xclick/business=donations%40scorched3d.co.uk&item_name=Scorched3D&no_note=1&tax=0&currency_code=GBP"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "data\windows\tank2.ico"
!define MUI_UNICON "data\windows\tank2.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Scorched3D-${PRODUCT_VERSION}-patch.exe"
InstallDir "$PROGRAMFILES\Scorched3D"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  ReadRegStr $R0 ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString"
  StrCmp $R0 "" 0 done
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION "${PRODUCT_NAME} is not already installed, do you wish to patch anyway?" IDOK done
  Abort
done:
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  
  
File "/oname=$INSTDIR\.\data\accessories\banana\banana.txt" ".\data\accessories\banana\banana.txt" 
File "/oname=$INSTDIR\.\data\accessories\barrage\barrage.txt" ".\data\accessories\barrage\barrage.txt" 
File "/oname=$INSTDIR\.\data\accessories\beer_bottle\bottle.txt" ".\data\accessories\beer_bottle\bottle.txt" 
File "/oname=$INSTDIR\.\data\accessories\bomb\bomb.txt" ".\data\accessories\bomb\bomb.txt" 
File "/oname=$INSTDIR\.\data\accessories\bomblet\bomblet.txt" ".\data\accessories\bomblet\bomblet.txt" 
File "/oname=$INSTDIR\.\data\accessories\bouncingbetty\bouncingbetty.txt" ".\data\accessories\bouncingbetty\bouncingbetty.txt" 
File "/oname=$INSTDIR\.\data\accessories\digger\digger.txt" ".\data\accessories\digger\digger.txt" 
File "/oname=$INSTDIR\.\data\accessories\dirt\dirt.txt" ".\data\accessories\dirt\dirt.txt" 
File "/oname=$INSTDIR\.\data\accessories\fatman\fatman.txt" ".\data\accessories\fatman\fatman.txt" 
File "/oname=$INSTDIR\.\data\accessories\hawkmissile\hawk.txt" ".\data\accessories\hawkmissile\hawk.txt" 
File "/oname=$INSTDIR\.\data\accessories\herring\herring.txt" ".\data\accessories\herring\herring.txt" 
File "/oname=$INSTDIR\.\data\accessories\icbm\icbm.txt" ".\data\accessories\icbm\icbm.txt" 
File "/oname=$INSTDIR\.\data\accessories\laser\hlaser.txt" ".\data\accessories\laser\hlaser.txt" 
File "/oname=$INSTDIR\.\data\accessories\laser\laser.txt" ".\data\accessories\laser\laser.txt" 
File "/oname=$INSTDIR\.\data\accessories\littleboy\littleboy.txt" ".\data\accessories\littleboy\littleboy.txt" 
File "/oname=$INSTDIR\.\data\accessories\m48\m48.txt" ".\data\accessories\m48\m48.txt" 
File "/oname=$INSTDIR\.\data\accessories\mirvwarhead\mirvwarhead.txt" ".\data\accessories\mirvwarhead\mirvwarhead.txt" 
File "/oname=$INSTDIR\.\data\accessories\napalm\napalm.txt" ".\data\accessories\napalm\napalm.txt" 
File "/oname=$INSTDIR\.\data\accessories\palmtree\burntpalm.txt" ".\data\accessories\palmtree\burntpalm.txt" 
File "/oname=$INSTDIR\.\data\accessories\palmtree\burntpalm2.txt" ".\data\accessories\palmtree\burntpalm2.txt" 
File "/oname=$INSTDIR\.\data\accessories\palmtree\palm.txt" ".\data\accessories\palmtree\palm.txt" 
File "/oname=$INSTDIR\.\data\accessories\palmtree\palm2.txt" ".\data\accessories\palmtree\palm2.txt" 
File "/oname=$INSTDIR\.\data\accessories\patriot\patriot.txt" ".\data\accessories\patriot\patriot.txt" 
CreateDirectory "$INSTDIR\.\data\accessories\pinguins"
File "/oname=$INSTDIR\.\data\accessories\pinguins\2pinguins.txt" ".\data\accessories\pinguins\2pinguins.txt" 
File "/oname=$INSTDIR\.\data\accessories\pinguins\birdmat.bmp" ".\data\accessories\pinguins\birdmat.bmp" 
File "/oname=$INSTDIR\.\data\accessories\pinguins\pinguin1.txt" ".\data\accessories\pinguins\pinguin1.txt" 
File "/oname=$INSTDIR\.\data\accessories\pinguins\pinguin2.txt" ".\data\accessories\pinguins\pinguin2.txt" 
CreateDirectory "$INSTDIR\.\data\accessories\pwrcrate"
File "/oname=$INSTDIR\.\data\accessories\pwrcrate\pwrcrate.bmp" ".\data\accessories\pwrcrate\pwrcrate.bmp" 
File "/oname=$INSTDIR\.\data\accessories\pwrcrate\pwrcrate.txt" ".\data\accessories\pwrcrate\pwrcrate.txt" 
File "/oname=$INSTDIR\.\data\accessories\riot\riot.txt" ".\data\accessories\riot\riot.txt" 
File "/oname=$INSTDIR\.\data\accessories\roller\roller.bmp" ".\data\accessories\roller\roller.bmp" 
File "/oname=$INSTDIR\.\data\accessories\roller\roller.txt" ".\data\accessories\roller\roller.txt" 
Delete "$INSTDIR\.\data\accessories\roller\metal.bmp" 
Delete "$INSTDIR\.\data\accessories\roller\warning.bmp" 
Delete "$INSTDIR\.\data\accessories\roller\worn.bmp" 
File "/oname=$INSTDIR\.\data\accessories\sa6\sa6.txt" ".\data\accessories\sa6\sa6.txt" 
CreateDirectory "$INSTDIR\.\data\accessories\shack"
File "/oname=$INSTDIR\.\data\accessories\shack\roof.bmp" ".\data\accessories\shack\roof.bmp" 
File "/oname=$INSTDIR\.\data\accessories\shack\shack.bmp" ".\data\accessories\shack\shack.bmp" 
File "/oname=$INSTDIR\.\data\accessories\shack\shack.txt" ".\data\accessories\shack\shack.txt" 
File "/oname=$INSTDIR\.\data\accessories\shack\window.bmp" ".\data\accessories\shack\window.bmp" 
File "/oname=$INSTDIR\.\data\accessories\shell\shell.txt" ".\data\accessories\shell\shell.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\burntsmallpine.txt" ".\data\accessories\smallpine\burntsmallpine.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\smallpine.txt" ".\data\accessories\smallpine\smallpine.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\smallpine2.txt" ".\data\accessories\smallpine\smallpine2.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\smallpine3.txt" ".\data\accessories\smallpine\smallpine3.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\wintersmallpine.txt" ".\data\accessories\smallpine\wintersmallpine.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\wintersmallpine2.txt" ".\data\accessories\smallpine\wintersmallpine2.txt" 
File "/oname=$INSTDIR\.\data\accessories\smallpine\wintersmallpine3.txt" ".\data\accessories\smallpine\wintersmallpine3.txt" 
File "/oname=$INSTDIR\.\data\accessories\sonicring\sonicring.txt" ".\data\accessories\sonicring\sonicring.txt" 
File "/oname=$INSTDIR\.\data\accessories\teleport\teleport.txt" ".\data\accessories\teleport\teleport.txt" 
File "/oname=$INSTDIR\.\data\accessories\v2missile\v2missile.txt" ".\data\accessories\v2missile\v2missile.txt" 
File "/oname=$INSTDIR\.\data\accessories.xml" ".\data\accessories.xml" 
File "/oname=$INSTDIR\.\data\ainames.txt" ".\data\ainames.txt" 
File "/oname=$INSTDIR\.\data\fastestdisplay.xml" ".\data\fastestdisplay.xml" 
File "/oname=$INSTDIR\.\data\fonts\VERA-COPYRIGHT.TXT" ".\data\fonts\VERA-COPYRIGHT.TXT" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\authors.txt" ".\data\globalmods\apoc\authors.txt" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\bar1.txt" ".\data\globalmods\apoc\data\accessories\buildings\bar1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\builds1.bmp" ".\data\globalmods\apoc\data\accessories\buildings\builds1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\builds2.bmp" ".\data\globalmods\apoc\data\accessories\buildings\builds2.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\builds3.bmp" ".\data\globalmods\apoc\data\accessories\buildings\builds3.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\builds4.bmp" ".\data\globalmods\apoc\data\accessories\buildings\builds4.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\builds5.bmp" ".\data\globalmods\apoc\data\accessories\buildings\builds5.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\church1.txt" ".\data\globalmods\apoc\data\accessories\buildings\church1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\church1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\church1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\factory1.txt" ".\data\globalmods\apoc\data\accessories\buildings\factory1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\factory1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\factory1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\farm1.txt" ".\data\globalmods\apoc\data\accessories\buildings\farm1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\farm1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\farm1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\fence1.bmp" ".\data\globalmods\apoc\data\accessories\buildings\fence1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\fence1trans.bmp" ".\data\globalmods\apoc\data\accessories\buildings\fence1trans.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\gasstation1.txt" ".\data\globalmods\apoc\data\accessories\buildings\gasstation1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\gasstation1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\gasstation1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\hospital.txt" ".\data\globalmods\apoc\data\accessories\buildings\hospital.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\house1-2.txt" ".\data\globalmods\apoc\data\accessories\buildings\house1-2.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\house1-2burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\house1-2burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\house1-3.txt" ".\data\globalmods\apoc\data\accessories\buildings\house1-3.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\house1-3burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\house1-3burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\house1.txt" ".\data\globalmods\apoc\data\accessories\buildings\house1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\house1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\house1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\igloo.bmp" ".\data\globalmods\apoc\data\accessories\buildings\igloo.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\igloo.txt" ".\data\globalmods\apoc\data\accessories\buildings\igloo.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\logcabin1.txt" ".\data\globalmods\apoc\data\accessories\buildings\logcabin1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\logcabin1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\logcabin1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\mainport.txt" ".\data\globalmods\apoc\data\accessories\buildings\mainport.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\mainport_anim.txt" ".\data\globalmods\apoc\data\accessories\buildings\mainport_anim.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\nuclearplant.txt" ".\data\globalmods\apoc\data\accessories\buildings\nuclearplant.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office1.txt" ".\data\globalmods\apoc\data\accessories\buildings\office1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\office1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office2.txt" ".\data\globalmods\apoc\data\accessories\buildings\office2.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office2burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\office2burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office3.txt" ".\data\globalmods\apoc\data\accessories\buildings\office3.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office4.txt" ".\data\globalmods\apoc\data\accessories\buildings\office4.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\office5.txt" ".\data\globalmods\apoc\data\accessories\buildings\office5.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\skyscraper1.txt" ".\data\globalmods\apoc\data\accessories\buildings\skyscraper1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\skyscraper1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\skyscraper1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\skyscraper2.txt" ".\data\globalmods\apoc\data\accessories\buildings\skyscraper2.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\skyscraper3.txt" ".\data\globalmods\apoc\data\accessories\buildings\skyscraper3.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\stadium.bmp" ".\data\globalmods\apoc\data\accessories\buildings\stadium.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\stadium.txt" ".\data\globalmods\apoc\data\accessories\buildings\stadium.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\store1.txt" ".\data\globalmods\apoc\data\accessories\buildings\store1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\store1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\store1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\trailorhouse1.txt" ".\data\globalmods\apoc\data\accessories\buildings\trailorhouse1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\buildings\trailorhouse1burnt.txt" ".\data\globalmods\apoc\data\accessories\buildings\trailorhouse1burnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\molten.bmp" ".\data\globalmods\apoc\data\accessories\molten.bmp" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\accessories\objects"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\9volt.txt" ".\data\globalmods\apoc\data\accessories\objects\9volt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\acidpod.bmp" ".\data\globalmods\apoc\data\accessories\objects\acidpod.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\acidpod.txt" ".\data\globalmods\apoc\data\accessories\objects\acidpod.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\atom.txt" ".\data\globalmods\apoc\data\accessories\objects\atom.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\brownrock1.txt" ".\data\globalmods\apoc\data\accessories\objects\brownrock1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\brownrock2.txt" ".\data\globalmods\apoc\data\accessories\objects\brownrock2.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\brownrock3.txt" ".\data\globalmods\apoc\data\accessories\objects\brownrock3.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\brownrock4.txt" ".\data\globalmods\apoc\data\accessories\objects\brownrock4.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cactus.txt" ".\data\globalmods\apoc\data\accessories\objects\cactus.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cactusburnt.txt" ".\data\globalmods\apoc\data\accessories\objects\cactusburnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cactussmall.txt" ".\data\globalmods\apoc\data\accessories\objects\cactussmall.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cactussmallburnt.txt" ".\data\globalmods\apoc\data\accessories\objects\cactussmallburnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cash.txt" ".\data\globalmods\apoc\data\accessories\objects\cash.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\container.txt" ".\data\globalmods\apoc\data\accessories\objects\container.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cow1.txt" ".\data\globalmods\apoc\data\accessories\objects\cow1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\cowmat.bmp" ".\data\globalmods\apoc\data\accessories\objects\cowmat.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\deer1.txt" ".\data\globalmods\apoc\data\accessories\objects\deer1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\deer2.txt" ".\data\globalmods\apoc\data\accessories\objects\deer2.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\deerburnt.txt" ".\data\globalmods\apoc\data\accessories\objects\deerburnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\earth.bmp" ".\data\globalmods\apoc\data\accessories\objects\earth.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\earth.txt" ".\data\globalmods\apoc\data\accessories\objects\earth.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\earth_half.txt" ".\data\globalmods\apoc\data\accessories\objects\earth_half.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\fleshpod.bmp" ".\data\globalmods\apoc\data\accessories\objects\fleshpod.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\fleshpod.txt" ".\data\globalmods\apoc\data\accessories\objects\fleshpod.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\fuelbarrel.txt" ".\data\globalmods\apoc\data\accessories\objects\fuelbarrel.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\medkit.txt" ".\data\globalmods\apoc\data\accessories\objects\medkit.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\mushroom.txt" ".\data\globalmods\apoc\data\accessories\objects\mushroom.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\objs1.bmp" ".\data\globalmods\apoc\data\accessories\objects\objs1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\objs2.bmp" ".\data\globalmods\apoc\data\accessories\objects\objs2.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\parachute.txt" ".\data\globalmods\apoc\data\accessories\objects\parachute.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\rock1.txt" ".\data\globalmods\apoc\data\accessories\objects\rock1.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\rock2.txt" ".\data\globalmods\apoc\data\accessories\objects\rock2.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\rock3.txt" ".\data\globalmods\apoc\data\accessories\objects\rock3.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\rock4.txt" ".\data\globalmods\apoc\data\accessories\objects\rock4.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\satellite.bmp" ".\data\globalmods\apoc\data\accessories\objects\satellite.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\satellite.txt" ".\data\globalmods\apoc\data\accessories\objects\satellite.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\smalloakburnt.txt" ".\data\globalmods\apoc\data\accessories\objects\smalloakburnt.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\objects\smalloakfall.txt" ".\data\globalmods\apoc\data\accessories\objects\smalloakfall.txt" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\accessories\people"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\people\male1_soldier.bmp" ".\data\globalmods\apoc\data\accessories\people\male1_soldier.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\people\male1_soldier.txt" ".\data\globalmods\apoc\data\accessories\people\male1_soldier.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\people\male1_soldier_standing.txt" ".\data\globalmods\apoc\data\accessories\people\male1_soldier_standing.txt" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\50cal.txt" ".\data\globalmods\apoc\data\accessories\weapons\50cal.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\bullet.txt" ".\data\globalmods\apoc\data\accessories\weapons\bullet.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\fthrower.txt" ".\data\globalmods\apoc\data\accessories\weapons\fthrower.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\fusionbarrel.txt" ".\data\globalmods\apoc\data\accessories\weapons\fusionbarrel.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\grenade.txt" ".\data\globalmods\apoc\data\accessories\weapons\grenade.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\m7a3.txt" ".\data\globalmods\apoc\data\accessories\weapons\m7a3.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\megamirv.txt" ".\data\globalmods\apoc\data\accessories\weapons\megamirv.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\moab.txt" ".\data\globalmods\apoc\data\accessories\weapons\moab.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\redhornet.txt" ".\data\globalmods\apoc\data\accessories\weapons\redhornet.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\redhornet_anim.txt" ".\data\globalmods\apoc\data\accessories\weapons\redhornet_anim.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\shockbomblet.txt" ".\data\globalmods\apoc\data\accessories\weapons\shockbomblet.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\shockrocket.txt" ".\data\globalmods\apoc\data\accessories\weapons\shockrocket.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\shotgunshell.txt" ".\data\globalmods\apoc\data\accessories\weapons\shotgunshell.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\tsarbomba.txt" ".\data\globalmods\apoc\data\accessories\weapons\tsarbomba.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\weapons1.bmp" ".\data\globalmods\apoc\data\accessories\weapons\weapons1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories\weapons\wobblebomb.txt" ".\data\globalmods\apoc\data\accessories\weapons\wobblebomb.txt" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\50cal" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\boulders" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\brownboulders" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\bullet" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\cactus" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\church1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\cityoffice" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\common" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\deer" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\factory1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\farm1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\fusionbarrel" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\gasstation1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\grenade" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\house1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\logcabin1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\m7a3grenade" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\napalm" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\office3" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\officeplaza1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\redhornet" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\remorcebomblet" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\shockbomblet" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\shockrocket" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\shotgun" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\skyscraper1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\smalloak" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\store1" 
RMDir /r "$INSTDIR\.\data\globalmods\apoc\data\accessories\trailorhouse1" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\accessories.xml" ".\data\globalmods\apoc\data\accessories.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\ambientsoundbuildings.xml" ".\data\globalmods\apoc\data\landscapes\ambientsoundbuildings.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\ambientsoundcars.xml" ".\data\globalmods\apoc\data\landscapes\ambientsoundcars.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\ambientsoundhelicopter.xml" ".\data\globalmods\apoc\data\landscapes\ambientsoundhelicopter.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\apoccity-pic.bmp" ".\data\globalmods\apoc\data\landscapes\apoccity-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\apoccity.bmp" ".\data\globalmods\apoc\data\landscapes\apoccity.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\bighill-pic.bmp" ".\data\globalmods\apoc\data\landscapes\bighill-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\boidsah64d.xml" ".\data\globalmods\apoc\data\landscapes\boidsah64d.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\boidscity.xml" ".\data\globalmods\apoc\data\landscapes\boidscity.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\boidsf18.xml" ".\data\globalmods\apoc\data\landscapes\boidsf18.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\boidshornets.xml" ".\data\globalmods\apoc\data\landscapes\boidshornets.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\bullseye.bmp" ".\data\globalmods\apoc\data\landscapes\bullseye.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\cars.bmp" ".\data\globalmods\apoc\data\landscapes\cars.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\cars2.bmp" ".\data\globalmods\apoc\data\landscapes\cars2.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\carsa.bmp" ".\data\globalmods\apoc\data\landscapes\carsa.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\castle-pic.bmp" ".\data\globalmods\apoc\data\landscapes\castle-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\colosseum-pic.bmp" ".\data\globalmods\apoc\data\landscapes\colosseum-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\craters-pic.bmp" ".\data\globalmods\apoc\data\landscapes\craters-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnapoccity.xml" ".\data\globalmods\apoc\data\landscapes\defnapoccity.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnarizonaislands.xml" ".\data\globalmods\apoc\data\landscapes\defnarizonaislands.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnbighill.xml" ".\data\globalmods\apoc\data\landscapes\defnbighill.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnbullseye.xml" ".\data\globalmods\apoc\data\landscapes\defnbullseye.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defncastle.xml" ".\data\globalmods\apoc\data\landscapes\defncastle.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defncolosseum.xml" ".\data\globalmods\apoc\data\landscapes\defncolosseum.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defncraters.xml" ".\data\globalmods\apoc\data\landscapes\defncraters.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defndesertmesa.xml" ".\data\globalmods\apoc\data\landscapes\defndesertmesa.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defndonuthills.xml" ".\data\globalmods\apoc\data\landscapes\defndonuthills.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnhexisle.xml" ".\data\globalmods\apoc\data\landscapes\defnhexisle.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnmaze.xml" ".\data\globalmods\apoc\data\landscapes\defnmaze.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnmoon.xml" ".\data\globalmods\apoc\data\landscapes\defnmoon.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnmountains.xml" ".\data\globalmods\apoc\data\landscapes\defnmountains.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnnexuscanyon.xml" ".\data\globalmods\apoc\data\landscapes\defnnexuscanyon.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnpillars.xml" ".\data\globalmods\apoc\data\landscapes\defnpillars.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnplateau.xml" ".\data\globalmods\apoc\data\landscapes\defnplateau.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnpyramids.xml" ".\data\globalmods\apoc\data\landscapes\defnpyramids.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnpyramids2.xml" ".\data\globalmods\apoc\data\landscapes\defnpyramids2.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnruffles.xml" ".\data\globalmods\apoc\data\landscapes\defnruffles.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnsteppes.xml" ".\data\globalmods\apoc\data\landscapes\defnsteppes.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnterraces.xml" ".\data\globalmods\apoc\data\landscapes\defnterraces.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defntwotowers.xml" ".\data\globalmods\apoc\data\landscapes\defntwotowers.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnusa.xml" ".\data\globalmods\apoc\data\landscapes\defnusa.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnvolcano.xml" ".\data\globalmods\apoc\data\landscapes\defnvolcano.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnweathered.xml" ".\data\globalmods\apoc\data\landscapes\defnweathered.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\defnworld.xml" ".\data\globalmods\apoc\data\landscapes\defnworld.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\desertmesa-pic.bmp" ".\data\globalmods\apoc\data\landscapes\desertmesa-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\dirt.bmp" ".\data\globalmods\apoc\data\landscapes\dirt.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\donuthills-pic.bmp" ".\data\globalmods\apoc\data\landscapes\donuthills-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\eventsatellitecrash.xml" ".\data\globalmods\apoc\data\landscapes\eventsatellitecrash.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\eventscargodrop.xml" ".\data\globalmods\apoc\data\landscapes\eventscargodrop.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\eventsflamespurt.xml" ".\data\globalmods\apoc\data\landscapes\eventsflamespurt.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\farmland.bmp" ".\data\globalmods\apoc\data\landscapes\farmland.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\farmlanda.bmp" ".\data\globalmods\apoc\data\landscapes\farmlanda.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\hexisle-pic.bmp" ".\data\globalmods\apoc\data\landscapes\hexisle-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\moon-pic.bmp" ".\data\globalmods\apoc\data\landscapes\moon-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\mountains-pic.bmp" ".\data\globalmods\apoc\data\landscapes\mountains-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\nexuscanyon-pic.bmp" ".\data\globalmods\apoc\data\landscapes\nexuscanyon-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\pillars-pic.bmp" ".\data\globalmods\apoc\data\landscapes\pillars-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placebuildings.xml" ".\data\globalmods\apoc\data\landscapes\placebuildings.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placecity1.xml" ".\data\globalmods\apoc\data\landscapes\placecity1.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placecity2.xml" ".\data\globalmods\apoc\data\landscapes\placecity2.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placecity3.xml" ".\data\globalmods\apoc\data\landscapes\placecity3.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placecityport.xml" ".\data\globalmods\apoc\data\landscapes\placecityport.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placedesert.xml" ".\data\globalmods\apoc\data\landscapes\placedesert.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placefleshpods.xml" ".\data\globalmods\apoc\data\landscapes\placefleshpods.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placeigloo.xml" ".\data\globalmods\apoc\data\landscapes\placeigloo.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placemoon.xml" ".\data\globalmods\apoc\data\landscapes\placemoon.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placeoak2_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placeoak2_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placeoak_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placeoak_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placepalm2_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placepalm2_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placepalm_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placepalm_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placepine2_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placepine2_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placepine_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placepine_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placesnowpine_bldg.xml" ".\data\globalmods\apoc\data\landscapes\placesnowpine_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placesummercitypine.xml" ".\data\globalmods\apoc\data\landscapes\placesummercitypine.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placeusa_summer.xml" ".\data\globalmods\apoc\data\landscapes\placeusa_summer.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\placewintercitypine.xml" ".\data\globalmods\apoc\data\landscapes\placewintercitypine.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\plateau-pic.bmp" ".\data\globalmods\apoc\data\landscapes\plateau-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\pyramids-pic.bmp" ".\data\globalmods\apoc\data\landscapes\pyramids-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\pyramids-v2-pic.bmp" ".\data\globalmods\apoc\data\landscapes\pyramids-v2-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\roads1.bmp" ".\data\globalmods\apoc\data\landscapes\roads1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\roads1a.bmp" ".\data\globalmods\apoc\data\landscapes\roads1a.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\ruffles-pic.bmp" ".\data\globalmods\apoc\data\landscapes\ruffles-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\steppes-pic.bmp" ".\data\globalmods\apoc\data\landscapes\steppes-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\terraces-pic.bmp" ".\data\globalmods\apoc\data\landscapes\terraces-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texarizona_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texarizona_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texasianspring_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texasianspring_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcastle_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texcastle_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texchina_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texchina_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity1_storm.xml" ".\data\globalmods\apoc\data\landscapes\texcity1_storm.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity1_summer.xml" ".\data\globalmods\apoc\data\landscapes\texcity1_summer.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity1_winter.xml" ".\data\globalmods\apoc\data\landscapes\texcity1_winter.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity2_storm.xml" ".\data\globalmods\apoc\data\landscapes\texcity2_storm.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity2_summer.xml" ".\data\globalmods\apoc\data\landscapes\texcity2_summer.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity2_winter.xml" ".\data\globalmods\apoc\data\landscapes\texcity2_winter.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity3_storm.xml" ".\data\globalmods\apoc\data\landscapes\texcity3_storm.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity3_summer.xml" ".\data\globalmods\apoc\data\landscapes\texcity3_summer.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texcity3_winter.xml" ".\data\globalmods\apoc\data\landscapes\texcity3_winter.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texdefault_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texdefault_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texdenali_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texdenali_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texdesert.xml" ".\data\globalmods\apoc\data\landscapes\texdesert.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texhell.xml" ".\data\globalmods\apoc\data\landscapes\texhell.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texice.xml" ".\data\globalmods\apoc\data\landscapes\texice.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texice_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texice_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texmoon.xml" ".\data\globalmods\apoc\data\landscapes\texmoon.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texnight_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texnight_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texsand_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texsand_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texsnow_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texsnow_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texstorm_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texstorm_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\textropical_bldg.xml" ".\data\globalmods\apoc\data\landscapes\textropical_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\textuscan_bldg.xml" ".\data\globalmods\apoc\data\landscapes\textuscan_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texusa_summer.xml" ".\data\globalmods\apoc\data\landscapes\texusa_summer.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\texvulcano_bldg.xml" ".\data\globalmods\apoc\data\landscapes\texvulcano_bldg.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\twotowers-pic.bmp" ".\data\globalmods\apoc\data\landscapes\twotowers-pic.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes\weathered-pic.bmp" ".\data\globalmods\apoc\data\landscapes\weathered-pic.bmp" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\landscapes\hillcity-pic.bmp" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\landscapes\hillcity.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\landscapes.xml" ".\data\globalmods\apoc\data\landscapes.xml" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\meshes"
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\meshes\737ua"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\737ua\737ua.bmp" ".\data\globalmods\apoc\data\meshes\737ua\737ua.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\737ua\737ua.txt" ".\data\globalmods\apoc\data\meshes\737ua\737ua.txt" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\meshes\cessna"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\cessna\body.bmp" ".\data\globalmods\apoc\data\meshes\cessna\body.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\cessna\cessna.txt" ".\data\globalmods\apoc\data\meshes\cessna\cessna.txt" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\meshes\fight4life"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\fight4life\body1.bmp" ".\data\globalmods\apoc\data\meshes\fight4life\body1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\fight4life\body2.bmp" ".\data\globalmods\apoc\data\meshes\fight4life\body2.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\meshes\fight4life\fight4life.txt" ".\data\globalmods\apoc\data\meshes\fight4life\fight4life.txt" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\modinfo.xml" ".\data\globalmods\apoc\data\modinfo.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\singleeasy.xml" ".\data\globalmods\apoc\data\singleeasy.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\singlehard.xml" ".\data\globalmods\apoc\data\singlehard.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\singlenormal.xml" ".\data\globalmods\apoc\data\singlenormal.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\singletarget.xml" ".\data\globalmods\apoc\data\singletarget.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\tankais.xml" ".\data\globalmods\apoc\data\tankais.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_1.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_10.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_10.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_11.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_11.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_12.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_12.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_2.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_2.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_3.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_3.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_4.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_4.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_5.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_5.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_6.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_6.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_7.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_7.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_8.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_8.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\lava00_9.bmp" ".\data\globalmods\apoc\data\textures\explode\lava00_9.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\light01_1.bmp" ".\data\globalmods\apoc\data\textures\explode\light01_1.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\explode\smoke_orange.bmp" ".\data\globalmods\apoc\data\textures\explode\smoke_orange.bmp" 
CreateDirectory "$INSTDIR\.\data\globalmods\apoc\data\textures\landscape\desert"
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\landscape\desert\surround.bmp" ".\data\globalmods\apoc\data\textures\landscape\desert\surround.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\landscape\moon\earth.bmp" ".\data\globalmods\apoc\data\textures\landscape\moon\earth.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\landscape\moon\sky.bmp" ".\data\globalmods\apoc\data\textures\landscape\moon\sky.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\landscape\moon\stars.bmp" ".\data\globalmods\apoc\data\textures\landscape\moon\stars.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\wicons\fthrower.bmp" ".\data\globalmods\apoc\data\textures\wicons\fthrower.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\wicons\harmor.bmp" ".\data\globalmods\apoc\data\textures\wicons\harmor.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\wicons\larmor.bmp" ".\data\globalmods\apoc\data\textures\wicons\larmor.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\wicons\mirror.bmp" ".\data\globalmods\apoc\data\textures\wicons\mirror.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\wicons\satellite.bmp" ".\data\globalmods\apoc\data\textures\wicons\satellite.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textures\wicons\volcano.bmp" ".\data\globalmods\apoc\data\textures\wicons\volcano.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\textureset.xml" ".\data\globalmods\apoc\data\textureset.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\acid.wav" ".\data\globalmods\apoc\data\wav\explosions\acid.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\beesting.wav" ".\data\globalmods\apoc\data\wav\explosions\beesting.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\empsmall.wav" ".\data\globalmods\apoc\data\wav\explosions\empsmall.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\exp.wav" ".\data\globalmods\apoc\data\wav\explosions\exp.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\quake.wav" ".\data\globalmods\apoc\data\wav\explosions\quake.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\radiation.wav" ".\data\globalmods\apoc\data\wav\explosions\radiation.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\tank.wav" ".\data\globalmods\apoc\data\wav\explosions\tank.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\explosions\thud.wav" ".\data\globalmods\apoc\data\wav\explosions\thud.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\beamup.wav" ".\data\globalmods\apoc\data\wav\misc\beamup.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\carhorn3.wav" ".\data\globalmods\apoc\data\wav\misc\carhorn3.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\cessna.wav" ".\data\globalmods\apoc\data\wav\misc\cessna.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\cheeringloop.wav" ".\data\globalmods\apoc\data\wav\misc\cheeringloop.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\cows.wav" ".\data\globalmods\apoc\data\wav\misc\cows.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\extralife.wav" ".\data\globalmods\apoc\data\wav\misc\extralife.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\factoryloop1.wav" ".\data\globalmods\apoc\data\wav\misc\factoryloop1.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\fight4life.wav" ".\data\globalmods\apoc\data\wav\misc\fight4life.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\firetruck.wav" ".\data\globalmods\apoc\data\wav\misc\firetruck.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\lockon.wav" ".\data\globalmods\apoc\data\wav\misc\lockon.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\moo.wav" ".\data\globalmods\apoc\data\wav\misc\moo.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\nuclearloop.wav" ".\data\globalmods\apoc\data\wav\misc\nuclearloop.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\policecar.wav" ".\data\globalmods\apoc\data\wav\misc\policecar.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\riftcollapse.wav" ".\data\globalmods\apoc\data\wav\misc\riftcollapse.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\rooster.wav" ".\data\globalmods\apoc\data\wav\misc\rooster.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\scream1.wav" ".\data\globalmods\apoc\data\wav\misc\scream1.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\scream2.wav" ".\data\globalmods\apoc\data\wav\misc\scream2.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\scream3.wav" ".\data\globalmods\apoc\data\wav\misc\scream3.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\scream4.wav" ".\data\globalmods\apoc\data\wav\misc\scream4.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\screaming.wav" ".\data\globalmods\apoc\data\wav\misc\screaming.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\misc\sheep.wav" ".\data\globalmods\apoc\data\wav\misc\sheep.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\shoot\launch.wav" ".\data\globalmods\apoc\data\wav\shoot\launch.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\wav\shoot\machinegun.wav" ".\data\globalmods\apoc\data\wav\shoot\machinegun.wav" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\windows\plan.bmp" ".\data\globalmods\apoc\data\windows\plan.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\windows\plana.bmp" ".\data\globalmods\apoc\data\windows\plana.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\windows\playera.bmp" ".\data\globalmods\apoc\data\windows\playera.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\windows\weapona.bmp" ".\data\globalmods\apoc\data\windows\weapona.bmp" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\data\windows\winda.bmp" ".\data\globalmods\apoc\data\windows\winda.bmp" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\.#landscapesdefn.xml.1.9" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\landscapesdefn.xml" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\landscapesplace.xml" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\landscapessound.xml" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\landscapestex.xml" 
Delete "$INSTDIR\.\data\globalmods\apoc\data\singlegames.xml" 
File "/oname=$INSTDIR\.\data\globalmods\apoc\readme.txt" ".\data\globalmods\apoc\readme.txt" 
File "/oname=$INSTDIR\.\data\html\server\banned.html" ".\data\html\server\banned.html" 
File "/oname=$INSTDIR\.\data\html\server\game.html" ".\data\html\server\game.html" 
File "/oname=$INSTDIR\.\data\html\server\header.html" ".\data\html\server\header.html" 
File "/oname=$INSTDIR\.\data\html\server\log.html" ".\data\html\server\log.html" 
File "/oname=$INSTDIR\.\data\html\server\logfile.html" ".\data\html\server\logfile.html" 
File "/oname=$INSTDIR\.\data\html\server\logfiles.html" ".\data\html\server\logfiles.html" 
File "/oname=$INSTDIR\.\data\html\server\menu.html" ".\data\html\server\menu.html" 
File "/oname=$INSTDIR\.\data\html\server\message.html" ".\data\html\server\message.html" 
File "/oname=$INSTDIR\.\data\html\server\mods.html" ".\data\html\server\mods.html" 
File "/oname=$INSTDIR\.\data\html\server\player.html" ".\data\html\server\player.html" 
File "/oname=$INSTDIR\.\data\html\server\server.css" ".\data\html\server\server.css" 
File "/oname=$INSTDIR\.\data\html\server\server.html" ".\data\html\server\server.html" 
File "/oname=$INSTDIR\.\data\html\server\settings.html" ".\data\html\server\settings.html" 
File "/oname=$INSTDIR\.\data\html\server\talk.html" ".\data\html\server\talk.html" 
File "/oname=$INSTDIR\.\data\keys.xml" ".\data\keys.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundjet.xml" ".\data\landscapes\ambientsoundjet.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundjungle.xml" ".\data\landscapes\ambientsoundjungle.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundlava.xml" ".\data\landscapes\ambientsoundlava.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundnight.xml" ".\data\landscapes\ambientsoundnight.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundrain.xml" ".\data\landscapes\ambientsoundrain.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundtrees.xml" ".\data\landscapes\ambientsoundtrees.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ambientsoundwaves.xml" ".\data\landscapes\ambientsoundwaves.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ascencion-pic.bmp" ".\data\landscapes\ascencion-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\ascencion.bmp" ".\data\landscapes\ascencion.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\boidsah64.xml" ".\data\landscapes\boidsah64.xml" 
File "/oname=$INSTDIR\.\data\landscapes\boidsbats.xml" ".\data\landscapes\boidsbats.xml" 
File "/oname=$INSTDIR\.\data\landscapes\boidsf16.xml" ".\data\landscapes\boidsf16.xml" 
File "/oname=$INSTDIR\.\data\landscapes\boidsf18.xml" ".\data\landscapes\boidsf18.xml" 
File "/oname=$INSTDIR\.\data\landscapes\boidsgulls.xml" ".\data\landscapes\boidsgulls.xml" 
File "/oname=$INSTDIR\.\data\landscapes\boidsparrot.xml" ".\data\landscapes\boidsparrot.xml" 
File "/oname=$INSTDIR\.\data\landscapes\boidst38.xml" ".\data\landscapes\boidst38.xml" 
File "/oname=$INSTDIR\.\data\landscapes\canyon-pic.bmp" ".\data\landscapes\canyon-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\canyon.bmp" ".\data\landscapes\canyon.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\cavern-pic.bmp" ".\data\landscapes\cavern-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\defnascencion.xml" ".\data\landscapes\defnascencion.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defncanyon.xml" ".\data\landscapes\defncanyon.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defncavern.xml" ".\data\landscapes\defncavern.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defndenali.xml" ".\data\landscapes\defndenali.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnglaciation.xml" ".\data\landscapes\defnglaciation.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnhalfed.xml" ".\data\landscapes\defnhalfed.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnhilly.xml" ".\data\landscapes\defnhilly.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnicebergs2.xml" ".\data\landscapes\defnicebergs2.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnicebergs3.xml" ".\data\landscapes\defnicebergs3.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnislands.xml" ".\data\landscapes\defnislands.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnlowlands.xml" ".\data\landscapes\defnlowlands.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnoldstyle.xml" ".\data\landscapes\defnoldstyle.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnridge.xml" ".\data\landscapes\defnridge.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnspike.xml" ".\data\landscapes\defnspike.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defntest.xml" ".\data\landscapes\defntest.xml" 
File "/oname=$INSTDIR\.\data\landscapes\defnvalley.xml" ".\data\landscapes\defnvalley.xml" 
File "/oname=$INSTDIR\.\data\landscapes\denali-pic.bmp" ".\data\landscapes\denali-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\denali.bmp" ".\data\landscapes\denali.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\eventslightning.xml" ".\data\landscapes\eventslightning.xml" 
File "/oname=$INSTDIR\.\data\landscapes\eventsmeteor.xml" ".\data\landscapes\eventsmeteor.xml" 
File "/oname=$INSTDIR\.\data\landscapes\eventstest.xml" ".\data\landscapes\eventstest.xml" 
File "/oname=$INSTDIR\.\data\landscapes\glaciation-pic.bmp" ".\data\landscapes\glaciation-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\glaciation.bmp" ".\data\landscapes\glaciation.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\halfed-pic.bmp" ".\data\landscapes\halfed-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\hilly-pic.bmp" ".\data\landscapes\hilly-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\icebergs002-pic.bmp" ".\data\landscapes\icebergs002-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\icebergs002.bmp" ".\data\landscapes\icebergs002.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\icebergs003-pic.bmp" ".\data\landscapes\icebergs003-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\icebergs003.bmp" ".\data\landscapes\icebergs003.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\islands-pic.bmp" ".\data\landscapes\islands-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\nomask.bmp" ".\data\landscapes\nomask.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\oldstyle-pic.bmp" ".\data\landscapes\oldstyle-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\parking.bmp" ".\data\landscapes\parking.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\parkinga.bmp" ".\data\landscapes\parkinga.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\path.bmp" ".\data\landscapes\path.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\patha.bmp" ".\data\landscapes\patha.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\placeburntpine.xml" ".\data\landscapes\placeburntpine.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placedenali.xml" ".\data\landscapes\placedenali.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placenone.xml" ".\data\landscapes\placenone.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placeoak.xml" ".\data\landscapes\placeoak.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placeoak2.xml" ".\data\landscapes\placeoak2.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placepalm.xml" ".\data\landscapes\placepalm.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placepalm2.xml" ".\data\landscapes\placepalm2.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placepine.xml" ".\data\landscapes\placepine.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placepine2.xml" ".\data\landscapes\placepine2.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placepingu.xml" ".\data\landscapes\placepingu.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placesnowpine.xml" ".\data\landscapes\placesnowpine.xml" 
File "/oname=$INSTDIR\.\data\landscapes\placetest.xml" ".\data\landscapes\placetest.xml" 
File "/oname=$INSTDIR\.\data\landscapes\ridge-pic.bmp" ".\data\landscapes\ridge-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\shipsdestroyer1.xml" ".\data\landscapes\shipsdestroyer1.xml" 
File "/oname=$INSTDIR\.\data\landscapes\shipsdestroyer2.xml" ".\data\landscapes\shipsdestroyer2.xml" 
File "/oname=$INSTDIR\.\data\landscapes\shipsfish.xml" ".\data\landscapes\shipsfish.xml" 
File "/oname=$INSTDIR\.\data\landscapes\shipspirate.xml" ".\data\landscapes\shipspirate.xml" 
File "/oname=$INSTDIR\.\data\landscapes\shipssail.xml" ".\data\landscapes\shipssail.xml" 
File "/oname=$INSTDIR\.\data\landscapes\shipssub.xml" ".\data\landscapes\shipssub.xml" 
File "/oname=$INSTDIR\.\data\landscapes\spike-pic.bmp" ".\data\landscapes\spike-pic.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\spike.bmp" ".\data\landscapes\spike.bmp" 
File "/oname=$INSTDIR\.\data\landscapes\texarizona.xml" ".\data\landscapes\texarizona.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texasianspring.xml" ".\data\landscapes\texasianspring.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texcastle.xml" ".\data\landscapes\texcastle.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texcavern.xml" ".\data\landscapes\texcavern.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texchina.xml" ".\data\landscapes\texchina.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texdefault.xml" ".\data\landscapes\texdefault.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texdenali.xml" ".\data\landscapes\texdenali.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texhell.xml" ".\data\landscapes\texhell.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texice.xml" ".\data\landscapes\texice.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texnight.xml" ".\data\landscapes\texnight.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texplage.xml" ".\data\landscapes\texplage.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texsahara.xml" ".\data\landscapes\texsahara.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texsand.xml" ".\data\landscapes\texsand.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texsnow.xml" ".\data\landscapes\texsnow.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texstorm.xml" ".\data\landscapes\texstorm.xml" 
File "/oname=$INSTDIR\.\data\landscapes\textropical.xml" ".\data\landscapes\textropical.xml" 
File "/oname=$INSTDIR\.\data\landscapes\textuscan.xml" ".\data\landscapes\textuscan.xml" 
File "/oname=$INSTDIR\.\data\landscapes\texvulcano.xml" ".\data\landscapes\texvulcano.xml" 
File "/oname=$INSTDIR\.\data\landscapes\valley-pic.bmp" ".\data\landscapes\valley-pic.bmp" 
Delete "$INSTDIR\.\data\landscapes\halved.bmp" 
Delete "$INSTDIR\.\data\landscapes\hilly.bmp" 
Delete "$INSTDIR\.\data\landscapes\islands.bmp" 
Delete "$INSTDIR\.\data\landscapes\lowlands.bmp" 
Delete "$INSTDIR\.\data\landscapes\oldstyle.bmp" 
Delete "$INSTDIR\.\data\landscapes\ridge.bmp" 
Delete "$INSTDIR\.\data\landscapes\valley.bmp" 
File "/oname=$INSTDIR\.\data\landscapes.xml" ".\data\landscapes.xml" 
File "/oname=$INSTDIR\.\data\meshes\ah64d\ah64d.txt" ".\data\meshes\ah64d\ah64d.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\arara"
File "/oname=$INSTDIR\.\data\meshes\arara\arara.bmp" ".\data\meshes\arara\arara.bmp" 
File "/oname=$INSTDIR\.\data\meshes\arara\arara.txt" ".\data\meshes\arara\arara.txt" 
File "/oname=$INSTDIR\.\data\meshes\bat\bat.txt" ".\data\meshes\bat\bat.txt" 
File "/oname=$INSTDIR\.\data\meshes\bird.txt" ".\data\meshes\bird.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\carrier"
File "/oname=$INSTDIR\.\data\meshes\carrier\carrier.txt" ".\data\meshes\carrier\carrier.txt" 
File "/oname=$INSTDIR\.\data\meshes\carrier\nimitz.bmp" ".\data\meshes\carrier\nimitz.bmp" 
CreateDirectory "$INSTDIR\.\data\meshes\ddg24"
File "/oname=$INSTDIR\.\data\meshes\ddg24\ddg24.bmp" ".\data\meshes\ddg24\ddg24.bmp" 
File "/oname=$INSTDIR\.\data\meshes\ddg24\ddg24.txt" ".\data\meshes\ddg24\ddg24.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\destroyer"
File "/oname=$INSTDIR\.\data\meshes\destroyer\destroy.bmp" ".\data\meshes\destroyer\destroy.bmp" 
File "/oname=$INSTDIR\.\data\meshes\destroyer\destroyer.txt" ".\data\meshes\destroyer\destroyer.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\f16"
File "/oname=$INSTDIR\.\data\meshes\f16\f16.bmp" ".\data\meshes\f16\f16.bmp" 
File "/oname=$INSTDIR\.\data\meshes\f16\f16.txt" ".\data\meshes\f16\f16.txt" 
File "/oname=$INSTDIR\.\data\meshes\f18\f18.txt" ".\data\meshes\f18\f18.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\fishboat"
File "/oname=$INSTDIR\.\data\meshes\fishboat\fishboat.bmp" ".\data\meshes\fishboat\fishboat.bmp" 
File "/oname=$INSTDIR\.\data\meshes\fishboat\fishboat.txt" ".\data\meshes\fishboat\fishboat.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\jollyroger"
File "/oname=$INSTDIR\.\data\meshes\jollyroger\jollyroger.txt" ".\data\meshes\jollyroger\jollyroger.txt" 
File "/oname=$INSTDIR\.\data\meshes\jollyroger\pflag1.bmp" ".\data\meshes\jollyroger\pflag1.bmp" 
File "/oname=$INSTDIR\.\data\meshes\jollyroger\pflag2.bmp" ".\data\meshes\jollyroger\pflag2.bmp" 
File "/oname=$INSTDIR\.\data\meshes\jollyroger\ship.bmp" ".\data\meshes\jollyroger\ship.bmp" 
CreateDirectory "$INSTDIR\.\data\meshes\sailboat"
File "/oname=$INSTDIR\.\data\meshes\sailboat\sailboat.bmp" ".\data\meshes\sailboat\sailboat.bmp" 
File "/oname=$INSTDIR\.\data\meshes\sailboat\sailboat.txt" ".\data\meshes\sailboat\sailboat.txt" 
File "/oname=$INSTDIR\.\data\meshes\seagull\seagull.txt" ".\data\meshes\seagull\seagull.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\sub"
File "/oname=$INSTDIR\.\data\meshes\sub\black.bmp" ".\data\meshes\sub\black.bmp" 
File "/oname=$INSTDIR\.\data\meshes\sub\sub.txt" ".\data\meshes\sub\sub.txt" 
File "/oname=$INSTDIR\.\data\meshes\survivalraft.txt" ".\data\meshes\survivalraft.txt" 
CreateDirectory "$INSTDIR\.\data\meshes\t38"
File "/oname=$INSTDIR\.\data\meshes\t38\t38.bmp" ".\data\meshes\t38\t38.bmp" 
File "/oname=$INSTDIR\.\data\meshes\t38\t38.txt" ".\data\meshes\t38\t38.txt" 
File "/oname=$INSTDIR\.\data\meshes\t38\t38b.bmp" ".\data\meshes\t38\t38b.bmp" 
File "/oname=$INSTDIR\.\data\meshes\wind.ase" ".\data\meshes\wind.ase" 
File "/oname=$INSTDIR\.\data\modinfo.xml" ".\data\modinfo.xml" 
File "/oname=$INSTDIR\.\data\prunetables.sql" ".\data\prunetables.sql" 
File "/oname=$INSTDIR\.\data\safedisplay.xml" ".\data\safedisplay.xml" 
File "/oname=$INSTDIR\.\data\singletarget.xml" ".\data\singletarget.xml" 
File "/oname=$INSTDIR\.\data\singletutorial.xml" ".\data\singletutorial.xml" 
File "/oname=$INSTDIR\.\data\statstables.sql" ".\data\statstables.sql" 
File "/oname=$INSTDIR\.\data\talk\talk1.txt" ".\data\talk\talk1.txt" 
File "/oname=$INSTDIR\.\data\talk\talk2.txt" ".\data\talk\talk2.txt" 
File "/oname=$INSTDIR\.\data\tankais.xml" ".\data\tankais.xml" 
File "/oname=$INSTDIR\.\data\tanks\battleship\battleship.txt" ".\data\tanks\battleship\battleship.txt" 
File "/oname=$INSTDIR\.\data\tanks\bender\bender-info.txt" ".\data\tanks\bender\bender-info.txt" 
File "/oname=$INSTDIR\.\data\tanks\bender\bender.txt" ".\data\tanks\bender\bender.txt" 
File "/oname=$INSTDIR\.\data\tanks\bm13\bm13-2.txt" ".\data\tanks\bm13\bm13-2.txt" 
File "/oname=$INSTDIR\.\data\tanks\bradley2\bradley2.txt" ".\data\tanks\bradley2\bradley2.txt" 
File "/oname=$INSTDIR\.\data\tanks\cannon\black.bmp" ".\data\tanks\cannon\black.bmp" 
File "/oname=$INSTDIR\.\data\tanks\cannon\cannon.bmp" ".\data\tanks\cannon\cannon.bmp" 
File "/oname=$INSTDIR\.\data\tanks\cannon\cannon.txt" ".\data\tanks\cannon\cannon.txt" 
Delete "$INSTDIR\.\data\tanks\cannon\turretBase.bmp" 
Delete "$INSTDIR\.\data\tanks\cannon\uprights.bmp" 
Delete "$INSTDIR\.\data\tanks\cannon\wheelouter.bmp" 
CreateDirectory "$INSTDIR\.\data\tanks\cannont"
File "/oname=$INSTDIR\.\data\tanks\cannont\base.bmp" ".\data\tanks\cannont\base.bmp" 
File "/oname=$INSTDIR\.\data\tanks\cannont\cannontower.txt" ".\data\tanks\cannont\cannontower.txt" 
File "/oname=$INSTDIR\.\data\tanks\cannont\gun.bmp" ".\data\tanks\cannont\gun.bmp" 
File "/oname=$INSTDIR\.\data\tanks\cannont\side.bmp" ".\data\tanks\cannont\side.bmp" 
File "/oname=$INSTDIR\.\data\tanks\cannont\side2.bmp" ".\data\tanks\cannont\side2.bmp" 
File "/oname=$INSTDIR\.\data\tanks\cannont\top.bmp" ".\data\tanks\cannont\top.bmp" 
File "/oname=$INSTDIR\.\data\tanks\CF-104\104.bmp" ".\data\tanks\CF-104\104.bmp" 
File "/oname=$INSTDIR\.\data\tanks\CF-104\104.txt" ".\data\tanks\CF-104\104.txt" 
Delete "$INSTDIR\.\data\tanks\CF-104\black.bmp" 
Delete "$INSTDIR\.\data\tanks\CF-104\cockpit.bmp" 
Delete "$INSTDIR\.\data\tanks\CF-104\engine.bmp" 
Delete "$INSTDIR\.\data\tanks\CF-104\gunFuselage.bmp" 
Delete "$INSTDIR\.\data\tanks\CF-104\wheel.bmp" 
File "/oname=$INSTDIR\.\data\tanks\death\death.txt" ".\data\tanks\death\death.txt" 
File "/oname=$INSTDIR\.\data\tanks\gorilla\gorilla.txt" ".\data\tanks\gorilla\gorilla.txt" 
File "/oname=$INSTDIR\.\data\tanks\guntower\guntower.txt" ".\data\tanks\guntower\guntower.txt" 
File "/oname=$INSTDIR\.\data\tanks\hawk\hawk.txt" ".\data\tanks\hawk\hawk.txt" 
File "/oname=$INSTDIR\.\data\tanks\helder\helder.txt" ".\data\tanks\helder\helder.txt" 
File "/oname=$INSTDIR\.\data\tanks\helder\helder2.txt" ".\data\tanks\helder\helder2.txt" 
CreateDirectory "$INSTDIR\.\data\tanks\ignignokt"
File "/oname=$INSTDIR\.\data\tanks\ignignokt\ignignokt.bmp" ".\data\tanks\ignignokt\ignignokt.bmp" 
File "/oname=$INSTDIR\.\data\tanks\ignignokt\ignignokt.txt" ".\data\tanks\ignignokt\ignignokt.txt" 
File "/oname=$INSTDIR\.\data\tanks\kenny2.txt" ".\data\tanks\kenny2.txt" 
File "/oname=$INSTDIR\.\data\tanks\lav-25\lav-25.txt" ".\data\tanks\lav-25\lav-25.txt" 
File "/oname=$INSTDIR\.\data\tanks\m1a1\m1a1.txt" ".\data\tanks\m1a1\m1a1.txt" 
File "/oname=$INSTDIR\.\data\tanks\m48\m48.txt" ".\data\tanks\m48\m48.txt" 
File "/oname=$INSTDIR\.\data\tanks\missileturret\missileturret.txt" ".\data\tanks\missileturret\missileturret.txt" 
File "/oname=$INSTDIR\.\data\tanks\mlrs\mlrs.txt" ".\data\tanks\mlrs\mlrs.txt" 
File "/oname=$INSTDIR\.\data\tanks\patriot\patriot.txt" ".\data\tanks\patriot\patriot.txt" 
File "/oname=$INSTDIR\.\data\tanks\photoncannon\photoncannon.txt" ".\data\tanks\photoncannon\photoncannon.txt" 
File "/oname=$INSTDIR\.\data\tanks\sa6\sa6.txt" ".\data\tanks\sa6\sa6.txt" 
CreateDirectory "$INSTDIR\.\data\tanks\sentrygun"
File "/oname=$INSTDIR\.\data\tanks\sentrygun\sentrygun.bmp" ".\data\tanks\sentrygun\sentrygun.bmp" 
File "/oname=$INSTDIR\.\data\tanks\sentrygun\sentrygun.txt" ".\data\tanks\sentrygun\sentrygun.txt" 
File "/oname=$INSTDIR\.\data\tanks\shark.txt" ".\data\tanks\shark.txt" 
File "/oname=$INSTDIR\.\data\tanks\sonic\sonic.txt" ".\data\tanks\sonic\sonic.txt" 
File "/oname=$INSTDIR\.\data\tanks\t90\t90.txt" ".\data\tanks\t90\t90.txt" 
File "/oname=$INSTDIR\.\data\tanks\thel\thel.txt" ".\data\tanks\thel\thel.txt" 
File "/oname=$INSTDIR\.\data\tanks\tiger2\tiger2.txt" ".\data\tanks\tiger2\tiger2.txt" 
File "/oname=$INSTDIR\.\data\tanks\towedartillery2\towedartillery2.txt" ".\data\tanks\towedartillery2\towedartillery2.txt" 
File "/oname=$INSTDIR\.\data\tanks\tracksh.bmp" ".\data\tanks\tracksh.bmp" 
File "/oname=$INSTDIR\.\data\tanks\trackshv.bmp" ".\data\tanks\trackshv.bmp" 
File "/oname=$INSTDIR\.\data\tanks\tracksv.bmp" ".\data\tanks\tracksv.bmp" 
File "/oname=$INSTDIR\.\data\tanks\tracksvh.bmp" ".\data\tanks\tracksvh.bmp" 
File "/oname=$INSTDIR\.\data\tanks\turret2\turret2.txt" ".\data\tanks\turret2\turret2.txt" 
File "/oname=$INSTDIR\.\data\tanks\tux\tux.txt" ".\data\tanks\tux\tux.txt" 
File "/oname=$INSTDIR\.\data\tanks\zsu23\zsu23.txt" ".\data\tanks\zsu23\zsu23.txt" 
File "/oname=$INSTDIR\.\data\tanks\zsu57\zsu57.txt" ".\data\tanks\zsu57\zsu57.txt" 
RMDir /r "$INSTDIR\.\data\tanks\cannontower" 
File "/oname=$INSTDIR\.\data\tanks.xml" ".\data\tanks.xml" 
File "/oname=$INSTDIR\.\data\tanktypes.xml" ".\data\tanktypes.xml" 
File "/oname=$INSTDIR\.\data\textures\bordershield\hit.bmp" ".\data\textures\bordershield\hit.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\arizona"
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\clearsky.bmp" ".\data\textures\landscape\arizona\clearsky.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\cloud1.bmp" ".\data\textures\landscape\arizona\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\cubemap.bmp" ".\data\textures\landscape\arizona\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\detail.bmp" ".\data\textures\landscape\arizona\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\rockside.bmp" ".\data\textures\landscape\arizona\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\scorch.bmp" ".\data\textures\landscape\arizona\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\shore.bmp" ".\data\textures\landscape\arizona\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\texture0.bmp" ".\data\textures\landscape\arizona\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\texture1.bmp" ".\data\textures\landscape\arizona\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\texture2.bmp" ".\data\textures\landscape\arizona\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\texture3.bmp" ".\data\textures\landscape\arizona\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\texture4.bmp" ".\data\textures\landscape\arizona\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\arizona\water.bmp" ".\data\textures\landscape\arizona\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\asianspring"
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\cloud1.bmp" ".\data\textures\landscape\asianspring\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\cubemap.bmp" ".\data\textures\landscape\asianspring\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\detail.bmp" ".\data\textures\landscape\asianspring\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\rockside.bmp" ".\data\textures\landscape\asianspring\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\scorch.bmp" ".\data\textures\landscape\asianspring\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\shore.bmp" ".\data\textures\landscape\asianspring\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\texture0.bmp" ".\data\textures\landscape\asianspring\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\texture1.bmp" ".\data\textures\landscape\asianspring\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\texture2.bmp" ".\data\textures\landscape\asianspring\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\texture3.bmp" ".\data\textures\landscape\asianspring\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\texture4.bmp" ".\data\textures\landscape\asianspring\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\asianspring\water.bmp" ".\data\textures\landscape\asianspring\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\castle"
File "/oname=$INSTDIR\.\data\textures\landscape\castle\cloud1.bmp" ".\data\textures\landscape\castle\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\cubemap.bmp" ".\data\textures\landscape\castle\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\detail.bmp" ".\data\textures\landscape\castle\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\rockside.bmp" ".\data\textures\landscape\castle\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\scorch.bmp" ".\data\textures\landscape\castle\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\shore.bmp" ".\data\textures\landscape\castle\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\texture0.bmp" ".\data\textures\landscape\castle\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\texture1.bmp" ".\data\textures\landscape\castle\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\texture2.bmp" ".\data\textures\landscape\castle\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\texture3.bmp" ".\data\textures\landscape\castle\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\texture4.bmp" ".\data\textures\landscape\castle\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\castle\water.bmp" ".\data\textures\landscape\castle\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\china"
File "/oname=$INSTDIR\.\data\textures\landscape\china\cloud1.bmp" ".\data\textures\landscape\china\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\cubemap.bmp" ".\data\textures\landscape\china\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\detail.bmp" ".\data\textures\landscape\china\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\rockside.bmp" ".\data\textures\landscape\china\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\scorch.bmp" ".\data\textures\landscape\china\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\shore.bmp" ".\data\textures\landscape\china\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\texture0.bmp" ".\data\textures\landscape\china\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\texture1.bmp" ".\data\textures\landscape\china\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\texture2.bmp" ".\data\textures\landscape\china\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\texture2.jpg" ".\data\textures\landscape\china\texture2.jpg" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\texture3.bmp" ".\data\textures\landscape\china\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\texture4.bmp" ".\data\textures\landscape\china\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\china\water.bmp" ".\data\textures\landscape\china\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\denali"
File "/oname=$INSTDIR\.\data\textures\landscape\denali\cloud1.bmp" ".\data\textures\landscape\denali\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\cubemap.bmp" ".\data\textures\landscape\denali\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\detail.bmp" ".\data\textures\landscape\denali\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\rockside.bmp" ".\data\textures\landscape\denali\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\scorch.bmp" ".\data\textures\landscape\denali\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\shore.bmp" ".\data\textures\landscape\denali\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\texture0.bmp" ".\data\textures\landscape\denali\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\texture1.bmp" ".\data\textures\landscape\denali\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\texture2.bmp" ".\data\textures\landscape\denali\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\texture3.bmp" ".\data\textures\landscape\denali\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\texture4.bmp" ".\data\textures\landscape\denali\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\denali\water.bmp" ".\data\textures\landscape\denali\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\ice"
File "/oname=$INSTDIR\.\data\textures\landscape\ice\cloud1.bmp" ".\data\textures\landscape\ice\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\cubemap.bmp" ".\data\textures\landscape\ice\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\detail.bmp" ".\data\textures\landscape\ice\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\rockside.bmp" ".\data\textures\landscape\ice\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\scorch.bmp" ".\data\textures\landscape\ice\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\shore.bmp" ".\data\textures\landscape\ice\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\texture0.bmp" ".\data\textures\landscape\ice\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\texture1.bmp" ".\data\textures\landscape\ice\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\texture2.bmp" ".\data\textures\landscape\ice\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\texture3.bmp" ".\data\textures\landscape\ice\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\texture4.bmp" ".\data\textures\landscape\ice\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\ice\water.bmp" ".\data\textures\landscape\ice\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\plage"
File "/oname=$INSTDIR\.\data\textures\landscape\plage\cloud1.bmp" ".\data\textures\landscape\plage\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\cubemap.bmp" ".\data\textures\landscape\plage\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\detail.bmp" ".\data\textures\landscape\plage\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\detailold.bmp" ".\data\textures\landscape\plage\detailold.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\rockside.bmp" ".\data\textures\landscape\plage\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\scorch.bmp" ".\data\textures\landscape\plage\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\shore.bmp" ".\data\textures\landscape\plage\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\texture0.bmp" ".\data\textures\landscape\plage\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\texture1.bmp" ".\data\textures\landscape\plage\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\texture2.bmp" ".\data\textures\landscape\plage\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\texture3.bmp" ".\data\textures\landscape\plage\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\texture4.bmp" ".\data\textures\landscape\plage\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\plage\water.bmp" ".\data\textures\landscape\plage\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\sahara"
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\clearsky.bmp" ".\data\textures\landscape\sahara\clearsky.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\cloud1.bmp" ".\data\textures\landscape\sahara\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\cubemap.bmp" ".\data\textures\landscape\sahara\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\detail.bmp" ".\data\textures\landscape\sahara\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\rockside.bmp" ".\data\textures\landscape\sahara\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\scorch.bmp" ".\data\textures\landscape\sahara\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\shore.bmp" ".\data\textures\landscape\sahara\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\texture0.bmp" ".\data\textures\landscape\sahara\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\texture1.bmp" ".\data\textures\landscape\sahara\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\texture2.bmp" ".\data\textures\landscape\sahara\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\texture3.bmp" ".\data\textures\landscape\sahara\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\texture4.bmp" ".\data\textures\landscape\sahara\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\sahara\water.bmp" ".\data\textures\landscape\sahara\water.bmp" 
CreateDirectory "$INSTDIR\.\data\textures\landscape\tuscan"
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\clearsky.bmp" ".\data\textures\landscape\tuscan\clearsky.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\cloud1.bmp" ".\data\textures\landscape\tuscan\cloud1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\cubemap.bmp" ".\data\textures\landscape\tuscan\cubemap.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\detail.bmp" ".\data\textures\landscape\tuscan\detail.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\rockside.bmp" ".\data\textures\landscape\tuscan\rockside.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\scorch.bmp" ".\data\textures\landscape\tuscan\scorch.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\shore.bmp" ".\data\textures\landscape\tuscan\shore.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\texture0.bmp" ".\data\textures\landscape\tuscan\texture0.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\texture1.bmp" ".\data\textures\landscape\tuscan\texture1.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\texture2.bmp" ".\data\textures\landscape\tuscan\texture2.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\texture3.bmp" ".\data\textures\landscape\tuscan\texture3.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\texture4.bmp" ".\data\textures\landscape\tuscan\texture4.bmp" 
File "/oname=$INSTDIR\.\data\textures\landscape\tuscan\water.bmp" ".\data\textures\landscape\tuscan\water.bmp" 
File "/oname=$INSTDIR\.\data\textures\moon.bmp" ".\data\textures\moon.bmp" 
File "/oname=$INSTDIR\.\data\textures\oak.bmp" ".\data\textures\oak.bmp" 
File "/oname=$INSTDIR\.\data\textures\oaka.bmp" ".\data\textures\oaka.bmp" 
File "/oname=$INSTDIR\.\data\textures\palm2.bmp" ".\data\textures\palm2.bmp" 
File "/oname=$INSTDIR\.\data\textures\palm2a.bmp" ".\data\textures\palm2a.bmp" 
File "/oname=$INSTDIR\.\data\textures\pine2.bmp" ".\data\textures\pine2.bmp" 
File "/oname=$INSTDIR\.\data\textures\pine2a.bmp" ".\data\textures\pine2a.bmp" 
File "/oname=$INSTDIR\.\data\textures\pine3.bmp" ".\data\textures\pine3.bmp" 
File "/oname=$INSTDIR\.\data\textures\pine3a.bmp" ".\data\textures\pine3a.bmp" 
File "/oname=$INSTDIR\.\data\textures\shield.bmp" ".\data\textures\shield.bmp" 
File "/oname=$INSTDIR\.\data\textures\shield2.bmp" ".\data\textures\shield2.bmp" 
File "/oname=$INSTDIR\.\data\textures\shielda.bmp" ".\data\textures\shielda.bmp" 
File "/oname=$INSTDIR\.\data\textures\stars.bmp" ".\data\textures\stars.bmp" 
File "/oname=$INSTDIR\.\data\tips.txt" ".\data\tips.txt" 
File "/oname=$INSTDIR\.\data\tutorial.xml" ".\data\tutorial.xml" 
File "/oname=$INSTDIR\.\data\wav\misc\f16_1.wav" ".\data\wav\misc\f16_1.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\f16_2.wav" ".\data\wav\misc\f16_2.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\lava2.wav" ".\data\wav\misc\lava2.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\oceanwaves.wav" ".\data\wav\misc\oceanwaves.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\para.wav" ".\data\wav\misc\para.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\t38.wav" ".\data\wav\misc\t38.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\thunder2.wav" ".\data\wav\misc\thunder2.wav" 
File "/oname=$INSTDIR\.\data\wav\misc\thunder3.wav" ".\data\wav\misc\thunder3.wav" 
File "/oname=$INSTDIR\.\data\wav\movement\elevate.wav" ".\data\wav\movement\elevate.wav" 
File "/oname=$INSTDIR\.\data\wav\movement\power.wav" ".\data\wav\movement\power.wav" 
File "/oname=$INSTDIR\.\data\wav\movement\turn.wav" ".\data\wav\movement\turn.wav" 
File "/oname=$INSTDIR\.\data\wav\shield\activate3.wav" ".\data\wav\shield\activate3.wav" 
File "/oname=$INSTDIR\.\data\wav\shield\activmag.wav" ".\data\wav\shield\activmag.wav" 
File "/oname=$INSTDIR\.\data\windows\bomb.bmp" ".\data\windows\bomb.bmp" 
File "/oname=$INSTDIR\.\data\windows\bomba.bmp" ".\data\windows\bomba.bmp" 
File "/oname=$INSTDIR\.\data\windows\book.bmp" ".\data\windows\book.bmp" 
File "/oname=$INSTDIR\.\data\windows\camera.bmp" ".\data\windows\camera.bmp" 
File "/oname=$INSTDIR\.\data\windows\cameraa.bmp" ".\data\windows\cameraa.bmp" 
File "/oname=$INSTDIR\.\data\windows\client.bmp" ".\data\windows\client.bmp" 
File "/oname=$INSTDIR\.\data\windows\display.bmp" ".\data\windows\display.bmp" 
File "/oname=$INSTDIR\.\data\windows\scorched.gif" ".\data\windows\scorched.gif" 
File "/oname=$INSTDIR\.\data\windows\scorcheda.gif" ".\data\windows\scorcheda.gif" 
File "/oname=$INSTDIR\.\data\windows\screen.bmp" ".\data\windows\screen.bmp" 
File "/oname=$INSTDIR\.\data\windows\screena.bmp" ".\data\windows\screena.bmp" 
File "/oname=$INSTDIR\.\data\windows\server.bmp" ".\data\windows\server.bmp" 
File "/oname=$INSTDIR\.\data\windows\setting.bmp" ".\data\windows\setting.bmp" 
File "/oname=$INSTDIR\.\data\windows\settinga.bmp" ".\data\windows\settinga.bmp" 
File "/oname=$INSTDIR\.\data\windows\tank.bmp" ".\data\windows\tank.bmp" 
File "/oname=$INSTDIR\.\data\windows\triangle.bmp" ".\data\windows\triangle.bmp" 
File "/oname=$INSTDIR\.\data\windows\wait.bmp" ".\data\windows\wait.bmp" 
File "/oname=$INSTDIR\.\data\windows\white.bmp" ".\data\windows\white.bmp" 
Delete "$INSTDIR\.\data\windows\Copy of scorched.gif" 
File "/oname=$INSTDIR\.\data\windows.xml" ".\data\windows.xml" 
Delete "$INSTDIR\.\data\landscapesdefn.xml" 
Delete "$INSTDIR\.\data\landscapesplace.xml" 
Delete "$INSTDIR\.\data\landscapessound.xml" 
Delete "$INSTDIR\.\data\landscapestex.xml" 
Delete "$INSTDIR\.\data\singlegames.xml" 
File "/oname=$INSTDIR\.\documentation\html\modelling.html" ".\documentation\html\modelling.html" 
File "/oname=$INSTDIR\.\ogg.dll" ".\ogg.dll" 
File "/oname=$INSTDIR\.\scorched.exe" ".\scorched.exe" 
File "/oname=$INSTDIR\.\TODO" ".\TODO" 
File "/oname=$INSTDIR\.\uninst.exe" ".\uninst.exe" 
File "/oname=$INSTDIR\.\vorbis.dll" ".\vorbis.dll" 
File "/oname=$INSTDIR\.\vorbisfile.dll" ".\vorbisfile.dll" 








SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}-docs.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}\wiki"
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}-donate.url" "InternetShortcut" "URL" "${PRODUCT_DONATE_WEB_SITE}"
  
  CreateDirectory "$SMPROGRAMS\Scorched3D"
  
  CreateShortCut "$SMPROGRAMS\Scorched3D\Uninstall Scorched3D.lnk" "$INSTDIR\uninst.exe"
  CreateShortCut "$SMPROGRAMS\Scorched3D\Scorched3D.lnk" "$INSTDIR\scorched.exe" "" "$INSTDIR\data\windows\tank2.ico"
  CreateShortCut "$SMPROGRAMS\Scorched3D\Scorched3D Documentation.lnk" "$INSTDIR\${PRODUCT_NAME}-docs.url"
  CreateShortCut "$SMPROGRAMS\Scorched3D\Scorched3D Homepage.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\Scorched3D\Scorched3D Donations.lnk" "$INSTDIR\${PRODUCT_NAME}-donate.url"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Var DEL_USER
Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES remove
  Abort
remove:

  StrCpy $DEL_USER "FALSE"
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Do you want to remove all $(^Name) user data.  Warning: this includes STATS, saved games, mods etc?" IDNO nodel
  StrCpy $DEL_USER "TRUE";
nodel:
FunctionEnd

Section Uninstall

  RMDir /r "$INSTDIR\data"
  RMDir /r "$INSTDIR\documentation"
  RMDir /r "$SMPROGRAMS\Scorched3D"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
  
  StrCmp $DEL_USER "FALSE" nodel
  RMDir /r "$INSTDIR\.scorched3d"
  RMDir /r "$PROFILE\.scorched3d"
nodel:

  Delete "$INSTDIR\*.*"
  RMDir "$INSTDIR"

SectionEnd
