/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.texture;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Pierre Lando
 */
public abstract class AbstractDataProvider<DataUserType extends DataUser> implements DataProvider<DataUserType> {

    private final Set<DataUserType> users = Collections.synchronizedSet(new HashSet<DataUserType>());

    @Override
    public void removeDataUser(DataUserType dataUser) {
        users.remove(dataUser);
    }

    @Override
    public void addDataUser(DataUserType dataUser) {
        users.add(dataUser);
    }

    protected void fireUpdate() {
        for (Object dataUser : users.toArray()) {
            ((DataUserType) dataUser).dataUpdated();
        }
    }
}
