/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.shapes.geometry;

import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;

/**
 *
 * Default implementation of a Geometry.
 *
 * @author Pierre Lando
 */
public class DefaultGeometry implements Geometry {

    private FaceCullingMode faceCullingMode = DEFAULT_FACE_CULLING_MODE;
    private FillDrawingMode fillDrawingMode = DEFAULT_FILL_DRAWING_MODE;
    private LineDrawingMode lineDrawingMode = DEFAULT_LINE_DRAWING_MODE;

    private ElementsBuffer textureCoordinates;
    private ElementsBuffer vertices;
    private ElementsBuffer normals;
    private ElementsBuffer colors;

    private IndicesBuffer wireIndices;
    private IndicesBuffer indices;

    /**
     * Default constructor.
     */
    public DefaultGeometry() {
    }

    @Override
    public FaceCullingMode getFaceCullingMode() {
        return faceCullingMode;
    }

    @Override
    public FillDrawingMode getFillDrawingMode() {
        return fillDrawingMode;
    }

    @Override
    public LineDrawingMode getLineDrawingMode() {
        return lineDrawingMode;
    }

    @Override
    public ElementsBuffer getVertices() {
        return vertices;
    }

    @Override
    public IndicesBuffer getIndices() {
        return indices;
    }

    @Override
    public IndicesBuffer getWireIndices() {
        return wireIndices;
    }

    @Override
    public ElementsBuffer getColors() {
        return colors;
    }

    @Override
    public ElementsBuffer getTextureCoordinates() {
        return textureCoordinates;
    }

    @Override
    public ElementsBuffer getNormals() {
        return normals;
    }

    public void setFaceCullingMode(FaceCullingMode faceCullingMode) {
        this.faceCullingMode = faceCullingMode;
    }

    public void setFillDrawingMode(FillDrawingMode fillDrawingMode) {
        this.fillDrawingMode = fillDrawingMode;
    }

    public void setLineDrawingMode(LineDrawingMode lineDrawingMode) {
        this.lineDrawingMode = lineDrawingMode;
    }

    public void setTextureCoordinates(ElementsBuffer textureCoordinates) {
        this.textureCoordinates = textureCoordinates;
    }

    public void setVertices(ElementsBuffer vertices) {
        this.vertices = vertices;
    }

    public void setNormals(ElementsBuffer normals) {
        this.normals = normals;
    }

    public void setColors(ElementsBuffer colors) {
        this.colors = colors;
    }

    public void setWireIndices(IndicesBuffer wireIndices) {
        this.wireIndices = wireIndices;
    }

    public void setIndices(IndicesBuffer indicesBuffer) {
        this.indices = indicesBuffer;
    }
}
