/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.ruler;

import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.sprite.Sprite;
import org.scilab.forge.scirenderer.sprite.SpriteDrawer;
import org.scilab.forge.scirenderer.sprite.SpriteDrawingTools;
import org.scilab.forge.scirenderer.sprite.SpriteManager;
import org.scilab.forge.scirenderer.sprite.TextEntity;

import java.awt.Dimension;
import java.text.DecimalFormat;

/**
 * @author Pierre Lando
 */
public class DefaultRulerSpriteFactory implements RulerSpriteFactory {

    @Override
    public Sprite create(double value, DecimalFormat adaptedFormat, SpriteManager spriteManager) {
        String text = adaptedFormat.format(value);
        final TextEntity textEntity = new TextEntity(text);
        textEntity.setTextColor(new Color(0, 0, 0));
        textEntity.setTextAntiAliased(false);

        final Dimension dimension = spriteManager.getSize(textEntity);
        Sprite sprite = spriteManager.createSprite(dimension.width, dimension.height);
        sprite.setDrawer(new SpriteDrawer() {

            @Override
            public void draw(SpriteDrawingTools drawingTools) {
                drawingTools.draw(textEntity, 0, 0);
            }

            @Override
            public OriginPosition getOriginPosition() {
                return OriginPosition.UPPER_LEFT;
            }
        });

        return sprite;
    }
}
