/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.simpleRotatingCube;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.picking.PickingTask;
import org.scilab.forge.scirenderer.picking.PickingTools;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * This class is a simple example of picking usage.
 * @author Pierre Lando
 */
public class MouseUnprojectAdapter extends MouseAdapter {

    private final Canvas canvas;

    /**
     * Default constructor.
     * @param canvas the listened canvas.
     */
    public MouseUnprojectAdapter(Canvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void mousePressed(final MouseEvent e) {
        canvas.getPickingManager().addPickingTask(new PickingTask() {
            @Override
            public void perform(PickingTools pickingTools) {
                Vector3d l = pickingTools.getUnderlyingPoint(e.getPoint());
                System.out.println("Click : " + l);
            }
        });
    }
}
