/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.rulerExample;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.forge.scirenderer.ruler.DefaultRulerModel;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

import javax.media.opengl.GLJPanel;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;

/**
 * @author Pierre Lando
 */
public class RulerExample {

    public static void main(String[] arguments) {

        // Create frame.
        JFrame frame = new JFrame("Ruler Example");
        frame.setLayout(new BorderLayout());
        frame.setSize(800, 600);

        // Create panel.
        final GLJPanel panel = new GLJPanel();
        frame.add(panel, BorderLayout.CENTER);

        final BoundedRangeModel zoomLevel = new DefaultBoundedRangeModel(13,0, 1, 1000);


        JPanel buttonsPanel = new JPanel(new FlowLayout());

        final JFormattedTextField minValue = new JFormattedTextField(new DecimalFormat("0.0000"));
        minValue.setValue(1);

        final JFormattedTextField maxValue = new JFormattedTextField(new DecimalFormat("0.0000"));
        maxValue.setValue(4);

        final JCheckBox logBox = new JCheckBox("Log");
        logBox.setSelected(true);

        buttonsPanel.add(minValue);
        buttonsPanel.add(maxValue);
        buttonsPanel.add(logBox);
        buttonsPanel.add(new JSlider(zoomLevel));

        frame.add(buttonsPanel, BorderLayout.SOUTH);

        // SciRenderer canvas.
        final Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        final DefaultRulerModel rulerModel = new DefaultRulerModel();
        rulerModel.setFirstPoint(new Vector3d(1, 0, 0));
        rulerModel.setSecondPoint(new Vector3d(-1, 0, 0));
        rulerModel.setFirstValue(Double.parseDouble(minValue.getValue().toString()));
        rulerModel.setSecondValue(Double.parseDouble(maxValue.getValue().toString()));
        rulerModel.setTicksDirection(new Vector3d(0, -1, 0));
        rulerModel.setLogarithmic(true);

        Drawer drawer = new RulerExampleDrawer(canvas, zoomLevel, rulerModel);
        canvas.setMainDrawer(drawer);


        // Show frame.
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        zoomLevel.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                canvas.redraw();
            }
        });

        logBox.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                if (logBox.isSelected()) {
                    double a = Math.abs(rulerModel.getFirstValue());
                    double b = Math.abs(rulerModel.getSecondValue());
                    if (b == 0) {
                        b = 10;
                    }
                    if (a == 0) {
                        a = 1;
                    }
                    rulerModel.setFirstValue(Math.min(a, b));
                    rulerModel.setSecondValue(Math.max(a, b));
                    rulerModel.setLogarithmic(true);
                } else {
                    rulerModel.setLogarithmic(false);
                }
                canvas.redraw();
            }
        });

        ActionListener valueChangedListener = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                rulerModel.setFirstValue(Double.parseDouble(minValue.getValue().toString()));
                rulerModel.setSecondValue(Double.parseDouble(maxValue.getValue().toString()));
                canvas.redraw();
            }
        };

        maxValue.addActionListener(valueChangedListener);
        minValue.addActionListener(valueChangedListener);
    }
}
