/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.plot2d;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.examples.utils.MouseRotationAdapter;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.forge.scirenderer.tranformations.Rotation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

import com.sun.opengl.util.Animator;

/**
 * @author Pierre Lando
 */
public class Plot2DExample {

    /**
     * Main function.
     * @param arguments
     */
    public static void main(String[] arguments) {

        // Create frame.
        JFrame frame = new JFrame("JoGLCanvas");
        frame.setSize(800, 600);

        // Create panel.
        final GLJPanel panel = new GLJPanel();
        frame.add(panel);

        // SciRenderer canvas.
        final Canvas canvas = JoGLCanvasFactory.createCanvas(panel);
    
        final MouseRotationAdapter mra = new MouseRotationAdapter(new Rotation(Math.toRadians(0), new Vector3d(1, 0, 0)));
        panel.addMouseListener(mra);
        
        // Set Drawer
        Drawer drawer = new PlotDrawer(canvas, mra);
        canvas.setMainDrawer(drawer);


        // Show frame.
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // Start animation.
        Animator animator = new Animator();
        animator.add(panel);
        animator.start();
    }

}
