/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.lightenedRotatingCube;

import com.sun.opengl.util.Animator;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.examples.utils.MouseRotationAdapter;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.forge.scirenderer.lightning.Light;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.sprite.Sprite;
import org.scilab.forge.scirenderer.sprite.SpriteAnchorPosition;
import org.scilab.forge.scirenderer.sprite.SpriteDrawer;
import org.scilab.forge.scirenderer.sprite.SpriteDrawingTools;
import org.scilab.forge.scirenderer.tranformations.Rotation;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.utils.shapes.geometry.CubeFactory;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;

/**
 * @author Pierre Lando
 */
public class LightenedRotatingCube {

    public static void main(String[] arguments) {
        GLJPanel panel = new GLJPanel();

        JFrame frame = new JFrame("JoGLCanvas");
        frame.setSize(800, 600);
        frame.add(panel);

        Animator animator = new Animator();
        animator.add(panel);
        animator.start();


        Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        /**
         * A sprite to represent light position.
         */
        final Sprite sprite = canvas.getSpriteManager().createSprite(16, 16);
        sprite.setDrawer(new SpriteDrawer() {

            @Override
            public void draw(SpriteDrawingTools drawingTools) {
                drawingTools.fillDisc(0, 0, 10, new Color(1, 0, 0));
            }

            @Override
            public OriginPosition getOriginPosition() {
                return SpriteDrawer.OriginPosition.CENTER;
            }
        });

        /**
         * A MouseRotationAdapter to add some interactivity.
         */
        final MouseRotationAdapter mra = new MouseRotationAdapter(new Rotation());
        panel.addMouseListener(mra);

        /**
         * A cube.
         */
        final Geometry cube = CubeFactory.createCube(canvas, 10);

        canvas.setMainDrawer(new Drawer() {

            @Override
            public void draw(DrawingTools dt) {
                dt.clear(new Color(.2f, .3f, .4f));

                try {
                    Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(dt.getCanvas().getDimension(), 1f);
                    dt.getTransformationManager().getProjectionStack().push(projection);
                    dt.getTransformationManager().getModelViewStack().push(TransformationFactory.getScaleTransformation(.2, .2, .2));

                    dt.getLightManager().setLightningEnable(true);
                    Light light = dt.getLightManager().getLight(0);
                    light.setEnable(true);
                    light.setAmbientColor(new Color(.5f, .5f, .5f));
                    light.setDiffuseColor(new Color(.5f, 0, 0));
                    light.setSpecularColor(new Color(.4f, .4f, 0));

                    Vector3d lightPosition = new Vector3d(0, 2, -2);
                    light.setPosition(lightPosition);
                    dt.draw(sprite, SpriteAnchorPosition.CENTER, lightPosition);


                    dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getRotationTransformation(mra.getRotation()));
                    dt.draw(cube);
                } catch (SciRendererException ignored) {
                    // Should not occur.
                }
            }
        });

        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
