#include "DrawableGrayplotGL.hxx"
/* Generated by GIWS (version 2.0.0) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/DrawableGrayplotGL.giws.xml 
*/
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO
Copyright 2011-2012 Scilab Enterprises

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_grayplotDrawing {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * DrawableGrayplotGL::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

DrawableGrayplotGL::~DrawableGrayplotGL() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
DrawableGrayplotGL::DrawableGrayplotGL(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidtranslatejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidendTranslateID=NULL;
voidclipXjdoubledoublejdoubledoubleID=NULL;
voidclipYjdoubledoublejdoubledoubleID=NULL;
voidclipZjdoubledoublejdoubledoubleID=NULL;
voidunClipID=NULL;
voiddrawGrayplotjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejintArray_intintID=NULL;


}

DrawableGrayplotGL::DrawableGrayplotGL(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidtranslatejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidendTranslateID=NULL;
voidclipXjdoubledoublejdoubledoubleID=NULL;
voidclipYjdoubledoublejdoubledoubleID=NULL;
voidclipZjdoubledoublejdoubledoubleID=NULL;
voidunClipID=NULL;
voiddrawGrayplotjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejintArray_intintID=NULL;


}

// Generic methods

void DrawableGrayplotGL::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "DrawableGrayplotGL");
}
}

void DrawableGrayplotGL::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "DrawableGrayplotGL");
}
}
// Method(s)

void DrawableGrayplotGL::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache */
 voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );
                        
}

void DrawableGrayplotGL::initializeDrawing (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidinitializeDrawingjintintID==NULL) { /* Use the cache */
 voidinitializeDrawingjintintID = curEnv->GetMethodID(this->instanceClass, "initializeDrawing", "(I)V" ) ;
if (voidinitializeDrawingjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initializeDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidinitializeDrawingjintintID ,figureIndex);
                        
}

void DrawableGrayplotGL::endDrawing (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendDrawingID==NULL) { /* Use the cache */
 voidendDrawingID = curEnv->GetMethodID(this->instanceClass, "endDrawing", "()V" ) ;
if (voidendDrawingID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendDrawingID );
                        
}

void DrawableGrayplotGL::show (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowjintintID==NULL) { /* Use the cache */
 voidshowjintintID = curEnv->GetMethodID(this->instanceClass, "show", "(I)V" ) ;
if (voidshowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowjintintID ,figureIndex);
                        
}

void DrawableGrayplotGL::destroy (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyjintintID==NULL) { /* Use the cache */
 voiddestroyjintintID = curEnv->GetMethodID(this->instanceClass, "destroy", "(I)V" ) ;
if (voiddestroyjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyjintintID ,parentFigureIndex);
                        
}

void DrawableGrayplotGL::translate (double tx, double ty, double tz){

JNIEnv * curEnv = getCurrentEnv();

if (voidtranslatejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidtranslatejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "translate", "(DDD)V" ) ;
if (voidtranslatejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "translate");
}
}
                         curEnv->CallVoidMethod( this->instance, voidtranslatejdoubledoublejdoubledoublejdoubledoubleID ,tx, ty, tz);
                        
}

void DrawableGrayplotGL::endTranslate (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendTranslateID==NULL) { /* Use the cache */
 voidendTranslateID = curEnv->GetMethodID(this->instanceClass, "endTranslate", "()V" ) ;
if (voidendTranslateID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endTranslate");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendTranslateID );
                        
}

void DrawableGrayplotGL::clipX (double xMin, double xMax){

JNIEnv * curEnv = getCurrentEnv();

if (voidclipXjdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidclipXjdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "clipX", "(DD)V" ) ;
if (voidclipXjdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "clipX");
}
}
                         curEnv->CallVoidMethod( this->instance, voidclipXjdoubledoublejdoubledoubleID ,xMin, xMax);
                        
}

void DrawableGrayplotGL::clipY (double yMin, double yMax){

JNIEnv * curEnv = getCurrentEnv();

if (voidclipYjdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidclipYjdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "clipY", "(DD)V" ) ;
if (voidclipYjdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "clipY");
}
}
                         curEnv->CallVoidMethod( this->instance, voidclipYjdoubledoublejdoubledoubleID ,yMin, yMax);
                        
}

void DrawableGrayplotGL::clipZ (double zMin, double zMax){

JNIEnv * curEnv = getCurrentEnv();

if (voidclipZjdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidclipZjdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "clipZ", "(DD)V" ) ;
if (voidclipZjdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "clipZ");
}
}
                         curEnv->CallVoidMethod( this->instance, voidclipZjdoubledoublejdoubledoubleID ,zMin, zMax);
                        
}

void DrawableGrayplotGL::unClip (){

JNIEnv * curEnv = getCurrentEnv();

if (voidunClipID==NULL) { /* Use the cache */
 voidunClipID = curEnv->GetMethodID(this->instanceClass, "unClip", "()V" ) ;
if (voidunClipID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "unClip");
}
}
                         curEnv->CallVoidMethod( this->instance, voidunClipID );
                        
}

void DrawableGrayplotGL::drawGrayplot (double const* xGrid, int xGridSize, double const* yGrid, int yGridSize, double zCoord, int const* colors, int colorsSize){

JNIEnv * curEnv = getCurrentEnv();

if (voiddrawGrayplotjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejintArray_intintID==NULL) { /* Use the cache */
 voiddrawGrayplotjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejintArray_intintID = curEnv->GetMethodID(this->instanceClass, "drawGrayplot", "([D[DD[I)V" ) ;
if (voiddrawGrayplotjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "drawGrayplot");
}
}
jdoubleArray xGrid_ = curEnv->NewDoubleArray( xGridSize ) ;

if (xGrid_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( xGrid_, 0, xGridSize, (jdouble*)(xGrid) ) ;


jdoubleArray yGrid_ = curEnv->NewDoubleArray( yGridSize ) ;

if (yGrid_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( yGrid_, 0, yGridSize, (jdouble*)(yGrid) ) ;


jintArray colors_ = curEnv->NewIntArray( colorsSize ) ;

if (colors_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( colors_, 0, colorsSize, (jint*)(colors) ) ;


                         curEnv->CallVoidMethod( this->instance, voiddrawGrayplotjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubledoublejintArray_intintID ,xGrid_, yGrid_, zCoord, colors_);
                        curEnv->DeleteLocalRef(xGrid_);
curEnv->DeleteLocalRef(yGrid_);
curEnv->DeleteLocalRef(colors_);

}

}
