#include "CenteredTextDrawerGL.hxx"
/* Generated by GIWS (version 2.0.0) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/CenteredTextDrawerGL.giws.xml 
*/
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO
Copyright 2011-2012 Scilab Enterprises

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_textDrawing {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * CenteredTextDrawerGL::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

CenteredTextDrawerGL::~CenteredTextDrawerGL() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
CenteredTextDrawerGL::CenteredTextDrawerGL(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetTextParametersjintintjintintjintintjdoubledoublejdoubledoublejbooleanbooleanID=NULL;
voidsetBoxDrawingParametersjbooleanbooleanjbooleanbooleanjintintjintintID=NULL;
voidsetTextContentjobjectArray_java_lang_Stringjava_lang_StringjintintjintintID=NULL;

jclass localStringArrayClass = curEnv->FindClass("java/lang/String");
stringArrayClass = static_cast<jclass>(curEnv->NewGlobalRef(localStringArrayClass));
curEnv->DeleteLocalRef(localStringArrayClass);
voidsetCenterPositionjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_drawTextContentID=NULL;
voidsetFilledBoxSizejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_getScreenBoundingBoxjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_updateParentFigurejintintID=NULL;


}

CenteredTextDrawerGL::CenteredTextDrawerGL(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetTextParametersjintintjintintjintintjdoubledoublejdoubledoublejbooleanbooleanID=NULL;
voidsetBoxDrawingParametersjbooleanbooleanjbooleanbooleanjintintjintintID=NULL;
voidsetTextContentjobjectArray_java_lang_Stringjava_lang_StringjintintjintintID=NULL;

jclass localStringArrayClass = curEnv->FindClass("java/lang/String");
stringArrayClass = static_cast<jclass>(curEnv->NewGlobalRef(localStringArrayClass));
curEnv->DeleteLocalRef(localStringArrayClass);
voidsetCenterPositionjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_drawTextContentID=NULL;
voidsetFilledBoxSizejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_getScreenBoundingBoxjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_updateParentFigurejintintID=NULL;


}

// Generic methods

void CenteredTextDrawerGL::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CenteredTextDrawerGL");
}
}

void CenteredTextDrawerGL::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CenteredTextDrawerGL");
}
}
// Method(s)

void CenteredTextDrawerGL::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache */
 voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );
                        
}

void CenteredTextDrawerGL::initializeDrawing (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidinitializeDrawingjintintID==NULL) { /* Use the cache */
 voidinitializeDrawingjintintID = curEnv->GetMethodID(this->instanceClass, "initializeDrawing", "(I)V" ) ;
if (voidinitializeDrawingjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initializeDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidinitializeDrawingjintintID ,figureIndex);
                        
}

void CenteredTextDrawerGL::endDrawing (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendDrawingID==NULL) { /* Use the cache */
 voidendDrawingID = curEnv->GetMethodID(this->instanceClass, "endDrawing", "()V" ) ;
if (voidendDrawingID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendDrawingID );
                        
}

void CenteredTextDrawerGL::show (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowjintintID==NULL) { /* Use the cache */
 voidshowjintintID = curEnv->GetMethodID(this->instanceClass, "show", "(I)V" ) ;
if (voidshowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowjintintID ,figureIndex);
                        
}

void CenteredTextDrawerGL::destroy (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyjintintID==NULL) { /* Use the cache */
 voiddestroyjintintID = curEnv->GetMethodID(this->instanceClass, "destroy", "(I)V" ) ;
if (voiddestroyjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyjintintID ,parentFigureIndex);
                        
}

void CenteredTextDrawerGL::setTextParameters (int textAlignment, int color, int fontStyle, double fontSize, double rotationAngle, bool useFractionalMetrics){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetTextParametersjintintjintintjintintjdoubledoublejdoubledoublejbooleanbooleanID==NULL) { /* Use the cache */
 voidsetTextParametersjintintjintintjintintjdoubledoublejdoubledoublejbooleanbooleanID = curEnv->GetMethodID(this->instanceClass, "setTextParameters", "(IIIDDZ)V" ) ;
if (voidsetTextParametersjintintjintintjintintjdoubledoublejdoubledoublejbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setTextParameters");
}
}
jboolean useFractionalMetrics_ = (static_cast<bool>(useFractionalMetrics) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallVoidMethod( this->instance, voidsetTextParametersjintintjintintjintintjdoubledoublejdoubledoublejbooleanbooleanID ,textAlignment, color, fontStyle, fontSize, rotationAngle, useFractionalMetrics_);
                        
}

void CenteredTextDrawerGL::setBoxDrawingParameters (bool drawBoxLine, bool drawBoxBackground, int lineColor, int backgroundColor){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetBoxDrawingParametersjbooleanbooleanjbooleanbooleanjintintjintintID==NULL) { /* Use the cache */
 voidsetBoxDrawingParametersjbooleanbooleanjbooleanbooleanjintintjintintID = curEnv->GetMethodID(this->instanceClass, "setBoxDrawingParameters", "(ZZII)V" ) ;
if (voidsetBoxDrawingParametersjbooleanbooleanjbooleanbooleanjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setBoxDrawingParameters");
}
}
jboolean drawBoxLine_ = (static_cast<bool>(drawBoxLine) ? JNI_TRUE : JNI_FALSE);

jboolean drawBoxBackground_ = (static_cast<bool>(drawBoxBackground) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallVoidMethod( this->instance, voidsetBoxDrawingParametersjbooleanbooleanjbooleanbooleanjintintjintintID ,drawBoxLine_, drawBoxBackground_, lineColor, backgroundColor);
                        
}

void CenteredTextDrawerGL::setTextContent (char const* const* text, int textSize, int nbRow, int nbCol){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetTextContentjobjectArray_java_lang_Stringjava_lang_StringjintintjintintID==NULL) { /* Use the cache */
 voidsetTextContentjobjectArray_java_lang_Stringjava_lang_StringjintintjintintID = curEnv->GetMethodID(this->instanceClass, "setTextContent", "([Ljava/lang/String;II)V" ) ;
if (voidsetTextContentjobjectArray_java_lang_Stringjava_lang_StringjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setTextContent");
}
}jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallVoidMethod( this->instance, voidsetTextContentjobjectArray_java_lang_Stringjava_lang_StringjintintjintintID ,text_, nbRow, nbCol);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);

}

void CenteredTextDrawerGL::setCenterPosition (double centerX, double centerY, double centerZ){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetCenterPositionjdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetCenterPositionjdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setCenterPosition", "(DDD)V" ) ;
if (voidsetCenterPositionjdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setCenterPosition");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetCenterPositionjdoubledoublejdoubledoublejdoubledoubleID ,centerX, centerY, centerZ);
                        
}

double* CenteredTextDrawerGL::drawTextContent (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_drawTextContentID==NULL) { /* Use the cache */
 jdoubleArray_drawTextContentID = curEnv->GetMethodID(this->instanceClass, "drawTextContent", "()[D" ) ;
if (jdoubleArray_drawTextContentID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "drawTextContent");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_drawTextContentID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

return myArray;

}

void CenteredTextDrawerGL::setFilledBoxSize (double boxWidth, double boxHeight){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetFilledBoxSizejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetFilledBoxSizejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setFilledBoxSize", "(DD)V" ) ;
if (voidsetFilledBoxSizejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFilledBoxSize");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetFilledBoxSizejdoubledoublejdoubledoubleID ,boxWidth, boxHeight);
                        
}

double* CenteredTextDrawerGL::getScreenBoundingBox (double centerPixX, double centerPixY, double centerPixZ){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_getScreenBoundingBoxjdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 jdoubleArray_getScreenBoundingBoxjdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "getScreenBoundingBox", "(DDD)[D" ) ;
if (jdoubleArray_getScreenBoundingBoxjdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenBoundingBox");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_getScreenBoundingBoxjdoubledoublejdoubledoublejdoubledoubleID ,centerPixX, centerPixY, centerPixZ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

return myArray;

}

double* CenteredTextDrawerGL::updateParentFigure (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_updateParentFigurejintintID==NULL) { /* Use the cache */
 jdoubleArray_updateParentFigurejintintID = curEnv->GetMethodID(this->instanceClass, "updateParentFigure", "(I)[D" ) ;
if (jdoubleArray_updateParentFigurejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "updateParentFigure");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_updateParentFigurejintintID ,parentFigureIndex));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

return myArray;

}

}
