#include "CallScilabBridge.hxx"
/* Generated by GIWS (version 2.0.0) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/CallScilabBridge.giws.xml 
*/
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO
Copyright 2011-2012 Scilab Enterprises

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_gui_bridge {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * CallScilabBridge::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

CallScilabBridge::~CallScilabBridge() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
CallScilabBridge::CallScilabBridge(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintnewWindowID=NULL;
jintnewMenuBarID=NULL;
jintnewMenuID=NULL;
jintnewPushButtonID=NULL;
jintnewEditBoxID=NULL;
jintnewLabelID=NULL;
jintnewCheckBoxID=NULL;
jintnewRadioButtonID=NULL;
jintnewSliderID=NULL;
jintnewPopupMenuID=NULL;
jintnewListBoxID=NULL;
jintnewFrameID=NULL;
jstringnewContextMenujobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintnewContextMenuID=NULL;
voiddestroyWidgetjintintID=NULL;
voiddestroyFramejintintID=NULL;
jintnewWindowjintintID=NULL;
voidsetFigureAsParentjintintjintintID=NULL;
voidsetMenuAsParentjintintjintintID=NULL;
voidsetRootAsParentjintintID=NULL;
voidsetParentjintintjintintID=NULL;
voidsetPushButtonParentjintintjintintID=NULL;
voidremovePushButtonFromParentjintintjintintID=NULL;
voidsetEditBoxParentjintintjintintID=NULL;
voidremoveEditBoxFromParentjintintjintintID=NULL;
voidsetLabelParentjintintjintintID=NULL;
voidremoveLabelFromParentjintintjintintID=NULL;
voidsetCheckBoxParentjintintjintintID=NULL;
voidremoveCheckBoxFromParentjintintjintintID=NULL;
voidsetRadioButtonParentjintintjintintID=NULL;
voidremoveRadioButtonFromParentjintintjintintID=NULL;
voidsetSliderParentjintintjintintID=NULL;
voidremoveSliderFromParentjintintjintintID=NULL;
voidsetPopupMenuParentjintintjintintID=NULL;
voidremovePopupMenuFromParentjintintjintintID=NULL;
voidsetListBoxParentjintintjintintID=NULL;
voidremoveListBoxFromParentjintintjintintID=NULL;
voidsetFrameParentjintintjintintID=NULL;
voidremoveFrameFromParentjintintjintintID=NULL;
voidsetWidgetTextjintintjstringjava_lang_StringID=NULL;
jstringgetWidgetTextjintintID=NULL;
voidsetFrameTextjintintjstringjava_lang_StringID=NULL;
jstringgetFrameTextjintintID=NULL;
voidsetWidgetBackgroundColorjintintjintintjintintjintintID=NULL;
jintArray_getWidgetBackgroundColorjintintID=NULL;
voidsetWidgetForegroundColorjintintjintintjintintjintintID=NULL;
jintArray_getWidgetForegroundColorjintintID=NULL;
voidsetFrameBackgroundColorjintintjintintjintintjintintID=NULL;
jintArray_getFrameBackgroundColorjintintID=NULL;
voidsetFrameForegroundColorjintintjintintjintintjintintID=NULL;
jintArray_getFrameForegroundColorjintintID=NULL;
voidsetWidgetFontNamejintintjstringjava_lang_StringID=NULL;
jstringgetWidgetFontNamejintintID=NULL;
voidsetWidgetFontWeightjintintjstringjava_lang_StringID=NULL;
voidsetWidgetFontSizejintintjintintID=NULL;
jintgetWidgetFontSizejintintID=NULL;
voidsetWidgetFontAnglejintintjstringjava_lang_StringID=NULL;
voidsetFrameFontNamejintintjstringjava_lang_StringID=NULL;
jstringgetFrameFontNamejintintID=NULL;
voidsetFrameFontWeightjintintjstringjava_lang_StringID=NULL;
voidsetFrameFontSizejintintjintintID=NULL;
jintgetFrameFontSizejintintID=NULL;
voidsetFrameFontAnglejintintjstringjava_lang_StringID=NULL;
voidsetWidgetPositionjintintjintintjintintjintintjintintID=NULL;
jintArray_getWidgetPositionjintintID=NULL;
voidsetFramePositionjintintjintintjintintjintintjintintID=NULL;
jintArray_getFramePositionjintintID=NULL;
voidsetWidgetCallbackjintintjstringjava_lang_StringjintintID=NULL;
voidsetFrameCallbackjintintjstringjava_lang_StringjintintID=NULL;
voidsetWidgetHorizontalAlignmentjintintjstringjava_lang_StringID=NULL;
voidsetWidgetVerticalAlignmentjintintjstringjava_lang_StringID=NULL;
voidsetSliderMinorTickSpacingjintintjintintID=NULL;
voidsetSliderMajorTickSpacingjintintjintintID=NULL;
voidsetListBoxSelectedIndicesjintintjintArray_intintID=NULL;
jintArray_getListBoxSelectedIndicesjintintID=NULL;
jintgetListBoxSelectionSizejintintID=NULL;
voidsetPopupMenuSelectedIndexjintintjintintID=NULL;
jintgetPopupMenuSelectedIndexjintintID=NULL;
voidsetSliderValuejintintjintintID=NULL;
jintgetSliderValuejintintID=NULL;
voidsetRadioButtonCheckedjintintjbooleanbooleanID=NULL;
jbooleanisRadioButtonCheckedjintintID=NULL;
voidsetCheckBoxCheckedjintintjbooleanbooleanID=NULL;
jbooleanisCheckBoxCheckedjintintID=NULL;
voidsetSliderMinValuejintintjintintID=NULL;
voidsetSliderMaxValuejintintjintintID=NULL;
voidsetSliderVerticaljintintID=NULL;
voidsetSliderHorizontaljintintID=NULL;
voidsetListBoxMultipleSelectionEnabledjintintjbooleanbooleanID=NULL;
jobjectArray_getListBoxAllItemsTextjintintID=NULL;
jintgetListBoxNumberOfItemsjintintID=NULL;
voidsetListBoxTextjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetListBoxListBoxTopjintintjintintID=NULL;
jintgetListBoxListBoxTopjintintID=NULL;
jobjectArray_getPopupMenuAllItemsTextjintintID=NULL;
jintgetPopupMenuNumberOfItemsjintintID=NULL;
voidsetPopupMenuTextjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetWidgetReliefjintintjstringjava_lang_StringID=NULL;
voidsetFrameReliefjintintjstringjava_lang_StringID=NULL;
voidsetRootMenuEnabledjstringjava_lang_StringjbooleanbooleanID=NULL;
voidsetRootSubMenuEnabledjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
voidsetFigureMenuEnabledjintintjstringjava_lang_StringjbooleanbooleanID=NULL;
voidsetFigureSubMenuEnabledjintintjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
voidsetWidgetEnablejintintjbooleanbooleanID=NULL;
voidsetFrameEnablejintintjbooleanbooleanID=NULL;
jbooleanisWidgetEnablejintintID=NULL;
jbooleanisFrameEnablejintintID=NULL;
voidsetMenuCheckedjintintjbooleanbooleanID=NULL;
jbooleanisMenuCheckedjintintID=NULL;
voidremoveRootMenujstringjava_lang_StringID=NULL;
voidremoveFigureMenujintintjstringjava_lang_StringID=NULL;
jstringdisplayAndWaitContextMenujintintID=NULL;
jintnewMessageBoxID=NULL;
voidsetMessageBoxTitlejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidmessageBoxDisplayAndWaitjintintID=NULL;
jintgetMessageBoxSelectedButtonjintintID=NULL;
voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID=NULL;
jintArray_getMessageBoxUserSelectedButtonsjintintID=NULL;
voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jobjectArray_getMessageBoxValuejintintID=NULL;
jintgetMessageBoxValueSizejintintID=NULL;
voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintgetMessageBoxSelectedItemjintintID=NULL;
voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxModaljintintjbooleanbooleanID=NULL;
voidsetMessageBoxIconjintintjstringjava_lang_StringID=NULL;
jbooleanisToolbarVisiblejintintID=NULL;
voidsetToolbarVisiblejintintjbooleanbooleanID=NULL;
voidsetEventHandlerjintintjstringjava_lang_StringID=NULL;
voidsetEventHandlerEnabledjintintjbooleanbooleanID=NULL;
jintnewWaitBarID=NULL;
voidsetWaitBarMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetWaitBarValuejintintjintintID=NULL;
voiddestroyWaitBarjintintID=NULL;
voidsetWaitBarIndeterminateModejintintjbooleanbooleanID=NULL;
voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
jintnewExportFileChooserjintintID=NULL;
jintnewFontChooserID=NULL;
voidfontChooserDisplayAndWaitjintintID=NULL;
voidsetFontChooserFontNamejintintjstringjava_lang_StringID=NULL;
voidsetFontChooserFontSizejintintjintintID=NULL;
voidsetFontChooserBoldjintintjbooleanbooleanID=NULL;
voidsetFontChooserItalicjintintjbooleanbooleanID=NULL;
jstringgetFontChooserFontNamejintintID=NULL;
jintgetFontChooserFontSizejintintID=NULL;
jbooleangetFontChooserBoldjintintID=NULL;
jbooleangetFontChooserItalicjintintID=NULL;
jintnewColorChooserID=NULL;
voidcolorChooserDisplayAndWaitjintintID=NULL;
voidsetColorChooserDefaultColorjintintjintArray_intintID=NULL;
jintArray_getColorChooserSelectedColorjintintID=NULL;
voidsetColorChooserTitlejintintjstringjava_lang_StringID=NULL;
voidsetWidgetVisiblejintintjbooleanbooleanID=NULL;
voidsetFrameVisiblejintintjbooleanbooleanID=NULL;
jbooleanisWidgetVisiblejintintID=NULL;
jbooleanisFrameVisiblejintintID=NULL;
jstringgetClipboardContentsID=NULL;
voidpasteClipboardIntoConsoleID=NULL;
voidcopyConsoleSelectionID=NULL;
voidemptyClipboardID=NULL;
voidsetClipboardContentsjstringjava_lang_StringID=NULL;
voidcopyFigureToClipBoardjintintID=NULL;
jintgetScreenResolutionID=NULL;
jdoublegetScreenWidthID=NULL;
jdoublegetScreenHeightID=NULL;
jintgetScreenDepthID=NULL;
jbooleanprintFigurejintintjbooleanbooleanjbooleanbooleanID=NULL;
jbooleanprintFilejstringjava_lang_StringID=NULL;
jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
jbooleanpageSetupID=NULL;
voidrequestWidgetFocusjintintID=NULL;
voidrequestFrameFocusjintintID=NULL;
voidraiseWindowjintintID=NULL;
voiduseCanvasForDisplayjbooleanbooleanID=NULL;
jbooleanuseCanvasForDisplayID=NULL;
voidscilabAboutBoxID=NULL;


}

CallScilabBridge::CallScilabBridge(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintnewWindowID=NULL;
jintnewMenuBarID=NULL;
jintnewMenuID=NULL;
jintnewPushButtonID=NULL;
jintnewEditBoxID=NULL;
jintnewLabelID=NULL;
jintnewCheckBoxID=NULL;
jintnewRadioButtonID=NULL;
jintnewSliderID=NULL;
jintnewPopupMenuID=NULL;
jintnewListBoxID=NULL;
jintnewFrameID=NULL;
jstringnewContextMenujobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintnewContextMenuID=NULL;
voiddestroyWidgetjintintID=NULL;
voiddestroyFramejintintID=NULL;
jintnewWindowjintintID=NULL;
voidsetFigureAsParentjintintjintintID=NULL;
voidsetMenuAsParentjintintjintintID=NULL;
voidsetRootAsParentjintintID=NULL;
voidsetParentjintintjintintID=NULL;
voidsetPushButtonParentjintintjintintID=NULL;
voidremovePushButtonFromParentjintintjintintID=NULL;
voidsetEditBoxParentjintintjintintID=NULL;
voidremoveEditBoxFromParentjintintjintintID=NULL;
voidsetLabelParentjintintjintintID=NULL;
voidremoveLabelFromParentjintintjintintID=NULL;
voidsetCheckBoxParentjintintjintintID=NULL;
voidremoveCheckBoxFromParentjintintjintintID=NULL;
voidsetRadioButtonParentjintintjintintID=NULL;
voidremoveRadioButtonFromParentjintintjintintID=NULL;
voidsetSliderParentjintintjintintID=NULL;
voidremoveSliderFromParentjintintjintintID=NULL;
voidsetPopupMenuParentjintintjintintID=NULL;
voidremovePopupMenuFromParentjintintjintintID=NULL;
voidsetListBoxParentjintintjintintID=NULL;
voidremoveListBoxFromParentjintintjintintID=NULL;
voidsetFrameParentjintintjintintID=NULL;
voidremoveFrameFromParentjintintjintintID=NULL;
voidsetWidgetTextjintintjstringjava_lang_StringID=NULL;
jstringgetWidgetTextjintintID=NULL;
voidsetFrameTextjintintjstringjava_lang_StringID=NULL;
jstringgetFrameTextjintintID=NULL;
voidsetWidgetBackgroundColorjintintjintintjintintjintintID=NULL;
jintArray_getWidgetBackgroundColorjintintID=NULL;
voidsetWidgetForegroundColorjintintjintintjintintjintintID=NULL;
jintArray_getWidgetForegroundColorjintintID=NULL;
voidsetFrameBackgroundColorjintintjintintjintintjintintID=NULL;
jintArray_getFrameBackgroundColorjintintID=NULL;
voidsetFrameForegroundColorjintintjintintjintintjintintID=NULL;
jintArray_getFrameForegroundColorjintintID=NULL;
voidsetWidgetFontNamejintintjstringjava_lang_StringID=NULL;
jstringgetWidgetFontNamejintintID=NULL;
voidsetWidgetFontWeightjintintjstringjava_lang_StringID=NULL;
voidsetWidgetFontSizejintintjintintID=NULL;
jintgetWidgetFontSizejintintID=NULL;
voidsetWidgetFontAnglejintintjstringjava_lang_StringID=NULL;
voidsetFrameFontNamejintintjstringjava_lang_StringID=NULL;
jstringgetFrameFontNamejintintID=NULL;
voidsetFrameFontWeightjintintjstringjava_lang_StringID=NULL;
voidsetFrameFontSizejintintjintintID=NULL;
jintgetFrameFontSizejintintID=NULL;
voidsetFrameFontAnglejintintjstringjava_lang_StringID=NULL;
voidsetWidgetPositionjintintjintintjintintjintintjintintID=NULL;
jintArray_getWidgetPositionjintintID=NULL;
voidsetFramePositionjintintjintintjintintjintintjintintID=NULL;
jintArray_getFramePositionjintintID=NULL;
voidsetWidgetCallbackjintintjstringjava_lang_StringjintintID=NULL;
voidsetFrameCallbackjintintjstringjava_lang_StringjintintID=NULL;
voidsetWidgetHorizontalAlignmentjintintjstringjava_lang_StringID=NULL;
voidsetWidgetVerticalAlignmentjintintjstringjava_lang_StringID=NULL;
voidsetSliderMinorTickSpacingjintintjintintID=NULL;
voidsetSliderMajorTickSpacingjintintjintintID=NULL;
voidsetListBoxSelectedIndicesjintintjintArray_intintID=NULL;
jintArray_getListBoxSelectedIndicesjintintID=NULL;
jintgetListBoxSelectionSizejintintID=NULL;
voidsetPopupMenuSelectedIndexjintintjintintID=NULL;
jintgetPopupMenuSelectedIndexjintintID=NULL;
voidsetSliderValuejintintjintintID=NULL;
jintgetSliderValuejintintID=NULL;
voidsetRadioButtonCheckedjintintjbooleanbooleanID=NULL;
jbooleanisRadioButtonCheckedjintintID=NULL;
voidsetCheckBoxCheckedjintintjbooleanbooleanID=NULL;
jbooleanisCheckBoxCheckedjintintID=NULL;
voidsetSliderMinValuejintintjintintID=NULL;
voidsetSliderMaxValuejintintjintintID=NULL;
voidsetSliderVerticaljintintID=NULL;
voidsetSliderHorizontaljintintID=NULL;
voidsetListBoxMultipleSelectionEnabledjintintjbooleanbooleanID=NULL;
jobjectArray_getListBoxAllItemsTextjintintID=NULL;
jintgetListBoxNumberOfItemsjintintID=NULL;
voidsetListBoxTextjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetListBoxListBoxTopjintintjintintID=NULL;
jintgetListBoxListBoxTopjintintID=NULL;
jobjectArray_getPopupMenuAllItemsTextjintintID=NULL;
jintgetPopupMenuNumberOfItemsjintintID=NULL;
voidsetPopupMenuTextjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetWidgetReliefjintintjstringjava_lang_StringID=NULL;
voidsetFrameReliefjintintjstringjava_lang_StringID=NULL;
voidsetRootMenuEnabledjstringjava_lang_StringjbooleanbooleanID=NULL;
voidsetRootSubMenuEnabledjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
voidsetFigureMenuEnabledjintintjstringjava_lang_StringjbooleanbooleanID=NULL;
voidsetFigureSubMenuEnabledjintintjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
voidsetWidgetEnablejintintjbooleanbooleanID=NULL;
voidsetFrameEnablejintintjbooleanbooleanID=NULL;
jbooleanisWidgetEnablejintintID=NULL;
jbooleanisFrameEnablejintintID=NULL;
voidsetMenuCheckedjintintjbooleanbooleanID=NULL;
jbooleanisMenuCheckedjintintID=NULL;
voidremoveRootMenujstringjava_lang_StringID=NULL;
voidremoveFigureMenujintintjstringjava_lang_StringID=NULL;
jstringdisplayAndWaitContextMenujintintID=NULL;
jintnewMessageBoxID=NULL;
voidsetMessageBoxTitlejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidmessageBoxDisplayAndWaitjintintID=NULL;
jintgetMessageBoxSelectedButtonjintintID=NULL;
voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID=NULL;
jintArray_getMessageBoxUserSelectedButtonsjintintID=NULL;
voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jobjectArray_getMessageBoxValuejintintID=NULL;
jintgetMessageBoxValueSizejintintID=NULL;
voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintgetMessageBoxSelectedItemjintintID=NULL;
voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxModaljintintjbooleanbooleanID=NULL;
voidsetMessageBoxIconjintintjstringjava_lang_StringID=NULL;
jbooleanisToolbarVisiblejintintID=NULL;
voidsetToolbarVisiblejintintjbooleanbooleanID=NULL;
voidsetEventHandlerjintintjstringjava_lang_StringID=NULL;
voidsetEventHandlerEnabledjintintjbooleanbooleanID=NULL;
jintnewWaitBarID=NULL;
voidsetWaitBarMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetWaitBarValuejintintjintintID=NULL;
voiddestroyWaitBarjintintID=NULL;
voidsetWaitBarIndeterminateModejintintjbooleanbooleanID=NULL;
voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
jintnewExportFileChooserjintintID=NULL;
jintnewFontChooserID=NULL;
voidfontChooserDisplayAndWaitjintintID=NULL;
voidsetFontChooserFontNamejintintjstringjava_lang_StringID=NULL;
voidsetFontChooserFontSizejintintjintintID=NULL;
voidsetFontChooserBoldjintintjbooleanbooleanID=NULL;
voidsetFontChooserItalicjintintjbooleanbooleanID=NULL;
jstringgetFontChooserFontNamejintintID=NULL;
jintgetFontChooserFontSizejintintID=NULL;
jbooleangetFontChooserBoldjintintID=NULL;
jbooleangetFontChooserItalicjintintID=NULL;
jintnewColorChooserID=NULL;
voidcolorChooserDisplayAndWaitjintintID=NULL;
voidsetColorChooserDefaultColorjintintjintArray_intintID=NULL;
jintArray_getColorChooserSelectedColorjintintID=NULL;
voidsetColorChooserTitlejintintjstringjava_lang_StringID=NULL;
voidsetWidgetVisiblejintintjbooleanbooleanID=NULL;
voidsetFrameVisiblejintintjbooleanbooleanID=NULL;
jbooleanisWidgetVisiblejintintID=NULL;
jbooleanisFrameVisiblejintintID=NULL;
jstringgetClipboardContentsID=NULL;
voidpasteClipboardIntoConsoleID=NULL;
voidcopyConsoleSelectionID=NULL;
voidemptyClipboardID=NULL;
voidsetClipboardContentsjstringjava_lang_StringID=NULL;
voidcopyFigureToClipBoardjintintID=NULL;
jintgetScreenResolutionID=NULL;
jdoublegetScreenWidthID=NULL;
jdoublegetScreenHeightID=NULL;
jintgetScreenDepthID=NULL;
jbooleanprintFigurejintintjbooleanbooleanjbooleanbooleanID=NULL;
jbooleanprintFilejstringjava_lang_StringID=NULL;
jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
jbooleanpageSetupID=NULL;
voidrequestWidgetFocusjintintID=NULL;
voidrequestFrameFocusjintintID=NULL;
voidraiseWindowjintintID=NULL;
voiduseCanvasForDisplayjbooleanbooleanID=NULL;
jbooleanuseCanvasForDisplayID=NULL;
voidscilabAboutBoxID=NULL;


}

// Generic methods

void CallScilabBridge::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallScilabBridge");
}
}

void CallScilabBridge::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallScilabBridge");
}
}
// Method(s)

int CallScilabBridge::newWindow (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewWindowID = curEnv->GetStaticMethodID(cls, "newWindow", "()I" ) ;
if (jintnewWindowID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newWindow");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewWindowID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newMenuBar (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMenuBarID = curEnv->GetStaticMethodID(cls, "newMenuBar", "()I" ) ;
if (jintnewMenuBarID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newMenuBar");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewMenuBarID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newMenu (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMenuID = curEnv->GetStaticMethodID(cls, "newMenu", "()I" ) ;
if (jintnewMenuID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newMenu");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewMenuID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newPushButton (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewPushButtonID = curEnv->GetStaticMethodID(cls, "newPushButton", "()I" ) ;
if (jintnewPushButtonID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newPushButton");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewPushButtonID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newEditBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewEditBoxID = curEnv->GetStaticMethodID(cls, "newEditBox", "()I" ) ;
if (jintnewEditBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newEditBox");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewEditBoxID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newLabel (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewLabelID = curEnv->GetStaticMethodID(cls, "newLabel", "()I" ) ;
if (jintnewLabelID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newLabel");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewLabelID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newCheckBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewCheckBoxID = curEnv->GetStaticMethodID(cls, "newCheckBox", "()I" ) ;
if (jintnewCheckBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newCheckBox");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewCheckBoxID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newRadioButton (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewRadioButtonID = curEnv->GetStaticMethodID(cls, "newRadioButton", "()I" ) ;
if (jintnewRadioButtonID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newRadioButton");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewRadioButtonID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newSlider (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewSliderID = curEnv->GetStaticMethodID(cls, "newSlider", "()I" ) ;
if (jintnewSliderID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newSlider");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewSliderID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newPopupMenu (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewPopupMenuID = curEnv->GetStaticMethodID(cls, "newPopupMenu", "()I" ) ;
if (jintnewPopupMenuID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newPopupMenu");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewPopupMenuID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newListBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewListBoxID = curEnv->GetStaticMethodID(cls, "newListBox", "()I" ) ;
if (jintnewListBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newListBox");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewListBoxID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newFrame (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewFrameID = curEnv->GetStaticMethodID(cls, "newFrame", "()I" ) ;
if (jintnewFrameID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newFrame");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewFrameID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char* CallScilabBridge::newContextMenu (JavaVM * jvm_, char const* const* menuLabels, int menuLabelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringnewContextMenujobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "newContextMenu", "([Ljava/lang/String;)Ljava/lang/String;" ) ;
if (jstringnewContextMenujobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newContextMenu");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray menuLabels_ = curEnv->NewObjectArray( menuLabelsSize, stringArrayClass, NULL);
if (menuLabels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < menuLabelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( menuLabels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( menuLabels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringnewContextMenujobjectArray_java_lang_Stringjava_lang_StringID ,menuLabels_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(menuLabels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

int CallScilabBridge::newContextMenu (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewContextMenuID = curEnv->GetStaticMethodID(cls, "newContextMenu", "()I" ) ;
if (jintnewContextMenuID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newContextMenu");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewContextMenuID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::destroyWidget (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddestroyWidgetjintintID = curEnv->GetStaticMethodID(cls, "destroyWidget", "(I)V" ) ;
if (voiddestroyWidgetjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroyWidget");
}

                         curEnv->CallStaticVoidMethod(cls, voiddestroyWidgetjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::destroyFrame (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddestroyFramejintintID = curEnv->GetStaticMethodID(cls, "destroyFrame", "(I)V" ) ;
if (voiddestroyFramejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroyFrame");
}

                         curEnv->CallStaticVoidMethod(cls, voiddestroyFramejintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::newWindow (JavaVM * jvm_, int figureIndex){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewWindowjintintID = curEnv->GetStaticMethodID(cls, "newWindow", "(I)I" ) ;
if (jintnewWindowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newWindow");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewWindowjintintID ,figureIndex));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setFigureAsParent (JavaVM * jvm_, int figureID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFigureAsParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setFigureAsParent", "(II)V" ) ;
if (voidsetFigureAsParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFigureAsParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFigureAsParentjintintjintintID ,figureID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMenuAsParent (JavaVM * jvm_, int menuID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMenuAsParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setMenuAsParent", "(II)V" ) ;
if (voidsetMenuAsParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMenuAsParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetMenuAsParentjintintjintintID ,menuID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setRootAsParent (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRootAsParentjintintID = curEnv->GetStaticMethodID(cls, "setRootAsParent", "(I)V" ) ;
if (voidsetRootAsParentjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setRootAsParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetRootAsParentjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setParent", "(II)V" ) ;
if (voidsetParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setPushButtonParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPushButtonParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setPushButtonParent", "(II)V" ) ;
if (voidsetPushButtonParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setPushButtonParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetPushButtonParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removePushButtonFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremovePushButtonFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removePushButtonFromParent", "(II)V" ) ;
if (voidremovePushButtonFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removePushButtonFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremovePushButtonFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setEditBoxParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetEditBoxParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setEditBoxParent", "(II)V" ) ;
if (voidsetEditBoxParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setEditBoxParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetEditBoxParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeEditBoxFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveEditBoxFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeEditBoxFromParent", "(II)V" ) ;
if (voidremoveEditBoxFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeEditBoxFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveEditBoxFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setLabelParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetLabelParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setLabelParent", "(II)V" ) ;
if (voidsetLabelParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setLabelParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetLabelParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeLabelFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveLabelFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeLabelFromParent", "(II)V" ) ;
if (voidremoveLabelFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeLabelFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveLabelFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setCheckBoxParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetCheckBoxParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setCheckBoxParent", "(II)V" ) ;
if (voidsetCheckBoxParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setCheckBoxParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetCheckBoxParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeCheckBoxFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveCheckBoxFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeCheckBoxFromParent", "(II)V" ) ;
if (voidremoveCheckBoxFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeCheckBoxFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveCheckBoxFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setRadioButtonParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRadioButtonParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setRadioButtonParent", "(II)V" ) ;
if (voidsetRadioButtonParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setRadioButtonParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetRadioButtonParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeRadioButtonFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveRadioButtonFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeRadioButtonFromParent", "(II)V" ) ;
if (voidremoveRadioButtonFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeRadioButtonFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveRadioButtonFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSliderParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setSliderParent", "(II)V" ) ;
if (voidsetSliderParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeSliderFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveSliderFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeSliderFromParent", "(II)V" ) ;
if (voidremoveSliderFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeSliderFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveSliderFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setPopupMenuParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPopupMenuParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setPopupMenuParent", "(II)V" ) ;
if (voidsetPopupMenuParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setPopupMenuParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetPopupMenuParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removePopupMenuFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremovePopupMenuFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removePopupMenuFromParent", "(II)V" ) ;
if (voidremovePopupMenuFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removePopupMenuFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremovePopupMenuFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setListBoxParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setListBoxParent", "(II)V" ) ;
if (voidsetListBoxParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setListBoxParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeListBoxFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveListBoxFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeListBoxFromParent", "(II)V" ) ;
if (voidremoveListBoxFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeListBoxFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveListBoxFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameParentjintintjintintID = curEnv->GetStaticMethodID(cls, "setFrameParent", "(II)V" ) ;
if (voidsetFrameParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeFrameFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveFrameFromParentjintintjintintID = curEnv->GetStaticMethodID(cls, "removeFrameFromParent", "(II)V" ) ;
if (voidremoveFrameFromParentjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeFrameFromParent");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveFrameFromParentjintintjintintID ,parentID, objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetText (JavaVM * jvm_, int objID, char const* text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetTextjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetText", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetTextjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetText");
}

jstring text_ = curEnv->NewStringUTF( text );
if (text != NULL && text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetTextjintintjstringjava_lang_StringID ,objID, text_);
                        curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getWidgetText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetWidgetTextjintintID = curEnv->GetStaticMethodID(cls, "getWidgetText", "(I)Ljava/lang/String;" ) ;
if (jstringgetWidgetTextjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWidgetText");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetWidgetTextjintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

void CallScilabBridge::setFrameText (JavaVM * jvm_, int objID, char const* text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameTextjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFrameText", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameTextjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameText");
}

jstring text_ = curEnv->NewStringUTF( text );
if (text != NULL && text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFrameTextjintintjstringjava_lang_StringID ,objID, text_);
                        curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getFrameText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFrameTextjintintID = curEnv->GetStaticMethodID(cls, "getFrameText", "(I)Ljava/lang/String;" ) ;
if (jstringgetFrameTextjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFrameText");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetFrameTextjintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

void CallScilabBridge::setWidgetBackgroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetBackgroundColorjintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "setWidgetBackgroundColor", "(IIII)V" ) ;
if (voidsetWidgetBackgroundColorjintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetBackgroundColor");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetBackgroundColorjintintjintintjintintjintintID ,objID, red, green, blue);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getWidgetBackgroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getWidgetBackgroundColorjintintID = curEnv->GetStaticMethodID(cls, "getWidgetBackgroundColor", "(I)[I" ) ;
if (jintArray_getWidgetBackgroundColorjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWidgetBackgroundColor");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getWidgetBackgroundColorjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setWidgetForegroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetForegroundColorjintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "setWidgetForegroundColor", "(IIII)V" ) ;
if (voidsetWidgetForegroundColorjintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetForegroundColor");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetForegroundColorjintintjintintjintintjintintID ,objID, red, green, blue);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getWidgetForegroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getWidgetForegroundColorjintintID = curEnv->GetStaticMethodID(cls, "getWidgetForegroundColor", "(I)[I" ) ;
if (jintArray_getWidgetForegroundColorjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWidgetForegroundColor");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getWidgetForegroundColorjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setFrameBackgroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameBackgroundColorjintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "setFrameBackgroundColor", "(IIII)V" ) ;
if (voidsetFrameBackgroundColorjintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameBackgroundColor");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameBackgroundColorjintintjintintjintintjintintID ,objID, red, green, blue);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getFrameBackgroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getFrameBackgroundColorjintintID = curEnv->GetStaticMethodID(cls, "getFrameBackgroundColor", "(I)[I" ) ;
if (jintArray_getFrameBackgroundColorjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFrameBackgroundColor");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getFrameBackgroundColorjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setFrameForegroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameForegroundColorjintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "setFrameForegroundColor", "(IIII)V" ) ;
if (voidsetFrameForegroundColorjintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameForegroundColor");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameForegroundColorjintintjintintjintintjintintID ,objID, red, green, blue);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getFrameForegroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getFrameForegroundColorjintintID = curEnv->GetStaticMethodID(cls, "getFrameForegroundColor", "(I)[I" ) ;
if (jintArray_getFrameForegroundColorjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFrameForegroundColor");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getFrameForegroundColorjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setWidgetFontName (JavaVM * jvm_, int objID, char const* name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontNamejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetFontNamejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetFontName");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontNamejintintjstringjava_lang_StringID ,objID, name_);
                        curEnv->DeleteLocalRef(name_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getWidgetFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetWidgetFontNamejintintID = curEnv->GetStaticMethodID(cls, "getWidgetFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetWidgetFontNamejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWidgetFontName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetWidgetFontNamejintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

void CallScilabBridge::setWidgetFontWeight (JavaVM * jvm_, int objID, char const* weight){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontWeightjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetFontWeight", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetFontWeightjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetFontWeight");
}

jstring weight_ = curEnv->NewStringUTF( weight );
if (weight != NULL && weight_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontWeightjintintjstringjava_lang_StringID ,objID, weight_);
                        curEnv->DeleteLocalRef(weight_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetFontSize (JavaVM * jvm_, int objID, int size){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontSizejintintjintintID = curEnv->GetStaticMethodID(cls, "setWidgetFontSize", "(II)V" ) ;
if (voidsetWidgetFontSizejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetFontSize");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontSizejintintjintintID ,objID, size);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getWidgetFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetWidgetFontSizejintintID = curEnv->GetStaticMethodID(cls, "getWidgetFontSize", "(I)I" ) ;
if (jintgetWidgetFontSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWidgetFontSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetWidgetFontSizejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setWidgetFontAngle (JavaVM * jvm_, int objID, char const* angle){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontAnglejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetFontAngle", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetFontAnglejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetFontAngle");
}

jstring angle_ = curEnv->NewStringUTF( angle );
if (angle != NULL && angle_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontAnglejintintjstringjava_lang_StringID ,objID, angle_);
                        curEnv->DeleteLocalRef(angle_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameFontName (JavaVM * jvm_, int objID, char const* name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontNamejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFrameFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameFontNamejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameFontName");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontNamejintintjstringjava_lang_StringID ,objID, name_);
                        curEnv->DeleteLocalRef(name_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getFrameFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFrameFontNamejintintID = curEnv->GetStaticMethodID(cls, "getFrameFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetFrameFontNamejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFrameFontName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetFrameFontNamejintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

void CallScilabBridge::setFrameFontWeight (JavaVM * jvm_, int objID, char const* weight){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontWeightjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFrameFontWeight", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameFontWeightjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameFontWeight");
}

jstring weight_ = curEnv->NewStringUTF( weight );
if (weight != NULL && weight_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontWeightjintintjstringjava_lang_StringID ,objID, weight_);
                        curEnv->DeleteLocalRef(weight_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameFontSize (JavaVM * jvm_, int objID, int size){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontSizejintintjintintID = curEnv->GetStaticMethodID(cls, "setFrameFontSize", "(II)V" ) ;
if (voidsetFrameFontSizejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameFontSize");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontSizejintintjintintID ,objID, size);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getFrameFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFrameFontSizejintintID = curEnv->GetStaticMethodID(cls, "getFrameFontSize", "(I)I" ) ;
if (jintgetFrameFontSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFrameFontSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFrameFontSizejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setFrameFontAngle (JavaVM * jvm_, int objID, char const* angle){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontAnglejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFrameFontAngle", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameFontAnglejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameFontAngle");
}

jstring angle_ = curEnv->NewStringUTF( angle );
if (angle != NULL && angle_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontAnglejintintjstringjava_lang_StringID ,objID, angle_);
                        curEnv->DeleteLocalRef(angle_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetPosition (JavaVM * jvm_, int objID, int x, int y, int width, int height){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetPositionjintintjintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "setWidgetPosition", "(IIIII)V" ) ;
if (voidsetWidgetPositionjintintjintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetPosition");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetPositionjintintjintintjintintjintintjintintID ,objID, x, y, width, height);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getWidgetPosition (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getWidgetPositionjintintID = curEnv->GetStaticMethodID(cls, "getWidgetPosition", "(I)[I" ) ;
if (jintArray_getWidgetPositionjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWidgetPosition");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getWidgetPositionjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setFramePosition (JavaVM * jvm_, int objID, int x, int y, int width, int height){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFramePositionjintintjintintjintintjintintjintintID = curEnv->GetStaticMethodID(cls, "setFramePosition", "(IIIII)V" ) ;
if (voidsetFramePositionjintintjintintjintintjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFramePosition");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFramePositionjintintjintintjintintjintintjintintID ,objID, x, y, width, height);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getFramePosition (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getFramePositionjintintID = curEnv->GetStaticMethodID(cls, "getFramePosition", "(I)[I" ) ;
if (jintArray_getFramePositionjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFramePosition");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getFramePositionjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setWidgetCallback (JavaVM * jvm_, int objID, char const* text, int type){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetCallbackjintintjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "setWidgetCallback", "(ILjava/lang/String;I)V" ) ;
if (voidsetWidgetCallbackjintintjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetCallback");
}

jstring text_ = curEnv->NewStringUTF( text );
if (text != NULL && text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetCallbackjintintjstringjava_lang_StringjintintID ,objID, text_, type);
                        curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameCallback (JavaVM * jvm_, int objID, char const* text, int type){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameCallbackjintintjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "setFrameCallback", "(ILjava/lang/String;I)V" ) ;
if (voidsetFrameCallbackjintintjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameCallback");
}

jstring text_ = curEnv->NewStringUTF( text );
if (text != NULL && text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFrameCallbackjintintjstringjava_lang_StringjintintID ,objID, text_, type);
                        curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetHorizontalAlignment (JavaVM * jvm_, int objID, char const* alignment){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetHorizontalAlignmentjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetHorizontalAlignment", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetHorizontalAlignmentjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetHorizontalAlignment");
}

jstring alignment_ = curEnv->NewStringUTF( alignment );
if (alignment != NULL && alignment_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetHorizontalAlignmentjintintjstringjava_lang_StringID ,objID, alignment_);
                        curEnv->DeleteLocalRef(alignment_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetVerticalAlignment (JavaVM * jvm_, int objID, char const* alignment){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetVerticalAlignmentjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetVerticalAlignment", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetVerticalAlignmentjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetVerticalAlignment");
}

jstring alignment_ = curEnv->NewStringUTF( alignment );
if (alignment != NULL && alignment_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetVerticalAlignmentjintintjstringjava_lang_StringID ,objID, alignment_);
                        curEnv->DeleteLocalRef(alignment_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSliderMinorTickSpacing (JavaVM * jvm_, int objID, int space){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMinorTickSpacingjintintjintintID = curEnv->GetStaticMethodID(cls, "setSliderMinorTickSpacing", "(II)V" ) ;
if (voidsetSliderMinorTickSpacingjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderMinorTickSpacing");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMinorTickSpacingjintintjintintID ,objID, space);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSliderMajorTickSpacing (JavaVM * jvm_, int objID, int space){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMajorTickSpacingjintintjintintID = curEnv->GetStaticMethodID(cls, "setSliderMajorTickSpacing", "(II)V" ) ;
if (voidsetSliderMajorTickSpacingjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderMajorTickSpacing");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMajorTickSpacingjintintjintintID ,objID, space);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setListBoxSelectedIndices (JavaVM * jvm_, int objID, int const* indices, int indicesSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxSelectedIndicesjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "setListBoxSelectedIndices", "(I[I)V" ) ;
if (voidsetListBoxSelectedIndicesjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setListBoxSelectedIndices");
}

jintArray indices_ = curEnv->NewIntArray( indicesSize ) ;

if (indices_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( indices_, 0, indicesSize, (jint*)(indices) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxSelectedIndicesjintintjintArray_intintID ,objID, indices_);
                        curEnv->DeleteLocalRef(indices_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getListBoxSelectedIndices (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getListBoxSelectedIndicesjintintID = curEnv->GetStaticMethodID(cls, "getListBoxSelectedIndices", "(I)[I" ) ;
if (jintArray_getListBoxSelectedIndicesjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getListBoxSelectedIndices");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getListBoxSelectedIndicesjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

int CallScilabBridge::getListBoxSelectionSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetListBoxSelectionSizejintintID = curEnv->GetStaticMethodID(cls, "getListBoxSelectionSize", "(I)I" ) ;
if (jintgetListBoxSelectionSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getListBoxSelectionSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetListBoxSelectionSizejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setPopupMenuSelectedIndex (JavaVM * jvm_, int objID, int index){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPopupMenuSelectedIndexjintintjintintID = curEnv->GetStaticMethodID(cls, "setPopupMenuSelectedIndex", "(II)V" ) ;
if (voidsetPopupMenuSelectedIndexjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setPopupMenuSelectedIndex");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetPopupMenuSelectedIndexjintintjintintID ,objID, index);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getPopupMenuSelectedIndex (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetPopupMenuSelectedIndexjintintID = curEnv->GetStaticMethodID(cls, "getPopupMenuSelectedIndex", "(I)I" ) ;
if (jintgetPopupMenuSelectedIndexjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getPopupMenuSelectedIndex");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetPopupMenuSelectedIndexjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setSliderValue (JavaVM * jvm_, int objID, int index){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderValuejintintjintintID = curEnv->GetStaticMethodID(cls, "setSliderValue", "(II)V" ) ;
if (voidsetSliderValuejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderValue");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderValuejintintjintintID ,objID, index);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getSliderValue (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetSliderValuejintintID = curEnv->GetStaticMethodID(cls, "getSliderValue", "(I)I" ) ;
if (jintgetSliderValuejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getSliderValue");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetSliderValuejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setRadioButtonChecked (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRadioButtonCheckedjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setRadioButtonChecked", "(IZ)V" ) ;
if (voidsetRadioButtonCheckedjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setRadioButtonChecked");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetRadioButtonCheckedjintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isRadioButtonChecked (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisRadioButtonCheckedjintintID = curEnv->GetStaticMethodID(cls, "isRadioButtonChecked", "(I)Z" ) ;
if (jbooleanisRadioButtonCheckedjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isRadioButtonChecked");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisRadioButtonCheckedjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::setCheckBoxChecked (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetCheckBoxCheckedjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setCheckBoxChecked", "(IZ)V" ) ;
if (voidsetCheckBoxCheckedjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setCheckBoxChecked");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetCheckBoxCheckedjintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isCheckBoxChecked (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisCheckBoxCheckedjintintID = curEnv->GetStaticMethodID(cls, "isCheckBoxChecked", "(I)Z" ) ;
if (jbooleanisCheckBoxCheckedjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isCheckBoxChecked");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisCheckBoxCheckedjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::setSliderMinValue (JavaVM * jvm_, int objID, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMinValuejintintjintintID = curEnv->GetStaticMethodID(cls, "setSliderMinValue", "(II)V" ) ;
if (voidsetSliderMinValuejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderMinValue");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMinValuejintintjintintID ,objID, value);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSliderMaxValue (JavaVM * jvm_, int objID, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMaxValuejintintjintintID = curEnv->GetStaticMethodID(cls, "setSliderMaxValue", "(II)V" ) ;
if (voidsetSliderMaxValuejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderMaxValue");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMaxValuejintintjintintID ,objID, value);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSliderVertical (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderVerticaljintintID = curEnv->GetStaticMethodID(cls, "setSliderVertical", "(I)V" ) ;
if (voidsetSliderVerticaljintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderVertical");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderVerticaljintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSliderHorizontal (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderHorizontaljintintID = curEnv->GetStaticMethodID(cls, "setSliderHorizontal", "(I)V" ) ;
if (voidsetSliderHorizontaljintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSliderHorizontal");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderHorizontaljintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setListBoxMultipleSelectionEnabled (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxMultipleSelectionEnabledjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setListBoxMultipleSelectionEnabled", "(IZ)V" ) ;
if (voidsetListBoxMultipleSelectionEnabledjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setListBoxMultipleSelectionEnabled");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxMultipleSelectionEnabledjintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char** CallScilabBridge::getListBoxAllItemsText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArray_getListBoxAllItemsTextjintintID = curEnv->GetStaticMethodID(cls, "getListBoxAllItemsText", "(I)[Ljava/lang/String;" ) ;
if (jobjectArray_getListBoxAllItemsTextjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getListBoxAllItemsText");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getListBoxAllItemsTextjintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[lenRow];
for (jsize i = 0; i < lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int CallScilabBridge::getListBoxNumberOfItems (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetListBoxNumberOfItemsjintintID = curEnv->GetStaticMethodID(cls, "getListBoxNumberOfItems", "(I)I" ) ;
if (jintgetListBoxNumberOfItemsjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getListBoxNumberOfItems");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetListBoxNumberOfItemsjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setListBoxText (JavaVM * jvm_, int objID, char const* const* text, int textSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxTextjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setListBoxText", "(I[Ljava/lang/String;)V" ) ;
if (voidsetListBoxTextjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setListBoxText");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxTextjintintjobjectArray_java_lang_Stringjava_lang_StringID ,objID, text_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setListBoxListBoxTop (JavaVM * jvm_, int objID, int index){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxListBoxTopjintintjintintID = curEnv->GetStaticMethodID(cls, "setListBoxListBoxTop", "(II)V" ) ;
if (voidsetListBoxListBoxTopjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setListBoxListBoxTop");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxListBoxTopjintintjintintID ,objID, index);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getListBoxListBoxTop (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetListBoxListBoxTopjintintID = curEnv->GetStaticMethodID(cls, "getListBoxListBoxTop", "(I)I" ) ;
if (jintgetListBoxListBoxTopjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getListBoxListBoxTop");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetListBoxListBoxTopjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char** CallScilabBridge::getPopupMenuAllItemsText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArray_getPopupMenuAllItemsTextjintintID = curEnv->GetStaticMethodID(cls, "getPopupMenuAllItemsText", "(I)[Ljava/lang/String;" ) ;
if (jobjectArray_getPopupMenuAllItemsTextjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getPopupMenuAllItemsText");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getPopupMenuAllItemsTextjintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[lenRow];
for (jsize i = 0; i < lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int CallScilabBridge::getPopupMenuNumberOfItems (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetPopupMenuNumberOfItemsjintintID = curEnv->GetStaticMethodID(cls, "getPopupMenuNumberOfItems", "(I)I" ) ;
if (jintgetPopupMenuNumberOfItemsjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getPopupMenuNumberOfItems");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetPopupMenuNumberOfItemsjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setPopupMenuText (JavaVM * jvm_, int objID, char const* const* text, int textSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPopupMenuTextjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setPopupMenuText", "(I[Ljava/lang/String;)V" ) ;
if (voidsetPopupMenuTextjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setPopupMenuText");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetPopupMenuTextjintintjobjectArray_java_lang_Stringjava_lang_StringID ,objID, text_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetRelief (JavaVM * jvm_, int objID, char const* reliefType){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetReliefjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWidgetRelief", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetReliefjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetRelief");
}

jstring reliefType_ = curEnv->NewStringUTF( reliefType );
if (reliefType != NULL && reliefType_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetReliefjintintjstringjava_lang_StringID ,objID, reliefType_);
                        curEnv->DeleteLocalRef(reliefType_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameRelief (JavaVM * jvm_, int objID, char const* reliefType){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameReliefjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFrameRelief", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameReliefjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameRelief");
}

jstring reliefType_ = curEnv->NewStringUTF( reliefType );
if (reliefType != NULL && reliefType_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFrameReliefjintintjstringjava_lang_StringID ,objID, reliefType_);
                        curEnv->DeleteLocalRef(reliefType_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setRootMenuEnabled (JavaVM * jvm_, char const* menuName, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRootMenuEnabledjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setRootMenuEnabled", "(Ljava/lang/String;Z)V" ) ;
if (voidsetRootMenuEnabledjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setRootMenuEnabled");
}

jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetRootMenuEnabledjstringjava_lang_StringjbooleanbooleanID ,menuName_, status_);
                        curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setRootSubMenuEnabled (JavaVM * jvm_, char const* menuName, int position, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRootSubMenuEnabledjstringjava_lang_StringjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setRootSubMenuEnabled", "(Ljava/lang/String;IZ)V" ) ;
if (voidsetRootSubMenuEnabledjstringjava_lang_StringjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setRootSubMenuEnabled");
}

jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetRootSubMenuEnabledjstringjava_lang_StringjintintjbooleanbooleanID ,menuName_, position, status_);
                        curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFigureMenuEnabled (JavaVM * jvm_, int figureID, char const* menuName, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFigureMenuEnabledjintintjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFigureMenuEnabled", "(ILjava/lang/String;Z)V" ) ;
if (voidsetFigureMenuEnabledjintintjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFigureMenuEnabled");
}

jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFigureMenuEnabledjintintjstringjava_lang_StringjbooleanbooleanID ,figureID, menuName_, status_);
                        curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFigureSubMenuEnabled (JavaVM * jvm_, int figureID, char const* menuName, int position, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFigureSubMenuEnabledjintintjstringjava_lang_StringjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFigureSubMenuEnabled", "(ILjava/lang/String;IZ)V" ) ;
if (voidsetFigureSubMenuEnabledjintintjstringjava_lang_StringjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFigureSubMenuEnabled");
}

jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFigureSubMenuEnabledjintintjstringjava_lang_StringjintintjbooleanbooleanID ,figureID, menuName_, position, status_);
                        curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetEnable (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetEnablejintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setWidgetEnable", "(IZ)V" ) ;
if (voidsetWidgetEnablejintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetEnable");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetEnablejintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameEnable (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameEnablejintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFrameEnable", "(IZ)V" ) ;
if (voidsetFrameEnablejintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameEnable");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameEnablejintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isWidgetEnable (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisWidgetEnablejintintID = curEnv->GetStaticMethodID(cls, "isWidgetEnable", "(I)Z" ) ;
if (jbooleanisWidgetEnablejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isWidgetEnable");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisWidgetEnablejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::isFrameEnable (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisFrameEnablejintintID = curEnv->GetStaticMethodID(cls, "isFrameEnable", "(I)Z" ) ;
if (jbooleanisFrameEnablejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isFrameEnable");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisFrameEnablejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::setMenuChecked (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMenuCheckedjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setMenuChecked", "(IZ)V" ) ;
if (voidsetMenuCheckedjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMenuChecked");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetMenuCheckedjintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isMenuChecked (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisMenuCheckedjintintID = curEnv->GetStaticMethodID(cls, "isMenuChecked", "(I)Z" ) ;
if (jbooleanisMenuCheckedjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isMenuChecked");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisMenuCheckedjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::removeRootMenu (JavaVM * jvm_, char const* menuName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveRootMenujstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "removeRootMenu", "(Ljava/lang/String;)V" ) ;
if (voidremoveRootMenujstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeRootMenu");
}

jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidremoveRootMenujstringjava_lang_StringID ,menuName_);
                        curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeFigureMenu (JavaVM * jvm_, int figureID, char const* menuName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveFigureMenujintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "removeFigureMenu", "(ILjava/lang/String;)V" ) ;
if (voidremoveFigureMenujintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeFigureMenu");
}

jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidremoveFigureMenujintintjstringjava_lang_StringID ,figureID, menuName_);
                        curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::displayAndWaitContextMenu (JavaVM * jvm_, int ID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringdisplayAndWaitContextMenujintintID = curEnv->GetStaticMethodID(cls, "displayAndWaitContextMenu", "(I)Ljava/lang/String;" ) ;
if (jstringdisplayAndWaitContextMenujintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "displayAndWaitContextMenu");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringdisplayAndWaitContextMenujintintID ,ID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

int CallScilabBridge::newMessageBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMessageBoxID = curEnv->GetStaticMethodID(cls, "newMessageBox", "()I" ) ;
if (jintnewMessageBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newMessageBox");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewMessageBoxID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxTitle (JavaVM * jvm_, int id, char const* title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxTitlejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxTitle", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxTitlejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxTitle");
}

jstring title_ = curEnv->NewStringUTF( title );
if (title != NULL && title_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxTitlejintintjstringjava_lang_StringID ,id, title_);
                        curEnv->DeleteLocalRef(title_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxMessage (JavaVM * jvm_, int id, char const* message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxMessagejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxMessage", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxMessagejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxMessage");
}

jstring message_ = curEnv->NewStringUTF( message );
if (message != NULL && message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxMessagejintintjstringjava_lang_StringID ,id, message_);
                        curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxMessage (JavaVM * jvm_, int id, char const* const* message, int messageSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxMessage", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxMessage");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray message_ = curEnv->NewObjectArray( messageSize, stringArrayClass, NULL);
if (message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < messageSize; i++)
{
jstring TempString = curEnv->NewStringUTF( message[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( message_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, message_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::messageBoxDisplayAndWait (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidmessageBoxDisplayAndWaitjintintID = curEnv->GetStaticMethodID(cls, "messageBoxDisplayAndWait", "(I)V" ) ;
if (voidmessageBoxDisplayAndWaitjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "messageBoxDisplayAndWait");
}

                         curEnv->CallStaticVoidMethod(cls, voidmessageBoxDisplayAndWaitjintintID ,id);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getMessageBoxSelectedButton (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxSelectedButtonjintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxSelectedButton", "(I)I" ) ;
if (jintgetMessageBoxSelectedButtonjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxSelectedButton");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetMessageBoxSelectedButtonjintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxDefaultSelectedButtons (JavaVM * jvm_, int id, int const* index, int indexSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "setMessageBoxDefaultSelectedButtons", "(I[I)V" ) ;
if (voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxDefaultSelectedButtons");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID ,id, index_);
                        curEnv->DeleteLocalRef(index_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getMessageBoxUserSelectedButtons (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getMessageBoxUserSelectedButtonsjintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxUserSelectedButtons", "(I)[I" ) ;
if (jintArray_getMessageBoxUserSelectedButtonsjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxUserSelectedButtons");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getMessageBoxUserSelectedButtonsjintintID ,id));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setMessageBoxButtonsLabels (JavaVM * jvm_, int id, char const* const* labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxButtonsLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxButtonsLabels");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, labels_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxInitialValue (JavaVM * jvm_, int id, char const* const* value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxInitialValue", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxInitialValue");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray value_ = curEnv->NewObjectArray( valueSize, stringArrayClass, NULL);
if (value_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valueSize; i++)
{
jstring TempString = curEnv->NewStringUTF( value[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( value_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, value_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char** CallScilabBridge::getMessageBoxValue (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArray_getMessageBoxValuejintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxValue", "(I)[Ljava/lang/String;" ) ;
if (jobjectArray_getMessageBoxValuejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxValue");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getMessageBoxValuejintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[lenRow];
for (jsize i = 0; i < lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int CallScilabBridge::getMessageBoxValueSize (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxValueSizejintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxValueSize", "(I)I" ) ;
if (jintgetMessageBoxValueSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxValueSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetMessageBoxValueSizejintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxListBoxItems (JavaVM * jvm_, int id, char const* const* items, int itemsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxListBoxItems", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxListBoxItems");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray items_ = curEnv->NewObjectArray( itemsSize, stringArrayClass, NULL);
if (items_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < itemsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( items[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( items_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, items_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(items_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getMessageBoxSelectedItem (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxSelectedItemjintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxSelectedItem", "(I)I" ) ;
if (jintgetMessageBoxSelectedItemjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxSelectedItem");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetMessageBoxSelectedItemjintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxLineLabels (JavaVM * jvm_, int id, char const* const* labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxLineLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxLineLabels");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, labels_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxColumnLabels (JavaVM * jvm_, int id, char const* const* labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxColumnLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxColumnLabels");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, labels_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxDefaultInput (JavaVM * jvm_, int id, char const* const* values, int valuesSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxDefaultInput", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxDefaultInput");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray values_ = curEnv->NewObjectArray( valuesSize, stringArrayClass, NULL);
if (values_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valuesSize; i++)
{
jstring TempString = curEnv->NewStringUTF( values[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( values_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, values_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(values_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxModal (JavaVM * jvm_, int id, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxModaljintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setMessageBoxModal", "(IZ)V" ) ;
if (voidsetMessageBoxModaljintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxModal");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxModaljintintjbooleanbooleanID ,id, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxIcon (JavaVM * jvm_, int id, char const* name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxIconjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxIcon", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxIconjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxIcon");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxIconjintintjstringjava_lang_StringID ,id, name_);
                        curEnv->DeleteLocalRef(name_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isToolbarVisible (JavaVM * jvm_, int figNum){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisToolbarVisiblejintintID = curEnv->GetStaticMethodID(cls, "isToolbarVisible", "(I)Z" ) ;
if (jbooleanisToolbarVisiblejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isToolbarVisible");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisToolbarVisiblejintintID ,figNum));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::setToolbarVisible (JavaVM * jvm_, int figNum, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetToolbarVisiblejintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setToolbarVisible", "(IZ)V" ) ;
if (voidsetToolbarVisiblejintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setToolbarVisible");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetToolbarVisiblejintintjbooleanbooleanID ,figNum, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setEventHandler (JavaVM * jvm_, int figNum, char const* command){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetEventHandlerjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setEventHandler", "(ILjava/lang/String;)V" ) ;
if (voidsetEventHandlerjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setEventHandler");
}

jstring command_ = curEnv->NewStringUTF( command );
if (command != NULL && command_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetEventHandlerjintintjstringjava_lang_StringID ,figNum, command_);
                        curEnv->DeleteLocalRef(command_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setEventHandlerEnabled (JavaVM * jvm_, int figNum, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetEventHandlerEnabledjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setEventHandlerEnabled", "(IZ)V" ) ;
if (voidsetEventHandlerEnabledjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setEventHandlerEnabled");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetEventHandlerEnabledjintintjbooleanbooleanID ,figNum, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::newWaitBar (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewWaitBarID = curEnv->GetStaticMethodID(cls, "newWaitBar", "()I" ) ;
if (jintnewWaitBarID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newWaitBar");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewWaitBarID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setWaitBarMessage (JavaVM * jvm_, int id, char const* const* message, int messageSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWaitBarMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setWaitBarMessage", "(I[Ljava/lang/String;)V" ) ;
if (voidsetWaitBarMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWaitBarMessage");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray message_ = curEnv->NewObjectArray( messageSize, stringArrayClass, NULL);
if (message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < messageSize; i++)
{
jstring TempString = curEnv->NewStringUTF( message[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( message_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetWaitBarMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, message_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWaitBarValue (JavaVM * jvm_, int id, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWaitBarValuejintintjintintID = curEnv->GetStaticMethodID(cls, "setWaitBarValue", "(II)V" ) ;
if (voidsetWaitBarValuejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWaitBarValue");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWaitBarValuejintintjintintID ,id, value);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::destroyWaitBar (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddestroyWaitBarjintintID = curEnv->GetStaticMethodID(cls, "destroyWaitBar", "(I)V" ) ;
if (voiddestroyWaitBarjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroyWaitBar");
}

                         curEnv->CallStaticVoidMethod(cls, voiddestroyWaitBarjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWaitBarIndeterminateMode (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWaitBarIndeterminateModejintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setWaitBarIndeterminateMode", "(IZ)V" ) ;
if (voidsetWaitBarIndeterminateModejintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWaitBarIndeterminateMode");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetWaitBarIndeterminateModejintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::launchHelpBrowser (JavaVM * jvm_, char const* const* helps, int helpsSize, char const* language){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "launchHelpBrowser", "([Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "launchHelpBrowser");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray helps_ = curEnv->NewObjectArray( helpsSize, stringArrayClass, NULL);
if (helps_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < helpsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( helps[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( helps_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring language_ = curEnv->NewStringUTF( language );
if (language != NULL && language_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID ,helps_, language_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(helps_);
curEnv->DeleteLocalRef(language_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::searchKeyword (JavaVM * jvm_, char const* const* helps, int helpsSize, char const* keyword, char const* language, bool fullText){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "searchKeyword", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V" ) ;
if (voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "searchKeyword");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray helps_ = curEnv->NewObjectArray( helpsSize, stringArrayClass, NULL);
if (helps_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < helpsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( helps[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( helps_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring keyword_ = curEnv->NewStringUTF( keyword );
if (keyword != NULL && keyword_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring language_ = curEnv->NewStringUTF( language );
if (language != NULL && language_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean fullText_ = (static_cast<bool>(fullText) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID ,helps_, keyword_, language_, fullText_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(helps_);
curEnv->DeleteLocalRef(keyword_);
curEnv->DeleteLocalRef(language_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::newExportFileChooser (JavaVM * jvm_, int figureId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewExportFileChooserjintintID = curEnv->GetStaticMethodID(cls, "newExportFileChooser", "(I)I" ) ;
if (jintnewExportFileChooserjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newExportFileChooser");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewExportFileChooserjintintID ,figureId));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newFontChooser (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewFontChooserID = curEnv->GetStaticMethodID(cls, "newFontChooser", "()I" ) ;
if (jintnewFontChooserID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newFontChooser");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewFontChooserID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::fontChooserDisplayAndWait (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidfontChooserDisplayAndWaitjintintID = curEnv->GetStaticMethodID(cls, "fontChooserDisplayAndWait", "(I)V" ) ;
if (voidfontChooserDisplayAndWaitjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "fontChooserDisplayAndWait");
}

                         curEnv->CallStaticVoidMethod(cls, voidfontChooserDisplayAndWaitjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserFontName (JavaVM * jvm_, int objID, char const* fontName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserFontNamejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFontChooserFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetFontChooserFontNamejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserFontName");
}

jstring fontName_ = curEnv->NewStringUTF( fontName );
if (fontName != NULL && fontName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserFontNamejintintjstringjava_lang_StringID ,objID, fontName_);
                        curEnv->DeleteLocalRef(fontName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserFontSize (JavaVM * jvm_, int objID, int fontSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserFontSizejintintjintintID = curEnv->GetStaticMethodID(cls, "setFontChooserFontSize", "(II)V" ) ;
if (voidsetFontChooserFontSizejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserFontSize");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserFontSizejintintjintintID ,objID, fontSize);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserBold (JavaVM * jvm_, int objID, bool bold){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserBoldjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFontChooserBold", "(IZ)V" ) ;
if (voidsetFontChooserBoldjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserBold");
}

jboolean bold_ = (static_cast<bool>(bold) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserBoldjintintjbooleanbooleanID ,objID, bold_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserItalic (JavaVM * jvm_, int objID, bool italic){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserItalicjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFontChooserItalic", "(IZ)V" ) ;
if (voidsetFontChooserItalicjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserItalic");
}

jboolean italic_ = (static_cast<bool>(italic) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserItalicjintintjbooleanbooleanID ,objID, italic_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getFontChooserFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFontChooserFontNamejintintID = curEnv->GetStaticMethodID(cls, "getFontChooserFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetFontChooserFontNamejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserFontName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetFontChooserFontNamejintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

int CallScilabBridge::getFontChooserFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFontChooserFontSizejintintID = curEnv->GetStaticMethodID(cls, "getFontChooserFontSize", "(I)I" ) ;
if (jintgetFontChooserFontSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserFontSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFontChooserFontSizejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallScilabBridge::getFontChooserBold (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleangetFontChooserBoldjintintID = curEnv->GetStaticMethodID(cls, "getFontChooserBold", "(I)Z" ) ;
if (jbooleangetFontChooserBoldjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserBold");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleangetFontChooserBoldjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::getFontChooserItalic (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleangetFontChooserItalicjintintID = curEnv->GetStaticMethodID(cls, "getFontChooserItalic", "(I)Z" ) ;
if (jbooleangetFontChooserItalicjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserItalic");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleangetFontChooserItalicjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int CallScilabBridge::newColorChooser (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewColorChooserID = curEnv->GetStaticMethodID(cls, "newColorChooser", "()I" ) ;
if (jintnewColorChooserID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newColorChooser");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewColorChooserID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::colorChooserDisplayAndWait (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcolorChooserDisplayAndWaitjintintID = curEnv->GetStaticMethodID(cls, "colorChooserDisplayAndWait", "(I)V" ) ;
if (voidcolorChooserDisplayAndWaitjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "colorChooserDisplayAndWait");
}

                         curEnv->CallStaticVoidMethod(cls, voidcolorChooserDisplayAndWaitjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setColorChooserDefaultColor (JavaVM * jvm_, int objID, int const* rgb, int rgbSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetColorChooserDefaultColorjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "setColorChooserDefaultColor", "(I[I)V" ) ;
if (voidsetColorChooserDefaultColorjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setColorChooserDefaultColor");
}

jintArray rgb_ = curEnv->NewIntArray( rgbSize ) ;

if (rgb_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( rgb_, 0, rgbSize, (jint*)(rgb) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetColorChooserDefaultColorjintintjintArray_intintID ,objID, rgb_);
                        curEnv->DeleteLocalRef(rgb_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getColorChooserSelectedColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getColorChooserSelectedColorjintintID = curEnv->GetStaticMethodID(cls, "getColorChooserSelectedColor", "(I)[I" ) ;
if (jintArray_getColorChooserSelectedColorjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getColorChooserSelectedColor");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getColorChooserSelectedColorjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setColorChooserTitle (JavaVM * jvm_, int objID, char const* title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetColorChooserTitlejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setColorChooserTitle", "(ILjava/lang/String;)V" ) ;
if (voidsetColorChooserTitlejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setColorChooserTitle");
}

jstring title_ = curEnv->NewStringUTF( title );
if (title != NULL && title_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetColorChooserTitlejintintjstringjava_lang_StringID ,objID, title_);
                        curEnv->DeleteLocalRef(title_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setWidgetVisible (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetVisiblejintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setWidgetVisible", "(IZ)V" ) ;
if (voidsetWidgetVisiblejintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWidgetVisible");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetVisiblejintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFrameVisible (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameVisiblejintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFrameVisible", "(IZ)V" ) ;
if (voidsetFrameVisiblejintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFrameVisible");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameVisiblejintintjbooleanbooleanID ,objID, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isWidgetVisible (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisWidgetVisiblejintintID = curEnv->GetStaticMethodID(cls, "isWidgetVisible", "(I)Z" ) ;
if (jbooleanisWidgetVisiblejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isWidgetVisible");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisWidgetVisiblejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::isFrameVisible (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisFrameVisiblejintintID = curEnv->GetStaticMethodID(cls, "isFrameVisible", "(I)Z" ) ;
if (jbooleanisFrameVisiblejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isFrameVisible");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisFrameVisiblejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

char* CallScilabBridge::getClipboardContents (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetClipboardContentsID = curEnv->GetStaticMethodID(cls, "getClipboardContents", "()Ljava/lang/String;" ) ;
if (jstringgetClipboardContentsID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getClipboardContents");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetClipboardContentsID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

void CallScilabBridge::pasteClipboardIntoConsole (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidpasteClipboardIntoConsoleID = curEnv->GetStaticMethodID(cls, "pasteClipboardIntoConsole", "()V" ) ;
if (voidpasteClipboardIntoConsoleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "pasteClipboardIntoConsole");
}

                         curEnv->CallStaticVoidMethod(cls, voidpasteClipboardIntoConsoleID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::copyConsoleSelection (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcopyConsoleSelectionID = curEnv->GetStaticMethodID(cls, "copyConsoleSelection", "()V" ) ;
if (voidcopyConsoleSelectionID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "copyConsoleSelection");
}

                         curEnv->CallStaticVoidMethod(cls, voidcopyConsoleSelectionID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::emptyClipboard (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidemptyClipboardID = curEnv->GetStaticMethodID(cls, "emptyClipboard", "()V" ) ;
if (voidemptyClipboardID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "emptyClipboard");
}

                         curEnv->CallStaticVoidMethod(cls, voidemptyClipboardID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setClipboardContents (JavaVM * jvm_, char const* text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetClipboardContentsjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setClipboardContents", "(Ljava/lang/String;)V" ) ;
if (voidsetClipboardContentsjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setClipboardContents");
}

jstring text_ = curEnv->NewStringUTF( text );
if (text != NULL && text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetClipboardContentsjstringjava_lang_StringID ,text_);
                        curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::copyFigureToClipBoard (JavaVM * jvm_, int figID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcopyFigureToClipBoardjintintID = curEnv->GetStaticMethodID(cls, "copyFigureToClipBoard", "(I)V" ) ;
if (voidcopyFigureToClipBoardjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "copyFigureToClipBoard");
}

                         curEnv->CallStaticVoidMethod(cls, voidcopyFigureToClipBoardjintintID ,figID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getScreenResolution (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetScreenResolutionID = curEnv->GetStaticMethodID(cls, "getScreenResolution", "()I" ) ;
if (jintgetScreenResolutionID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenResolution");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetScreenResolutionID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double CallScilabBridge::getScreenWidth (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetScreenWidthID = curEnv->GetStaticMethodID(cls, "getScreenWidth", "()D" ) ;
if (jdoublegetScreenWidthID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenWidth");
}

                        jdouble res =  static_cast<jdouble>( curEnv->CallStaticDoubleMethod(cls, jdoublegetScreenWidthID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double CallScilabBridge::getScreenHeight (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetScreenHeightID = curEnv->GetStaticMethodID(cls, "getScreenHeight", "()D" ) ;
if (jdoublegetScreenHeightID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenHeight");
}

                        jdouble res =  static_cast<jdouble>( curEnv->CallStaticDoubleMethod(cls, jdoublegetScreenHeightID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::getScreenDepth (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetScreenDepthID = curEnv->GetStaticMethodID(cls, "getScreenDepth", "()I" ) ;
if (jintgetScreenDepthID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenDepth");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetScreenDepthID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallScilabBridge::printFigure (JavaVM * jvm_, int figID, bool postScript, bool displayDialog){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintFigurejintintjbooleanbooleanjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "printFigure", "(IZZ)Z" ) ;
if (jbooleanprintFigurejintintjbooleanbooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "printFigure");
}

jboolean postScript_ = (static_cast<bool>(postScript) ? JNI_TRUE : JNI_FALSE);

jboolean displayDialog_ = (static_cast<bool>(displayDialog) ? JNI_TRUE : JNI_FALSE);

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanprintFigurejintintjbooleanbooleanjbooleanbooleanID ,figID, postScript_, displayDialog_));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::printFile (JavaVM * jvm_, char const* fileName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintFilejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "printFile", "(Ljava/lang/String;)Z" ) ;
if (jbooleanprintFilejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "printFile");
}

jstring fileName_ = curEnv->NewStringUTF( fileName );
if (fileName != NULL && fileName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanprintFilejstringjava_lang_StringID ,fileName_));
                        curEnv->DeleteLocalRef(fileName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::printString (JavaVM * jvm_, char const* theString, char const* pageHeader){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "printString", "(Ljava/lang/String;Ljava/lang/String;)Z" ) ;
if (jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "printString");
}

jstring theString_ = curEnv->NewStringUTF( theString );
if (theString != NULL && theString_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring pageHeader_ = curEnv->NewStringUTF( pageHeader );
if (pageHeader != NULL && pageHeader_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID ,theString_, pageHeader_));
                        curEnv->DeleteLocalRef(theString_);
curEnv->DeleteLocalRef(pageHeader_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::pageSetup (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanpageSetupID = curEnv->GetStaticMethodID(cls, "pageSetup", "()Z" ) ;
if (jbooleanpageSetupID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "pageSetup");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanpageSetupID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::requestWidgetFocus (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrequestWidgetFocusjintintID = curEnv->GetStaticMethodID(cls, "requestWidgetFocus", "(I)V" ) ;
if (voidrequestWidgetFocusjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "requestWidgetFocus");
}

                         curEnv->CallStaticVoidMethod(cls, voidrequestWidgetFocusjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::requestFrameFocus (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrequestFrameFocusjintintID = curEnv->GetStaticMethodID(cls, "requestFrameFocus", "(I)V" ) ;
if (voidrequestFrameFocusjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "requestFrameFocus");
}

                         curEnv->CallStaticVoidMethod(cls, voidrequestFrameFocusjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::raiseWindow (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidraiseWindowjintintID = curEnv->GetStaticMethodID(cls, "raiseWindow", "(I)V" ) ;
if (voidraiseWindowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "raiseWindow");
}

                         curEnv->CallStaticVoidMethod(cls, voidraiseWindowjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::useCanvasForDisplay (JavaVM * jvm_, bool onOrOff){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduseCanvasForDisplayjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "useCanvasForDisplay", "(Z)V" ) ;
if (voiduseCanvasForDisplayjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "useCanvasForDisplay");
}

jboolean onOrOff_ = (static_cast<bool>(onOrOff) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voiduseCanvasForDisplayjbooleanbooleanID ,onOrOff_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::useCanvasForDisplay (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanuseCanvasForDisplayID = curEnv->GetStaticMethodID(cls, "useCanvasForDisplay", "()Z" ) ;
if (jbooleanuseCanvasForDisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "useCanvasForDisplay");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanuseCanvasForDisplayID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::scilabAboutBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidscilabAboutBoxID = curEnv->GetStaticMethodID(cls, "scilabAboutBox", "()V" ) ;
if (voidscilabAboutBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "scilabAboutBox");
}

                         curEnv->CallStaticVoidMethod(cls, voidscilabAboutBoxID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
