// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Vincent COUVERT <vincent.couvert@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// Unitary tests for Scilab Java slider

// Exec tests common to all uicontrols
clear uicontrol_generic_test
exec("SCI/modules/gui/tests/unit_tests/uicontrol_generic_test.sci");
uicontrol_generic_test("slider");

// Default relief value
h = uicontrol("parent", scf(), "style", "slider");
if get(h, "relief") <> "flat" then pause; end

// --- Value tests ---
// Default value
if get(h, "value") <> get(h,"min") then pause; end

set(h, "max", 10);
set(h, "value", 10);
if get(h, "value") <> 10 then pause; end

// TODO return an error
//set(h, "value", [1 2 3]);
//if ~and(get(h, "value") == [1 2 3]) then pause; end

// TODO return an error
//set(h, "value", []);
//if ~isempty(get(h, "value")) then pause; end

// TODO test with wrong values

// Create an horizontal slider
h = uicontrol("parent", gcf(), "style", "slider", "position", [20,20,100,20]);

// Create a vertical slider
h = uicontrol("parent", gcf(), "style", "slider", "position", [20,20,20,100]);